<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<jsp:include page="../common/headerV3.jsp">
	<jsp:param name="title" value="Logout_Title" />
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="true" name="not_logged_in" />
	<jsp:param value="true" name="showOnlyHelp" />
</jsp:include>
<div id="loginform" class="vw-block-container vw-center-container">
	<div class="vw-vertical-center">
		<div class="vw-horizontal-center">
			<div class="vw-light-block">
				<h1 class="logintitle vw-page-title" id="logout-message"><fmt:message key="Logout_Text" /></h1>
				<p>
					<fmt:message key="Login_Again_Text">
						<c:choose>
							<c:when test="${param.foreignCallback == 1 && param.foreignCallbackUrl != null }">
								<c:url value="index.jsp" var="loginUrlForExternalcallBack">
								   <c:param name="foreignCallback" value="1"/>
								   <c:param name="callBackUrl" value="${param.foreignCallbackUrl}"/>
								   <c:param name="app" value="1"/>
								   <c:param name="redirectAfterLoginType" value="0"/>

								</c:url>
								<fmt:param value="${loginUrlForExternalcallBack}"  />
							</c:when>
							<c:when test="${param.retainUrl != null}">
								<c:set var="loginUrlWithRetainUrl" value="index.jsp"/>
									<fmt:param value="${loginUrlWithRetainUrl}?${param.retainUrl}"  />
							</c:when>
							<c:otherwise>
								<c:set var="loginUrl" value="index.jsp"/>
									<fmt:param value="${loginUrl}"  />
							</c:otherwise>
						</c:choose>
					</fmt:message>
				</p>

				<c:if test="${applicationScope.CURRENT_SSO_DOMAIN != null}">
					<p>
						<fmt:message key="NO_SSO_Again_Text">
							<fmt:param value="index.jsp?disableSSO"/>
						</fmt:message>
					</p>
				</c:if>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript" nonce="${sessionScope.cspNonce}" >
	document.cookie = 'showCustomStartupMessageAcknowledged=;path=/;expires=Thu, 01 Jan 1970 00:00:01 GMT;';
</script>


<jsp:include page="../common/footerV3.jsp">
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>