<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>

<jsp:include page="../common/header.jsp">
	<jsp:param value="true" name="includeMask" />
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="true" name="includeJqueryUI" />
	<jsp:param value="" name="titleLocalized" />
	<jsp:param value="Legal Notice" name="title" />
	<jsp:param value="../common/css/custom-cb.css" name="css" />
	<jsp:param value="dialog" name="displayMode" />
</jsp:include>
<fmt:message key="common.action.close" var= "ActionClose"/>
 <style>
#content{
	border: 0px;
	background-color: transparent;
	box-shadow: 0 0 0 0;
	padding: 0px;
}
#legalText{
	height: 460px;
	margin-bottom: 15px;
	overflow-y: auto;
	border: 1px solid #ccc;
	text-align: justify;
	padding-right: 10px;
}
.custom-cb{
	margin-top: 2px;
}
.indented{
	padding-left: 10px;
	font-size: 1.1em;
	padding-bottom:10px;
}
.heavy{
	font-weight:bold;
}
#loginform .warning{
	font-size:0.9em;
	padding-top:10px;
}
b{
	font-weight:bold;
}
.NormalaaWeba,.headingaa{
	margin-top:15px;
}
div.btns a{
	text-decoration:none;
}
div.btns a.disabledBtns {
	pointer-events: none;
	cursor: default;
	-ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=30)";
	filter: alpha(opacity = 30);
	opacity: .3;
 </style>
<div id="mainBody">
	<div id="legalText">
		<enhance:out escapeXml="false">
			<div class="indented warning">${requestScope.MAIN_LEGAL_TEXT}</div>
		</enhance:out>
	</div>

	<div id="legalCb"><div class="custom-cb unchecked" data-state="unchecked" aria-checked="false" tabindex="0" role="checkbox" aria-labelledby="accept-eula-label"></div><div class="custom-cb-label" id="accept-eula-label"><fmt:message key="EULA_Legal_Text" /></div>
	</div>
	<fmt:bundle basename="localization.messages">
			<div class="btns" >
				<a href="#" id="okButton" class="okSaveButton disabledBtns mainBtn"><fmt:message key="Accept_Button" /></a>
				<a href="#" id="closeButton"><fmt:message key="Decline_Button" /></a>
			</div>
	</fmt:bundle>
</div>

<script nonce="${sessionScope.cspNonce}" >
$(document).ready(function(){
	if ("true"==="${sessionScope.MISSING_LEGAL_TEXT}") {
		$("body #legalCb").addClass("hidden");
		$("body #okButton").addClass('hidden');
		$("body #closeButton").html("${ActionClose}");
	}
});

var returnVals=null;
$("body").on("click","#closeButton", function(){
	returnVals = false;
	cvUtil.closeModal();

});

$("body").on("click","#okButton", function(){
	returnVals = true;
	cvUtil.closeModal();

});

$("body").on("click", "#legalCb .custom-cb", function(){
	if($(this).attr("data-state")=="checked")
		$("#okButton").addClass("disabledBtns");
	else
		$("#okButton").removeClass("disabledBtns");
});

function getData(){
	return returnVals;
}
</script>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="../common/js/encoder.js" name="js"/>
	<jsp:param value="../common/js/custom-cb.js" name="js" />
</jsp:include>