<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv"%>

	<c:if test="${applicationScope.OEM_ID != null && applicationScope.OEM_ID == 119}">
		<link rel="stylesheet" href="${pageContext.request.contextPath}/OEM/${applicationScope.OEM_ID}/CSS/override.css?${applicationScope.BUILD_TS}" />
	</c:if>
	<jsp:include page="../common/headerV3.jsp">
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="true" name="not_logged_in" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/custom-cb.css" name="css" />
		<jsp:param value="Login" name="title" />
		<jsp:param value="true" name="showOnlyHelp" />
	</jsp:include>
	<script nonce="${sessionScope.cspNonce}" >
// In adminconsole routes are based on url fragments in URL. Buttons in login page are anchor tags with href attribute as #.
//On clicking button url fragment is updated to #, hence the original url fragment pointing to a certain adminconsole page is lost.
// As a result, after login, requested page in adminconosle doesnt load. Instead it goes to default lading page in adminconosle.
// Hence, updating href for anchor tags in login page (Only Login page from WebConsole is used by adminconosle ).
//Also only those anchors that have # as href hence dummy anchor tags are updated.
		$(document).on("ready", function(){
			if(window.location.hash) {
				$("a[href='#']").attr('href', window.location.hash);
			}

		});
	</script>
		<fmt:message key="locked.account" var="lockedAccount" />
		<fmt:message key="date.numberDays" var="numberDays" />
		<fmt:message key="date.numberHours" var="numberHours" />
		<fmt:message key="date.numberMinutes" var="numberMinutes" />
		<fmt:message key="enterEmailOrUsername" var="enterEmailOrUsername"/>

		<fmt:message key="login.error.getTfaPin" var="loginErrorGetTfaPin"/>
		<fmt:message key="login.success.getTfaPin" var="loginSuccessGetTfaPin"/>



		    <div id="loginform" class="vw-login-container vw-center-container">
		    <div class="vw-vertical-center">
			    <!-- banner-font css class is used by some customers to override style for banner in login page and banner entry in customization screen in adminconsole.
				Do not use this class as your properties might be overridden for such customers-->
		    	<p class="vw-logo-warningLoginBanner banner-font"></p>
		   		<div class="vw-horizontal-center  vw-login-min-height">
			<c:if test="${applicationScope.ENABLE_SOCIAL_SIGN_IN_REGISTRATION == true}">
			    	<p class="logintitle"><a class="vw-btn vw-btn-default toggleButton"><span class="sprite icon-plus"></span>&nbsp;<fmt:message key="Social_Login_Title" /></a></p>
				    <div id="socialButtons">
					</div>
			</c:if>
				<div id="custom-logo">
				</div>
				<svg class="vw-commvault-logo" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 210.2 132.1" xml:space="preserve" role="img"><title>Commvault&reg;</title><path role="presentation" d="M19.4,130.9c-2.2,0.8-4.5,1.2-6.8,1.2c-8.4,0-12.6-4.1-12.6-12.2c0-7.7,4.2-11.5,12.6-11.5c2.3,0,4.7,0.3,6.9,1.1v3.9c-2.1-0.9-4.3-1.3-6.5-1.3c-5.6,0-8.4,2.6-8.4,7.8c0,5.6,2.8,8.4,8.4,8.4c2.2,0,4.5-0.4,6.5-1.3V130.9z"/><path role="presentation" d="M21.7,120.3c0-7.9,3.9-11.9,11.7-11.9c7.7,0,11.5,4,11.5,11.9s-3.8,11.8-11.5,11.8C25.9,132.1,22,128.2,21.7,120.3z M33.4,128.3c4.7,0,7-2.7,7-8.1s-2.4-8.1-7-8c-4.8,0-7.2,2.7-7.2,8S28.6,128.2,33.4,128.3L33.4,128.3z"/><path role="presentation" d="M48.3,131.9v-23.3h4.5l7.9,17.7l7.8-17.7h4.3v23.3h-4v-16.3l-6.3,16.3h-3.7l-6.5-16.3v16.3H48.3z"/><path role="presentation" d="M77.7,131.9v-23.3h4.5l7.9,17.7l7.8-17.7h4.3v23.3h-4v-16.3l-6.3,16.3h-3.7l-6.5-16.3v16.3H77.7z"/><path role="presentation" d="M128.7,108.6l-10.2,23.3h-4.7l-9.8-23.4h5.1l7.2,17.9l7.2-17.9H128.7z"/><path role="presentation" d="M123.9,131.9l9.9-23.4h4.6l10.2,23.4h-4.7l-2.9-6.4h-7.4l1.5-3.8h4.7l-3.8-8.8l-7.6,18.9H123.9z"/><path role="presentation" d="M149.1,122.8v-14.2h4.3v14.2c0,3.7,1.9,5.6,5.7,5.6c3.8,0,5.7-1.9,5.7-5.6v-14.2h4.3v14.2c0,6.2-3.3,9.3-10,9.3C152.6,132.1,149.2,129,149.1,122.8z"/><path role="presentation" d="M178,108.6v19.6h10.9v3.8h-15.3v-23.3H178z"/><path role="presentation" d="M204.2,108.6v3.8h-6.7v19.6h-4.3v-19.6h-6.7v-3.8H204.2z"/><path role="presentation" d="M208.4,109.4c0.2,0,0.4,0,0.6,0.2c0.1,0.1,0.2,0.3,0.2,0.5c0,0.2,0,0.3-0.2,0.4c-0.1,0.1-0.3,0.2-0.4,0.2l0.6,1h-0.4l-0.6-1h-0.4v1h-0.3v-2.2L208.4,109.4z M208.3,110.4h0.2c0.1,0,0.1,0,0.2,0c0.1,0,0.1-0.1,0.1-0.1c0-0.1,0-0.1,0-0.2c0-0.1,0-0.1,0-0.2c0,0-0.1-0.1-0.1-0.1c-0.1,0-0.1,0-0.2,0h-0.2h-0.5v0.7L208.3,110.4z"/><path role="presentation" d="M208.3,108.6c-1.1,0-1.9,0.9-1.9,1.9s0.9,1.9,1.9,1.9c1.1,0,1.9-0.9,1.9-1.9C210.2,109.4,209.3,108.6,208.3,108.6L208.3,108.6z M208.3,112.1c-0.9,0-1.6-0.7-1.6-1.6s0.7-1.6,1.6-1.6c0.9,0,1.6,0.7,1.6,1.6S209.2,112.1,208.3,112.1C208.3,112.1,208.3,112.1,208.3,112.1z"/><path role="presentation" d="M102.1,0L64.5,21.7v41.8l37.6,21.7l37.6-21.7V21.7L102.1,0z M133.2,59.7l-31.1,18L71,59.7V25.5l31.1-18l31.1,18V59.7z"/><path role="presentation" d="M100,69.1c0,0.2-0.2,0.4-0.4,0.4c-0.1,0-0.1,0-0.2-0.1L77.4,56.8c-0.4-0.2-0.6-0.6-0.6-1.1V31.2c0-0.2,0.2-0.4,0.4-0.4c0.1,0,0.1,0,0.2,0.1l21.9,12.6c0.4,0.2,0.6,0.6,0.6,1.1V69.1z"/><path role="presentation" d="M123.9,27.5l-21,12.1c-0.5,0.3-1.2,0.3-1.7,0l-21-12.1c-0.2-0.1-0.3-0.4-0.2-0.6c0-0.1,0.1-0.1,0.2-0.2l21-12.1c0.5-0.3,1.2-0.3,1.7,0l21,12.1c0.2,0.1,0.3,0.4,0.2,0.6C124,27.4,124,27.5,123.9,27.5z"/><path role="presentation" d="M123.9,58.4l-19,11c-0.2,0.1-0.5,0-0.6-0.2c0-0.1-0.1-0.1-0.1-0.2v-22c0-0.2,0.2-0.4,0.4-0.4c0.1,0,0.1,0,0.2,0.1l19,11c0.2,0.1,0.2,0.4,0.1,0.6C124,58.4,124,58.4,123.9,58.4z"/></svg>

				<c:set var="stayLoggedInVal"  value="${cvConfig.getStayLoggedInDefaultValue()}" />

				<c:if test="${stayLoggedInVal != null }">
					<c:set var="stayLoggedInDefaultAriaValue"  value="${stayLoggedInVal}" />
					<c:set var="stayLoggedInDefaultValue" value="${stayLoggedInVal == true?'checked':'unchecked'}" />
				</c:if>
				<c:set var="forgotPasswordVisibilityClass"  value="${cvConfig.showForgotPasswordLinkInLoginFirstStep() == true ? '' : 'hidden'}" />

				<c:choose>
	 				<c:when test="${param.app == 1}">
						<fmt:message key="AdminConsole_Title" var="AppName"/>
						<c:if test="${stayLoggedInVal == null }">
							<c:set var="stayLoggedInDefaultValue" value="checked" />
							<c:set var="stayLoggedInDefaultAriaValue"  value="true" />
						</c:if>
	 				</c:when>
					<c:when test="${param.app == 3}">
	 					<c:set var="AppName" value="Apps" />
	 				</c:when>
					<c:when test="${param.app == 4}">
	 					<c:set var="AppName" value="Search" />
	 				</c:when>
					<c:when test="${param.app == 5}">
	 					<c:set var="AppName" value="Compliance Search" />
	 				</c:when>
					<c:when test="${param.app == 6}">
	 					<c:set var="AppName" value="Search Admin" />
	 				</c:when>
	 				<c:when test="${param.app == 7}">
						<fmt:message key="Comet_Title" var="AppName"/>
	 				</c:when>
	 				<c:otherwise>
	 					<c:set var="AppName" value="WebConsole" />
	 					<c:if test="${stayLoggedInVal == null }">
							<c:set var="stayLoggedInDefaultValue" value="unchecked" />
							<c:set var="stayLoggedInDefaultAriaValue"  value="false" />
						</c:if>
	 				</c:otherwise>
				 </c:choose>
				<p class="logintitle vw-logo-lock-up">
					<c:if test="${param.app == 1}">
						<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 210 19.6" xml:space="preserve" role="img"><title>Command Center&trade;</title><path role="presentation" d="M0,9.8c0-3.2,0.1-4.2,0.5-5.3C1.2,1.7,3.8-0.2,6.7,0c2.6-0.1,5,1.4,6,3.8c0.1,0.1,0,0.3-0.1,0.4L10.9,5c-0.1,0.1-0.3,0-0.4-0.1c0,0,0,0,0,0C9.9,3.3,8.4,2.3,6.7,2.3C4.9,2.2,3.3,3.4,2.9,5.1C2.6,5.9,2.5,6.8,2.5,9.8s0.1,3.9,0.4,4.7c0.4,1.7,2.1,2.9,3.8,2.8c1.7,0,3.2-1,3.8-2.5c0.1-0.1,0.2-0.2,0.3-0.2c0,0,0,0,0,0l1.6,0.8c0.1,0.1,0.2,0.2,0.1,0.4c-1,2.4-3.4,3.9-6,3.8c-2.9,0.2-5.5-1.7-6.2-4.5C0.1,14.1,0,13,0,9.8z"/><path role="presentation" d="M15.8,16c-0.3-1.1-0.5-2.3-0.4-3.4c0-1.1,0.1-2.3,0.4-3.4C16.9,6.4,20,4.9,22.9,6c1.5,0.6,2.7,1.7,3.2,3.2c0.3,1.1,0.5,2.2,0.4,3.4c0.1,1.2-0.1,2.3-0.4,3.4c-1.1,2.9-4.2,4.3-7.1,3.2C17.6,18.7,16.4,17.5,15.8,16z M23.9,15.4c0.2-0.9,0.3-1.8,0.3-2.7c0-0.9-0.1-1.8-0.3-2.7c-0.6-1.6-2.4-2.5-4-1.9C19,8.3,18.3,9,18,9.9c-0.2,0.9-0.3,1.8-0.3,2.7c0,0.9,0.1,1.8,0.3,2.7c0.6,1.6,2.4,2.5,4,1.9C22.9,17,23.6,16.3,23.9,15.4z"/><path role="presentation" d="M47.1,19.3c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0v-7.8c0-2.2-1-3.4-2.9-3.4c-1.7,0-3,1.3-3,3c0,0.1,0,0.2,0,0.3v8c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0h-1.8c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0v-7.8c0-2.2-1-3.4-2.9-3.4c-1.7,0-3,1.3-3,3c0,0.1,0,0.2,0,0.3v8c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0h-1.8c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0V6.2c0-0.1,0.1-0.3,0.2-0.3c0,0,0,0,0,0h1.8c0.1,0,0.3,0.1,0.3,0.2c0,0,0,0,0,0v1.2l0,0c1.5-2,4.4-2.4,6.4-0.9c0.4,0.3,0.8,0.7,1.1,1.2l0,0c1-1.4,2.6-2.1,4.2-2c3,0,4.7,2,4.7,5v8.4c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0-0.1,0L47.1,19.3z"/><path role="presentation" d="M70.3,19.3c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0v-7.8c0-2.2-1-3.4-2.9-3.4c-1.7,0-3,1.3-3,3c0,0.1,0,0.2,0,0.3v8c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0h-1.8c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0v-7.8c0-2.2-1-3.4-2.9-3.4c-1.7,0-3,1.3-3,3c0,0.1,0,0.2,0,0.3v8c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0h-1.8c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0V6.2c0-0.1,0.1-0.3,0.2-0.3c0,0,0,0,0,0h1.8c0.1,0,0.3,0.1,0.3,0.2c0,0,0,0,0,0v1.2l0,0c1.5-2,4.4-2.5,6.4-1c0.5,0.3,0.9,0.8,1.2,1.2l0,0c1-1.4,2.6-2.2,4.2-2.1c3,0,4.7,2,4.7,5V19c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0L70.3,19.3z"/><path role="presentation" d="M84.7,19.3c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0v-1.2l0,0c-0.6,1-1.9,1.8-3.9,1.8c-2.5,0-4.4-1.3-4.4-4s1.9-4.1,5.1-4.1h3c0.1,0,0.2,0,0.2-0.1c0,0,0,0,0,0v-1c0-1.8-0.7-2.6-3.2-2.6c-1.1,0-2.3,0.3-3.2,1c-0.1,0.1-0.3,0.1-0.4,0L77,7.4c-0.1-0.1-0.1-0.3,0-0.4c1.3-0.9,2.9-1.4,4.4-1.3c3.7,0,5.1,1.3,5.1,4.6v8.9c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0L84.7,19.3z M84.3,15v-1.5c0-0.1,0-0.2-0.1-0.2c0,0,0,0,0,0h-2.6c-2.3,0-3.3,0.7-3.3,2.2s1,2.1,2.7,2.1C83.1,17.6,84.3,16.7,84.3,15z"/><path role="presentation" d="M99.5,19.3c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0v-7.8c0-2.2-1-3.4-2.9-3.4c-1.7,0-3,1.3-3,3c0,0.1,0,0.2,0,0.3v8c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0h-1.8c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0V6.2c0-0.1,0.1-0.3,0.2-0.3c0,0,0,0,0,0H93c0.1,0,0.3,0.1,0.3,0.2c0,0,0,0,0,0v1.2l0,0c0.8-1.2,2.2-1.9,3.7-1.8c2.8,0,4.5,2,4.5,5v8.4c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0L99.5,19.3z"/><path role="presentation" d="M114.2,19.3c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0v-1.3l0,0c-0.8,1.3-2.2,2-3.7,1.9c-2.1,0.2-4-1.2-4.5-3.2c-0.4-1.2-0.5-2.5-0.5-3.8c-0.1-1.3,0.1-2.5,0.5-3.8c0.5-2,2.4-3.4,4.5-3.2c1.5-0.1,2.9,0.6,3.7,1.8l0,0V0.6c0-0.1,0.1-0.3,0.3-0.3c0,0,0,0,0,0h1.8c0.1,0,0.3,0.1,0.3,0.3c0,0,0,0,0,0V19c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0L114.2,19.3z M113.6,15.4c0.3-0.9,0.4-1.9,0.3-2.8c0-0.9-0.1-1.9-0.3-2.8c-0.6-1.6-2.4-2.4-4-1.8c-0.8,0.3-1.5,1-1.8,1.8c-0.2,0.9-0.3,1.9-0.3,2.8c0,0.9,0.1,1.9,0.3,2.8c0.6,1.6,2.3,2.4,3.9,1.9C112.6,17,113.3,16.3,113.6,15.4z"/><path role="presentation" d="M126.8,9.8c0-3.2,0.1-4.2,0.5-5.3c0.7-2.8,3.3-4.6,6.2-4.5c2.6-0.1,5,1.4,6,3.8c0.1,0.1,0,0.3-0.1,0.4L137.7,5c-0.1,0.1-0.3,0-0.4-0.1c0,0,0,0,0,0c-0.6-1.6-2.2-2.6-3.8-2.5c-1.8-0.1-3.4,1.1-3.9,2.8c-0.3,1.5-0.5,3.1-0.4,4.7c-0.1,1.6,0,3.2,0.4,4.7c0.4,1.7,2.1,2.9,3.9,2.8c1.7,0,3.2-1,3.8-2.5c0-0.1,0.2-0.2,0.3-0.2c0,0,0,0,0.1,0l1.6,0.8c0.1,0.1,0.2,0.2,0.1,0.4c-1,2.4-3.4,3.9-6,3.8c-2.9,0.2-5.5-1.7-6.2-4.5C126.9,14.1,126.8,13,126.8,9.8z"/><path role="presentation" d="M142.6,16c-0.3-1.1-0.5-2.2-0.4-3.4c0-1.1,0.1-2.3,0.4-3.4c1-2.8,4.2-4.3,7-3.3c1.5,0.6,2.7,1.7,3.3,3.3c0.3,1.2,0.5,2.5,0.4,3.8c0,0.1-0.1,0.3-0.3,0.3c0,0,0,0,0,0h-8.3c-0.1,0-0.2,0.1-0.2,0.2c0,0.5,0.1,1.1,0.2,1.6c0.4,1.5,1.8,2.4,3.3,2.3c1.3,0,2.5-0.5,3.4-1.5c0.1-0.1,0.3-0.2,0.4-0.1c0,0,0,0,0,0l1.1,1c0.1,0.1,0.1,0.2,0,0.4c0,0,0,0,0,0c-1.3,1.5-3.1,2.4-5.1,2.3C145.5,19.8,143.3,18.3,142.6,16z M150.8,11.5c0.1,0,0.2-0.1,0.2-0.2c0-0.5,0-1-0.2-1.5c-0.6-1.7-2.5-2.5-4.1-1.9c-0.9,0.3-1.6,1-1.9,1.9c-0.1,0.5-0.2,1-0.2,1.5c0,0.1,0,0.2,0.2,0.2H150.8z"/><path role="presentation" d="M165.5,19.3c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0v-7.8c0-2.2-1-3.4-2.9-3.4c-1.7,0-3,1.3-3,3c0,0.1,0,0.2,0,0.3v8c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0h-1.8c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0V6.2c0-0.1,0.1-0.3,0.2-0.3c0,0,0,0,0,0h1.8c0.1,0,0.3,0.1,0.3,0.2c0,0,0,0,0,0v1.2l0,0c0.8-1.2,2.2-1.9,3.7-1.8c2.8,0,4.5,2,4.5,5V19c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0L165.5,19.3z"/><path role="presentation" d="M175.8,19.5c-2.5,0-3.5-1.2-3.5-3.8V8c0-0.1,0-0.2-0.2-0.2H171c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0,0V6.2c0-0.1,0.1-0.3,0.2-0.3c0,0,0,0,0,0h1.1c0.1,0,0.1,0,0.2-0.1c0,0,0,0,0,0V2c0-0.1,0.1-0.3,0.2-0.3c0,0,0,0,0,0h1.8c0.1,0,0.3,0.1,0.3,0.2c0,0,0,0,0,0v3.8c0,0.1,0,0.1,0.1,0.2c0,0,0,0,0,0h2.1c0.1,0,0.3,0.1,0.3,0.2c0,0,0,0,0,0v1.3c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0h-2.1c-0.1,0-0.2,0.1-0.2,0.2v7.6c0,1.3,0.5,1.7,1.7,1.7h0.6c0.1,0,0.3,0.1,0.3,0.3c0,0,0,0,0,0v1.6c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0L175.8,19.5z"/><path role="presentation" d="M180.4,16c-0.3-1.1-0.5-2.2-0.4-3.4c0-1.1,0.1-2.3,0.4-3.4c1-2.8,4.2-4.3,7-3.3c1.5,0.6,2.7,1.7,3.3,3.3c0.3,1.2,0.5,2.5,0.4,3.8c0,0.1-0.1,0.3-0.3,0.3c0,0,0,0,0,0h-8.3c-0.1,0-0.2,0.1-0.2,0.1c0,0,0,0,0,0c0,0.5,0.1,1.1,0.2,1.6c0.4,1.5,1.8,2.4,3.3,2.3c1.3,0,2.5-0.5,3.4-1.5c0.1-0.1,0.3-0.2,0.4-0.1l1.1,1c0.1,0.1,0.1,0.2,0,0.4c0,0,0,0,0,0c-1.3,1.5-3.1,2.4-5.1,2.3C183.3,19.8,181.1,18.3,180.4,16z M188.5,11.5c0.1,0,0.2-0.1,0.2-0.2c0-0.5,0-1-0.2-1.5c-0.6-1.7-2.5-2.5-4.1-1.9c-0.9,0.3-1.5,1-1.9,1.9c-0.1,0.5-0.2,1-0.2,1.5c0,0.1,0,0.2,0.1,0.2c0,0,0,0,0,0H188.5z"/><path role="presentation" d="M195.1,19.3c-0.1,0-0.3-0.1-0.3-0.2c0,0,0,0,0-0.1V6.2c0-0.1,0.1-0.3,0.2-0.3c0,0,0,0,0.1,0h1.8c0.1,0,0.3,0.1,0.3,0.2c0,0,0,0,0,0v1.4l0,0c0.7-1.3,2-2.1,3.5-2c1,0,1.9,0.3,2.7,1c0.1,0.1,0.2,0.3,0.1,0.4l-1,1.4c-0.1,0.1-0.2,0.2-0.3,0.1c0,0,0,0-0.1,0c-0.6-0.4-1.3-0.6-2-0.6c-2,0-2.8,1.6-2.8,3.9V19c0,0.1-0.1,0.3-0.2,0.3c0,0,0,0,0,0L195.1,19.3z"/><path role="presentation" d="M205.2,3.4C205.2,3.4,205.1,3.4,205.2,3.4C205.1,3.3,205.1,3.3,205.2,3.4l-0.1-2.7c0,0,0,0-0.1,0h-0.8c0,0-0.1,0-0.1-0.1l0,0V0.3c0,0,0-0.1,0.1-0.1c0,0,0,0,0,0h2.3c0,0,0.1,0,0.1,0.1c0,0,0,0,0,0v0.3c0,0,0,0.1-0.1,0.1l0,0h-0.8h0v2.6c0,0,0,0.1-0.1,0.1c0,0,0,0,0,0L205.2,3.4z M209.6,3.4C209.6,3.4,209.5,3.4,209.6,3.4C209.5,3.3,209.5,3.3,209.6,3.4l-0.1-2l0,0l-0.7,1.5c0,0-0.1,0.1-0.1,0.1h-0.3c-0.1,0-0.1,0-0.1-0.1l-0.7-1.5l0,0v1.9c0,0,0,0.1-0.1,0.1c0,0,0,0,0,0h-0.3c0,0-0.1,0-0.1-0.1c0,0,0,0,0,0v-3c0,0,0-0.1,0.1-0.1c0,0,0,0,0,0h0.3c0,0,0.1,0,0.1,0.1l0.9,2l0,0l0.9-2c0,0,0.1-0.1,0.1-0.1h0.3c0,0,0.1,0,0.1,0.1c0,0,0,0,0,0v3c0,0,0,0.1-0.1,0.1c0,0,0,0,0,0H209.6z"/></svg>
					</c:if>
					<span>${AppName}</span>
				</p>
			    	<form method="POST" action="../applications" id="">
			    	<div class="vw-extra-space" id="idpInfoContainer">
			    		<div class="vw-extra-space loginMsg vw-login-message hidden error-box">&nbsp;</div>
			    		<div class="vw-login-sso">
							<div id="ssoMessage" class="vw-message alert  vw-start-hidden sso-div">
								<span class="sso-one-line">
								<fmt:message key="login.sso.attemptingSSOIn" > <fmt:param value="<span id='ssotimer'>${applicationScope.LoginSSORedirectTimeout}</span>" /></fmt:message>
								</span>
								<a id="cancel" href="#" class="alert-link vw-sso-button pull-right"><fmt:message key="Cancel" /></a>
							</div>
							<div id="cvSSOMessage" class="vw-message alert  vw-start-hidden sso-div">
									<span id="cvAccountsFetchingSSOSiteURL">
										<fmt:message key="lable.login.fetchingSSOServerRedirectURL" ></fmt:message>
									</span>
									<div id="cvAccountsSSOSuccessMessage" style="display:inline-block;">
										<fmt:message key="lable.login.redirectingToSSOServer" ></fmt:message>
									</div>
									<span id="cvAccountsSSOServerName"></span>
									<a id="dismissCVAccountsSSO" href="#" class="alert-link vw-sso-button pull-right"><fmt:message key="Cancel" /></a>
							</div>
							<div id="idpSSO" class="vw-message alert vw-start-hidden sso-div">
								<span id="idpSSOMessages" class="vw-start-hidden ">
									<div class="text-center" id="idpSSORedirectUrlListContainer">
										<ul class="idpSSORedirectUrlList list-group">
										</ul>
										<a id="dismissIdpSSO" class="float-right alert-link vw-sso-button" href="#"><fmt:message key="Cancel" /></a>
									</div>
								</span>
							</div>
			 			</div>
			 		</div>
			    		<div class="form-group">
				 			<label class="control-label sr-only" for="username"><fmt:message key="Username" /></label>
				 				<c:choose>
					 				<c:when test="${applicationScope.devUserName == null}">
					 					<input type="text" id="username" name="username" placeholder="<fmt:message key="usernameOrEmail" />" class="textbox form-control"/>
					 				</c:when>
					 				<c:otherwise>
					 					<input type="text" id="username" name="username" class="textbox form-control" value="${applicationScope.devUserName}"/>
					 					<c:set var="isAutoLogin" value="${true}" />
					 				</c:otherwise>
				 				</c:choose>
			    		</div>
			    		<div class="form-group">
				 			<label class="control-label sr-only" for="password"><fmt:message key="Password" /></label>
				 				<c:choose>
					 				<c:when test="${applicationScope.devPassword == null}">
										<input type="password" id="password" autocomplete="off" placeholder="<fmt:message key="Password" />" name="password" class="textbox form-control hidden"/>
									</c:when>
					 				<c:otherwise>
										<input type="password" id="password" autocomplete="off" placeholder="<fmt:message key="Password" />" name="password" class="textbox form-control hidden" value="${applicationScope.devPassword}"/>
										<c:set var="isAutoLogin" value="${true}" />
				 					</c:otherwise>
			 					</c:choose>
						</div>

						<div class="form-group hidden" id="tfaPinBlock" name="tfaPinBlock">
				 			<label class="control-label sr-only" for="tfaPin"><fmt:message key="Pin" /></label>
				 			<div class="input-group">
				 				<input type="password" id="tfaPin" name="tfaPin" autocomplete="off" placeholder="<fmt:message key="Pin" />" class="textbox form-control"/>
								<span class="input-group-btn"><button id="getPinBtn" name="getPinBtn" type="button" class="vw-btn vw-btn-primary"><fmt:message key="getPin" /></button></span>
							</div>

						</div>

						<c:if test="${requestScope.appNotInitialized == true}">
							<div class="vw-extra-space">
								<div class="vw-extra-space vw-login-message error-box alert vw-alert-danger">AppNotInitialized, enter hostname</div>
							</div>
						</c:if>
						<c:if test="${applicationScope.IS_DEVMODE == true || applicationScope.noInitialBaseUrl == true }">
							<div class="form-group">
								<label class="control-label sr-only" for="url"><fmt:message key="Url" /></label>
						 		<input type="text" id="url" name="url" placeholder="<fmt:message key="Url" />" class="textbox form-control"/>
				 			</div>
			 			</c:if>
						<c:if test="${param.app != 3 && !cv:getConfigPropertyForKey('hideStayLoggedIn')}">
							<div class="form-group">
								<div id="loginchkbox" class="loginchkbox vw-checkbox-container hidden">
									<div class="custom-cb vw-custom-checkbox ${stayLoggedInDefaultValue}" data-state="${stayLoggedInDefaultValue}" id="stayactivebox" tabindex="0" role="checkbox" aria-labelledby="stay-logged-in-label" aria-checked="${stayLoggedInDefaultAriaValue}"></div><span class="custom-cb-label vw-form-label" id="stay-logged-in-label"><fmt:message key="Stay_Logged_In" /></span>
								</div>
							</div>
						</c:if>
			 			<div class="form-group">
							<a id="continuebtn" class="mainBtn vw-btn vw-btn-primary" href="#"><span class="vw-btn-text"><fmt:message key="Continue" /></span><svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-spin"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg></a>
							<a id="loginbtn" class="mainBtn vw-btn vw-btn-primary hidden" href="#"><span class="vw-btn-text"><fmt:message key="Login" /></span><svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-spin"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg></a>
						</div>
						<c:if test="${param.app != 3}">
							<div class="form-group clearfix">
							 <div id="reg_pass" class="pull-left vw-alternate-actions vw-alternate-actions-login">
							 <ul>
								<c:if test="${applicationScope.disableUserPasswordManagement == false}">
									<c:choose>
						 				<c:when test="${param.app == '1'}">
							 				<c:choose>
								 				<c:when test="${param.foreignCallback  == '1'}">
								 					<li id="forgotPwdLink" class="${forgotPasswordVisibilityClass}"><a href="${pageContext.request.contextPath}/login/forgotPassword.jsp?app=1&foreignCallback=1&foreignCallbackUrl=${param.callBackUrl}"><fmt:message key="Forgot_Password" /></a></li>
								 				</c:when>
								 				<c:otherwise>
								 					<li id="forgotPwdLink" class="${forgotPasswordVisibilityClass}"><a href="${pageContext.request.contextPath}/login/forgotPassword.jsp?app=1"><fmt:message key="Forgot_Password" /></a></li>
								 				</c:otherwise>
											</c:choose>
						 				</c:when>
						 				<c:otherwise>
						 					<li id="forgotPwdLink" class="${forgotPasswordVisibilityClass}"><a href="${pageContext.request.contextPath}/login/forgotPassword.jsp"><fmt:message key="Forgot_Password" /></a></li>
						 				</c:otherwise>
									</c:choose>
								</c:if>
								<c:if test="${applicationScope.SHOW_SOCIAL_REG_LINK == true}">
									<li><a href="${pageContext.request.contextPath}/login/registerSocialSignIn.jsp"><fmt:message key="Register_Social_Sign_In" /></a></li>
								</c:if>
								<c:if test="${applicationScope.SHOW_INDIVIDUAL_REG_LINK == true}">
									<li><a href="${customRegisterUrl}"><fmt:message key="Register" /></a></li>
								</c:if>
								</ul>
								</div>
							</div>
						</c:if>

					 </form>
				</div>
			</div>


</div>

<div id="divTfaSecretQRCode" class="vw-center-container hidden">
	<div class="vw-vertical-center">
		<div class="vw-horizontal-center">
			<div id="custom-logo"></div>
			<p class="vw-page-title"><fmt:message key="tfa.secretQRCode.registerHeading"/></p>
			<p><fmt:message key="tfa.secretQRCode.registerMessage" /></p>

			<div class="secret-qr-image"><img id="qrImage" alt="QR Code" src=""/></div>
			<p><fmt:message key="secretQRHelpMessage" /></p>
			<div><p class="secret-qr-help"><fmt:message key="secretQRHelpAccount" /></p><p class="secret-qr-data"><span id="spanTFAAccount" /></p></div>
			<div><p class="secret-qr-help"><fmt:message key="secretQRHelpKey" /></p><p class="secret-qr-data"><span id="spanTFAKey" /></p></div>
			<div><p class="secret-qr-help"><fmt:message key="secretQRHelpTimeBased" /></p><p class="secret-qr-data"><fmt:message key="secretQRHelpTimebasedStatus" /></p></div>
			<div class="form-group">
				<a id="goLoginBackBtn" class="mainBtn vw-btn vw-btn-primary" href="#"><span class="vw-btn-text"><fmt:message key="returnToLogin" /></span><svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-spin"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg></a>
			</div>
		</div>
	</div>
</div>
		    <!--<c:choose>
		    	<c:when test="${sessionScope.doSSO != null && sessionScope.doSSO}">
		    		<c:remove var="doSSO" scope="session"/>
		    		<script nonce="${sessionScope.cspNonce}" >
			    		$(document).on("ready", function(){
			    			checkSSO();
			    		});
					</script>
		    	</c:when>
		    </c:choose>-->

		     <fmt:message key="Exception_Text"  var="Exception_TextVar" />
		     <fmt:message key="legal.eulaText"  var="eulaTextVar" />
		     <fmt:message key="error.cvAccountsServerConnectionFailed.message"  var="failedToConnectToServer" />
		     <fmt:message key="label.login.redirectingToCommcell"  var="label_redirectingToCommcell" />
		     <fmt:message key="label.login.redirectingToSAMLIDP"  var="label_redirectingToSAMLIDP" />
		     <fmt:message key="label.login.chooseConsole"  var="label_pickARedirectUrl" />
		     <fmt:message key="login.javaGui.error"  var="label_javaGui_error" />


		<c:if test="${sessionScope.forceChangePwdUser != null}">
			<script nonce="${sessionScope.cspNonce}" >

				var forceChangePwdUser = "${sessionScope.forceChangePwdUser}";
				$("#username").val(forceChangePwdUser);

			</script>
			<c:remove var="forceChangePwdUser" scope="session" />
		</c:if>

		    <script nonce="${sessionScope.cspNonce}" >
				var localMsg = localMsg || {};
				localMsg.lockedAccount= "${lockedAccount}";
				localMsg.numberDays="${numberDays}";
				localMsg.numberHours="${numberHours}";
				localMsg.numberMinutes="${numberMinutes}";
				localMsg.label_redirectingToCommcell="${label_redirectingToCommcell}";
				localMsg.label_pickARedirectUrl="${label_pickARedirectUrl}";
				localMsg.label_redirectingToSAMLIDP="${label_redirectingToSAMLIDP}";
				localMsg.label_javaGui_error = "${label_javaGui_error}";
				localMsg.enterEmailOrUsername = "${enterEmailOrUsername}";

				localMsg.loginErrorGetTfaPin = "${loginErrorGetTfaPin}";
				localMsg.loginSuccessGetTfaPin = "${loginSuccessGetTfaPin}";

		    	var isAutoLogin = "${isAutoLogin}";
		    	var forceSAMLLogin = "${cvConfig.forceSAMLLogin()}" == "true";
		    	if(window != cvUtil.getTopWindow()) {
		    		cvUtil.getTopWindow().location.href = window.location.href;
		    	}
		    	var ssoUserName = '${sessionScope.REQUEST_USER_NAME}';
		    	var isLogout = "${fn:escapeXml(param.action)}";
		    	var Exception_TextVar = "${Exception_TextVar}";
		    	var eulaTextVar = "${eulaTextVar}";
		    	nh.clearNotificationHistory();
		    	var ssoTimerCount='<c:out value="${applicationScope.LoginSSORedirectTimeout}"/>';
		    	var isCvSSOEnabled = '${applicationScope.bEnableCvAccountsSSO}';
		    	var disableSSORedirect = "${fn:escapeXml(param.disableSSORedirect)}"
	    		var callBackUrl = "${fn:escapeXml(param.callBackUrl)}";
	    		var failedToConnectToServer = '${failedToConnectToServer}';
	    		var sTkValidity = "${fn:escapeXml(param.sTkValidity)}";
	    		var isIDPSSOEnabled = "${applicationScope.isIDPSSOEnabled}";
                var isTFAEnabled = "${applicationScope.isTFAEnabled}";
	    		var redirectAfterLoginType = "${fn:escapeXml(param.redirectAfterLoginType)}";
	    		var idpSSOUserName = '${fn:replace(fn:escapeXml(param.username),'\\','\\\\')}';
	    		var spSid = "${fn:escapeXml(param.spSID)}";
	    		var app = "${fn:escapeXml(param.app)}";
				var isOidcAppPresent = ("${applicationScope.isOpenIdConnectAppPresent}" === "true");
				var errorToDisplay = "${fn:escapeXml(param.etd)}";
				var disableTPSSO = "${fn:escapeXml(param.disableTPSSO)}";
				var foreignCallback = "${fn:escapeXml(param.foreignCallback)}";
				var targetURIFromSessionScope = '${sessionScope.TARGETURI}';
				var requestFromIDP = '${fn:escapeXml(param.requestFromIDP)}';
				var getToken 			= "${fn:escapeXml(param.getToken)}"; // see GetAuthTokenForThirdPartyApplicationHelper.java for more info.
				var consoleType  = "${fn:escapeXml(param.consoleType)}";
	    		var loopyMobileLogin = "${fn:escapeXml(param.loopyMobileLogin)}";
		    </script>

	   <jsp:include page="../common/footerV3.jsp">
	    <jsp:param value="true" name="bootstrapped" />
	   	<jsp:param value="${pageContext.request.contextPath}/login/js/login.js" name="js"/>
		<jsp:param value="${pageContext.request.contextPath}/common/js/encoder.js" name="js"/>
		<jsp:param value="${pageContext.request.contextPath}/common/js/custom-cb.js" name="js" />
	   </jsp:include>
