<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<jsp:include page="../common/headerV3.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="true" name="not_logged_in" />
	<jsp:param value="${requestScope.ACK_TITLE}" name="titleLocalized" />
	<jsp:param value="true" name="showOnlyHelp" />
</jsp:include>

<div id="loginform" class="vw-block-container vw-center-container">
	<div class="vw-vertical-center">
		<div class="vw-horizontal-center">
			<div class="vw-light-block">
				<h1 class="logintitle vw-page-title" id="forgotpass-title">${requestScope.ACK_TITLE}</h1>
				<p>${requestScope.ACK_MESSAGE}</p>
			</div>

			<c:choose>
				<c:when test='${cv:isUserLoggedIn(pageContext.request)}'>
					<p class="vw-alternate-actions"><a href="index.jsp"><fmt:message key="ReturnTo_applications" /></a></p>
				</c:when>
				<c:otherwise>
					<p class="vw-alternate-actions"><a href="index.jsp"><fmt:message key="Sign_In" /></a></p>
				</c:otherwise>
			</c:choose>
		</div>
	</div>
</div>

<jsp:include page="../common/footerV3.jsp">
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>