<%@ page contentType="text/css; charset=UTF-8" %>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>


<%-- Place a condition to load the file only if either a reqParam or theme is set from tenant --%>
<c:if test="${webconsoleThemeOverride && theme.headerColor != null && theme.headerColor != ''}">
body.vw-fullscreen-mode .vw-header {
	background: ${theme.headerColor};
}
#container {
	width: 100% !important;
}
#header:not(.hidden-print) {
	background: ${theme.headerColor};
}
</c:if>
<c:if test="${webconsoleThemeOverride && theme.headerTextColor != null && theme.headerTextColor != ''}">
body.vw-fullscreen-mode .vm-mydata-title, body.vw-fullscreen-mode .vw-header .vw-drop-down-toggle,
body.vw-fullscreen-mode .vw-header .vw-drop-down-toggle:hover {
	color: ${theme.headerTextColor} !important;
}
body #helpText, body #languagesText, body #usernameText{
	color: ${theme.headerTextColor} !important;
}
#header {
	color: ${theme.headerTextColor} !important;
}
body.vw-fullscreen-mode .vw-header .vm-mydata-title {
	box-shadow: -1px 0px 0 0 ${theme.headerTextColor} !important;
}
</c:if>
<c:if test="${theme.headerTextColor != null && theme.headerTextColor != ''}">


body.vw-fullscreen-mode .vw-header .vw-navigation-container .vw-pinhome svg {
	fill: ${theme.headerTextColor};
}

body.vw-fullscreen-mode .vw-header .vw-navigation-container .vw-pinhome:focus {
	box-shadow: 0 1px 0 ${theme.headerTextColor};
}


</c:if>
<%-- Custom logos in the header only --%>
<c:if test="${theme.customLogoSmall != null && theme.customLogoSmall != ''}">

#pglogo,
body.vw-fullscreen-mode #pglogo {
	max-width: 170px;
	max-height: 28px;
	width: 170px;
	height: 28px;
}

body.vw-fullscreen-mode #pglogo.vw-navbar-brand {
	max-width: 170px;
	max-height: 40px;
	width: 170px;
	height: 40px;
}

body.vw-fullscreen-mode .vm-mydata-title {
	margin-left: 0;
}

body.vw-fullscreen-mode .vw-header .vw-brand-container .vw-navbar-brand {
	margin:		5px 10px 5px 0;
	padding-top:	0;
	padding-bottom:	0;
}

</c:if>

<%-- only showing the SVG for "Command Center" if there is no custom logo set. Otherwise, it gets plain text. --%>
<c:if test="${theme.isSameLogo == true || (theme.customLogo != null && theme.customLogo != '')}">
.vw-commvault-logo,
body.vw-fullscreen-mode.vw-body_not-logged-in .vw-logo-lock-up svg {
	display: none;
}

body.vw-fullscreen-mode.vw-body_not-logged-in .vw-logo-lock-up svg + span {
	display: block;
}

#custom-logo {
	background-size: contain;
	background-position: center;
	background-repeat: no-repeat;
	background-image: url("data:image/${theme.customLogo}") !important;
	margin-top: 0;
	margin-bottom: 20px;
	height: 100px;
}

.vw-container_fullscreen .vw-center-container .vw-login-min-height {
	min-height: 511px;
}

</c:if>

<c:if test="${theme.isSameLogo == true && theme.customLogoSmall != null && theme.customLogoSmall != ''}">
#custom-logo {
	background-image: url("data:image/${theme.customLogoSmall}") !important;

}
</c:if>

<c:if test="${theme.warningLoginBanner != null && theme.warningLoginBanner != ''}">
.vw-logo-warningLoginBanner {
	padding: 25px 0;
}
<enhance:out escapeXml="false">
.vw-logo-warningLoginBanner::before {
 	content: "${theme.warningLoginBanner}";
	display: block;
	word-break: break-all;
	text-align: center;
	white-space: pre;
}
</enhance:out>
</c:if>
<%-- primary color effect --%>
<c:if test="${theme.actionBtnBg != null && theme.actionBtnBg != ''}">

body.vw-fullscreen-mode.vw-body_not-logged-in .vw-btn.vw-btn-primary
 {
	background-color: ${theme.actionBtnBg};
}
</c:if>
<c:if test="${theme.actionBtnText != null && theme.actionBtnText != ''}">

body.vw-fullscreen-mode.vw-body_not-logged-in .vw-btn.vw-btn-primary{
	color: ${theme.actionBtnText} ;
}
</c:if>


<c:if test="${theme.loginAndBannerBg != null && theme.loginAndBannerBg != ''}">

.vw-fullscreen-mode.vw-body_not-logged-in, .vw-fullscreen-mode.vw-body_not-logged-in > #loginform,
.vw-fullscreen-mode .loading-spinner:before, .vw-fullscreen-mode .loading-spinner:after {
	background:${theme.loginAndBannerBg} !important;
}

body.vw-fullscreen-mode.vw-body_not-logged-in .vw-block-container .vw-light-block .vw-page-title,
body.vw-fullscreen-mode.vw-body_not-logged-in .vw-block-container .vw-light-block .vw-sprite-arrow,
 body.vw-fullscreen-mode.vw-body_not-logged-in .vw-block-container .vw-light-block
 { /* overrides UI Dialog */
	color: ${theme.loginAndBannerBg};
}


.vw-fullscreen-mode .vw-logo-windows-small .vw-sprite-apple, .vw-fullscreen-mode .vw-logo-windows-small .vw-sprite-linux, .vw-fullscreen-mode .vw-logo-osx-small .vw-sprite-windows,
.vw-fullscreen-mode .vw-logo-osx-small .vw-sprite-linux, .vw-fullscreen-mode .vw-logo-linux-small .vw-sprite-apple, .vw-fullscreen-mode .vw-logo-linux-small .vw-sprite-windows {
	fill: none;
}


.vw-container_fullscreen #browsetable.tablesorter tbody tr.row_selected td {
	background-color: transparent;
	box-shadow: 0px 0px 50px 50px rgba(255, 255, 255, 0.75) inset;
}


@media (min-width: 220px) and (max-width: 767px) {
	body.vw-fullscreen-mode.vw-body_not-logged-in .vw-header {
		background: ${theme.loginAndBannerBg};
	}
}

</c:if>

<%-- Nav Icon color effect --%>
<c:if test="${theme.navIconColor != null && theme.navIconColor != ''}">

body.vw-fullscreen-mode.vw-body_not-logged-in .vw-contains-drop-down > .vw-drop-down-toggle,
body.vw-fullscreen-mode.vw-body_not-logged-in  .vw-contains-drop-down > .vw-drop-down-toggle:not(.alert-link):hover,
body.vw-fullscreen-mode.vw-body_not-logged-in .vw-logo-lock-up, body.vw-fullscreen-mode.vw-body_not-logged-in :not(.input-group-btn) > .vw-btn.vw-btn-primary,
body.vw-fullscreen-mode.vw-body_not-logged-in .vw-alternate-actions a, body.vw-fullscreen-mode.vw-body_not-logged-in .vw-alternate-actions a:not(.alert-link):hover, body.vw-fullscreen-mode.vw-body_not-logged-in .vw-contains-drop-down > .vw-drop-down-toggle:not(.alert-link):hover,
body.vw-fullscreen-mode.vw-body_not-logged-in, body.vw-fullscreen-mode.vw-body_not-logged-in .vw-page-title, body.vw-fullscreen-mode.vw-body_not-logged-in .vw-small a,
body.vw-fullscreen-mode.vw-body_not-logged-in .loader-logout-link {
	color: ${theme.navIconColor};
}



body.vw-fullscreen-mode.vw-body_not-logged-in #container .vw-navbar-toggle,
body.vw-fullscreen-mode.vw-body_not-logged-in :not(.input-group-btn) > .vw-btn.vw-btn-primary,
body.vw-fullscreen-mode.vw-body_not-logged-in .input-group-btn .vw-btn-primary {
	border-color: ${theme.navIconColor};
}

body.vw-fullscreen-mode.vw-body_not-logged-in #container .vw-navbar-toggle:focus {
	box-shadow: 0 0 3px ${theme.navIconColor};
	-webkit-box-shadow: 0 0 3px ${theme.navIconColor};
}

body.vw-fullscreen-mode.vw-body_not-logged-in #container .vw-navbar-toggle .vw-icon-bar {
	background: ${theme.navIconColor};
}

.vw-fullscreen-mode.vw-body_not-logged-in .vw-custom-checkbox:focus {
	box-shadow: 0 0 8px ${theme.navIconColor};
	-webkit-box-shadow: 0 0 8px ${theme.navIconColor};
}

@media (min-width: 220px) and (max-width: 767px) {
	body.vw-fullscreen-mode.vw-body_not-logged-in #container .vw-dropdown-menu > li a {
		color: ${theme.navIconColor};
	}
}

</c:if>

<%-- link color --%>
<c:if test="${theme.linkText != null && theme.linkText != ''}">

a:hover,
a:focus,
.vw-drop-down-toggle:hover,
.vw-drop-down-toggle:focus { /* link color is always the same due to theme now; differentiate with underline */
	text-decoration: underline;
}
</c:if>

<c:if test="${theme.customBg != null && theme.customBg != ''}">

	body.vw-fullscreen-mode.vw-body_not-logged-in {
		background-image: url("data:image/${theme.customBg}") !important;
		background-size: cover !important;
	}

	.vw-horizontal-center.vw-login-min-height {
		position: relative;
	}

	.vw-horizontal-center.vw-login-min-height:before {
		position: absolute;
		width: 100%;
		height: 100%;
		background-color: ${ (theme.loginAndBannerBg != null && theme.loginAndBannerBg != "") ? theme.loginAndBannerBg: "#0B2E44" };
		opacity: 0.18;
		content: '';
		display: block;
		z-index: -1;
		border-radius: 5px;
		margin-top: -25px;
	}

	.vw-fullscreen-mode.vw-body_not-logged-in .vw-header  {
		background-color: transparent !important;
	}
</c:if>

<c:if test="${theme.customizeCSS != null && theme.customizeCSS != ''}">
${theme.getDecodedCustomizeCSS()};
</c:if>
