<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<c:choose>
	<c:when test="${param.includeLatestDatatable != null && param.includeLatestDatatable == 'true'}">
		<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/table/jquery.dataTables-1.10.minV3.js?${applicationScope.BUILD_TS}"></script>
	</c:when>
	<c:otherwise>
		<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/table/jquery.dataTables.min.js?${applicationScope.BUILD_TS}"></script>
	</c:otherwise>
</c:choose>

<c:if test="${param.bootstrapped != null && param.bootstrapped == 'true'}">
	<c:choose>
		<c:when test="${param.browsePage != null && param.browsePage == 'true'}">
			<link rel="stylesheet" href="${pageContext.request.contextPath}/common/datatables/css/dataTables.bootstrap.min.css?${applicationScope.BUILD_TS}" />
			<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/datatables/js/dataTables.bootstrap.js?${applicationScope.BUILD_TS}"></script>
		</c:when>
		<c:when test="${param.logMonitoring != null && param.logMonitoring == 'true'}">
			<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/datatables/js/dataTables.responsive.min.js?${applicationScope.BUILD_TS}"></script>
			<script nonce="${sessionScope.cspNonce}"	src="${pageContext.request.contextPath}/common/datatables/js/jquery-datatables-pagination-without-ellipses.js?${applicationScope.BUILD_TS}"> </script>
		</c:when>
		<c:when test="${param.lmSchedule != null && param.lmSchedule == 'true'}">
			<link rel="stylesheet" href="${pageContext.request.contextPath}/common/datatables/css/dataTables.bootstrap.min.css?${applicationScope.BUILD_TS}" />
			<link rel="stylesheet" href="${pageContext.request.contextPath}/common/datatables/css/responsive.bootstrap.min.css?${applicationScope.BUILD_TS}" />
		</c:when>
		<c:when test="${param.includeLatestDatatable != null && param.includeLatestDatatable == 'true'}">
			<link rel="stylesheet" href="${pageContext.request.contextPath}/common/datatables/css/dataTables.bootstrap.min.css?${applicationScope.BUILD_TS}" />
			<link rel="stylesheet" href="${pageContext.request.contextPath}/common/datatables/css/responsive.bootstrap.min.css?${applicationScope.BUILD_TS}" />
			<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/datatables/js/dataTables.responsive.min.js?${applicationScope.BUILD_TS}"></script>
			<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/datatables/js/dataTables.bootstrap.js?${applicationScope.BUILD_TS}"></script>
		</c:when>
		<c:otherwise>
			<!-- don't need other scripts -->
		</c:otherwise>
	</c:choose>
</c:if>

<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/table/jquery.jeditable.js?${applicationScope.BUILD_TS}"></script>
<c:if test="${param.disableTableColReordering == null || param.disableTableColReordering == 'false'}">
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/table/ColReorderWithResize.js?${applicationScope.BUILD_TS}"></script>
</c:if>
<c:if test="${param.enableTableRowGrouping != null || param.enableTableRowGrouping == 'true'}">
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/table/jquery.dataTables.rowGrouping.js?${applicationScope.BUILD_TS}"></script>
</c:if>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/table/Scroller.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}"  type="text/javascript">

var CVTable = {
		table: '_table',
		pager: '_pager'
};
$.fn.dataTableExt.oApi.fnDisplayStart = function ( oSettings, iStart, bRedraw )
{
    if ( typeof bRedraw == 'undefined' )
    {
        bRedraw = true;
    }

    oSettings._iDisplayStart = iStart;
    oSettings.oApi._fnCalculateEnd( oSettings );

    if ( bRedraw )
    {
        oSettings.oApi._fnDraw( oSettings );
    }
};

$.fn.dataTableExt.oApi.fnReloadAjax = function ( oSettings, sNewSource, fnCallback, bStandingRedraw )
{
    if ( typeof sNewSource != 'undefined' && sNewSource != null )
    {
        oSettings.sAjaxSource = sNewSource;
    }
    this.oApi._fnProcessingDisplay( oSettings, true );
    var that = this;
    var iStart = oSettings._iDisplayStart;
    var aData = [];

    this.oApi._fnServerParams( oSettings, aData );

    oSettings.fnServerData( oSettings.sAjaxSource, aData, function(json) {
        /* Clear the old information from the table */
        that.oApi._fnClearTable( oSettings );

        /* Got the data - add it to the table */
        var aData =  (oSettings.sAjaxDataProp !== "") ?
            that.oApi._fnGetObjectDataFn( oSettings.sAjaxDataProp )( json ) : json;

        for ( var i=0 ; i<aData.length ; i++ )
        {
            that.oApi._fnAddData( oSettings, aData[i] );
        }

        oSettings.aiDisplay = oSettings.aiDisplayMaster.slice();
        that.fnDraw();

        if ( typeof bStandingRedraw != 'undefined' && bStandingRedraw === true )
        {
            oSettings._iDisplayStart = iStart;
            that.fnDraw( false );
        }

        that.oApi._fnProcessingDisplay( oSettings, false );

        /* Callback user function - for event handlers etc */
        if ( typeof fnCallback == 'function' && fnCallback != null )
        {
            fnCallback( oSettings );
        }
    }, oSettings );
};

$.fn.dataTableExt.afnFiltering.push(
		function( oSettings, aData, iDataIndex ) {
			var isOr = (cvUtil.getParameter("isOr", "") == "true" || oSettings.isOr) ? true : false;
			// for alert we also need OR filtering. The other/default condition is AND filtering.
			var result=true;
			var OPERATORS = ['begins:', 'ends:', 'equals:', 'notequals:', 'contains:', 'notcontains:',
				'>=', '<=', '<>', '!=', '<', '>', '=', 'inlast', 'innext', 'beyondlast', 'beyondnext', 'isempty', 'notlike', 'notempty'];
			for ( var i = 0; i < oSettings.aoColumns.length; i++) {
				if (oSettings.aoColumns[i].bVisible && oSettings.aoColumns[i].sSearch){
					var search = oSettings.aoColumns[i].sSearch.toString().toLowerCase();
					search=$.trim(search);
					var tokens = [];
					var isOrInCol = false;
					if(search.indexOf(" or ") > -1) {
						tokens = search.split(' or ');
						isOrInCol = true;
					} else if(search.indexOf(" || ") > -1) {
						tokens = search.split(' || ');
						isOrInCol = true;
					} else if(search.indexOf(" and ") > -1) {
						tokens = search.split(' and ');
					} else if(search.indexOf(" && ") > -1) {
						tokens = search.split(' && ');
					} else {
						tokens.push(search);
					}

					var valueInModel = aData[i];
					result = true;
					$.each(tokens, function(index, condition){
						var filterRendered = oSettings.aoColumns[i].bFilterRendered;
						filterRendered = filterRendered == undefined ? true : filterRendered;
						var hasRenderer = oSettings.aoColumns[i].fnRender != null;
						var operator = "";
						var rendererName = oSettings.aoColumns[i].rendererType;
						var now = parseInt(new Date().getTime()/1000, 10) - new Date().getTimezoneOffset() * 60;

						search = $.trim(condition);
						if(isOrInCol) {
							result = true;
						}
						if(search != "") {
							for (var ndx = 0; ndx < OPERATORS.length; ndx++) {
								var op = OPERATORS[ndx];
								if (search.indexOf(op) == 0) {
									operator = search.substring(0, op.length);
									search = $.trim(search.substring(op.length));
									break;
								}
							}

							if(hasRenderer) {
								if(filterRendered) {
									if(operator == "") {
										valueInModel = oSettings.aoColumns[i].fnRender({iDataColumn: i, aData:oSettings.aoData[iDataIndex]._aData, oSettings:oSettings},aData[i]);
									} else if(typeof Reports != 'undefined' && typeof Reports.Renderers != 'undefined'){
										// get unformatted search token value.
										if(typeof rendererName!='undefined' && typeof Reports != 'undefined'
												&& Reports.Renderers[rendererName].length == 4) {		// new renderer
											// Missing validation??? @TODO
											 search = Reports.Renderers[rendererName](null, null, null, {unformat: true})(search);
											// need to get the rendered formatted value
											// and get the unformatted value for it
											// as the actual value in the model might have been rounded-off during formatting.
											// applicable for capacity, capacityMB, capacityMB_Neg, LicenseSizeMB
											if(rendererName == "capacity"
													|| rendererName == "capacityMB"
													|| rendererName == "capacityMB_Neg"
														|| rendererName == "DifferenceMB"
														|| rendererName == "LicenseSizeMB") {
												var v = oSettings.aoColumns[i].fnRender({iDataColumn: i,
													aData:oSettings.aoData[iDataIndex]._aData, oSettings:oSettings},aData[i]);
												if(rendererName == "DifferenceMB" && v == 'N/A'){
													//nothing.. for null values
												}else{
													valueInModel = Reports.Renderers[rendererName](null, null, null, {unformat: true})(v.toLowerCase());
												}

											}
										} else {
											// calc search
										}
									}
								} else {
									if(typeof rendererName!='undefined' && typeof Reports != 'undefined'
											&& typeof Reports.Renderers != 'undefined'
											&& Reports.Renderers[rendererName].length == 4) {		// new renderer
										// There are some special renderers which have html with images
										// and in the model they have some special representation(eg: 4_Critical for health status)
										// we split these and prepare the rendered value, and when = operator is used
										// and if the actual model value is not passed, no rows will be shown.
										// the optional customValueFn acts as a bridge between the internal value and the rendered value.
										var customValueFn = Reports.Renderers[rendererName](null, null, null, {customValueFn: true});
										if(!!customValueFn && typeof customValueFn == "function") {
											valueInModel = Reports.Renderers[rendererName](null, null, null, {customValueFn: true})(valueInModel);
										}
									}
								}

							} else {
								// Nothing to do here as well.
							}
							if(!valueInModel && valueInModel != 0 ){//return false for null values.
								result = false;
								return false;
							}

							// use operator to calc the value of result(true/false)
							valueInModel=valueInModel.toString().toLowerCase();
							search = search.toString().toLowerCase();

							if(operator != ""){
								if(!isNaN(search) && !(/[a-zA-Z]/g).test(search)){
									search=parseFloat(search);
								}
								if(!isNaN(valueInModel) && !(/[a-zA-Z]/g).test(valueInModel)) {
									valueInModel = parseFloat(valueInModel, 10);
								}
							}
							if(operator == "") {//this is for contain
								result = valueInModel.toString().indexOf(search) > -1 ? true : false;
							} else if(operator=="notlike") { // does not contain
								result = valueInModel.toString().indexOf(search) > -1 ? false : true;
							} else if(operator==">=") {
								if(valueInModel < search)
									result = false;
							} else if(operator=="<=") {
								if(valueInModel > search)
									result = false;
							} else if(operator==">") {
								if(valueInModel <= search)
									result = false;
							} else if(operator=="<") {
								if(valueInModel >= search)
									result = false;
							} else if(operator=="=") {
								if(valueInModel != search)
									result = false;
							} else if(operator=="inlast") {
								if((now-search)> valueInModel || valueInModel > now)
									result = false;
							} else if(operator=="innext") {
								if(now > valueInModel || valueInModel > now + search)
									result = false;
							} else if(operator=="beyondlast") {
								if(valueInModel > now - search)
									result = false;
							} else if(operator=="beyondnext") {
								if(valueInModel < now + search)
									result = false;
							} else if(operator=="<>" || operator=="!=") {
								if(valueInModel == search)
									result = false;
							}else if(operator=="isempty") {
								valueInModel = $.trim(aData[i]).toLowerCase();
								if(valueInModel != "")
									result = false;
							}else if(operator=="notempty") {
								valueInModel = $.trim(aData[i]).toLowerCase();
								if(valueInModel == "")
									result = false;
							} else {
								// operators from custom reports...
								valueInModel = $.trim(aData[i]).toLowerCase();
								if (operator == 'begins:') {
									if (valueInModel.indexOf(search) != 0) {
										result = false;
									}
								} else if (operator == 'ends:') {
									search = '' + search;
									if (valueInModel.length < search.length
											|| valueInModel.substring(valueInModel.length - search.length, valueInModel.length) != search ) {
										result = false;
									}
								} else if (operator == 'equals:') {
									if(valueInModel != search) {
										result = false;
									}
								} else if (operator == 'notequals:') {
									if(valueInModel == search) {
										result = false;
									}
								} else if (operator == 'contains:') {
									if(valueInModel.indexOf(search) < 0) {
										result = false;
									}
								} else if (operator == 'notcontains:') {
									if(valueInModel.indexOf(search) >= 0) {
										result = false;
									}
								}
							}

							if(isOr || isOrInCol) {
								if(result == true) {
									return false; //break the loop
								}
							}
							else if(result==false) {
								return false; //break the loop
							}
						}

					});
					if(isOr) {
						if(result == true) {
							return true;
						}
					} else {
						if(result==false)
							return false;

					}
				}
			}
			return result;
		}
	);

$.fn.dataTableExt.oPagination.input = {
	    /*
	     * Function: oPagination.input.fnInit
	     * Purpose:  Initalise dom elements required for pagination with input textbox
	     * Returns:  -
	     * Inputs:   object:oSettings - dataTables settings object
	     *           node:nPaging - the DIV which contains this pagination control
	     *           function:fnCallbackDraw - draw function which must be called on update
	     */
	    "fnInit": function ( oSettings, nPaging, fnCallbackDraw )
	    {
	        var nFirst = document.createElement( 'span' );
	        var nPrevious = document.createElement( 'span' );
	        var nNext = document.createElement( 'span' );
	        var nLast = document.createElement( 'span' );
	        var nInput = document.createElement( 'input' );
	     //   var nPage = document.createElement( 'span' );
	     //   var nOf = document.createElement( 'span' );

	        nFirst.innerHTML = oSettings.oLanguage.oPaginate.sFirst;
	        nPrevious.innerHTML = oSettings.oLanguage.oPaginate.sPrevious;
	        nNext.innerHTML = oSettings.oLanguage.oPaginate.sNext;
	        nLast.innerHTML = oSettings.oLanguage.oPaginate.sLast;

	        nFirst.className = "paginate_button first";
	        nPrevious.className = "paginate_button previous";
	        nNext.className="paginate_button next";
	        nLast.className = "paginate_button last";
	      //  nOf.className = "paginate_of";
	       // nPage.className = "paginate_page";

	        if ( oSettings.sTableId !== '' )
	        {
	            nPaging.setAttribute( 'id', oSettings.sTableId+'_paginate' );
	            nFirst.setAttribute( 'id', oSettings.sTableId+'_first' );
	            nPrevious.setAttribute( 'id', oSettings.sTableId+'_previous' );
	            nNext.setAttribute( 'id', oSettings.sTableId+'_next' );
	            nLast.setAttribute( 'id', oSettings.sTableId+'_last' );
	        }

	        nInput.type = "text";
	        nInput.style.width = "15px";
	        nInput.style.display = "inline";
	        //nPage.innerHTML = "Page ";

	        nPaging.appendChild( nFirst );
	        nPaging.appendChild( nPrevious );
	       // nPaging.appendChild( nPage );
	        nPaging.appendChild( nInput );
	      //  nPaging.appendChild( nOf );
	        nPaging.appendChild( nNext );
	        nPaging.appendChild( nLast );

	        $(nFirst).click( function () {
	            oSettings.oApi._fnPageChange( oSettings, "first" );
	            fnCallbackDraw( oSettings );
	        } );

	        $(nPrevious).click( function() {
	            oSettings.oApi._fnPageChange( oSettings, "previous" );
	            fnCallbackDraw( oSettings );
	        } );

	        $(nNext).click( function() {
	            oSettings.oApi._fnPageChange( oSettings, "next" );
	            fnCallbackDraw( oSettings );
	        } );

	        $(nLast).click( function() {
	            oSettings.oApi._fnPageChange( oSettings, "last" );
	            fnCallbackDraw( oSettings );
	            debugger;
	        } );

	        $(nInput).on('keydown', function(e) {
	        	if (e.which == 13 && this.value > 0)  {
	        		fnCallbackDraw( oSettings );
	        	}
	        });

	        $(nInput).keyup( function (e) {
	        	var isDirKey = false;
	        	nInput.style.width = (e.target.value.length * 5 + 15)+ 'px';
                if ( e.which == 38 || e.which == 39 )
	            {
	                this.value++;
	                isDirKey = true;
	            }
	            else if ( (e.which == 37 || e.which == 40) && this.value > 1 )
	            {
	            	isDirKey = true;
	                this.value--;
	            }

	            if ( this.value == "" || this.value.match(/[^0-9]/) )
	            {
	                /* Nothing entered or non-numeric character */
	                return;
	            }
	            if(oSettings.fnRecordsDisplay()>0 && this.value=="0")
	            	this.value=1;

	            var iNewStart = oSettings._iDisplayLength * (this.value - 1);

	            if ( iNewStart >= oSettings.fnRecordsDisplay() )
	            {
	                /* Display overrun */
	                oSettings._iDisplayStart = (Math.ceil((oSettings.fnRecordsDisplay()-1) /
	                    oSettings._iDisplayLength)-1) * oSettings._iDisplayLength;
	                if(oSettings._iDisplayStart<0)
	                	oSettings._iDisplayStart=0;
	            } else
	            	oSettings._iDisplayStart = iNewStart;
	            if (isDirKey)
	            	fnCallbackDraw( oSettings );

	        } );

	        /* Take the brutal approach to cancelling text selection */
	        $('span', nPaging).bind( 'mousedown', function () { return false; } );
	        $('span', nPaging).bind( 'selectstart', function () { return false; } );
	    },

	    /*
	     * Function: oPagination.input.fnUpdate
	     * Purpose:  Update the input element
	     * Returns:  -
	     * Inputs:   object:oSettings - dataTables settings object
	     *           function:fnCallbackDraw - draw function which must be called on update
	     */
	    "fnUpdate": function ( oSettings, fnCallbackDraw )
	    {
	        if ( !oSettings.aanFeatures.p )
	        {
	            return;
	        }
	        var iPages=0, iCurrentPage=0;
	        if(oSettings._iDisplayLength!=0)
	        {
	        	iPages = Math.ceil((oSettings.fnRecordsDisplay()) / oSettings._iDisplayLength);
	        	iCurrentPage = Math.ceil(oSettings._iDisplayStart / oSettings._iDisplayLength) + 1;
	        }

	        /* Loop over each instance of the pager */
	        var an = oSettings.aanFeatures.p;
	        for ( var i=0, iLen=an.length ; i<iLen ; i++ )
	        {
	        	if(iPages<2) //1 or 0
		        {
	        		$(an[i]).hide();
		        }
	        	else
	        		$(an[i]).show();
	            var spans = an[i].getElementsByTagName('span');
	            var inputs = an[i].getElementsByTagName('input');
	      //      spans[3].innerHTML = " of "+iPages;
	            inputs[0].value = iCurrentPage;
	            inputs[0].style.width = (inputs[0].value.length * 5 + 15)+ 'px';

	            if ( an[i].childNodes.length !== 0 )
	            {
	                spans[0].className = 'paginate_button first '+
	                    (( oSettings._iDisplayStart === 0 ) ?
	                    'disabled' : 'enabled');

	                spans[1].className = 'paginate_button previous '+
	                    (( oSettings._iDisplayStart === 0 ) ?
	                    		'disabled' : 'enabled');

	                spans[2].className = 'paginate_button next '+
	                    (( oSettings.fnDisplayEnd() == oSettings.fnRecordsDisplay() ) ?
	                    		'disabled' : 'enabled');

	                spans[3].className = 'paginate_button last '+
	                   ( ( oSettings.fnDisplayEnd() == oSettings.fnRecordsDisplay() ) ?
	                    		'disabled' : 'enabled');
	            }
	        }
	    }
	};
CVTable.styleIt = function()
{
	$('.dataTables_paginate').addClass('vw-pagination-with-sprites');
	$(".dataTables_paginate input").click(function(e){
		//$(this).css("background","url('../common/img/pging_bg_edit.png') repeat-x 0 0 transparent").css("width","25px");
		e.stopPropagation();
	});
	$('html').click(function(){
		//$(".dataTables_paginate input").css("background","url('../common/img/pging_bg.png') repeat-x 0 0 transparent").css("width","15px");
	}).keypress(function(event){
		var keycode = (event.keyCode ? event.keyCode : event.which);
		if(keycode == '13'){
			//$(".dataTables_paginate input").css("background","url('../common/img/pging_bg.png') repeat-x 0 0 transparent").css("width","15px").blur();
			}

	});
};
</script>
