<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<%--
    This page exists for cases where a page needs to be opened in a new tab,
    but via some function call executed asynchronously. In most browsers, if a
    new tab is opened by a function and the call stack does not show a user-
    initiated event, the browser will block it as a pop-up. Sometimes pages
    need to be opened in response to asynchronous calls (for example, after
    fetching the URL of a CommCell's Java Console). The workaround is to open a
    tab when the user event occurs, store a reference to the window object, and
    then update the window location within the callback of the asynchronous
    operation. During this time, it is preferable to show the user a page
    informing them that their content is loading. This serves that purpose, and
    will intentionally and continuously fire off page requests in an iframe to
    force the loading animation on the page tab. When requested with no params,
    the page just shows a loading message. When requested with a sleep
    parameter, it sleeps for the provided number of milliseconds.
--%>
<c:set var="esleep" value="${fn:escapeXml(param.sleep)}" />
<c:choose>
	<c:when test="${empty esleep}">
	    <c:set var="sleep" value="10000"></c:set>
	</c:when>
	<c:otherwise>
	    <c:set var="sleep" value="${esleep}"></c:set>
	</c:otherwise>
</c:choose>

<c:choose>
    <c:when test="${param.showPage == null}">
	<%
	   Thread.sleep(Integer.parseInt(pageContext.getAttribute("sleep").toString()));
	%>
	</c:when>

	<c:otherwise>
	<fmt:bundle basename="localization.SurveyMessages">
	<!doctype html>
	<html>
	    <head>
			<jsp:include page="/common/search-engine.jsp" />
	        <title><fmt:message key="ccdropdown.redirecting"/></title>
	        <meta charset="utf-8" />
			<!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame
			       Remove this if you use the .htaccess -->
			<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
			<meta name="viewport" content="width=device-width, initial-scale=1.0" />
			<meta name="description" content="" />
			<meta name="author" content="CommVault">
			<link rel="shortcut icon" href="${pageContext.request.contextPath}/${applicationScope.OEM_PATH}/favicon.png" />
	    </head>

	    <body>
	        <p><fmt:message key="ccdropdown.redirecting_please_wait"/></p>
	        <iframe height="0" width="0" frameborder="0" style="display:none;"
	            src="redirect.jsp?sleep=${esleep}"
	            onload="this.src='redirect.jsp?sleep=${esleep}'">
	        </iframe>
	    </body>
	</html>
	</fmt:bundle>
	</c:otherwise>
</c:choose>
