<!doctype html>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<html>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=Edge" />
<jsp:include page="/common/search-engine.jsp" />
<title>${requestScope.PREVIEW_TITLE}</title>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/clientLoggingJs.do?${applicationScope.BUILD_TS}"></script>

<!-- 	!!! NAMESPACE - The script blocks below are a dependency workaround for cases where
		preview is	opened from a copy link and some js vars normally defined in browse/index.jsp
	 	have not been defined. The js is required for the code in download.js to function. -->
<script nonce="${sessionScope.cspNonce}" >
var localMsg = localMsg || {};
var isArchiver = !!isArchiver;
var defaultShowDeleted = !!defaultShowDeleted;
</script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/cvutil.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/browse/js/browseCommon.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/browse/js/backupBrowseMain.js?${applicationScope.BUILD_TS}"></script>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/browse/js/download.js?${applicationScope.BUILD_TS}"></script>
<jsp:include page="jquery.jsp" />


<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="backupBrowse.notification.downloadSubmitted" var="downloadSubmitted" />
	<fmt:message key="backupBrowse.action.download" var="downloadText" />
	<fmt:message key="backupBrowse.notification.downloadSubmitted" var="downloadSubmitted" />
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
var localMsg = localMsg || {};
var downloadSubmitted = "${downloadSubmitted}";
var downloadText = "${downloadText}";
var downloadCookieKey = null;
localMsg.downloadSubmitted = "${downloadSubmitted}";

$("document").ready(function(){
	reSize();

	function reSize(){
		$("#previewIframe").height($(window).height()-41);
	}

	$(window).resize(function() {
		reSize();
		});

	if("${requestScope.COPY_LINK}" == "false" && "${requestScope.EXCH_PREVIEW}" == "false"){
		navClass = window.opener.preview.getState();
		if(navClass == "noLeft") {
			$("#backNav").addClass("disableNav");
		}
		else if(navClass == "noRight") {
			$("#nextNav").addClass("disableNav");
		}
		else if(navClass == "noLeftRight") {
			$("#backNav").addClass("disableNav");
			$("#nextNav").addClass("disableNav");
		}
		else{
			$("#backNav").removeClass("disableNav");
			$("#nextNav").removeClass("disableNav");
		}

		$("#backNav").on("click",function(){
			if(!$(this).hasClass("disableNav")){
				navigate("bkwd");
			}
		});
		$("#nextNav").on("click",function(){
			if(!$(this).hasClass("disableNav")){
				navigate("fwd");
			}
		});
	}

	$("body").on("click", "#downloadButton", function(e){
		if("${requestScope.IMAP_PREVIEW}" != null && "${requestScope.IMAP_PREVIEW}" == "true") {
			e.stopPropagation();
			return;
		}
		if("${requestScope.COPY_LINK}" == "false") {
			var w = window.opener.document;
			var parentRow = $(w).find("tr.row_selected");

			var api = "/server/doAdhocDownload"; // this API uses client-side selections and applies for all apptypes
			var params = window.opener.browseMain.getDownloadAdHocParamsForPreview();

			cvUtil.toast(downloadSubmitted, 15000, false, false);

			cvUtil.loadPageWithGET(cvUtil.getContextPath() + api, params, function(result) {
				downloadSuccess(result);
			}, function(error) {
				downloadFailure(error);
			});
		} else {
			// !!! This call appears to be unreachable in the latest code
			doCopyLinkDownload();
		}
	});

	if(window.opener != null && typeof(window.opener) != "undefined" && $(window.opener.document).find("tr.row_selected").find(".folder").length>0)
		$("#downloadButton").hide();
	else
		$("#downloadButton").show();



});

function getURLParameter(name) {
    return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null;
}

function navigate(direction){
  	var w = window.opener.document;
	var parentRow = $(w).find("tr.row_selected");

 if(direction=="fwd")
		{
			parentRow.next().click();
			location.href = location.protocol + '//' + location.host+location.pathname+"?guid="+parentRow.next().find(".previewData").data("guid");
		}
	if(direction=="bkwd")
		{
			parentRow.prev().click();
			location.href = location.protocol + '//' + location.host+location.pathname+"?guid="+parentRow.prev().find(".previewData").data("guid");
		}
}
</script>
<style>
.frameHeader {
	background: url("common/img/Company_logo.png") no-repeat 5px 6px #F4F4F4;
	height: 40px;
	border-bottom: 1px solid #AAA;
}

ul.nav {
	list-style: none;
	float: right;
	margin: 4px 4px;
	padding-left: 0px;
}
ul.nav li, ul.nav li.disableNav:hover {
	float: left;
	padding: 5px 15px;
	border: 1px solid #d6d6d6;
	background: transparent;
}
ul.nav li:hover {
	border: 1px solid #CCC;
	cursor: pointer;
	background: #fff;
}
ul.nav li:hover .next {
	border-left: 10px solid #369;
}
ul.nav li:hover .back {
	border-right: 10px solid #369;
}
.back, .next {
	border-top: 10px solid transparent;
	border-bottom: 10px solid transparent;
	height: 0;
	width: 0;
}
.back {
	border-right: 10px solid #888;
	}
.next {
	border-left: 10px solid #888;
}
ul.nav li.disableNav .back {
	border-right: 10px solid #ddd;
}
ul.nav li.disableNav .next{
	border-left: 10px solid #ddd;
}
body {
	margin: 0;
	overflow: hidden;
}
#downloadButton{

	margin: 5px 5px 0px 0px;
	float: right;
	color: #FFFFFF;
	padding: 5px 10px;
	border: 0px;
	text-decoration: none;
	font-family: Helvetica, Arial, sans-serif;;
	font-weight: normal;
	font-size: 14px;
	background: #0B2E44 ;
}
</style>
</head>
<body>
<div class="frameHeader">
<c:if test="${requestScope.COPY_LINK == 'false' && requestScope.EXCH_PREVIEW == 'false'}">
<ul class="nav">
<li id="backNav"><div class="back"></div></li>
<li id="nextNav"><div class="next"></div></li>
</ul>
</c:if>
<c:choose>
<c:when test="${requestScope.IMAP_PREVIEW != null && requestScope.IMAP_PREVIEW == 'true'}">
<a class="mainBtn" href="${requestScope.DOWNLOAD_URL}" id="downloadButton">${downloadText}</a>
</c:when>
<c:otherwise>
<a class="mainBtn" href="#" id="downloadButton">${downloadText}</a>
</c:otherwise>
</c:choose>
</div>

<div id="notificationContainer" style="display:none; z-index:9999; top: auto; right: 0px; bottom: 0px; margin: 0px 10px 10px 0px;">
		<div id="notificationTemplateInfo">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
				<span class="sprite icon-notif-info" alt="Information" title="Information"></span>
			</div>
			<p><%="#"%>{text}</p>

		</div>
		<div id="notificationTemplateError">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
				<span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p><%="#"%>{text}</p>
		</div>
		<div id="notificationTemplateServerError">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
				<span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p>${exceptionText}</p>
			<p><span style="font-size: 0.8em;"><%="#"%>{text}</span></p>
		</div>
</div>
<iframe id="previewIframe" src="${requestScope.PREVIEW_URL}" marginheight="0" marginwidth="0" frameborder="0" width="100%" style="overflow:visible"></iframe>
</body>
</html>
