<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsMessages">
	<fmt:message key="others" var="others" />
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/pageSelection.js?${applicationScope.BUILD_TS}"></script>
<link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath}/common/css/pageSelection.css">
<div class="pageSelectWrapper secTitleClickable repDropdown">
<div id="pageSelect">

</div>
</div>
<c:choose>
	<c:when test="${sessionScope.CR_VERSION == 'true'}">
		<c:url var="url" value="/customreports/viewReport.jsp"></c:url>
	</c:when>
	<c:when
		test="${sessionScope.CR_VERSION == null || sessionScope.CR_VERSION == 'false'}">
		<c:url var="customreportsURL" value="/reportsplus/reportViewer.jsp"></c:url>
	</c:when>
</c:choose>
<script nonce="${sessionScope.cspNonce}" >
var slaDays = 30;
var fromCCDashboardSLA = cvUtil.getParameter("fromCCDashboardSLA");
if(fromCCDashboardSLA != undefined && fromCCDashboardSLA == 'true'){
	slaDays = "${applicationScope.MetricsReportingSLADays}";
}
localMsg = localMsg || {};
localMsg.others='${others}';

var useCrVersion1 = '${sessionScope.CR_VERSION}' || 0;
var customreportsURL = '${customreportsURL}';
var surveySingleCommcellUser= null;
var reportListLoaded= false;
var metricsInstalled = ${applicationScope.METRICS_INSTALLED};
<c:if test="${sessionScope.SurveySingleCommcellUser != null}">
	surveySingleCommcellUser=${sessionScope.SurveySingleCommcellUser};
</c:if>
var commUniId = encodeURIComponent(cvUtil.getParameter("commUniId", 0));
if(commUniId <= 0 && surveySingleCommcellUser){
	commUniId = surveySingleCommcellUser;
}
$('.repDropdown').on("mouseover",function(e){
	 if(!reportListLoaded){
		reportListLoaded = true;
		$(".repDropdownTitle").append('<span class="reportsLoadStatus"></span>')
		loadReportsDropDown(e);
	}else{
		showReportsDropDown(e);
	}

});

function showReportsDropDown(e){
	if(window.hidePageSelect){
		window.clearTimeout(window.hidePageSelect);
		window.hidePageSelect=null;
	}

	var left = $('li.repDropdown').position().left;
	var menuWidth = 280;
	if(!window.reportsMenuWidth){
		getMenuWidth();
	}
	if(window.reportsMenuWidth > 0){
		menuWidth = window.reportsMenuWidth;
	}
	if($('li.repDropdown').width() > menuWidth){
		left = 10;//left+$('li.repDropdown').width() - menuWidth;
	}
	left += 'px';
	var top = ($('li.repDropdown').position().top + $('li.repDropdown').height())+'px';
	$(".pageSelectWrapper").css("left", left);
	$(".pageSelectWrapper").css("top", top);
	$("#pageSelect").css("display","block");

	e.stopPropagation();
	$(".reportsLoadStatus").remove();
	$("#pageSelect").addClass('pageSelecBox');
}

function getMenuWidth(){
	var cln = $(".pageSelectWrapper").clone();
	$('body').append(cln);
	cln.css('visibility', 'hidden');
	cln.css('font-size', '11.2px');
	cln.find($("#pageSelect")).show();
	window.reportsMenuWidth = cln.width();
	cln.remove();
}

$('html').on("mouseover",function() {
	if(!window.hidePageSelect)
		window.hidePageSelect = window.setTimeout(function(){
			$("#pageSelect").fadeOut(100);
	}, 1000);
});
$('html').on("click", function(){
	if(window.hidePageSelect){
		$("#pageSelect").fadeOut(0);
	}
});

	function getCombinedTags(reportTags) {
		reportTags = $.parseJSON(reportTags);
		var allTags = reportTags.globalTags || {};
		var userTags = reportTags.userTags || {};

		$.each(userTags, function(key,value){
			if (allTags[key] != undefined ) {
				var origVal = allTags[key];
				for (var i=0; i<  value.length; i++) {
					var userTag = value[i];
					var found = false;
					for (var j=0; j< origVal.length; j++) {
						var origTag= origVal[j];
						if (origTag.tagId == userTag.tagId) {
							found=true;
						}
					}
					if (!found) {
						origVal.push(userTag);
					}
				}
			} else {
				allTags[key] = value;
			}
		});
		return allTags;
	}

	function getTag(tagsForReports,reportUniqueId, isCustomReport){
		var tagValue=[];
		for(var i = 0; i < tagsForReports.length; i++){
			var reportId= tagsForReports[i].reportId;
			if(isCustomReport && tagsForReports[i].reportType=="custom"){
				if(reportId == reportUniqueId) {
					tagValue.push(tagsForReports[i]);

				}
			}else if(!isCustomReport && tagsForReports[i].reportType=="metrics"){
				if(reportId == reportUniqueId) {
					tagValue.push(tagsForReports[i]);
				}
			}
		}
		return tagValue;
	}
	function populateReportName(surveyId){
		var cgId = cvUtil.getParameterByName("ccGroupId");
		var commUniId = cvUtil.getParameterByName("commUniId");
		var companyId = encodeURIComponent(cvUtil.getParameter("companyId"));
		var optParameter = "";
		var  surveyIDArray= [51,137, 146];
		var fetchSurveyId =false;
		var title = "";
		 if(surveyId != undefined && surveyId.trim() != ""){
				if($.inArray(surveyId , surveyIDArray)){
					var repType = cvUtil.getParameter('repType');
					optParameter = repType;
					fetchSurveyId = true;
				}else if(window.location.href.indexOf("CommCellSurvey.jsp") > -1){
					fetchSurveyId = true;
				}

				if(fetchSurveyId){
					cvUtil.loadPage("survey.do",{action: 'GetSurveyMetaData', surveyId : surveyId, commUniId : commUniId, optParameter: optParameter },
							function(SurveyMetaData){
								title = SurveyMetaData.selectedSurveyName;
								$("#surveyName").html(title);
								$(document).attr("title", title);
								if((cgId == undefined || cgId <= 0) && (companyId == undefined || companyId <= 0)){
									$(document).attr("title", 'Worldwide ' + title);
								}
							},
							function(xhr, ajaxOptions, thrownError){
								cvUtil.errorToast("Failed to load reports dropdown");
						});
				}
			}
			if(title){
				$("#surveyName").html(title);
				$(document).attr("title", title);
				if((cgId == undefined || cgId <= 0) && (companyId == undefined || companyId <= 0)){
					$(document).attr("title", 'Worldwide ' + title);
				}
			}
		return title;
	}

function loadReportsDropDown(e){

var getReq, params;
	var untaggedSectionID = "Untagged";
	var isExport = cvUtil.getParameter("exportType", "");
	var safeReportName = "";
	if(commUniId != undefined && commUniId != 0){
		getReq = "survey.do";
		params = {action: 'GetSurveyList', app: 'none', commUniId: commUniId};
		if(!isExport) {
			cvUtil.loadPage(getReq ,params,function(reportsList){
			cvUtil.loadPage(cvUtil.getContextPath() + "/server/getReportsTags.do",{},function(tagsForReports){
				//tagsForReports = $.parseJSON(tagsForReports);
				//reportsList = $.parseJSON(reportsList);
				var surveyGroupList = reportsList.surveyGroupList;
				var uniqueTags = [];
				var tagMap= {};
				var uniqueTagsName= [];

				for(var prop in surveyGroupList){
					for(var i=0; i< surveyGroupList[prop].length; i++){

						safeReportName = getSafeString(surveyGroupList[prop][i].name);
						if(surveyGroupList[prop][i].type === "URL")
						{
							var reportId = surveyGroupList[prop][i].reportId;

							var tagElements = getTag(tagsForReports,reportId,false);
							//var link = cvUtil.getContextPath()+"/survey/reports/"+surveyGroupList[prop][i].value+"&commUniId="+cvUtil.getParameterByName("commUniId");

							var link = cvUtil.getContextPath()+"/survey/reports/"+surveyGroupList[prop][i].value;
                            if(link.indexOf("commUniId")==-1 && link.indexOf("ccId") == -1 && link.indexOf("masterCommservId") == -1){
                                  link+="&commUniId="+commUniId;
                            }
						}
						else{
							var reportId = surveyGroupList[prop][i].value;
							var tagElements = getTag(tagsForReports,reportId,false);

							if((surveyGroupList[prop][i].value == 23) || (surveyGroupList[prop][i].value==25) || (surveyGroupList[prop][i].value==44) || (surveyGroupList[prop][i].value==30) || (surveyGroupList[prop][i].value==103)){
								var link = cvUtil.getContextPath()+"/survey/reports/operations.jsp?surveyId="+surveyGroupList[prop][i].value+"&commUniId="+commUniId;
							}
							else {
								var link = cvUtil.getContextPath()+"/survey/reports/indcommcellsurvey.jsp?surveyId="+surveyGroupList[prop][i].value+"&commUniId="+commUniId;
							}

							var surveyId = cvUtil.getParameterByName("surveyId");
							if(surveyId != undefined){
								if(parseInt(surveyId) === surveyGroupList[prop][i].value) {
									$("#surveyName").html(safeReportName);
									$(document).attr("title", $("#surveyName").text());
								}
							}
						}

						var cgId = cvUtil.getParameterByName("ccGroupId");
						if(cgId != undefined && cgId > 0){
							link += (link.indexOf('?') > 0? "&" : "?") + "ccGroupId="+cgId;
						}
						var cpId = encodeURIComponent(cvUtil.getParameterByName("companyId"));
						if(cpId != undefined && cpId > 0){
							link += (link.indexOf('?') > 0? "&" : "?") + "companyId="+cpId;
						}
						if(tagElements != undefined && tagElements != null && tagElements.length>0){
							$.each(tagElements, function(ndx, tag){
								tagId = tag.tagId+"_tag";
								if($.inArray(tag.tagName, uniqueTagsName) < 0) {
									uniqueTagsName.push(tag.tagName);
									tagMap[tag.tagName]=tagId;

								}
								if($("#"+tagId).length === 0) {
									$("<div id='"+tagId+"'>"+"</div>").appendTo("#pageSelect");
									$("<h3 class='head' >"+tag.tagName+" <span class='sprite reports-minus' /> </h3>").appendTo("#"+tagId);
									$("<ul class='shw' id='"+tagId+"list'>"+"</ul>").appendTo("#"+tagId);
								}

								$("<li><a href='"+link+"' title='" + safeReportName + "'>" + safeReportName +"</a></li>").appendTo("#"+tagId+"list");
							});
						}
						else{
							tag = localMsg.others;
							if($("#"+untaggedSectionID).length === 0) {
								$("<div id='"+untaggedSectionID+"'>"+"</div>").appendTo("#pageSelect");
								$("<h3 class='head' >"+tag+" <span class='sprite reports-plus' /></h3>").appendTo("#"+untaggedSectionID);
								$("<ul class='hid' id='"+untaggedSectionID+"list'>"+"</ul>").appendTo("#"+untaggedSectionID);
							}
							$("<li><a href='"+link+"' title='"+ safeReportName +"'>" + safeReportName + "</a></li>").appendTo("#"+untaggedSectionID+"list");
						}
					}
				}
				if(surveySingleCommcellUser != null && $.isNumeric(surveySingleCommcellUser)){
					var customReportList = reportsList.CR_LIST;
					$.each(customReportList, function(key,value){
						if(!value.viewable){
							return;
						}
						var reportId = value.reportId;
						var tagElements = getTag(tagsForReports,reportId,true);
						var link = customreportsURL+"?reportId="+value.reportId;

						safeReportName = getSafeString(value.reportName);
						if(tagElements && tagElements.length>0){
							$.each(tagElements, function(ndx, tag){
								tagId = tag.tagId+"_tag";
								if($.inArray(tag.tagName, uniqueTagsName) < 0) {
									uniqueTagsName.push(tag.tagName);
									tagMap[tag.tagName]=tagId;

								}
								if($("#"+tagId).length === 0) {
									$("<div id='"+tagId+"'>"+"</div>").appendTo("#pageSelect");
									$("<h3 class='head' >"+tag.tagName+" <span class='sprite reports-minus' /> </h3>").appendTo("#"+tagId);
									$("<ul class='shw' id='"+tagId+"list'>"+"</ul>").appendTo("#"+tagId);
								}
								$("<li><a href='"+link+"' title='" + safeReportName + "'>"+  safeReportName + "</a></li>").appendTo("#"+tagId+"list");
							});
						}
						else{
							tag = localMsg.others;
							if($("#"+untaggedSectionID).length === 0) {
								$("<div id='"+untaggedSectionID+"'>"+"</div>").appendTo("#pageSelect");
								$("<h3 class='head' >"+tag+" <span class='sprite reports-plus' /> </h3>").appendTo("#"+untaggedSectionID);
								$("<ul class='hid' id='"+untaggedSectionID+"list'>"+"</ul>").appendTo("#"+untaggedSectionID);
							}
							$("<li><a href='"+link+"' title='" + safeReportName + "'>" + safeReportName + "</a></li>").appendTo("#"+untaggedSectionID+"list");
						}
					});
				}
				if(surveyId == 51) {
					title = populateReportName(surveyId);
				}
				uniqueTagsName.sort();
				$.each(uniqueTagsName, function(index, value){
					uniqueTags.push(tagMap[value]);
				});
				uniqueTags.reverse();
				$.each(uniqueTags,function(i,v){
					$("#"+v).prependTo("#pageSelect");
					});

				if(reportsList.miscReports != undefined){
					miscReports = reportsList.miscReports;
					for(var i=0; i<miscReports.length; i++){
						var link = cvUtil.getContextPath()+"/reports/"+miscReports[i].href;
						if(cvUtil.getParameterByName("commUniId") != ""){
	                        link += "?commUniId="+cvUtil.getParameterByName("commUniId");
	                  	}
						var cgId = cvUtil.getParameterByName("ccGroupId");
						if(cgId != undefined && cgId > 0){
							link += (link.indexOf('?') > 0? "&" : "?") + "ccGroupId="+cgId;
						}
						var cpId = encodeURIComponent(cvUtil.getParameterByName("companyId"));
						if(cpId != undefined && cpId > 0){
							link += (link.indexOf('?') > 0? "&" : "?") + "companyId="+cpId;
						}
						safeReportName = getSafeString(miscReports[i].reportName);
						if(i==1){
							if($("#CommCell_taglist").length>0){
								$("#CommCell_taglist").append("<li><a href='"+link+"' title='"+safeReportName+"'>"+safeReportName+"</a></li>");
							} else{
								$("#Untaggedlist").append("<li><a href='"+link+"' title='"+safeReportName+"'>"+safeReportName+"</a></li>");
							}
						}else{
							if($("#Jobs_taglist").length>0){
								$("#Jobs_taglist").append("<li><a href='"+link+"' title='"+safeReportName+"'>"+safeReportName+"</a></li>");
							}else{
								$("#Untaggedlist").append("<li><a href='"+link+"' title='"+safeReportName+"'>"+safeReportName+"</a></li>");
								}
							}
						}

				}
				var reportName="";
				var reportLevel = "";
				if($("#sectionTitle") && $("#sectionTitle").text()){
					reportName = $("#sectionTitle").text().trim();
				}
				if(window.location.href.indexOf("customreports/reportSettings.jsp")>-1 && reportName!=""){
		            reportLevel = "CommCell" ;
					cvUtil.GUIAuditReportLog(reportName,reportLevel);
		        }
				showReportsDropDown(e);
			},

			function(xhr, ajaxOptions, thrownError){
				cvUtil.errorToast("Failed to load survey reports dropdown");
			});
			},
			function(xhr, ajaxOptions, thrownError){
				cvUtil.errorToast("Failed to load survey reports tags for dropdown");
			});
		}

	}
	else {
        var ccGroupId = cvUtil.getParameter("ccGroupId", -1);
		getReq = cvUtil.getContextPath() +"/server/getReportsListAsJson.do";
		if (ccGroupId > 0) {
			getReq += "?ccGroupId=" + ccGroupId;
		}
		var companyId = encodeURIComponent(cvUtil.getParameter("companyId", 0));
		if(companyId > 0){
			getReq += (getReq.indexOf('?') > 0? "&" : "?") + "companyId="+companyId;
		}
		if(!isExport) {
			cvUtil.loadPage(getReq ,params,function(reportsList){
			cvUtil.loadPage(cvUtil.getContextPath() + "/server/getReportsTags.do",{},function(tagsForReports){
				//tagsForReports = $.parseJSON(tagsForReports);
				//reportsList = $.parseJSON(reportsList);
				var uniqueTags = [];
				var uniqueTagsName= [];
				var tagMap={};
				for(var i = 0; i < reportsList.length; i++) {
					var tagElement = null;
					var reportId = reportsList[i].id!=0?reportsList[i].id:reportsList[i].reportId;
					if(reportId == 0 || reportId=="" || reportId == undefined ){
						reportId = reportsList[i].queryId;
					}

					var tagElements = getTag(tagsForReports,reportId,reportsList[i].customReport);

					safeReportName = getSafeString(reportsList[i].reportName);
					if(reportsList[i].href != undefined && reportsList[i].href != "" && reportsList[i].reportsEnum != "Survey") {
						if(tagElements != undefined && tagElements !=null && tagElements.length>0){
							$.each(tagElements, function(ndx, tag){
								var tagId = tag.tagId + "_tag";

								if($.inArray(tag.tagName, uniqueTagsName) < 0) {
								uniqueTagsName.push(tag.tagName);
								tagMap[tag.tagName]=tagId;
								}

								if($("#"+tagId).length === 0) {
									$("<div id='"+tagId+"'>"+"</div>").appendTo("#pageSelect");
									$("<h3 class='head' >"+tag.tagName+" <span class='sprite reports-minus' /> </h3>").appendTo("#"+tagId);
									$("<ul class='shw' id='"+tagId+"list'>"+"</ul>").appendTo("#"+tagId);
								}
								$("<li><a href='"+cvUtil.getContextPath()+"/reports/"+reportsList[i].href+"' title='"+safeReportName+"'>"
										+safeReportName+"</a></li>").appendTo("#"+tagId+"list");
							});


						}
						else {//undefined tags - others it is
							tag = localMsg.others;
							if($("#"+untaggedSectionID).length === 0) {
								$("<div id='"+untaggedSectionID+"'>"+"</div>").appendTo("#pageSelect");
								$("<h3 class='head' >"+tag+" <span class='sprite reports-plus' /> </h3>").appendTo("#"+untaggedSectionID);
								$("<ul class='hid' id='"+untaggedSectionID+"list'>"+"</ul>").appendTo("#"+untaggedSectionID);
							}
							$("<li><a href='"+cvUtil.getContextPath()+"/reports/"+reportsList[i].href+"' title='"+safeReportName+"'>"
									+safeReportName+"</a></li>").appendTo("#"+untaggedSectionID+"list");
						}
					}
					else {
						if(reportsList[i].reportsEnum === "Survey"){
							var cgId = cvUtil.getParameterByName("ccGroupId");
							if(reportsList[i].href != undefined && reportsList[i].href != "")
							{
								if (reportsList[i].reportId === '2020' &&  (!metricsInstalled || (cvUtil.getParameter('commUniId', 0) > 0) )) {
									var metricsReportURLElement = $("#reportEntity .slideBox a:not(.actionButtons)");
									$(metricsReportURLElement).attr("href", "../health/" + reportsList[i].href);
								} else {
									var link = cvUtil.getContextPath()+"/survey/reports/"+reportsList[i].href;
								}
							}
							else{
								if((reportsList[i].id == 23) || (reportsList[i].id==25) || (reportsList[i].id==44) || (reportsList[i].id==30) || (reportsList[i].id==103)){
									var link = cvUtil.getContextPath()+"/survey/reports/operations.jsp?surveyId="+reportsList[i].id;
								}
								else {
									var link = cvUtil.getContextPath()+"/survey/reports/CommCellSurvey.jsp?surveyId="+reportsList[i].id;
								}
								var surveyId = cvUtil.getParameterByName("surveyId");
								if(parseInt(surveyId) === reportsList[i].id) {
									title = reportsList[i].reportName;
								}
							}

							if(cgId != undefined && cgId > 0){
								link += (link.indexOf('?') > 0? "&" : "?") + "ccGroupId="+cgId;
							}
							if(companyId != undefined && companyId > 0){
								link += (link.indexOf('?') > 0? "&" : "?") + "companyId="+companyId;
							}
							if(tagElements != undefined && tagElements !=null && tagElements.length>0){
								$.each(tagElements, function(ndx, tag){
									tagId = tag.tagId + "_tag";

									if($.inArray(tag.tagName, uniqueTagsName) < 0) {
										uniqueTagsName.push(tag.tagName);
										tagMap[tag.tagName]=tagId;
										}

									if($("#"+tagId).length === 0) {
										$("<div id='"+tagId+"'>"+"</div>").appendTo("#pageSelect");
										$("<h3 class='head' >"+tag.tagName+" <span class='sprite reports-minus' /> </h3>").appendTo("#"+tagId);
										$("<ul class='shw' class='sev' id='"+tagId+"list'>"+"</ul>").appendTo("#"+tagId);
									}
									$("<li><a href='"+link+"' title='"+safeReportName+"'>"
											+safeReportName+"</a></li>").appendTo("#"+tagId+"list");
								});

							}
							else{
								tag = localMsg.others;
								if($("#"+untaggedSectionID).length === 0) {
									$("<div id='"+untaggedSectionID+"'>"+"</div>").appendTo("#pageSelect");
									$("<h3 class='head' >"+tag+" <span class='sprite reports-plus'  /> </h3>").appendTo("#"+untaggedSectionID);
									$("<ul class='hid' id='"+untaggedSectionID+"list'>"+"</ul>").appendTo("#"+untaggedSectionID);
								}
								$("<li><a href='"+link+"' title='"+safeReportName+"'>"
										+safeReportName+"</a></li>").appendTo("#"+untaggedSectionID+"list");
							}
						}
						else {//custom reports case
							if(tagElements != undefined && tagElements !=null && tagElements.length>0){
								$.each(tagElements, function(ndx, tag){
									tagId = tag.tagId + "_tag";

									if($.inArray(tag.tagName, uniqueTagsName) < 0) {
										uniqueTagsName.push(tag.tagName);
										tagMap[tag.tagName]=tagId;
										}

									if($("#"+tagId).length === 0) {
										$("<div id='"+tagId+"'>"+"</div>").appendTo("#pageSelect");
										$("<h3 class='head' >"+tag.tagName+" <span class='sprite reports-minus' /> </h3>").appendTo("#"+tagId);
										$("<ul class='shw' id='"+tagId+"list'>"+"</ul>").appendTo("#"+tagId);
									}
									if(useCrVersion1)
										$("<li><a href='"+cvUtil.getContextPath()+"/customreports/viewReport.jsp?reportId="
												+reportsList[i].id+"' title='"+safeReportName+"'>"
												+safeReportName+"</a></li>").appendTo("#"+tagId+"list");
									else
										$("<li><a href='"+cvUtil.getContextPath()+"/reportsplus/reportViewer.jsp?reportId="
												+reportsList[i].id+"' title='"+safeReportName+"'>"
												+safeReportName+"</a></li>").appendTo("#"+tagId+"list");
								});
							}
							else {
								tag = localMsg.others;
								if($("#"+untaggedSectionID).length === 0) {
									$("<div id='"+untaggedSectionID+"'>"+"</div>").appendTo("#pageSelect");
									$("<h3 class='head' >"+tag+"<span class='sprite reports-plus' /> </h3>").appendTo("#"+untaggedSectionID);
									$("<ul class='hid' id='"+untaggedSectionID+"list'>"+"</ul>").appendTo("#"+untaggedSectionID);
								}
								if(useCrVersion1)
									$("<li><a href='"+cvUtil.getContextPath()+"/customreports/viewReport.jsp?reportId="
											+reportsList[i].id+"' title='"+safeReportName+"'>"
											+safeReportName+"</a></li>").appendTo("#"+untaggedSectionID+"list");
								else
									$("<li><a href='"+cvUtil.getContextPath()+"/reportsplus/reportViewer.jsp?reportId="
											+reportsList[i].id+"' title='"+safeReportName+"'>"
											+safeReportName+"</a></li>").appendTo("#"+untaggedSectionID+"list");

							}
						}
					 }
				}
				//populateReportName(surveyId);
				uniqueTagsName.sort();
				$.each(uniqueTagsName, function(index, value){
					uniqueTags.push(tagMap[value]);
				});
				uniqueTags.reverse();
				$.each(uniqueTags,function(i,v){
					$("#"+v).prependTo("#pageSelect");
					});
				var reportName="";
				if($("#surveyName") && $("#surveyName").text()){
					reportName = $("#surveyName").text().trim();
				}else if($("#secTitleDiv") && $("#secTitleDiv").text()){
					reportName = $("#secTitleDiv").text().trim();
				}
				else if($("#sectionTitle") && $("#sectionTitle").text()){
					reportName = $("#sectionTitle").text().trim();
				}
				var reportLevel = "WorldWide";
				//if(window.location.href.indexOf("customreports/viewReport.jsp")>-1 || window.location.href.indexOf("customreports/buildCustomReport.do")>-1){
				if(window.location.href.indexOf("reportsplus")>-1){
		            reportLevel = "CustomReport";
		        }
				if(reportName && $.inArray(parseInt(surveyId), [25,30]) == -1 ){
					cvUtil.GUIAuditReportLog(reportName,reportLevel);
				}
				showReportsDropDown(e);
			},
				function(xhr, ajaxOptions, thrownError){
					cvUtil.errorToast($.trim(xhr.responseText),30000);
				});
			},
			function(xhr, ajaxOptions, thrownError){
				cvUtil.errorToast("Failed to load reports dropdown");
			});
		}

	}

	function getSafeString(input) {
		var retval = $('<div/>').text(input).html();
		return retval;
	}
}

$(function() {
	if(cvUtil.getParameterByName("commUniId") == undefined || cvUtil.getParameterByName("commUniId") <= 0){
		var surveyId = cvUtil.getParameterByName("surveyId");
		populateReportName(surveyId);
	}
});
// $(".pageSelectWrapper").width($(".sectiontitle").width() + 30);
</script>