<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:message key="summary.link.computers" var="computersText" />
<fmt:message key="summary.link.sync" var="syncText" />
<fmt:message key="summary.link.email" var="emailText" />
<fmt:message key="summary.link.vms" var="vmsText" />
<fmt:message key="summary.link.sharedFolder" var="sharedFolderText" />
<fmt:message key="summary.link.sharepoint" var="sharepointText" />
<fmt:message key="summary.link.drive" var="driveText" />
<fmt:message key="common.label.loading" var="loading" />
<fmt:message key="share.label.sharedByMe" var="sharedByMe" />
<fmt:message key="summary.noclients" var="noClientsMessage" />

<c:if test="${param.adminMode == true}">
	<c:set var="myDataPageURL" value="../summary/adminSummary.jsp" />
</c:if>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="share.label.sharedWithMe" var="sharedWithMe" />
	<fmt:message key="share.label.sharedByMe" var="sharedByMe" />
	<fmt:message key="share.label.publicLinks" var="publicLinks" />
	<fmt:message key="share.label.systemShares" var="systemShares" />
</fmt:bundle>
<fmt:message key="summary.label.mobileApps" var="mobileApps"/>
<c:if test="${param.adminMode != true}">
	<c:set var="myDataPageURL" value="../summary/index.do?page=fs" />
</c:if>

<script id="mydata-apps-template" type="x-tmpl-mustache">
			<li id="fs" class="{{IsComputersEnabled}}"><a href="${myDataPageURL}" title="${computersText}">
				<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M23.021,19v-1H22v-1h-1V5H4v12H3v1H1.979v1H1v1h23v-1H23.021z M5,6h15v10H5V6z M20,19h-1v-1h-1v1h-1v-1h-1v1h-1v-1h-1v1h-1v-1h-1v1h-1v-1h-1v1H9v-1H8v1H7v-1H6v1H5v-1h1v-1h1v1h1v-1h1v1h1v-1h1v1h1v-1h1v1h1v-1h1v1h1v-1h1v1h1v-1h1v1h1V19z"></path></svg>
				<span id="cv-acc-computers-text" class="vw-text">
					${computersText}
				</span>
			</a></li>
			<li class="{{IsDriveEnabled}}" id="drive"><a href="<%=(request.getContextPath())%>/mydrive" title="${driveText}">
			<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M21.6,11.1H21.3a3.6,3.6,0,0,0-1.7-4,4.2,4.2,0,0,0-2.3-.7,4.6,4.6,0,0,0-2.6.8,5.4,5.4,0,0,0-4.3-2.1l-1.9.3c-2.6.9-4.6,3.3-3.8,5.6H4.5A4.9,4.9,0,0,0,.1,16.5c0.4,2.9,2.8,3.6,5.2,3.6H20.1c2.4,0,4.5-.9,4.8-3.9A4.9,4.9,0,0,0,21.6,11.1ZM23.9,16c-0.2,2.1-1.3,2.9-3.8,3H5.3c-3.4,0-4-1.5-4.2-2.7a3.9,3.9,0,0,1,3.5-4.5H6.1L5.7,10.5a2.3,2.3,0,0,1,.1-1.9,5.2,5.2,0,0,1,3-2.4l1.6-.3a4.4,4.4,0,0,1,3.5,1.8l0.6,0.7,0.7-.5a3.6,3.6,0,0,1,2-.6,3.2,3.2,0,0,1,1.8.5,2.6,2.6,0,0,1,1.3,3l-0.2.9,0.8,0.3h0.3A3.9,3.9,0,0,1,23.9,16Z"/><path d="M10.6,14.8a2.8,2.8,0,0,1-.2-3.2l0.6,1,1-3L9,9.1l0.7,1.2a4.3,4.3,0,0,0,0,5.5h0l-0.2-1h1Z"/><path class="b" d="M12.9,8.8L11.5,9h1l-0.3,1h0.7a3,3,0,0,1,2.9,2.3H14.6l2.3,2.2,1.7-2.4H17.2A4.3,4.3,0,0,0,12.9,8.8Z"/><path d="M15.5,14.6a3,3,0,0,1-3,1.4l0.8-.9H10.1l0.6,2.9,0.8-1a4.3,4.3,0,0,0,5-1.8h0l-0.9-1Z"/></svg>
			<span id="cv-acc-drive-text" class="vw-text">
				${driveText}
			</span>
			</a></li>
			<li class="{{IsSyncAllowed}}" id="webFolder"><a href="<%=(request.getContextPath())%>/summary/index.do?page=webFolder" title="${syncText}">
			<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25" height="25" viewBox="0 0 25 25">
    <path d="M15.841,176.851l3.794,1.458a0.565,0.565,0,0,0,.7-0.228l0.13-.295a0.468,0.468,0,0,0-.269-0.606l-4.425-1.693-0.011-.007-0.222-.092a0.489,0.489,0,0,0-.366,0,0.43,0.43,0,0,0-.237.253l-0.069.219s-0.02,0-.021,0l-1.821,4.145a0.424,0.424,0,0,0,.293.552l0.334,0.13a0.489,0.489,0,0,0,.628-0.258Zm0,0,3.794,1.458a0.565,0.565,0,0,0,.7-0.228l0.13-.295a0.468,0.468,0,0,0-.269-0.606l-4.425-1.693-0.011-.007-0.222-.092a0.489,0.489,0,0,0-.366,0,0.43,0.43,0,0,0-.237.253l-0.069.219s-0.02,0-.021,0l-1.821,4.145a0.424,0.424,0,0,0,.293.552l0.334,0.13a0.489,0.489,0,0,0,.628-0.258Zm0,0,3.794,1.458a0.565,0.565,0,0,0,.7-0.228l0.13-.295a0.468,0.468,0,0,0-.269-0.606l-4.425-1.693-0.011-.007-0.222-.092a0.489,0.489,0,0,0-.366,0,0.43,0.43,0,0,0-.237.253l-0.069.219s-0.02,0-.021,0l-1.821,4.145a0.424,0.424,0,0,0,.293.552l0.334,0.13a0.489,0.489,0,0,0,.628-0.258Zm0,0,3.794,1.458a0.565,0.565,0,0,0,.7-0.228l0.13-.295a0.468,0.468,0,0,0-.269-0.606l-4.425-1.693-0.011-.007-0.222-.092a0.489,0.489,0,0,0-.366,0,0.43,0.43,0,0,0-.237.253l-0.069.219s-0.02,0-.021,0l-1.821,4.145a0.424,0.424,0,0,0,.293.552l0.334,0.13a0.489,0.489,0,0,0,.628-0.258Zm0,0,3.794,1.458a0.565,0.565,0,0,0,.7-0.228l0.13-.295a0.468,0.468,0,0,0-.269-0.606l-4.425-1.693-0.011-.007-0.222-.092a0.489,0.489,0,0,0-.366,0,0.43,0.43,0,0,0-.237.253l-0.069.219s-0.02,0-.021,0l-1.821,4.145a0.424,0.424,0,0,0,.293.552l0.334,0.13a0.489,0.489,0,0,0,.628-0.258Zm0,0,3.794,1.458a0.565,0.565,0,0,0,.7-0.228l0.13-.295a0.468,0.468,0,0,0-.269-0.606l-4.425-1.693-0.011-.007-0.222-.092a0.489,0.489,0,0,0-.366,0,0.43,0.43,0,0,0-.237.253l-0.069.219s-0.02,0-.021,0l-1.821,4.145a0.424,0.424,0,0,0,.293.552l0.334,0.13a0.489,0.489,0,0,0,.628-0.258Zm0,0,3.794,1.458a0.565,0.565,0,0,0,.7-0.228l0.13-.295a0.468,0.468,0,0,0-.269-0.606l-4.425-1.693-0.011-.007-0.222-.092a0.489,0.489,0,0,0-.366,0,0.43,0.43,0,0,0-.237.253l-0.069.219s-0.02,0-.021,0l-1.821,4.145a0.424,0.424,0,0,0,.293.552l0.334,0.13a0.489,0.489,0,0,0,.628-0.258Zm0,0,3.794,1.458a0.565,0.565,0,0,0,.7-0.228l0.13-.295a0.468,0.468,0,0,0-.269-0.606l-4.425-1.693-0.011-.007-0.222-.092a0.489,0.489,0,0,0-.366,0,0.43,0.43,0,0,0-.237.253l-0.069.219s-0.02,0-.021,0l-1.821,4.145a0.424,0.424,0,0,0,.293.552l0.334,0.13a0.489,0.489,0,0,0,.628-0.258Z" transform="translate(-12.5 -164.5)"/>
    <path d="M25.162,186c-5.429,0-9.457-3.73-9.457-8.807a0.665,0.665,0,0,1,1.328,0c0,4.393,3.432,7.566,8.129,7.566A8.56,8.56,0,0,0,33,179.907c0.763-1.673,1.829-.778,1.191.554A9.967,9.967,0,0,1,25.162,186Z" transform="translate(-12.5 -164.5)"/>
    <path d="M34.179,177.066l-3.768-1.445a0.561,0.561,0,0,0-.7.226l-0.129.292a0.464,0.464,0,0,0,.267.6l4.4,1.677,0.011,0.007,0.221,0.091a0.482,0.482,0,0,0,.364,0,0.423,0.423,0,0,0,.236-0.25l0.068-.218s0.02,0,.021,0l1.809-4.107a0.421,0.421,0,0,0-.291-0.548l-0.331-.128a0.486,0.486,0,0,0-.624.256Zm0,0-3.768-1.445a0.561,0.561,0,0,0-.7.226l-0.129.292a0.464,0.464,0,0,0,.267.6l4.4,1.677,0.011,0.007,0.221,0.091a0.482,0.482,0,0,0,.364,0,0.423,0.423,0,0,0,.236-0.25l0.068-.218s0.02,0,.021,0l1.809-4.107a0.421,0.421,0,0,0-.291-0.548l-0.331-.128a0.486,0.486,0,0,0-.624.256Zm0,0-3.768-1.445a0.561,0.561,0,0,0-.7.226l-0.129.292a0.464,0.464,0,0,0,.267.6l4.4,1.677,0.011,0.007,0.221,0.091a0.482,0.482,0,0,0,.364,0,0.423,0.423,0,0,0,.236-0.25l0.068-.218s0.02,0,.021,0l1.809-4.107a0.421,0.421,0,0,0-.291-0.548l-0.331-.128a0.486,0.486,0,0,0-.624.256Zm0,0-3.768-1.445a0.561,0.561,0,0,0-.7.226l-0.129.292a0.464,0.464,0,0,0,.267.6l4.4,1.677,0.011,0.007,0.221,0.091a0.482,0.482,0,0,0,.364,0,0.423,0.423,0,0,0,.236-0.25l0.068-.218s0.02,0,.021,0l1.809-4.107a0.421,0.421,0,0,0-.291-0.548l-0.331-.128a0.486,0.486,0,0,0-.624.256Zm0,0-3.768-1.445a0.561,0.561,0,0,0-.7.226l-0.129.292a0.464,0.464,0,0,0,.267.6l4.4,1.677,0.011,0.007,0.221,0.091a0.482,0.482,0,0,0,.364,0,0.423,0.423,0,0,0,.236-0.25l0.068-.218s0.02,0,.021,0l1.809-4.107a0.421,0.421,0,0,0-.291-0.548l-0.331-.128a0.486,0.486,0,0,0-.624.256Zm0,0-3.768-1.445a0.561,0.561,0,0,0-.7.226l-0.129.292a0.464,0.464,0,0,0,.267.6l4.4,1.677,0.011,0.007,0.221,0.091a0.482,0.482,0,0,0,.364,0,0.423,0.423,0,0,0,.236-0.25l0.068-.218s0.02,0,.021,0l1.809-4.107a0.421,0.421,0,0,0-.291-0.548l-0.331-.128a0.486,0.486,0,0,0-.624.256Zm0,0-3.768-1.445a0.561,0.561,0,0,0-.7.226l-0.129.292a0.464,0.464,0,0,0,.267.6l4.4,1.677,0.011,0.007,0.221,0.091a0.482,0.482,0,0,0,.364,0,0.423,0.423,0,0,0,.236-0.25l0.068-.218s0.02,0,.021,0l1.809-4.107a0.421,0.421,0,0,0-.291-0.548l-0.331-.128a0.486,0.486,0,0,0-.624.256Zm0,0-3.768-1.445a0.561,0.561,0,0,0-.7.226l-0.129.292a0.464,0.464,0,0,0,.267.6l4.4,1.677,0.011,0.007,0.221,0.091a0.482,0.482,0,0,0,.364,0,0.423,0.423,0,0,0,.236-0.25l0.068-.218s0.02,0,.021,0l1.809-4.107a0.421,0.421,0,0,0-.291-0.548l-0.331-.128a0.486,0.486,0,0,0-.624.256Z" transform="translate(-12.5 -164.5)"/>
    <path d="M24.92,168c5.392,0,9.393,3.7,9.393,8.727a0.661,0.661,0,0,1-1.319,0c0-4.353-3.409-7.5-8.074-7.5a8.5,8.5,0,0,0-7.787,4.807c-0.758,1.658-1.816.772-1.183-.548A9.9,9.9,0,0,1,24.92,168Z" transform="translate(-12.5 -164.5)"/>
</svg>
			<span id="cv-acc-sync-text" class="vw-text">
			${syncText}
			</span></a></li>
			<li class="{{IsEmailEnabled}}" id="email"><a href="<%=(request.getContextPath())%>/summary/index.do?page=email" title="${emailText}">
			<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path d="M35.986,215.339a0.392,0.392,0,0,0-.014-0.076,0.316,0.316,0,0,0-.029-0.063,0.333,0.333,0,0,0-.037-0.058,0.3,0.3,0,0,0-.055-0.053,0.322,0.322,0,0,0-.029-0.029,0.175,0.175,0,0,0-.021-0.007,0.327,0.327,0,0,0-.069-0.026,0.391,0.391,0,0,0-.068-0.015c-0.008,0-.015,0-0.023,0H16.35a0.223,0.223,0,0,0-.025.006,0.373,0.373,0,0,0-.065.013,0.415,0.415,0,0,0-.07.027,0.174,0.174,0,0,0-.021.007,0.337,0.337,0,0,0-.029.029,0.3,0.3,0,0,0-.055.053,0.367,0.367,0,0,0-.037.057,0.4,0.4,0,0,0-.028.064,0.392,0.392,0,0,0-.014.076,0.328,0.328,0,0,0-.008.042v15.241a0.364,0.364,0,0,0,.353.374H35.641a0.364,0.364,0,0,0,.353-0.374V215.381A0.346,0.346,0,0,0,35.986,215.339Zm-0.7,14.111a29.8,29.8,0,0,0-5.772-6.673,24.236,24.236,0,0,0,5.772-6.15V229.45ZM16.7,216.627a24.24,24.24,0,0,0,5.769,6.148,29.859,29.859,0,0,0-5.769,6.669V216.627ZM26,223.837c-4.594-1.681-7.948-6.441-9-8.082H34.991C33.944,217.4,30.59,222.156,26,223.837ZM23.1,223.2a13.358,13.358,0,0,0,2.781,1.387h0a0.339,0.339,0,0,0,.218,0h0a13.383,13.383,0,0,0,2.779-1.385,29.56,29.56,0,0,1,6.052,7.044H17.05A29.535,29.535,0,0,1,23.1,223.2Z" transform="translate(-13.5 -210.5)"/></svg>
			<span id="cv-acc-email-text" class="vw-text">
			${emailText}
			</span>
			</a></li>
			<li class="{{IsVMEnabled}}" id="virtualServer"><a href="<%=(request.getContextPath())%>/summary/index.do?page=virtualServer" title="${vmsText}">
			<svg id="VMs02" xmlns="http://www.w3.org/2000/svg" width="25" height="23" viewBox="0 0 25 23"><path d="M32.031,281.386a0.919,0.919,0,0,1,.194,1.047,0.8,0.8,0,0,1-.751.566H23.511a0.987,0.987,0,0,1-.586-1.6,1.47,1.47,0,0,1,.192-0.118l0.11-.06a5.356,5.356,0,0,0,.871-0.565,21.166,21.166,0,0,0,.215-2.623,0.431,0.431,0,0,1,.455-0.423,0.439,0.439,0,0,1,.427.451,8.447,8.447,0,0,1-.39,3.13,4.826,4.826,0,0,1-1.138.789l-0.092.05c0,0.015.009,0.033,0.016,0.053s0.014,0.031.02,0.043H31.4a0.5,0.5,0,0,0,.02-0.085l-0.1-.052a4.833,4.833,0,0,1-1.15-.794,9.47,9.47,0,0,1-.394-3.125,0.44,0.44,0,0,1,.427-0.452,0.428,0.428,0,0,1,.455.424,20.963,20.963,0,0,0,.214,2.615,5.259,5.259,0,0,0,.862.559A2.362,2.362,0,0,1,32.031,281.386Zm5.96-20.617v15.779a0.771,0.771,0,0,1-.773.767H17.774a0.776,0.776,0,0,1-.782-0.767V260.769a0.78,0.78,0,0,1,.782-0.776H37.218A0.775,0.775,0,0,1,37.991,260.769Zm-0.883.1H17.875v15.57H37.108v-15.57Z" transform="translate(-15 -260)"/><path d="M28.787,263.005H19.214a0.207,0.207,0,0,0-.215.2v6.6a0.207,0.207,0,0,0,.215.2h9.572A0.207,0.207,0,0,0,29,269.8v-6.6A0.207,0.207,0,0,0,28.787,263.005Zm-0.215,6.6H19.429v-6.2h9.143v6.2Z" transform="translate(-15 -260)"/><path d="M31.765,267.005H21.236a0.22,0.22,0,0,0-.236.2v6.6a0.22,0.22,0,0,0,.236.2H31.765A0.22,0.22,0,0,0,32,273.8v-6.6A0.22,0.22,0,0,0,31.765,267.005Zm-0.236,6.6H21.472v-6.2H31.529v6.2Z" transform="translate(-15 -260)"/><path d="M35.765,265.005H25.236a0.22,0.22,0,0,0-.236.2v6.6a0.22,0.22,0,0,0,.236.2H35.765A0.22,0.22,0,0,0,36,271.8v-6.6A0.22,0.22,0,0,0,35.765,265.005Zm-0.236,6.6H25.472v-6.2H35.529v6.2Z" transform="translate(-15 -260)"/><path d="M28.787,263.005H19.214a0.207,0.207,0,0,0-.215.2v6.6a0.207,0.207,0,0,0,.215.2h9.572A0.207,0.207,0,0,0,29,269.8v-6.6A0.207,0.207,0,0,0,28.787,263.005Zm-0.215,6.6H19.429v-6.2h9.143v6.2Z" transform="translate(-15 -260)"/><path d="M31.765,267.005H21.236a0.22,0.22,0,0,0-.236.2v6.6a0.22,0.22,0,0,0,.236.2H31.765A0.22,0.22,0,0,0,32,273.8v-6.6A0.22,0.22,0,0,0,31.765,267.005Zm-0.236,6.6H21.472v-6.2H31.529v6.2Z" transform="translate(-15 -260)"/><path d="M35.765,265.005H25.236a0.22,0.22,0,0,0-.236.2v6.6a0.22,0.22,0,0,0,.236.2H35.765A0.22,0.22,0,0,0,36,271.8v-6.6A0.22,0.22,0,0,0,35.765,265.005Zm-0.236,6.6H25.472v-6.2H35.529v6.2Z" transform="translate(-15 -260)"/></svg>
			<span id="cv-acc-vms-text" class="vw-text">
			${vmsText}
			</span>
			</a></li>
			<li class="{{IsSharePointEnabled}}" id="sharepoint"><a href="<%=(request.getContextPath())%>/summary/index.do?page=sharepoint" title="${sharepointText}">
			<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"> <path d="M16.5,4.9a1.4,1.4,0,0,1,1.4,1.4V6.8l-0.2.3a1.4,1.4,0,0,1-1.1.6H16.1V5h0.5m6.1,6.1a1.4,1.4,0,1,1,0,2.7H22l-0.3-.2a1.4,1.4,0,0,1,0-2.1l0.3-.2h0.6m-6.1,6.2a1.4,1.4,0,0,1,1.1.6l0.2,0.3v0.5A1.4,1.4,0,0,1,16.5,20H16.1V17.3h0.5m0-13.3a2.4,2.4,0,0,0-1.5.5V8.2a2.4,2.4,0,0,0,3.4-.5,5.4,5.4,0,0,1,2.7,2.9,2.4,2.4,0,0,0,0,3.7,5.4,5.4,0,0,1-2.7,3,2.4,2.4,0,0,0-3.4-.5v3.7a2.4,2.4,0,0,0,3.8-1.9,2.4,2.4,0,0,0,0-.3,6.5,6.5,0,0,0,3.3-3.6h0.5a2.4,2.4,0,1,0,0-4.7H22.1a6.5,6.5,0,0,0-3.3-3.5,2.4,2.4,0,0,0-2.3-2.7h0Z"/><path d="M12.8,2V23L1,20.9V4.1L12.8,2m-8,12L5,14.2a4.1,4.1,0,0,1,.9.8,3.4,3.4,0,0,1-1.4-.7L2.9,13v2.1c0,0.7,0,1.4.1,2.1v0.7L3.6,18a6.7,6.7,0,0,0,2.5.6,3.7,3.7,0,0,0,2.2-.7,3.8,3.8,0,0,0,1.4-3.2,3.9,3.9,0,0,0-1.6-3l-0.8-.5-0.8-.7H6.7l1,0.3H8.1l1.3,0.4V7.1H6.8a4,4,0,0,0-2.2.6A3.9,3.9,0,0,0,3,10.7,3.9,3.9,0,0,0,4.7,14m9-13.2L0,3.3V21.7l13.8,2.5V0.8h0ZM5.9,16a1.2,1.2,0,0,0,.8-0.3c0.7-1.2-.7-1.9-1.5-2.5a3.1,3.1,0,0,1-.1-5,3,3,0,0,1,1.7-.4L8.4,7.9V9.9a6.1,6.1,0,0,0-1.7-.4,1.3,1.3,0,0,0-1,.5c-0.5,1.3,1.1,1.8,1.9,2.5a3,3,0,0,1,.2,4.6,2.7,2.7,0,0,1-1.6.5A5.9,5.9,0,0,1,4,17.1C4,16.4,4,15.7,4,15a3.7,3.7,0,0,0,2,.9h0Z"/></svg>
			<span id="cv-acc-sharepoint-text" class="vw-text">
				${sharepointText}
			</span>
			</a></li>
			<li class="{{IsSharesEnabled}} shareFolderLink"><a data-toggle="collapse" data-parent="#accordion1" id="shareFolderLink" href="#firstLink">

			<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25" height="25" viewBox="0 0 25 25"><path d="M20.72,123.056H16.138v10.858h14.8v-7.457l1.138-1.037v8.494A1.113,1.113,0,0,1,30.937,135h-14.8A1.113,1.113,0,0,1,15,133.914V123.056a1.113,1.113,0,0,1,1.138-1.086h5.7L21.871,122Zm8.521,1.833a0.581,0.581,0,0,0,.4-0.159l3.362-3.292-3.362-3.291a0.589,0.589,0,0,0-.8,0,0.524,0.524,0,0,0,0,.767l2.646,2.524-2.646,2.524a0.526,0.526,0,0,0,0,.768A0.582,0.582,0,0,0,29.241,124.889Zm1.1-2.919a9.531,9.531,0,0,0-9.5,7.6H19.7a10.666,10.666,0,0,1,10.667-8.687c0.588,0,1.154,0,1.708,0v1.1C31.526,121.977,30.955,121.97,30.344,121.97Z" transform="translate(-11.5 -114)"/></svg>
			<span id="cv-acc-shared-text" class="vw-text">
			${sharedFolderText}
			</span>
			<span class="glyphicon glyphicon-menu-right expandIcons" id="expandedIcon" aria-hidden="true" ></span>
			</a>
				<ul id=	"firstLink" class="collapse vw-subnav">
					<li title="${systemShares}" id="collabShareLi" class="{{IsSharesEnabled}} accordionMine"><a style="padding-left:24px" href="${pageContext.request.contextPath}/summary/index.do?page=collabShareLi"><span><svg width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><path  d="M21.69,14.44a2.56,2.56,0,0,0-.57.07L16.22,6a2.57,2.57,0,1,0-3.74,0L11.16,8.33,5.5,5.58l.81,3.29s-7,2.79-5.15,9.94c0,0,1.41-5.42,5.88-5.26l1,4,6.11-7.75L12.51,9,13.77,6.8a2.39,2.39,0,0,0,1.15,0l4.89,8.47a2.55,2.55,0,0,0-.57,1H10L8,18.77l-1-4a4.94,4.94,0,0,0-1.5.17,2.56,2.56,0,1,0,4,2.8h9.72a2.56,2.56,0,1,0,2.44-3.32Z"/></svg></span><span class="vw-text">${systemShares}</span></a></li>
                    <li title="${sharedWithMe}" id="sharedWithMeLi" class="{{IsSharesEnabled}} accordionMine"><a  style="padding-left:24px" href="${pageContext.request.contextPath}/summary/index.do?page=sharedWithMeLi"><span><svg  width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><polygon points="23.24 11.75 9.91 11.75 13.69 8.24 12.72 7.2 7.05 12.46 12.74 17.75 13.72 16.7 9.91 13.17 23.24 13.17 23.24 11.75"/><polygon points="16.09 16.87 16.09 20.32 3.64 20.32 3.64 4.59 16.09 4.59 16.09 8.01 17.85 8.01 17.85 2.92 1.88 2.92 1.88 22 17.85 22 17.85 16.87 16.09 16.87"/></svg></span><span class="vw-text">${sharedWithMe}</span></a></li>
					<li title="${sharedByMe}" id="sharedByMeLi" class="{{IsSharesEnabled}} accordionMine"><a style="padding-left:24px" href="${pageContext.request.contextPath}/summary/index.do?page=sharedByMeLi"><span><svg width="18" height="18" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><polygon points="18.45 7.4 17.5 8.42 21.2 11.85 8.16 11.85 8.16 13.24 21.2 13.24 17.48 16.7 18.43 17.72 24 12.55 18.45 7.4"/><polygon points="14.78 16.86 14.78 20.24 2.6 20.24 2.6 4.86 14.78 4.86 14.78 8.2 16.5 8.2 16.5 3.22 0.88 3.22 0.88 21.88 16.5 21.88 16.5 16.86 14.78 16.86"/></svg></span><span class="vw-text">${sharedByMe}</span></a></li>
                    <li title="${publicLinks}" id="publicShareLi" class="{{IsSharesEnabled}} accordionMine"><a style="padding-left:24px" href="${pageContext.request.contextPath}/summary/index.do?page=publicShareLi"><span><svg width="18" height="18"  xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><circle  cx="6.35" cy="4.59" r="2.04"/><circle  cx="15.84" cy="4.05" r="2.04"/><circle  cx="19.77" cy="17.01" r="2.04"/><circle  cx="21.81" cy="9.01" r="1.45" transform="matrix(0.18, -0.98, 0.98, 0.18, 9.07, 28.86)"/><circle  cx="12.04" cy="20.95" r="2.04"/><path  d="M1.74,17s2.67-4.92,7-3.69v4.1l7.79-6.05L9.13,5.22V8.61S1.64,9.63,1.74,17Z"/></svg></span><span class="vw-text">${publicLinks}</span></a></li>
                </ul>
			</li>
			<li class="${applicationScope.showMobileInfoEnabled}" id="mobile">
				<a href="<%=(request.getContextPath())%>/summary/index.do?page=mobile">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"><path id="smartphone" d="M13.5,20.5a1,1,0,1,0,1,1A1,1,0,0,0,13.5,20.5Zm0-16.5A.5.5,0,1,0,13,3.53.51.51,0,0,0,13.46,4Zm6.18-3H7.35A.36.36,0,0,0,7,1.37H7V23.63a.36.36,0,0,0,.35.37h12.3a.36.36,0,0,0,.35-.37h0V1.37A.36.36,0,0,0,19.65,1h0ZM8,6H19V19H8ZM19,2V5H8V2ZM8,23V20H19v3Z"/></svg>
					<span id="cv-mobile-apps" class="vw-text">${mobileApps}</span>
				</a>
			</li>

</script>

<label class="vw-js-nav-trigger" for="vw-nav-trigger" title="Collapse/Open navigation" class="hidden-xs"><svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24"><path d="M3,1v22h20V1H3z M7,21H5V3h2V21z M9,21V3h12v8h-7V8l-4.5,4l4.5,4v-3h7v8H9z" class="vw-close"/><path d="M3,1v22h20V1H3z M7,21H5V3h2V21z M21,21H9v-8h7v3l4.5-4L16,8v3H9V3h12V21z" class="vw-open"/></svg></label>
<c:if test="${param.browsePage != null && param.browsePage == 'true'}">
	<c:set var="collapseNav" value="checked" scope="page" />
</c:if>

<input type="checkbox" id="vw-nav-trigger" class="vw-nav-trigger" ${collapseNav}>

<nav id="cv-nav" class="vw-side-nav">
	<span class="vw-loading-links js-loading-links"><div class="vw-loading-spinner"><div class="vw-loading-comp"></div></div></span>
	<ul class="nav vw-apps-list js-mydata-apps" id="accordion1">
	</ul>
</nav>
<script nonce="${sessionScope.cspNonce}" >
var expanded = false;


function buildNavLinks(result) {
	var template = $('#mydata-apps-template').html();
    Mustache.parse(template);   // optional, speeds up future uses
	var rendered = Mustache.render(template, JSON.parse(result));

    $(".js-loading-links").hide();
	$('.js-mydata-apps').html(rendered);
	var pageParam = cvUtil.getParameterByName("page");
	if((pageParam === "sharedWithMeLi" || pageParam === "sharedByMeLi" || pageParam === "collabShareLi" || pageParam === "publicShareLi")
			&& !window.matchMedia(maxWidthString).matches){
		$("#"+cvUtil.getParameterByName("page")).addClass("nav-selected-accordion");
		$("#shareFolderLink").trigger("click");
		expanded = true;
		expandAccordionGen();
	}
	if(cvUtil.getParameterByName("page") !== ""){
		$("#"+cvUtil.getParameterByName("page")).addClass("nav-selected-accordion");
	}
	else if(location.pathname.indexOf("exchangeBrowse") > -1){
		$("#email").addClass("nav-selected-accordion");
	}
	else if(location.pathname.indexOf("sharepoint") > -1) {
		$("#sharepoint").addClass("nav-selected-accordion");
	}
	else if(location.pathname.indexOf("MyDrive") > -1 || location.pathname.indexOf("syncedClientList") > -1) {
		// extra condition for drive settings page
		$("#drive").addClass("nav-selected-accordion");
	}
	else if(location.pathname.indexOf("sync") > -1){
		$("#webFolder").addClass("nav-selected-accordion");
	}
	else{
		$($(".js-mydata-apps li")[0]).addClass("nav-selected-accordion");
	}

	// Here when the accordion is expanded the icon is changed from right to down
	// When expanded a down icon is displayed. Otherwise a right icon is shown.
	$("#shareFolderLink").click(expandAccordion);

}

function expandAccordion(){
	expanded = !expanded ? true:false;
	expandAccordionGen();
}

function expandAccordionGen(){
	if (window.matchMedia(maxWidthString).matches) {
		if(expanded){
			$("#firstLink").addClass("sharedClose");
			add_navbar_classes();
		}else{
			remove_navbar_classes();
		}
	} else{
		if(expanded){
			$("#expandedIcon").removeClass("glyphicon-menu-right");
			$("#expandedIcon").addClass("glyphicon-menu-down");
		}else{
			$("#expandedIcon").removeClass("glyphicon-menu-down");
			$("#expandedIcon").addClass("glyphicon-menu-right");
		}
		if ($("#vw-nav-trigger").prop("checked") == true) {
			add_navbar_classes();
		}else{
			remove_navbar_classes();
		}
	}
}

var maxWidthString = "(max-width: 767px)";

$(window).resize(function(){
	if (window.matchMedia(maxWidthString).matches) {
		if(expanded){
			$("#shareFolderLink").trigger("click");
			$("#expandedIcon").removeClass("glyphicon-menu-down");
			$("#expandedIcon").addClass("glyphicon-menu-right");
		}else{
			$("#firstLink").addClass("sharedClose");
		}
	}else{
		remove_navbar_classes();
		$("#firstLink").removeClass("sharedClose");
	}
});




function remove_navbar_classes(){
	$("#cv-nav").removeClass("navmine");
	$("#cv-acc-computers-text").removeClass("cv-text");
	$("#cv-acc-drive-text").removeClass("cv-text");
	$("#cv-acc-sync-text").removeClass("cv-text");
	$("#cv-acc-email-text").removeClass("cv-text");
	$("#cv-acc-vms-text").removeClass("cv-text");
	$("#cv-acc-shared-text").removeClass("cv-text");
	$("#cv-acc-sharepoint-text").removeClass("cv-text");
	$("#cv-mobile-apps").removeClass("cv-text");
	$("#expandedIcon").removeClass("cv-text");
	$("#firstLink").removeClass("accordion-expanded");
}

function add_navbar_classes(){
	$("#cv-nav").addClass("navmine");
	$("#cv-acc-computers-text").addClass("cv-text");
	$("#cv-acc-drive-text").addClass("cv-text");
	$("#cv-acc-sync-text").addClass("cv-text");
	$("#cv-acc-email-text").addClass("cv-text");
	$("#cv-acc-vms-text").addClass("cv-text");
	$("#cv-acc-shared-text").addClass("cv-text");
	$("#cv-acc-sharepoint-text").addClass("cv-text");
	$("#cv-mobile-apps").addClass("cv-text");
	$("#expandedIcon").addClass("cv-text");

	$("#firstLink").addClass("accordion-expanded");
}
//using session storage to cache the left nav links
if(sessionStorage.myDataNav){
	var result = JSON.parse(sessionStorage.myDataNav);
	buildNavLinks(result);
}

$("body").on("click", ".js-mydata-apps a", function(event){
	var thisLink = $(this).parent("li");
	var thisLinkId = thisLink.attr("id");
	console.log(thisLinkId);
	if(thisLinkId == undefined){
		return;
	}
	if(thisLinkId === "drive"){
		return;
	}
	if(location.pathname.indexOf("index") !== -1) {
		event.preventDefault();
		// if same tab do not call
		if(thisLink.hasClass("nav-selected")){
			return;
		}
		var params = [];
		params.push(cvUtil.createParamString("page", thisLinkId));
		History.pushState(null, document.title, "?" + cvUtil.createParamsString(params));
		$(".nav-selected").removeClass("nav-selected-accordion");
		$(thisLink).addClass("nav-selected-accordion");
		$(".nav-selected-accordion").removeClass("nav-selected-accordion");
		$(thisLink).addClass("nav-selected-accordion");
		if (thisLinkId == "shareFolder") {

			cvUtil.loadPage('displaySummaryShareFolder.jsp', null, function(data) {
				$("#holder").html(data);
			});
		}else if (thisLinkId == "webFolder"){
			cvUtil.loadPage('displaySummaryWF.jsp', null, function(data) {
				$("#holder").html(data);
			});
		}else if (thisLinkId == "email"){
			cvUtil.loadPage('displaySummaryMail.jsp', null, function(data) {
				$("#holder").html(data);
			});
		}else if (thisLinkId==="mobile"){
			cvUtil.loadPage('mobileAppsCvCloud.jsp', null, function(data) {
				$("#holder").html(data);
			});
		}else if (thisLinkId == "virtualServer"){
			cvUtil.loadPage('displaySummaryVs.jsp', null, function(data) {
				$("#holder").html(data);
			});
		}else if (thisLinkId == "sharepoint"){
			cvUtil.loadPage('displaySummarySharepoint.jsp', null, function(data) {
				$("#holder").html(data);
			});
		}else if (thisLinkId == "fs"){
			if(expanded && $("#vw-nav-trigger").prop("checked") == true) {
				$("#shareFolderLink").trigger("click");
			}
			cvUtil.loadPage('displaySummaryFs.jsp',
				typeof enableMultiCommCell === "undefined" ? null : {enableMultiCommCell: enableMultiCommCell},
				function(data) {
			$("#holder").html(data);

			<%-- Manually bootstrap the 'reports' application after the tab content is loaded. --%>
			if (typeof angular === "object") {
				angular.bootstrap(angular.element("#ng-app"), [ 'reports' ]);
			}});
		}else if( thisLinkId === "sharedByMeLi"){
			closeTheAccordion();

			cvUtil.loadPage('displaySummaryShareFolder.jsp', null, function(data) {
				$("#holder").html(data);
			});
		}else if( thisLinkId === "sharedWithMeLi"){
			closeTheAccordion();
			cvUtil.loadPage('displaySummaryShareFolder.jsp', null, function(data) {
				$("#holder").html(data);
			});
		}else if( thisLinkId === "publicShareLi"){
			closeTheAccordion();
			cvUtil.loadPage('displaySummaryShareFolder.jsp', null, function(data) {
				$("#holder").html(data);
			});
		}else if( thisLinkId === "collabShareLi"){
			closeTheAccordion();
			cvUtil.loadPage('displaySummaryShareFolder.jsp', null, function(data) {
				$("#holder").html(data);
			});
		}
}

});

function closeTheAccordion (){
	if(expanded && $("#vw-nav-trigger").prop("checked") == true) {
		$("#firstLink").addClass("sharedClose");
		$("#shareFolderLink").trigger("click");
	}
	else if (window.matchMedia(maxWidthString).matches && expanded) {
		$("#firstLink").addClass("sharedClose");
		$("#shareFolderLink").trigger("click");
	}
}

function openDefaultPage() {
	var tabList = $(".js-mydata-apps li.true");
	var curSelection = 0;
	if ($(tabList[curSelection]).is("#drive")){
		if (tabList.length > 1){
			// select some other tab
			curSelection++;
		}
	}
	if ($(tabList[curSelection]).hasClass("shareFolderLink")){
		curSelection++;
	}
	if ($(tabList[curSelection]).children("a").length > 0) {
		$(tabList[curSelection]).children("a")[0].click();
	}
	else {
		console.debug("User has no client categories to show on the My Data page");
		$('.vw-container_fullscreen').unmask('');
		cvUtil.toast("${noClientsMessage}")
	}
}

function isNoPageSelected() {
	return ($("#noSummaryPageSelected").length > 0 );
}

$(function(){
	var pageSelected = false;
	if (isNoPageSelected()){
		$('.vw-container_fullscreen').mask('');
		if(sessionStorage.myDataNav){
			// buildNavLinks() is already executed... select and open default page
			openDefaultPage();
			pageSelected = true;
		}
	}

	var params = "isOpenMailbox=" + sessionStorage.getItem('isOpenMailbox');

	cvUtil.loadPageWithGET(cvUtil.getContextPath() + "/getMyDataNav.do", params, function(result) {
		//populate list in nav
		try{
			sessionStorage.setItem('myDataNav', JSON.stringify(result));
		} catch (e){
            console.debug("Browser does not support storing settings locally.");
     	}
		buildNavLinks(result);
		if (isNoPageSelected() && !pageSelected){
			// select and open default page
			openDefaultPage();
		}
	});

		// Bottom Sidebar nav: change the open/close SVG status
		if ($("#vw-nav-trigger").prop("checked") == true) { // checked = truncated version
			$(".vw-js-nav-trigger svg .vw-open").show();
			$(".vw-js-nav-trigger svg .vw-close").hide();

		} else { // unchecked = wide version
			$(".vw-js-nav-trigger svg .vw-close").show();
			$(".vw-js-nav-trigger svg .vw-open").hide();

		}

	$(".vw-js-nav-trigger").on("click", function(){
		if ($("#vw-nav-trigger").prop("checked") == true) { // checked = truncated version
			$(".vw-js-nav-trigger svg .vw-open").hide();
			$(".vw-js-nav-trigger svg .vw-close").show();
			$("#firstLink").removeClass("sharedClose");
			remove_navbar_classes();


		} else { // unchecked = wide version
			$(".vw-js-nav-trigger svg .vw-close").hide();
			$(".vw-js-nav-trigger svg .vw-open").show();

			if(expanded){
				$("#firstLink").addClass("sharedClose");
				$("#shareFolderLink").trigger("click");
				//add_navbar_classes();
			}
		}
	})
});

</script>