<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib prefix="enhance" uri="/WEB-INF/webenhance.tld" %>
<c:if test="${param.bootstrapped == 'true'}">
	<jsp:include page="../common/header-fullscreen.jsp" />
</c:if>

<c:if test="${param.bootstrapped == null}">
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<jsp:include page="/common/search-engine.jsp" />
<!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame
       Remove this if you use the .htaccess -->
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta name="description" content="" />
<meta name="author" content="CommVault">

<c:if test="${param.mobileApp != null || param.mobileApp == 'true'}">
	<meta name="apple-itunes-app" content="app-id=604246090">
	<meta name="google-play-app" content="app-id=com.commvault.mobile.edge">
</c:if>

<c:choose>
	<c:when test="${param.titleLocalized != null}">
		<c:set var="title" value="${param.titleLocalized}" scope="page" />
	</c:when>
	<c:otherwise>
		<fmt:message key="${param.title}" var="title" />
	</c:otherwise>
</c:choose>
<title>${title}</title>
<!-- Replace favicon.ico & apple-touch-icon.png in the root of your domain and delete these references -->
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/customTheme.do?${applicationScope.BUILD_TS}">
<link rel="shortcut icon" href="${pageContext.request.contextPath}/${applicationScope.OEM_PATH}/favicon.png" />
<link rel="apple-touch-icon" href="${pageContext.request.contextPath}/common/img/apple-touch-icon.png" />
<link rel="apple-touch-icon" sizes="57x57" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-57x57.png" />
<link rel="apple-touch-icon" sizes="72x72" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-72x72.png" />
<link rel="apple-touch-icon" sizes="76x76" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-76x76.png" />
<link rel="apple-touch-icon" sizes="114x114" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-114x114.png" />
<link rel="apple-touch-icon" sizes="120x120" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-120x120.png" />
<link rel="apple-touch-icon" sizes="144x144" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-144x144.png" />
<link rel="apple-touch-icon" sizes="152x152" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-152x152.png" />
<link rel="apple-touch-icon" sizes="180x180" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-180x180.png" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/templatestyles.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/sprites.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/notificationHistory.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/settings/settings.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/applications/css/apps.css?${applicationScope.BUILD_TS}" />

<c:if test="${param.displayMode != null && param.displayMode == 'dialog'}">
	<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/cvdialog.css?${applicationScope.BUILD_TS}" />
</c:if>

<link rel="stylesheet" href="${pageContext.request.contextPath}/bareFrameModeCss.do?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/devModeCss.do?${applicationScope.BUILD_TS}" />
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/devModeJs.do?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/clientLoggingJs.do?${applicationScope.BUILD_TS}"></script>

<c:if test="${param.exportType == null || param.exportType != 'mhtml'}">
	<cv:evaluate test="page is not /unsupportedIE.jsp" >
	<!--[if lte IE 9]>
		<meta http-equiv="refresh" content="0;url=${pageContext.request.contextPath}/unsupportedIE.jsp">
	<![endif]-->
	</cv:evaluate>
</c:if>

<c:if test="${paramValues.css != null}">
	<c:forEach items="${paramValues.css}" var="cssFile">
		<c:if test="${!fn:startsWith(cssFile, pageContext.request.contextPath)}">
			<c:set var="cssFile" value="${pageContext.request.contextPath}${pageContext.request.servletPath}/../${cssFile}" />
		</c:if>
		<c:if test="${cv:isSafeInclude(fn:escapeXml(cssFile))}" >
		<link rel="stylesheet" href="${fn:escapeXml(cssFile)}?${applicationScope.BUILD_TS}" />
		</c:if>
	</c:forEach>
</c:if>

<jsp:include page="jquery.jsp" >
	<jsp:param value="${param.includeLatestJquery}" name="includeLatestJquery" />
</jsp:include>
<c:if test="${param.mobileApp != null || param.mobileApp == 'true'}">
	<jsp:include page="jquery.smartbanner.jsp" />
</c:if>
<c:if test="${param.includeTableSupport != null && param.includeTableSupport == 'true'}">
	<jsp:include page="table.jsp" flush="true">
		<jsp:param value="${param.includeLatestDatatable}" name="includeLatestDatatable" />
	</jsp:include>
</c:if>

<c:if test="${param.includeTreeSupport != null && param.includeTreeSupport == 'true'}">
	<jsp:include page="tree.jsp" flush="true" />
</c:if>

<c:if test="${param.includeCustomSelect != null && param.includeCustomSelect == 'true'}">
	<jsp:include page="customSelect.jsp" flush="true" />
</c:if>

<c:if test="${paramValues.jsp != null}">
	<c:forEach items="${paramValues.jsp}" var="jspFile">
		<c:if test="${!(fn:contains(jspFile, 'WEB-INF/') || fn:contains(jspFile, 'WEB-INF\\\\'))}">
			<jsp:include page="../${jspFile}" flush="true" />
		</c:if>
	</c:forEach>
</c:if>

<c:if test="${param.includeMask != null && param.includeMask == 'true'}">
	<jsp:include page="mask.jsp" flush="true" />
</c:if>
<c:if test="${param.includeHistory != null && param.includeHistory == 'true'}">
	<jsp:include page="history.jsp" flush="true" />
</c:if>
<c:if test="${param.includeFormsSupport != null && param.includeFormsSupport == 'true'}">
	<jsp:include page="../forms/forms.jsp" flush="true" />
</c:if>

<c:if test="${paramValues.js != null}">
	<c:forEach items="${paramValues.js}" var="jsFile">
		<c:if test="${!fn:startsWith(jsFile, pageContext.request.contextPath)}">
			<c:set var="jsFile" value="${pageContext.request.contextPath}${pageContext.request.servletPath}/../${jsFile}" />
		</c:if>
		<c:if test="${cv:isSafeInclude(fn:escapeXml(jsFile))}" >
		<script nonce="${sessionScope.cspNonce}" src="${fn:escapeXml(jsFile)}?${applicationScope.BUILD_TS}"></script>
		</c:if>
	</c:forEach>
</c:if>

</head>

<body>
	<fmt:message key="Exception_Text" var="exceptionText" />
	<fmt:message key="common.label.secondsAgo" var="secondsAgo" />
	<fmt:message key="common.label.minuteAgo" var="minuteAgo" />
	<fmt:message key="common.label.minutesAgo" var="minutesAgo" />
	<fmt:message key="common.label.hourAgo" var="hourAgo" />
	<fmt:message key="common.label.hoursAgo" var="hoursAgo" />
	<fmt:message key="common.label.dayAgo" var="dayAgo" />
	<fmt:message key="common.label.daysAgo" var="daysAgo" />
	<fmt:message key="common.action.yes" var="yes" />
	<fmt:message key="common.action.no" var="no" />
	<fmt:message key="common.action.ok" var="ok" />
	<fmt:message key="common.action.pleaseNote" var="pleaseNote" />
	<fmt:message key="sethomepage.success.msg" var="setHomePageSuccess" />
	<fmt:message key="sethomepage.error.msg" var="setHomePageError" />
	<fmt:message key="sethomepage.dialogTitle" var="setHomePageDialogTitle" />
	<fmt:message key="sethomepage.dialogText" var="setHomePageDialogText" />
	<div id="notificationContainer" style="display:none; z-index:9999;">
		<div id="notificationTemplateInfo">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
			    <span class="sprite icon-notif-info" alt="Information" title="Information"></span>
			</div>
			<p><%="#"%>{text}</p>

		</div>
		<div id="notificationTemplateError">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
			    <span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p><%="#"%>{text}</p>
		</div>
		<div id="notificationTemplateServerError">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
				<span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p>${exceptionText}</p>
			<p><span style="font-size: 0.8em;"><%="#"%>{text}</span></p>
		</div>

		<div id="notificationTemplateErrorWithDetails">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
				<span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p><span style="font-size: 0.8em;"><%="#"%>{text}</span></p>
			<a id="errorMoreLink" href="#" style="font-size: 12px"><%="#"%>{moreLabel}</a>
			<p style="display:none; background-color: #555555; border: 1px solid #666666; border-radius: 8px 8px 8px 8px; max-height: 200px; overflow-y: auto; padding: 5px; word-wrap: break-word; font-size: 12px;"><%="#"%>{exceptionText}</p>
		</div>

		<div class="uploadProgress">
		</div>
	</div>
	<div id="progressContainer" style="display:none; z-index:1000;">
	</div>
    <div id="tip" style="display:none"></div>
    <div id="container">
		<c:if test="${param.displayMode == null || param.displayMode != 'dialog'}">
			<div id="header">

				<%-- <img src="${pageContext.request.contextPath}/${applicationScope.OEM_PATH}/Logo_Top.png" alt="Top Logo">&nbsp; --%>

				<c:set var="headerLogoHover" value="Yes" scope="page" />
				<c:set var="homeUrl" value="${pageContext.request.contextPath}/applications" scope="page"/>
				<cv:evaluate test="user is not logged in" > <c:set var="headerLogoHover" value="No" scope="page" />
				</cv:evaluate>
				<c:if test="${param.login_info_not_required == true }" > <c:set var="headerLogoHover" value="No" />
				</c:if>
				<c:choose>
					<c:when test="${headerLogoHover == 'Yes' && (sessionScope.isPublicShareFolder != 'true' && sessionScope.isSoftwareStoreOpenAccess != 'true' )}"><span class="totalHover"><a href= "${cvConfig.getCustomHomeUrl() == null ? homeUrl : cvConfig.getCustomHomeUrl()}" class="hoverDropDown" data-url="/common/apps.jsp" data-left="-1">
						<div id="pglogo" class="hideOnSmallScreens pg-logo-class" style="background-image: url(${sessionScope.customIcon})" alt="Company Logo"></div>
						<div id="pglogo" class="showOnSmallScreens pg-logo-class" style="background-image: url(${sessionScope.customIconSmall})" alt="Company Logo"></div>
						</a></span><span id="dropDownArrowSpan"  class="dropdownOpener hideOnPrintFriendly" data-url="/common/apps.jsp"  data-left="-1"><a href="#" id="appsShortcut"><span class="sprite icon-arrow-dropdown"></span></a><span class="dropdown"></span><span id="appsDiv" class="hidden">
						</span></span>
					</c:when>
					<c:when test="${sessionScope.isPublicShareFolder == 'true' || sessionScope.isSoftwareStoreOpenAccess == 'true'}">
						<div id="pglogo" class="hideOnSmallScreens pg-logo-class" style="background-image: url(${sessionScope.customIcon})" alt="Company Logo"></div>
						<div id="pglogo" class="showOnSmallScreens pg-logo-class" style="background-image: url(${sessionScope.customIconSmall})" alt="Company Logo"></div>
					</c:when>
					<c:otherwise>
						<c:if test="${applicationScope.source != 'VSPHERE_PLUGIN'}">
							<a href="${cvConfig.getCustomHomeUrl() == null ? homeUrl : cvConfig.getCustomHomeUrl()}" >
						</c:if>
						<div id="pglogo" class="hideOnSmallScreens pg-logo-class" style="background-image: url(${sessionScope.customIcon})" alt="Company Logo"></div>
						<div id="pglogo" class="showOnSmallScreens pg-logo-class" style="background-image: url(${sessionScope.customIconSmall})" alt="Company Logo"></div>
						<c:if test="${applicationScope.source != 'VSPHERE_PLUGIN'}">
							</a>
						</c:if>
					</c:otherwise>
				</c:choose>
				<c:choose>
					<c:when test="${cookie.locale != null}">
						<c:set var="curLocale" scope="session" value="${fn:escapeXml(cookie.locale.value)}" />
					</c:when>
					<c:otherwise>
						<c:set var="curLocale" scope="session" value="${pageContext.request.locale}" />
					</c:otherwise>
				</c:choose>
				<c:choose>
				<c:when test="${sessionScope.isPublicShareFolder == 'true' || sessionScope.isSoftwareStoreOpenAccess == 'true'}">
					<ul class="pglinks">
						<li class="invisible nobar rightMenu hideOnExportFriendly" id="activeDownloadsOpener"><span class="dropdownOpener" data-url="/server/getCurrentDownloads"  ><img class="" src="${pageContext.request.contextPath}/common/img/jobProgress.gif" alt="Job Progress" /><span class="dropdown"></span></span></li>
						<li class="nobar rightMenu" style="display:none;" id="notificationHistoryOpener"><span class="sprite icon-notif-unread"></span></li>
						<li class="nobar rightMenu" ><div id="notificationHistoryHolder" style="display:none;"></div></li>
						<c:if test="${cvConfig.isShowLanguageSelection() == true}">
							<li class="nobar rightMenu hideOnExportFriendly"><span id="languagesText" class="dropdownOpener" data-url="/login/languages.jsp" ><span id="currentLanguage">${curLocale}</span>&nbsp;&nbsp;<span id="dropDownArrowSpan" ><span class="sprite icon-arrow-dropdown" alt="^" ></span></span><span class="dropdown"></span></span></li>
						</c:if>
						<li class="nobar rightMenu hideOnExportFriendly"><span id="helpText" class="dropdownOpener" data-url="/login/help.jsp" ><fmt:message key="Help" />&nbsp;&nbsp;<span id="dropDownArrowSpan" ><span class="sprite icon-dropdown" alt="^" ></span></span><span class="dropdown"></span></span></li>
					</ul>
				</c:when>
				<c:otherwise>
					<ul class="pglinks">
						<li class="invisible nobar rightMenu hideOnExportFriendly" id="activeDownloadsOpener"><span class="dropdownOpener" data-url="/server/getCurrentDownloads"  ><img class="" src="${pageContext.request.contextPath}/common/img/jobProgress.gif" alt="Job Progress" /><span class="dropdown"></span></span></li>
						<li class="nobar rightMenu"  style="display:none;" id="notificationHistoryOpener"><span class="sprite icon-notif-unread"></span></li>
						<li class="nobar rightMenu" ><div id="notificationHistoryHolder" style="display:none;"></div></li>
						<li id="setHomePage" class="nobar rightMenu hideOnExportFriendly"><span class="sprite icon-pinhome" title='<fmt:message key="sethomepage.tooltip"/>'></span></li>
						<c:if test="${cvConfig.isShowUserSettings() == true && (param.showOnlyHelp == null || param.showOnlyHelp == 'false' || headerLogoHover == 'Yes')}">
							<li class="rightMenu hideOnExportFriendly userNameValue" data-id="${sessionScope.USERID}"><span id="usernameText" class="dropdownOpener" data-url="/login/username.jsp"><fmt:message key="Top_Welcome"><fmt:param value="${sessionScope.username}" /></fmt:message>&nbsp;&nbsp;<span id="dropDownArrowSpan"><span class="sprite icon-arrow-dropdown" alt="^" ></span></span><span class="dropdown"></span></span></li>
						</c:if>
						<c:if test="${cvConfig.isShowLanguageSelection() == true && cvConfig.isMailboxShortcutLiteEnabled() == false}">
							<li class="nobar rightMenu hideOnExportFriendly"><span id="languagesText" class="dropdownOpener" data-url="/login/languages.jsp" ><span id="currentLanguage">${curLocale}</span>&nbsp;&nbsp;<span id="dropDownArrowSpan" ><span class="sprite icon-arrow-dropdown" alt="^" ></span></span><span class="dropdown"></span></span></li>
						</c:if>
						<c:choose>
							<c:when test="${applicationScope.customHelpUrl != null && cvConfig.isMailboxShortcutLiteEnabled() == false}">
								<li class="nobar rightMenu hideOnExportFriendly"><a id="helpText" target="_blank" href="${applicationScope.customHelpUrl}" ><fmt:message key="Help" /></a></li>
							</c:when>
							<c:when test="${applicationScope.customHelpUrl == null && cvConfig.isMailboxShortcutLiteEnabled() == false}">
 								<li class="nobar rightMenu hideOnExportFriendly"><span id="helpText" class="dropdownOpener" data-url="/login/help.jsp" ><fmt:message key="Help" />&nbsp;&nbsp;<span id="dropDownArrowSpan" ><span class="sprite icon-arrow-dropdown" alt="^" ></span></span><span class="dropdown"></span></span></li>
							</c:when>
							<c:otherwise/>
						</c:choose>
					</ul>
				</c:otherwise>
				</c:choose>
			</div>
		</c:if>

		<div id="content">
			<c:if test="${param.includeSecHeader != null && param.includeSecHeader == 'true' && param.displayMode != 'dialog'}">
				<c:choose>
					<c:when test="${param.headerTitleLocalized != null}">
						<c:set var="headerTitle" value="${param.headerTitleLocalized}" scope="page" />
					</c:when>
					<c:otherwise>
						<fmt:message key="${param.headerTitle}" var="headerTitle" />
					</c:otherwise>
				</c:choose>

				<jsp:include page="secHeader.jsp" flush="true">
					<jsp:param value="${param.searchContext}" name="searchContext" />
					<jsp:param value="${param.hideSearchBox}" name="hideSearchBox" />
					<jsp:param value="${headerTitle}" name="headerTitle" />
					<jsp:param value="${param.showSyncItems}" name="showSyncItems" />
					<jsp:param value="${param.LMHeader}" name="LMHeader"/>
				</jsp:include>
			</c:if>

			<c:if test="${param.includeCustomSecHeader != null && param.includeCustomSecHeader == 'true' && param.displayMode != 'dialog'}">

				<c:choose>
					<c:when test='${(requestScope.APPTYPE == "EXCHANGEMAILBOX")}'>
						<c:set var="headerTitle" value="${param.headerTitleLocalizedExchange}" scope="page" />
					</c:when>
					<c:when test="${param.headerTitleLocalized != null}">
						<c:set var="headerTitle" value="${param.headerTitleLocalized}" scope="page" />
					</c:when>
					<c:otherwise>
						<fmt:message key="${param.headerTitle}" var="headerTitle" />
					</c:otherwise>
				</c:choose>

				<c:set var="customHeaderUrl" value="${param.customHeaderURL}" />
				<c:set var="customHeaderUrl" value="${pageContext.request.servletPath}/../${customHeaderUrl}" />
				<c:if test="${cv:isSafeInclude(fn:escapeXml(customHeaderUrl))}">
					<jsp:include page="${customHeaderUrl}" flush="true">
						<jsp:param value="${param.searchContext}" name="searchContext" />
						<jsp:param value="${param.hideSearchBox}" name="hideSearchBox" />
						<jsp:param value="${headerTitle}" name="headerTitle" />
						<jsp:param value="${param.sourcePage}" name="sourcePage" />
					</jsp:include>
				</c:if>
			</c:if>
			<input type="hidden" id="isLogOut" value="false"/>
			<input type="hidden" id="logOutUrl" value="<%=(request.getContextPath())%>/doLogout.do"/>
			<c:set var="isCustomStartupMessageEnabled" value="${cvConfig.isEnableCustomStartupMessage()}"/>
	<script type="text/javascript" nonce="${sessionScope.cspNonce}" >
		var localMsg = localMsg || {};
		localMsg.exceptionText= "${exceptionText}";
		localMsg.secondsAgo="${secondsAgo}";
		localMsg.minuteAgo="${minuteAgo}";
		localMsg.minutesAgo="${minutesAgo}";
		localMsg.hourAgo="${hourAgo}";
		localMsg.hoursAgo="${hoursAgo}";
		localMsg.dayAgo="${dayAgo}";
		localMsg.daysAgo="${daysAgo}";
		localMsg.yes="${yes}";
		localMsg.no="${no}";
		localMsg.ok="${ok}";
		localMsg.pleaseNote="${pleaseNote}";
		localMsg.setHomePageSuccess="${setHomePageSuccess}";
		localMsg.setHomePageError="${setHomePageError}";
		localMsg.setHomePageDialogTitle="${setHomePageDialogTitle}";
		localMsg.setHomePageDialogText="${setHomePageDialogText}";

		$(".logout").click(function(event)
		{
				nh.clearNotificationHistory();
				if(typeof(Storage) !== "undefined") sessionStorage.clear();
				window.location.href="<%=(request.getContextPath())%>/doLogout.do";
		});

		if(!cv){
			var cv = cv || {};
			cv.additionalSettings = "${sessionScope.ADDITIONAL_SETTINGS}" === "" ? {} :JSON.parse("${sessionScope.ADDITIONAL_SETTINGS}".replace(/&#034;/g, '\"'));
			cv.userPref = "${sessionScope.userPreferences}" === "" ? {} :JSON.parse("${sessionScope.userPreferences}".replace(/&#034;/g, '\"'));
			cv.locale = '${sessionScope.PREF_LOCALE}';
			cv.loggedInUserSmtp = "${loginContext.getUserInfo().getSmtpAddress()}";
			cv.isAdmin = "${sessionScope.isAdminUser}" === "true";
			cv.isAdminOnCommcellLevel = "${sessionScope.IS_ADMIN_ON_COMMCELL}" === "true";
			cv.contextPath= '${pageContext.request.contextPath}';
			cv.isDomainUser= "${sessionScope.IS_DOMAIN_USER}"==="true";
			cv.isTenantAdmin = "${sessionScope.IS_TENANT_ADMIN}"=== "true";
			cv.isTenantUser = "${sessionScope.IS_TENANT_USER}"=== "true";
			cv.isMspUser = "${sessionScope.IS_MSP_USER}" === "true";
			cv.isMspAdmin = "${sessionScope.IS_MSP_Admin}" === "true";
			var isCustomStartupMessageEnabled = ${isCustomStartupMessageEnabled};

			if (isCustomStartupMessageEnabled && (!cvUtil.readCookie("showCustomStartupMessageAcknowledged")) && cv.additionalSettings && cv.additionalSettings.Console) {
				cvUtil.showCustomStartupMessage(cv.additionalSettings.Console.CustomStartUpMessage);
			}
			var System = cv;
		}

		$(".dropdown").on("click", ".languageList", function(event){
			var selected;
			if (event.target.tagName == "A"){
				selected = event.target.parentElement.id;
			}else{
				selected = event.target.id;
			}
		    var ca = document.cookie.split(';');
		    var localeCk = "";
		    for(var i=0; i<ca.length; i++) {
		        var c = ca[i];
		        c = $.trim(c);
		        if (c.indexOf("locale=") == 0)
		        	localeCk = c;
		    }
	    	var myDate = new Date() ;
	    	myDate.setMonth(myDate.getMonth() + 12);
	    	if( localeCk == "" || localeCk != "locale="+selected){
		    	document.cookie = "locale=" + selected + ";expires=" + myDate + ";path=/";
		    	document.cookie = "tempLocale=" + selected + ";max-age=1800;path=/";
		    	location.reload(true);
			}
		});
		try {
			cvUtil.DEFAULT_TIMEOUT = parseInt("${applicationScope.connectionTimeout}") * 60000;
		} catch(err) {
			console.log("Unable to fetch connection timeout, default to 1 minute.");
		}


	</script>
</c:if>
<!-- Keep Login Modal -->
<div class="modal fade" id="keepLoginModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="display:none;" >
  <div class="modal-dialog" role="document" style="width:400px;" >
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel"><fmt:message key="title.keepLogin" /></h4>
      </div>
      <div class="modal-body">
		<fmt:message key="msg.timeWarning">
			<fmt:param value='<span type="text" name="sessionTimer" id="sessionTimer"></span>'/>
		</fmt:message>	<br/>
		<fmt:message key="msg.keepLogin"/><br/>
      </div>
      <div class="modal-footer">
        <button type="button" class="vw-btn vw-btn-default keepLoginNo"><fmt:message key="keepLogin.no"/>
        </button>
        <button type="button" class="vw-btn vw-btn-primary keepLoginYes" data-dismiss="modal"><fmt:message key="keepLogin.yes" /></button>
      </div>
    </div>
  </div>
</div>

<!-- Locked session modal -->
<div class="modal fade" id="lockedSessionModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="display:none;" data-backdrop="static" data-keyboard="false" >
  <div class="modal-dialog" role="document" style="width:400px;" >
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel"><fmt:message key="session_locked_title" /></h4>
      </div>
      <div class="modal-body">
		<fmt:message key="session_locked" /><br><fmt:message key="enter_password" /><br/>
		<input type="password" id="lockedPassword" autocomplete="off" placeholder="Password" name="password" class="textbox form-control" style="margin: 10px 0;">
		<div class="passError" style="display:none;color: #ff1133;"><fmt:message key="msg.incorrect_password" /></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="vw-btn vw-btn-default lockedLogout"><fmt:message key="Logout" />
        </button>
        <button type="button" class="vw-btn vw-btn-primary lockedLogin" data-dismiss="modal"><fmt:message key="unlock_session" /></button>
      </div>
    </div>
  </div>
</div>
