<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib prefix="enhance" uri="/WEB-INF/webenhance.tld" %>
<!DOCTYPE html>
<html lang="en">
<head>
<jsp:include page="/common/search-engine.jsp" />
<meta charset="utf-8" />
<!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame
       Remove this if you use the .htaccess -->
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
<meta name="description" content="" />
<meta name="author" content="CommVault">

<c:choose>
	<c:when test="${param.app == 3}">
		<meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0">
	</c:when>
	<c:otherwise>
		<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	</c:otherwise>
</c:choose>

<c:if test="${param.mobileApp != null || param.mobileApp == 'true'}">
	<meta name="apple-itunes-app" content="app-id=604246090">
</c:if>

<c:choose>
	<c:when test="${param.titleLocalized != null}">
		<c:set var="title" value="${fn:escapeXml(param.titleLocalized)}" scope="page" />
	</c:when>
	<c:otherwise>
		<fmt:message key="${param.title}" var="title" />
	</c:otherwise>
</c:choose>

<title>${fn:escapeXml(title)}</title>

<c:set var="exportOperation" value="false" />
<c:if test="${param.exportType != null}">
	<c:set var="exportOperation" value="true" />
</c:if>
<c:set var="templateStyles" value="${pageContext.request.contextPath}/common/css/template-bootstrap.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/thirdParty/glyphicons/glyphicons.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/thirdParty/glyphicons/glyphicons-halflings.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/thirdParty/glyphicons/glyphicons-filetypes.css?${applicationScope.BUILD_TS}" />
<c:if test="${exportOperation eq true}">
	<c:set var="templateStyles" value="${pageContext.request.contextPath}/common/css/templatestyles.css?${applicationScope.BUILD_TS}" />
	<c:if test="${param.LMHeader != null && param.LMHeader != ''}">
		<c:set var="templateStyles" value="${pageContext.request.contextPath}/common/css/template-bootstrap.css?${applicationScope.BUILD_TS}" />
	</c:if>
</c:if>

<!-- Replace favicon.ico & apple-touch-icon.png in the root of your domain and delete these references -->
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/customTheme.do?${applicationScope.BUILD_TS}">
<link rel="shortcut icon" href="${pageContext.request.contextPath}/${applicationScope.OEM_PATH}/favicon.png" />
<link rel="apple-touch-icon" href="${pageContext.request.contextPath}/common/img/apple-touch-icon.png" />
<link rel="apple-touch-icon" sizes="57x57" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-57x57.png" />
<link rel="apple-touch-icon" sizes="72x72" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-72x72.png" />
<link rel="apple-touch-icon" sizes="76x76" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-76x76.png" />
<link rel="apple-touch-icon" sizes="114x114" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-114x114.png" />
<link rel="apple-touch-icon" sizes="120x120" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-120x120.png" />
<link rel="apple-touch-icon" sizes="144x144" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-144x144.png" />
<link rel="apple-touch-icon" sizes="152x152" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-152x152.png" />
<link rel="apple-touch-icon" sizes="180x180" href="${pageContext.request.contextPath}/common/img/apple-touch-icon-180x180.png" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/sprites.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${templateStyles}" />
<!-- <link rel="stylesheet" href="${pageContext.request.contextPath}/reports/responsive/css/reportsNav.css?${applicationScope.BUILD_TS}" />-->
<link rel="stylesheet" href="${pageContext.request.contextPath}/bareFrameModeCss.do?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/devModeCss.do?${applicationScope.BUILD_TS}" />
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/devModeJs.do?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/clientLoggingJs.do?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/mustache.js?${applicationScope.BUILD_TS}"></script>

<c:if test="${param.exportType == null || param.exportType != 'mhtml'}">
	<cv:evaluate test="page is not /unsupportedIE.jsp" >
	<!--[if lte IE 9]>
		<meta http-equiv="refresh" content="0;url=${pageContext.request.contextPath}/unsupportedIE.jsp">
	<![endif]-->
	</cv:evaluate>
</c:if>

<c:if test="${paramValues.css != null}">
	<c:forEach items="${paramValues.css}" var="cssFile">
		<c:if test="${!fn:startsWith(cssFile, pageContext.request.contextPath)}">
			<c:set var="cssFile" value="${pageContext.request.contextPath}${pageContext.request.servletPath}/../${cssFile}" />
		</c:if>
		<c:if test="${cv:isSafeInclude(fn:escapeXml(cssFile))}" >
		<link rel="stylesheet" href="${fn:escapeXml(cssFile)}?${applicationScope.BUILD_TS}" />
		</c:if>
	</c:forEach>
</c:if>

<jsp:include page="jqueryV3.jsp" >
	<jsp:param value="${param.includeLatestJquery}" name="includeLatestJquery" />
</jsp:include>
<c:if test="${param.mobileApp != null || param.mobileApp == 'true'}">
	<jsp:include page="jquery.smartbanner.jsp" />
</c:if>
<c:if test="${param.includeTableSupport != null && param.includeTableSupport == 'true'}">
	<jsp:include page="tableV3.jsp" flush="true">
		<jsp:param value="${param.includeLatestDatatable}" name="includeLatestDatatable" />
		<jsp:param value="${param.bootstrapped}" name="bootstrapped" />
	</jsp:include>
</c:if>

<c:if test="${param.includeTreeSupport != null && param.includeTreeSupport == 'true'}">
	<jsp:include page="tree.jsp" flush="true" />
</c:if>

<c:if test="${param.includeCustomSelect != null && param.includeCustomSelect == 'true'}">
	<jsp:include page="customSelect.jsp" flush="true" />
</c:if>

<c:if test="${paramValues.jsp != null}">
	<c:forEach items="${paramValues.jsp}" var="jspFile">
		<c:if test="${!(fn:contains(jspFile, 'WEB-INF/') || fn:contains(jspFile, 'WEB-INF\\\\'))}">
			<jsp:include page="../${jspFile}" flush="true" />
		</c:if>
	</c:forEach>
</c:if>

<c:if test="${param.includeMask != null && param.includeMask == 'true'}">
	<jsp:include page="mask.jsp" flush="true" />
</c:if>
<c:if test="${param.includeHistory != null && param.includeHistory == 'true'}">
	<jsp:include page="historyV3.jsp" flush="true" />
</c:if>
<c:if test="${param.includeFormsSupport != null && param.includeFormsSupport == 'true'}">
	<jsp:include page="../forms/forms.jsp" flush="true" />
</c:if>

<c:if test="${paramValues.js != null}">
	<c:forEach items="${paramValues.js}" var="jsFile">
		<c:if test="${!fn:startsWith(jsFile, pageContext.request.contextPath)}">
			<c:set var="jsFile" value="${pageContext.request.contextPath}${pageContext.request.servletPath}/../${jsFile}" />
		</c:if>
		<c:if test="${cv:isSafeInclude(fn:escapeXml(jsFile))}" >
		<script nonce="${sessionScope.cspNonce}" src="${fn:escapeXml(jsFile)}?${applicationScope.BUILD_TS}"></script>
		</c:if>
	</c:forEach>
</c:if>

</head>

<body class="vw-fullscreen-mode<c:if test="${param.not_logged_in == 'true'}"> vw-body_not-logged-in</c:if> vw-${param.displayMode}">
	<fmt:message key="Exception_Text" var="exceptionText" />
	<fmt:message key="common.label.secondsAgo" var="secondsAgo" />
	<fmt:message key="common.label.minuteAgo" var="minuteAgo" />
	<fmt:message key="common.label.minutesAgo" var="minutesAgo" />
	<fmt:message key="common.label.hourAgo" var="hourAgo" />
	<fmt:message key="common.label.hoursAgo" var="hoursAgo" />
	<fmt:message key="common.label.dayAgo" var="dayAgo" />
	<fmt:message key="common.label.daysAgo" var="daysAgo" />
	<fmt:message key="common.action.yes" var="yes" />
	<fmt:message key="common.action.no" var="no" />
	<fmt:message key="common.action.ok" var="ok" />
	<fmt:message key="common.action.pleaseNote" var="pleaseNote" />
	<fmt:message key="sethomepage.success.msg" var="setHomePageSuccess" />
	<fmt:message key="sethomepage.error.msg" var="setHomePageError" />
	<fmt:message key="sethomepage.dialogTitle" var="setHomePageDialogTitle" />
	<fmt:message key="sethomepage.dialogText" var="setHomePageDialogText" />
	<div id="notificationContainer" class="vw-note-templates">
		<div id="notificationTemplateInfo" class="vw-note_info">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div class="vw-note_text">
			    <span class="sprite icon-notif-info" alt="Information" title="Information"></span>
			</div>
			<p><%="#"%>{text}</p>

		</div>
		<div id="notificationTemplateError" class="vw-note_error">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div class="vw-note_text">
			    <span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p><%="#"%>{text}</p>
		</div>
		<div id="notificationTemplateServerError" class="vw-note_server-error">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div class="vw-note_text">
				<span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p>${exceptionText}</p>
			<p><small><%="#"%>{text}</small></p>
		</div>

		<div id="notificationTemplateErrorWithDetails" class="vw-note_error-detailed">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div class="vw-note_text">
				<span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p><small><%="#"%>{text}</small></p>
			<a id="errorMoreLink" href="#" class="vw-small"><%="#"%>{moreLabel}</a>
			<p class="vw-details vw-small hidden"><%="#"%>{exceptionText}</p>
		</div>

		<div class="uploadProgress">
		</div>
	</div>
	<div id="progressContainer" class="hidden vw-file-progress-container">
	</div>
    <div id="tip" class="hidden"></div>
    <div id="container">
		<c:if test="${param.displayMode == null || param.displayMode != 'dialog'}">
			<c:if test="${param.app != 3}">
				<div id="header" class="vw-header hidden-print">
					<nav class="vw-navbar" role="navigation">
					<c:set var="headerLogoHover" value="Yes" scope="page" />
					<c:set var="homeUrl" value="${pageContext.request.contextPath}/applications" scope="page"/>
					<cv:evaluate test="user is not logged in" > <c:set var="headerLogoHover" value="No" scope="page" />
					</cv:evaluate>
					<c:if test="${param.login_info_not_required == true }" > <c:set var="headerLogoHover" value="No" />
					</c:if>
					<c:set var="icon" value="${sessionScope.customIcon}" />
					<c:if test="${param.customIcon != null}">
						<c:set var="icon" value="${fn:escapeXml(param.customIcon)}" />
					</c:if>
					<c:choose>
						<c:when test="${headerLogoHover == 'Yes' && (sessionScope.isPublicShareFolder != 'true' && sessionScope.isSoftwareStoreOpenAccess != 'true')}">
							<div class="totalHover vw-brand-container pull-left">
								<c:choose>
								<c:when test="${requestScope.isHeaderClicksDisabled ne 'true' && param.not_logged_in != 'true'}">
									<a href= "${cvConfig.getCustomHomeUrl() == null ? homeUrl : cvConfig.getCustomHomeUrl()}" class="hoverDropDown vw-logo pull-left" data-url="/common/apps.jsp" data-left="-1">
										<div id="pglogo" class="hideOnSmallScreens pg-logo-class vw-navbar-brand hidden-xs" style="background-image: url(${icon})" alt="Company Logo"></div>
										<div id="pglogo" class="showOnSmallScreens pg-logo-class vw-navbar-brand visible-xs-block" style="background-image: url(${sessionScope.customIconSmall})" alt="Company Logo"></div>
									</a>
								</c:when>
								<c:when test="${param.not_logged_in != 'true'}">
									<div id="pglogo" class="hideOnSmallScreens pg-logo-class vw-navbar-brand  hidden-xs" style="background-image: url(${icon})" alt="Company Logo"></div>
									<div id="pglogo" class="showOnSmallScreens pg-logo-class vw-navbar-brand visible-xs-block" style="background-image: url(${sessionScope.customIconSmall})" alt="Company Logo">
								</c:when>
								</c:choose>

								<c:if test="${param.myDataTitle != null || param.myDataTitle == 'true'}">
									<div class="vm-mydata-title">
									<fmt:message key="My_Backups" />
									</div>
								</c:if>
								<c:if test="${param.reportsNav != null || param.reportsNav == 'true'}">
									<div class="vm-mydata-title vm-mydata-title1 hideOnExportFriendly">
									<fmt:message key="Reports" />
									</div>
								</c:if>
								<c:if test="${param.primaryheaderTitle != null}">
									<div class="vm-mydata-title">
									<fmt:message key="${param.primaryheaderTitle}" />
									</div>
								</c:if>
							</div>
							<span id="dropDownArrowSpan" class="dropdownOpener vw-dropdown-container vw-drop-down-toggle hideOnPrintFriendly hidden-xs" data-url="/common/apps.jsp" data-left="-1"><a href="#" id="appsShortcut" class="app-shortcut vw-shortcut-app"><span class="sprite icon-arrow-dropdown"></span></a><span class="dropdown vw-drop-down"></span><span id="appsDiv" class="hidden"></span></span>
						</c:when>
						<c:when test="${sessionScope.isPublicShareFolder == 'true' || sessionScope.isSoftwareStoreOpenAccess == 'true'}">
							<div class="vw-brand-container pull-left">
								<div class="vw-logo pull-left" data-left="-1">
									<div id="pglogo" class="showOnSmallScreens pg-logo-class vw-navbar-brand hidden-xs" style="background-image: url(${icon})" alt="Company Logo"></div>
									<div id="pglogo" class="hideOnSmallScreens pg-logo-class vw-navbar-brand visible-xs-block" style="background-image: url(${sessionScope.customIconSmall})" alt="Company Logo"></div>
								</div>
								<c:if test="${param.myDataTitle != null || param.myDataTitle == 'true'}">
									<div class="vm-mydata-title">
									<fmt:message key="My_Backups" />
									</div>
								</c:if>
								<c:if test="${param.reportsNav != null || param.reportsNav == 'true'}">
									<div class="vm-mydata-title vm-mydata-title1">
									<fmt:message key="Reports" />
									</div>
								</c:if>
								<c:if test="${param.primaryheaderTitle != null}">
									<div class="vm-mydata-title">
									<fmt:message key="${param.primaryheaderTitle}" />
									</div>
								</c:if>
							</div>
						</c:when>
						<c:otherwise>
							<c:if test="${param.not_logged_in != 'true'}">
								<c:if test="${applicationScope.source != 'VSPHERE_PLUGIN'}">
									<a href="${cvConfig.getCustomHomeUrl() == null ? homeUrl : cvConfig.getCustomHomeUrl()}" >
								</c:if>
								<div class="vw-brand-container pull-left">
									<div id="pglogo" class="hideOnSmallScreens pg-logo-class vw-navbar-brand visible-xs-block" style="background-image: url(${icon})" alt="Company Logo"></div>
									<div id="pglogo" class="showOnSmallScreens pg-logo-class vw-navbar-brand hidden-xs" style="background-image: url(${sessionScope.customIconSmall})" alt="Company Logo"></div>
									<c:if test="${param.myDataTitle != null || param.myDataTitle == 'true'}">
										<div class="vm-mydata-title">
										<fmt:message key="My_Backups" />
										</div>
									</c:if>
									<c:if test="${param.reportsNav != null || param.reportsNav == 'true'}">
										<div class="vm-mydata-title vm-mydata-title1">
										<fmt:message key="Reports" />
										</div>
									</c:if>
								</div>
								<c:if test="${applicationScope.source != 'VSPHERE_PLUGIN'}">
									</a>
								</c:if>
							</c:if>
						</c:otherwise>
					</c:choose>
					<c:choose>
						<c:when test="${cookie.locale != null}">
							<c:set var="curLocale" scope="session" value="${fn:escapeXml(cookie.locale.value)}" />
						</c:when>
						<c:otherwise>
							<c:set var="curLocale" scope="session" value="${pageContext.request.locale}" />
						</c:otherwise>
					</c:choose>
					<c:choose>
					<c:when test="${sessionScope.isPublicShareFolder == 'true' || sessionScope.isSoftwareStoreOpenAccess == 'true'}">
						<div class="vw-navigation-container">
								<button type="button" class="vw-navbar-toggle collapsed hideOnExportFriendly" data-toggle="collapse" data-target="#navbar-ex" aria-haspopup="true" aria-expanded="false">
									<span class="sr-only">Toggle navigation</span>
									<span class="vw-icon-bar"></span>
									<span class="vw-icon-bar"></span>
									<span class="vw-icon-bar"></span>
								</button>
								<ul class="vw-notifications-menu hideOnExportFriendly">
									<li class="invisible nobar rightMenu hideOnExportFriendly vw-icon-progress" id="activeDownloadsOpener"><span class="dropdownOpener vw-drop-down-toggle" data-url="/server/getCurrentDownloads"><svg width="14px" height="14px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-wheel" focusable="false"><circle cx="50" cy="50" r="35" fill="none" stroke-width="20" stroke-dasharray="22px"><animate attributeName="stroke-dashoffset" from="130" to="0" begin="0" dur="1s" repeatCount="indefinite" fill="freeze"></animate></circle></svg><span class="dropdown vw-drop-down"></span></span></li>
									<li class="nobar rightMenu vw-icon-notification hidden" id="notificationHistoryOpener"><a href="#" id="vw-notification-popover"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" class="vw-notification-svg" focusable="false"><path d="M8,0a8,8,0,1,0,8,8A8,8,0,0,0,8,0ZM9,12H7V10H9v2ZM9,9H7V3H9V9Z"/></svg></a></li>
									<li class="nobar rightMenu" ><div id="notificationHistoryHolder" class="vw-notification-history_container hidden"></div></li>
								</ul>
							<div class="collapse vw-navbar-collapse" id="navbar-ex">
								<ul class="pglinks hideOnExportFriendly vw-header_nav nav navbar-nav navbar-right">
									<c:if test="${ param.enableLoginLink == true }">
										<c:choose>
											<c:when test="${ param.storeApp == true }">
												<li class="nobar rightMenu hideOnExportFriendly vw-contains-drop-down"><a href="${pageContext.request.contextPath}/softwarestore/loginAndReturn.do?targetUrl=softwarestore/store.do"><fmt:message key="Login" /></a></li>
											</c:when>
											<c:when test="${ param.downloadCenterApp == true }">
												<li class="nobar rightMenu hideOnExportFriendly vw-contains-drop-down"><a href="${pageContext.request.contextPath}/downloadcenter/loginAndReturn.do?targetUrl=downloadcenter/dc.do"><fmt:message key="Login" /></a></li>
											</c:when>
											<c:otherwise>
												<li class="nobar rightMenu hideOnExportFriendly vw-contains-drop-down"><a href="${pageContext.request.contextPath}/login/"><fmt:message key="Login" /></a></li>
											</c:otherwise>
										</c:choose>
									</c:if>
									<c:if test="${cvConfig.isShowLanguageSelection() == true}">
										<li class="nobar rightMenu hideOnExportFriendly vw-contains-drop-down"><span id="languagesText" class="dropdownOpener vw-drop-down-toggle" data-url="/login/languages.jsp" tabindex="0"><span id="currentLanguage">${curLocale}</span><span id="dropDownArrowSpan" class="vw-dropdown-container"><span class="vw-sprite-arrow vw-sprite-arrow-down" alt="^" ></span></span><span class="dropdown vw-drop-down"></span></span></li>
									</c:if>
									<li class="nobar rightMenu hideOnExportFriendly vw-contains-drop-down vw-help"><span id="helpText" class="dropdownOpener vw-drop-down-toggle" data-url="/login/help.jsp" tabindex="0" role="button" aria-haspopup="true" aria-expanded="false" aria-controls="header-help-menu"><fmt:message key="Help" /><span id="dropDownArrowSpan" class="vw-dropdown-container" class="vw-dropdown-container"><span class="vw-sprite-arrow vw-sprite-arrow-down" alt="^" ></span></span><span class="dropdown vw-drop-down"></span></span></li>
								</ul>
							</div>
						</div>
						</nav>
					</c:when>
					<c:otherwise>
						<div class="vw-navigation-container">
								<button type="button" class="vw-navbar-toggle collapsed hideOnExportFriendly" data-toggle="collapse" data-target="#navbar-ex" aria-haspopup="true" aria-expanded="false">
									<span class="sr-only">Toggle navigation</span>
									<span class="vw-icon-bar"></span>
									<span class="vw-icon-bar"></span>
									<span class="vw-icon-bar"></span>
								</button>


							<div class="iconWrapper">
								<ul class="vw-notifications-menu hideOnExportFriendly">
										<li class="invisible nobar rightMenu hideOnExportFriendly vw-icon-progress" id="activeDownloadsOpener"><span class="dropdownOpener vw-drop-down-toggle" data-url="/server/getCurrentDownloads"><svg width="14px" height="14px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-wheel" focusable="false"><circle cx="50" cy="50" r="35" fill="none" stroke-width="20" stroke-dasharray="22px"><animate attributeName="stroke-dashoffset" from="130" to="0" begin="0" dur="1s" repeatCount="indefinite" fill="freeze"></animate></circle></svg><span class="dropdown vw-drop-down"></span></span></li>
										<li class="nobar rightMenu vw-icon-notification hidden" id="notificationHistoryOpener"><a href="#" id="vw-notification-popover"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" class="vw-notification-svg" focusable="false"><path d="M8,0a8,8,0,1,0,8,8A8,8,0,0,0,8,0ZM9,12H7V10H9v2ZM9,9H7V3H9V9Z"/></svg></a></li>
										<li class="nobar rightMenu"><div id="notificationHistoryHolder" class="vw-notification-history_container hidden"></div></li>
								</ul>
							<c:if test="${param.not_logged_in != 'true'}">
								<div id="setHomePage" class="nobar rightMenu hideOnExportFriendly vw-pinhome" role="button" aria-label="<fmt:message key="sethomepage.tooltip"/>" tabindex="0" data-toggle="tooltip" data-placement="bottom" title='<fmt:message key="sethomepage.tooltip"/>'><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" role="img" alt="" aria-hidden="true" focusable="false"><path role="presentation" d="M0.1,15.8v-0.3c0-2.5,0-4.9,0-7.4c0-0.1,0.1-0.3,0.2-0.4l7.6-7.6L8,0.1l0.2,0.2l7.6,7.5c0.1,0.1,0.2,0.3,0.2,0.4 c0,2.5,0,4.9,0,7.4v0.3H9.6v-4.7H6.4v4.7H0.1z"/></svg></div>
							</c:if>

							</div>
							<div class="collapse vw-navbar-collapse" id="navbar-ex">
								<ul class="pglinks vw-header_nav nav navbar-nav navbar-right">
									<c:if test="${cvConfig.isShowUserSettings() == true && (param.showOnlyHelp == null || param.showOnlyHelp == 'false' || headerLogoHover == 'Yes')}">
										<li class="rightMenu hideOnExportFriendly userNameValue vw-contains-drop-down" data-id="${sessionScope.USERID}"><span class="dropdownOpener vw-drop-down-toggle"  data-url="/login/username.jsp" tabindex="0" role="button" aria-haspopup="true" aria-expanded="false" aria-controls="header-username-menu"><fmt:message key="Top_Welcome"><fmt:param value="${sessionScope.username}" /></fmt:message><span id="dropDownArrowSpan" class="vw-dropdown-container"><span class="vw-sprite-arrow vw-sprite-arrow-down" alt="^" ></span></span><span class="dropdown vw-drop-down"></span></span></li>
									</c:if>
									<c:if test="${cvConfig.isShowLanguageSelection() == true}">
										<li class="nobar rightMenu hideOnExportFriendly vw-contains-drop-down"><span id="languagesText" class="dropdownOpener vw-drop-down-toggle" data-url="/login/languages.jsp" tabindex="0"><span id="currentLanguage">${curLocale}</span><span id="dropDownArrowSpan" class="vw-dropdown-container"><span class="vw-sprite-arrow vw-sprite-arrow-down" alt="^" ></span></span><span class="dropdown vw-drop-down"></span></span></li>
									</c:if>
									<c:choose>
										<c:when test="${applicationScope.customHelpUrl != null}">
											<li class="nobar rightMenu hideOnExportFriendly vw-contains-drop-down"><a id="helpText" target="_blank" href="${applicationScope.customHelpUrl}" tabindex="0"><fmt:message key="Help" /></a></li>
										</c:when>
										<c:otherwise>
											<li class="nobar rightMenu hideOnExportFriendly vw-contains-drop-down vw-help"><span id="helpText" class="dropdownOpener vw-drop-down-toggle" data-url="/login/help.jsp" tabindex="0" role="button" aria-haspopup="true" aria-expanded="false" aria-controls="header-help-menu"><fmt:message key="Help" /><span id="dropDownArrowSpan" class="vw-dropdown-container"><span class="vw-sprite-arrow vw-sprite-arrow-down" alt="^" ></span></span><span class="dropdown vw-drop-down"></span></span></li>
										</c:otherwise>
									</c:choose>
								</ul>
							</div>
						</div>
					</c:otherwise>
					</c:choose>
					</nav>
				</div>
			</c:if>
		</c:if>

<c:if test="${(sessionScope.isPublicShareFolder != 'true' && sessionScope.isSoftwareStoreOpenAccess != 'true') && (param.navPage != null)}">
	<c:if test="${!(fn:contains(param.navPage, 'WEB-INF/') || fn:contains(param.navPage, 'WEB-INF\\\\'))}">
		<jsp:include page="${param.navPage}" />
	</c:if>
</c:if>

<c:if test="${exportOperation eq false}">
	<c:if test="${(sessionScope.isPublicShareFolder != 'true' && sessionScope.isSoftwareStoreOpenAccess != 'true') && (param.reportsNav != null || param.reportsNav == 'true') && (param.dashboard == null || param.dashboard == 'false') }">
		<jsp:include page="/reports/reportsNav.jsp">
			<jsp:param value="true" name="reportsNav" />
		 	<jsp:param value="true" name="changePage" />
		 	<jsp:param value="true" name="dashboard" />
		 	<jsp:param value="true" name="newDashboard" />
			<jsp:param name="welcomeMsg" value="" />
			<jsp:param name="searchCC" value="true" />
			<jsp:param name="showTabs" value="true" />
			<jsp:param name="dashboard" value="true" />
			<jsp:param name="includeDashboardBreadcrumb" value="true" />
			<jsp:param name="includeCROptionBeforeSearch" value="true" />
			<jsp:param value="true" name="exportPdf"/>
			<jsp:param value="true" name="exportHtml"/>
			<jsp:param value="true" name="printButton"/>
			<jsp:param value="true" name="exportEnabled"/>
			<jsp:param value="true" name="usersManagement"/>
		</jsp:include>
	</c:if>
</c:if>

			<div id="content" class="vw-content">
				<div class="vw-container_fullscreen vw-container_fullscreen1<c:if test="${param.fullscreen == 'true'}"> vw-fullscreen-area</c:if>">

			<c:if test="${param.includeSecHeader != null && param.includeSecHeader == 'true' && param.displayMode != 'dialog'}">
				<c:choose>
					<c:when test="${param.headerTitleLocalized != null}">
						<c:set var="headerTitle" value="${param.headerTitleLocalized}" scope="page" />
					</c:when>
					<c:otherwise>
						<fmt:message key="${param.headerTitle}" var="headerTitle" />
					</c:otherwise>
				</c:choose>

				<jsp:include page="secHeader.jsp" flush="true">
					<jsp:param value="${param.searchContext}" name="searchContext" />
					<jsp:param value="${param.hideSearchBox}" name="hideSearchBox" />
					<jsp:param value="${headerTitle}" name="headerTitle" />
					<jsp:param value="${param.showSyncItems}" name="showSyncItems" />
					<jsp:param value="${param.LMHeader}" name="LMHeader"/>
					<jsp:param value="${param.showSettings}" name="showSettings"/>
				</jsp:include>
			</c:if>

			<c:if test="${param.includeCustomSecHeader != null && param.includeCustomSecHeader == 'true' && param.displayMode != 'dialog'}">

				<c:choose>
					<c:when test='${(requestScope.APPTYPE == "EXCHANGEMAILBOX")}'>
						<c:set var="headerTitle" value="${param.headerTitleLocalizedExchange}" scope="page" />
					</c:when>
					<c:when test="${param.headerTitleLocalized != null}">
						<c:set var="headerTitle" value="${param.headerTitleLocalized}" scope="page" />
					</c:when>
					<c:otherwise>
						<fmt:message key="${param.headerTitle}" var="headerTitle" />
					</c:otherwise>
				</c:choose>
				<c:set var="customHeaderUrl" value="${param.customHeaderURL}" />
				<c:set var="customHeaderUrl" value="${pageContext.request.servletPath}/../${customHeaderUrl}" />
				<c:if test="${cv:isSafeInclude(fn:escapeXml(customHeaderUrl))}">
					<jsp:include page="${customHeaderUrl}" flush="true">
						<jsp:param value="${param.searchContext}" name="searchContext" />
						<jsp:param value="${param.hideSearchBox}" name="hideSearchBox" />
						<jsp:param value="${headerTitle}" name="headerTitle" />
						<jsp:param value="${param.sourcePage}" name="sourcePage" />
					</jsp:include>
				</c:if>
			</c:if>
			<input type="hidden" id="isLogOut" value="false"/>
			<input type="hidden" id="logOutUrl" value="<%=(request.getContextPath())%>/doLogout.do"/>
	<c:set var="isCustomStartupMessageEnabled" value="${cvConfig.isEnableCustomStartupMessage()}"/>
	<script type="text/javascript" nonce="${sessionScope.cspNonce}" >
		var localMsg = localMsg || {};
		localMsg.exceptionText= "${exceptionText}";
		localMsg.secondsAgo="${secondsAgo}";
		localMsg.minuteAgo="${minuteAgo}";
		localMsg.minutesAgo="${minutesAgo}";
		localMsg.hourAgo="${hourAgo}";
		localMsg.hoursAgo="${hoursAgo}";
		localMsg.dayAgo="${dayAgo}";
		localMsg.daysAgo="${daysAgo}";
		localMsg.yes="${yes}";
		localMsg.no="${no}";
		localMsg.setHomePageSuccess="${setHomePageSuccess}";
		localMsg.setHomePageError="${setHomePageError}";
		localMsg.setHomePageDialogTitle="${setHomePageDialogTitle}";
		localMsg.setHomePageDialogText="${setHomePageDialogText}";
		localMsg.ok="${ok}";
		localMsg.pleaseNote="${pleaseNote}";
		if(!cv){
			var cv = cv || {};
			cv.additionalSettings = "${sessionScope.ADDITIONAL_SETTINGS}" === "" ? {} :JSON.parse("${sessionScope.ADDITIONAL_SETTINGS}".replace(/&#034;/g, '\"'));
			cv.userPref = "${sessionScope.userPreferences}" === "" ? {} :JSON.parse("${sessionScope.userPreferences}".replace(/&#034;/g, '\"'));
			cv.locale = "${loginContext.getLocaleEntity().getLocaleName()}";
			cv.loggedInUserSmtp = "${loginContext.getUserInfo().getSmtpAddress()}";
			cv.isAdmin = "${sessionScope.isAdminUser}" === "true";
			cv.contextPath= '${pageContext.request.contextPath}';
			cv.isDomainUser= "${sessionScope.IS_DOMAIN_USER}"==="true";
			cv.isTenantAdmin = "${sessionScope.IS_TENANT_ADMIN}"=== "true";
			cv.isMspUser = "${sessionScope.IS_MSP_USER}" === "true";
			cv.isMspAdmin = "${sessionScope.IS_MSP_Admin}" === "true";
			var isCustomStartupMessageEnabled = ${isCustomStartupMessageEnabled};

			if (isCustomStartupMessageEnabled && (!cvUtil.readCookie("showCustomStartupMessageAcknowledged"))&& cv.additionalSettings && cv.additionalSettings.Console) {
				cvUtil.showCustomStartupMessage(cv.additionalSettings.Console.CustomStartUpMessage);
			}
			var System = cv;
		}

		$(".dropdown").on("keypress click", ".languageList", function(event){
			var selected;
			if (event.target.tagName == "A"){
				selected = event.target.parentElement.id;
			}else{
				selected = event.target.id;
			}
		    var ca = document.cookie.split(';');
		    var localeCk = "";
		    for(var i=0; i<ca.length; i++) {
		        var c = ca[i];
		        c = $.trim(c);
		        if (c.indexOf("locale=") == 0)
		        	localeCk = c;
		    }
	    	var myDate = new Date() ;
	    	myDate.setMonth(myDate.getMonth() + 12);
	    	if( localeCk == "" || localeCk != "locale="+selected){
		    	document.cookie = "locale=" + selected + ";expires=" + myDate + ";path=/";
		    	document.cookie = "tempLocale=" + selected + ";max-age=1800;path=/";
		    	location.reload(true);
			}
		});

		try {
			cvUtil.DEFAULT_TIMEOUT = parseInt("${applicationScope.connectionTimeout}") * 60000;
		} catch(err) {
			console.log("Unable to fetch connection timeout, default to 1 minute.");
		}
	</script>