<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<c:if test="${param.bootstrapped == 'true'}">
	<jsp:include page="../common/footer-fullscreenV3.jsp" />
</c:if>

<c:if test="${param.bootstrapped == null}">
	</div>
	<!-- content div ends -->
		<ul class="footerLinks hideOnExportFriendly">
			<c:choose>
				<c:when test="${applicationScope.footerLinks != 'default' && fn:length(applicationScope.footerLinks) >= 0}">
					<c:forEach var="item" items="${applicationScope.footerLinks}">
						<c:if test="${item == 'WHATSNEW' && applicationScope.CUSTOM_WHATSNEW != ''}">
							<li><a href="${applicationScope.CUSTOM_WHATSNEW}" target="_new"><fmt:message key="Whats_new" /></a></li>
						</c:if>
						<c:if test="${item == 'CONTACTUS' && applicationScope.CUSTOM_CONTACTUS != ''}">
							<li><a href="${applicationScope.CUSTOM_CONTACTUS}"><fmt:message key="Contact_Title" /></a></li>
						</c:if>
						<c:if test="${item == 'LEGAL' && applicationScope.CUSTOM_LEGAL != ''}">
							<li><a href="${applicationScope.CUSTOM_LEGAL}" target="_blank"><fmt:message key="Legal" /></a></li>
						</c:if>
					</c:forEach>
				</c:when>
				<c:otherwise>
					<c:if test="${applicationScope.CUSTOM_WHATSNEW != ''}">
						<li><a href="${applicationScope.CUSTOM_WHATSNEW}" target="_new"><fmt:message key="Whats_new" /></a></li>
					</c:if>
					<c:if test="${applicationScope.CUSTOM_CONTACTUS != ''}">
						<li><a href="${applicationScope.CUSTOM_CONTACTUS}"><fmt:message key="Contact_Title" /></a></li>
					</c:if>
					<c:if test="${applicationScope.CUSTOM_LEGAL != ''}">
						<li><a href="${applicationScope.CUSTOM_LEGAL}" target="_blank"><fmt:message key="Legal" /></a></li>
					</c:if>
				</c:otherwise>
			</c:choose>
		</ul>
	</div>
	<!-- container div ends -->
	<div id="footer">
		<div class="hidden"><!-- hidden div for mustache templates -->
			<div id="notificationHistoryTemplate">
				<ul class="notifications">
					<li class="notificationHistoryHeader"><fmt:message key="common.label.nhHeader" /><span class="clearNotificationHistory"><fmt:message key="common.label.clearNotifications" /></span><span class="closeNotificationHistory close-button-x" title="<fmt:message key='common.action.close' />"></span></li>
					<!-- the "message" var must use triple braces so HTML is not escaped and we can put links/formatting in our notification history -->
					{{#notifications}}
					<li>
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" class="vw-notification-svg {{type}}"><path d="M8,0a8,8,0,1,0,8,8A8,8,0,0,0,8,0ZM9,12H7V10H9v2ZM9,9H7V3H9V9Z"></path></svg>
					<span class="{{type}} {{status}}">{{{message}}}</span>
					<span title="<fmt:message key='common.action.clear' />" class="removeNotification sprite icon-cancel" data-nid="{{timestamp}}"></span>
					<span class="notificationAge" >{{age}}</span></li>
					{{/notifications}}

					<!-- // close icon on bottom start // -->
					<li class="LI__last-row">
						<span class="arrow-open closeNotificationHistory cursor-pointer"
								title="<fmt:message key='common.action.close' />"
								class="closeNotificationHistory"></span>
					</li>
					<!-- // close icon on bottom end // -->

				</ul>
			</div>
		</div>
	</div>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/mustache.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}"  type="text/javascript">
	$(document).ready(
			function() {
				cvUtil.initializeNotifications();

				var val = 0, id;
				$("body").on("click", function(e) {
					dropDownShowing=false;
					currentShowing="";
					var ele = $(e.target);
					if ($("body").find(".settingsbox").length != 0) {
						$(".settingsbox").parent().hide();
					}
					$(".dropdown").hide();

				});

				var dropdownDivs = new Array();
				var dropdownDivsCount = 0;
				var dropDownShowing=false;
				var currentShowing = "";
				var currentShowingDataDiv="";
				var fromHover = false;

				/*
 				$(".totalHover").mouseenter(function(e){
					if(currentShowing == $('#dropDownArrowSpan').data("url") && dropDownShowing)
						return;
					$("#dropDownArrowSpan").trigger("click");
					fromHover=true;
				});


				$(".totalHover").mouseleave(function(e){
					if(fromHover){
						for(var i=0;i<dropdownDivsCount;i++){
							if (typeof dropdownDivs[i] != 'undefined' && dropdownDivs[i] != null){
								dropdownDivs[i].hide();
								dropDownShowing=false;
								if($(this).find("div").attr("div-url")!=null && $(this).find("div").attr("div-url").indexOf("getCurrentDownloads")>=0){
									$(this).find("div").remove();
									dropdownDivs[i]=null;
								}
							}
						}
						fromHover=false;
					}
				});
				 */
				$("body").on(
						"click",".dropdownOpener",
						function(e) {
							if($(e.target).parents(".settingsbox").length>0)
								return;
							var url = $(this).data("url");
							var trileft = $(this).data("left");
							var dropDownElement = $(this);
							var divToShow;

							for(var i=0;i<dropdownDivsCount;i++){
								if (typeof dropdownDivs[i] != 'undefined' && $(dropdownDivs[i]).attr("div-url") == url && $(this).attr("data-div")!=null && $(this).attr("data-div") == $(dropdownDivs[i]).attr("data-div") && url!="/server/getCurrentDownloads"){

									$(".dropdown").hide();
									if(dropDownShowing && currentShowing == url && $(this).attr("data-div") == $(dropdownDivs[i]).attr("data-div") && currentShowingDataDiv==$(this).attr("data-div")){
										e.stopPropagation();
										e.preventDefault();
										dropDownShowing=false;
										return;
									}

									dropDownShowing = true;
									currentShowing =url;
									dropdownDivs[i].show();
									e.stopPropagation();
									e.preventDefault();
									return;
								}
							}


							$(".dropdown").hide();

							if ($(this).hasClass("inlineDropdown")) {
								$(this).find(".dropdown").show();
							    // Prevent event from bubbling up to the body
							    // and re-triggering the event
                                e.stopPropagation();
                                return;
							}

							if (typeof url != 'undefined') {
								if (typeof divToShow == 'undefined') {
									id = val++;
									divToShow = $(this).find(".dropdown");
									divToShow.html("");
									divToShow.attr('data-div','dropdown'+id);
									$(this).attr('data-div','dropdown'+id);
								}
								else{
									divToShow = $('#'+divToShow);
									divToShow.show();
									e.preventDefault();
									return;
								}

								var urlToOpen = cvUtil.getContextPath() + url;
								if(url=="/common/apps.jsp"){
									divToShow.appendTo($(this).prev());
								}
								else
									divToShow.appendTo($(this));

								cvUtil.loadPage(urlToOpen, null, function(data) {
									if(typeof trileft == 'undefined'){
										//trileft = divToShow.parent().find("img, span.sprite").position().left;
										trileft = -divToShow.parent().width()/1.5;
									}
									if(trileft == -1){
										trileft = divToShow.parent().width()/2;
									}
									divToShow.html('<div class="triborder" style="left:'+ trileft + 'px;"><div class="triarea"></div></div>');
									divToShow.append(data);
									var top = 22;
									var left = -9;//do not change this - suraj
									var dropDownWidth = divToShow.width();
									if(dropDownWidth == 0){
										divToShow.find(".settingsbox").css("display", "inline-block");
										dropDownWidth = divToShow.find(".settingsbox").width();
									}
									if((divToShow.parent().offset().left+dropDownWidth > $("#container").width())){
										right = -10;
										if (url=="/server/getCurrentDownloads"){
											divToShow.find(".triborder").css('left',dropDownWidth-30);
										} else {
											divToShow.find(".triborder").css('left',dropDownWidth-25);
										}

										if(url.indexOf("timeRangeMenu.jsp" >= 0)){
											right = 0;
										}
										divToShow.css('right', right);
									}
									else{
										divToShow.css('left', left);
									}

									if (url=="/server/getCurrentDownloads"){
										top=17;
									}

									if(url=="/common/apps.jsp"){
										left= 0;
										top= 25;
										divToShow.css('left', left);
									}
									if(divToShow.parents("#browsetable").length > 0){
										top = "2px";
									}

									//30 to be on the safe side and for the paging info
									if($("#centercol").length !== 0 && (($("#centercol").height()-30-$(e.target).offset().top) < divToShow.outerHeight() || divToShow.hasClass("rePosition")) && url!="/server/getCurrentDownloads" && $('#header').has(dropDownElement).length == 0){
										divToShow.addClass("rePosition"); // this is not redundant, for the first if case.
										top = "auto";
										bottom = "25px";
										divToShow.css('bottom', bottom);
									}

									divToShow.css('top', top);

									divToShow.show();
									dropDownShowing=true;
									currentShowing=url;
									currentShowingDataDiv='dropdown'+id;
									e.stopPropagation();
								});


								divToShow.attr("div-url", url);
							} else {
								if (typeof divToShow == 'undefined') {
									return;
								}
								divToShow = $(divToShow);
								divToShow.addClass("dropdown");
							}

							dropdownDivs[dropdownDivsCount] = divToShow;
							dropdownDivsCount++;
							e.preventDefault();
						});

				$("body").on(
						"click","ul.settingsbox li",function(e){
							if($(this).attr("data-href")!=null){
								if($(this).attr("target")){
									window.open($(this).attr("data-href"), '_blank');
								}else{
									window.location=$(this).attr("data-href");
								}
							}

				});

				var curStr = $("#currentLanguage").html();
				cvUtil.loadPage(cvUtil.getContextPath() + "/getLocaleName.do?localeStr=" + curStr, null, function(data) {
					$("#currentLanguage").html(data);
				});

				var lastFooterLink = $($(".footerLinks li")[$(".footerLinks li").length-1]);
				if( typeof(lastFooterLink) != "undefinded" && lastFooterLink!=null){
					lastFooterLink.addClass("nobar");
				}
			});

</script>

<c:if test="${paramValues.js != null}">
	<c:forEach items="${paramValues.js}" var="jsFile">
		<c:if test="${!fn:startsWith(jsFile, pageContext.request.contextPath)}">
			<c:set var="jsFile" value="${pageContext.request.contextPath}${pageContext.request.servletPath}/../${jsFile}" />
		</c:if>
		<c:if test="${cv:isSafeInclude(fn:escapeXml(jsFile))}" >
		<script nonce="${sessionScope.cspNonce}" src="${fn:escapeXml(jsFile)}?${applicationScope.BUILD_TS}"></script>
		</c:if>
	</c:forEach>
</c:if>

<c:if test="${paramValues.jsp != null}">
	<c:forEach items="${paramValues.jsp}" var="jspFile">
		<c:if test="${!(fn:contains(jspFile, 'WEB-INF/') || fn:contains(jspFile, 'WEB-INF\\\\'))}">
			<jsp:include page="${jspFile}" flush="true" />
		</c:if>
	</c:forEach>
</c:if>

<c:choose>
	<c:when test="${sessionScope.SESSION_TIMEOUT != null}">
		<script nonce="${sessionScope.cspNonce}" >cvUtil.SESSION_TIMEOUT = ("${sessionScope.SESSION_TIMEOUT}" * 1000);</script>
	</c:when>
	<c:otherwise>
		<script nonce="${sessionScope.cspNonce}" >cvUtil.SESSION_TIMEOUT = cvUtil.DEFAULT_SESSION_TIMEOUT;</script>
	</c:otherwise>
</c:choose>

<c:if test="${param.intro != null && param.intro == 'true'}">
	<link rel="stylesheet" href="${pageContext.request.contextPath}/common/introjs/introjs.min.css?${applicationScope.BUILD_TS}" />
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/introjs/intro.min.js?${applicationScope.BUILD_TS}"></script>
</c:if>

<div class="overlay"></div> <!-- used to disable clicks in mhtml -->
<script nonce="${sessionScope.cspNonce}" >
$(document).ready(function() {
	window.allOnReadiesExecuted=true; //while exporting we need to know when the page has completed its execution
});

window.onbeforeunload = function(){
	localforage.setItem(nh.NOTIFICATIONS_COOKIE_NAME, JSON.stringify(nh.notificationItems[nh.NOTIFICATIONS_COOKIE_NAME]));
}
</script>
<script nonce="${sessionScope.cspNonce}">
	${cvConfig.getWebAnalyticsJsSnippet()}	
</script>
</body>

</html>

</c:if>