<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
	</div>
	</div>
<c:set var="browser" value="${header['User-Agent']}"/>

	<!-- content div ends -->
		<ul class="footerLinks hideOnExportFriendly vw-footer-links">
			<c:choose>
				<c:when test="${applicationScope.footerLinks != 'default' && fn:length(applicationScope.footerLinks) >= 0}">
					<c:forEach var="item" items="${applicationScope.footerLinks}">
						<c:if test="${item == 'WHATSNEW' && applicationScope.CUSTOM_WHATSNEW != ''}">
							<li><a href="${applicationScope.CUSTOM_WHATSNEW}" target="_new"><fmt:message key="Whats_new" /></a></li>
						</c:if>
						<c:if test="${item == 'CONTACTUS' && applicationScope.CUSTOM_CONTACTUS != ''}">
							<li><a href="${applicationScope.CUSTOM_CONTACTUS}"><fmt:message key="Contact_Title" /></a></li>
						</c:if>
						<c:if test="${item == 'LEGAL' && applicationScope.CUSTOM_LEGAL != ''}">
							<li><a href="${applicationScope.CUSTOM_LEGAL}" target="_blank"><fmt:message key="Legal" /></a></li>
						</c:if>
					</c:forEach>
				</c:when>
				<c:otherwise>
					<c:if test="${applicationScope.CUSTOM_WHATSNEW != ''}">
						<li><a href="${applicationScope.CUSTOM_WHATSNEW}" target="_new"><fmt:message key="Whats_new" /></a></li>
					</c:if>
					<c:if test="${applicationScope.CUSTOM_CONTACTUS != ''}">
						<li><a href="${applicationScope.CUSTOM_CONTACTUS}"><fmt:message key="Contact_Title" /></a></li>
					</c:if>
					<c:if test="${applicationScope.CUSTOM_LEGAL != ''}">
						<li><a href="${applicationScope.CUSTOM_LEGAL}" target="_blank"><fmt:message key="Legal" /></a></li>
					</c:if>
				</c:otherwise>
			</c:choose>
		</ul>
	</div>
	<!-- container div ends -->
	<div id="footer">
		<div class="hidden"><!-- hidden div for mustache templates -->
			<div id="notificationHistoryTemplate" class="vw-notification-template">
				<div class="notificationHistoryHeader vw-notifications-title"><fmt:message key="common.label.nhHeader" /><span class="clearNotificationHistory vw-clear-notification-history"><fmt:message key="common.label.clearNotifications" /></span><span class="closeNotificationHistory vw-close-notification-history" title="<fmt:message key='common.action.close' />"></span></div>
				<ul class="notifications vw-notifications-list">
					<!-- the "message" var must use triple braces so HTML is not escaped and we can put links/formatting in our notification history -->
					{{#notifications}}
					<li class="notificationRow" id="{{id}}">

						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" class="vw-notification-svg {{type}}"><path d="M8,0a8,8,0,1,0,8,8A8,8,0,0,0,8,0ZM9,12H7V10H9v2ZM9,9H7V3H9V9Z"></path></svg>
						<span class="{{type}} {{status}}">{{{message}}}</span>
						<span title="<fmt:message key='common.action.clear' />" class="removeNotification sprite icon-cancel vw-remove-note" data-nid="{{timestamp}}"></span>
						<span id="{{id}}" class="notificationAge vw-note-age">{{age}}</span>
					</li>
					{{/notifications}}

					<!-- // close icon on bottom start // -->
					<li class="LI__last-row">
						<span class="arrow-open closeNotificationHistory cursor-pointer"
								title="<fmt:message key='common.action.close' />"
								class="closeNotificationHistory"></span>
					</li>
					<!-- // close icon on bottom end // -->

				</ul>
			</div>
		</div>
	</div>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/bootstrap/javascripts/bootstrap.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}"  type="text/javascript">
	$(document).ready(
			function() {
				cvUtil.initializeNotifications();

				var val = 0, id;
				$("body").on("click", function(e) {
					dropDownShowing=false;
					currentShowing="";
					var ele = $(e.target);
					if ($("body").find(".settingsbox").length != 0) {
						$(".settingsbox").parent().hide();
					}
					$(".vw-drop-down").hide().parent().attr("aria-expanded","false");

				});

				var dropdownDivs = new Array();
				var dropdownDivsCount = 0;
				var dropDownShowing=false;
				var currentShowing = "";
				var currentShowingDataDiv="";
				var fromHover = false;

				/*
 				$(".totalHover").mouseenter(function(e){
					if(currentShowing == $('#dropDownArrowSpan').data("url") && dropDownShowing)
						return;
					$("#dropDownArrowSpan").trigger("click");
					fromHover=true;
				});


				$(".totalHover").mouseleave(function(e){
					if(fromHover){
						for(var i=0;i<dropdownDivsCount;i++){
							if (typeof dropdownDivs[i] != 'undefined' && dropdownDivs[i] != null){
								dropdownDivs[i].hide();
								dropDownShowing=false;
								if($(this).find("div").attr("div-url")!=null && $(this).find("div").attr("div-url").indexOf("getCurrentDownloads")>=0){
									$(this).find("div").remove();
									dropdownDivs[i]=null;
								}
							}
						}
						fromHover=false;
					}
				});
				 */
				$("body").on(
						"click keydown",".vw-drop-down-toggle",
						function(e) {
							if (e.which == 13 || e.which == 32 || e.type == "click") {// on space, enter or click
								if($(e.target).parents(".vw-dropdown-menu").length>0)
									return;
								var url = $(this).data("url");
								var trileft = $(this).data("left");
								var dropDownElement = $(this);
								var divToShow;

								for(var i=0;i<dropdownDivsCount;i++){
									if (typeof dropdownDivs[i] != 'undefined' && $(dropdownDivs[i]).attr("div-url") == url && $(this).attr("data-div")!=null && $(this).attr("data-div") == $(dropdownDivs[i]).attr("data-div") && url!="/server/getCurrentDownloads"){
										$(".open .vw-drop-down-toggle + .vw-dropdown-menu").prev().dropdown('toggle'); // Bootstrap dropdowns only
										$(".vw-drop-down").hide().parent().attr("aria-expanded","false");
										if(dropDownShowing && currentShowing == url && $(this).attr("data-div") == $(dropdownDivs[i]).attr("data-div") && currentShowingDataDiv==$(this).attr("data-div")){
											e.stopPropagation();
											e.preventDefault();
											dropDownShowing=false;
											return;
										}

										dropDownShowing = true;
										currentShowing =url;
										$(this).attr("aria-expanded","true");
										dropdownDivs[i].show();
										e.stopPropagation();
										e.preventDefault();
										return;
									}
								}

								$(".vw-drop-down").hide().parent().attr("aria-expanded","false");

								if ($(this).hasClass("inlineDropdown")) {
									$(this).attr("aria-expanded","true").find(".vw-drop-down").show();
								    // Prevent event from bubbling up to the body
								    // and re-triggering the event
	                                e.stopPropagation();
	                                return;
								}

								if (typeof url != 'undefined') {
									if (typeof divToShow == 'undefined') {
										id = val++;
										divToShow = $(this).find(".vw-drop-down");
										divToShow.html("");
										divToShow.attr('data-div','dropdown'+id);
										$(this).attr({
											'data-div': 'dropdown'+id,
											'aria-expanded': 'true'
										});
									}
									else{
										divToShow = $('#'+divToShow);
										$(this).attr("aria-expanded","true");
										divToShow.show();
										e.preventDefault();
										return;
									}

									var urlToOpen = cvUtil.getContextPath() + url;
									if(url=="/common/apps.jsp"){
										divToShow.appendTo($(this).prev());
									}
									else
										divToShow.appendTo($(this));

									cvUtil.loadPage(urlToOpen, null, function(data) {
										if(typeof trileft == 'undefined'){
											// trileft = divToShow.parent().find("img, span.sprite").position().left;		// original value
											trileft = -divToShow.parent().width()/1.5;
										}
										if(trileft == -1){
											trileft = divToShow.parent().width()/2;
										}
										divToShow.html('<div class="triborder vw-triangle-border" style="right: 5px;"><div class="triarea vw-triangle-innards"></div></div>');
										divToShow.append(data);
										var top = 22;
										var left = -9;//do not change this - suraj
										var dropDownWidth = divToShow.width();
										if(dropDownWidth == 0){
											divToShow.find(".vw-dropdown-menu").css("display", "inline-block");
											dropDownWidth = divToShow.find(".vw-dropdown-menu").width();
										}
										if((divToShow.parent().offset().left+dropDownWidth > $("#container").width())){
											right = -10;
											if (url=="/server/getCurrentDownloads"){
												divToShow.find(".vw-triangle-border").css('left',dropDownWidth-30);
											}
											//else {
												//divToShow.find(".vw-triangle-border").css('left',dropDownWidth-25);
												//console.log("inside1"); //
											//}

											if(url.indexOf("timeRangeMenu.jsp" >= 0)){
												right = 0;
											}
											divToShow.css('right', right);
										}
										else{
											// divToShow.css('left', left); 	original value
											divToShow.css('right', '0');
										}

										if (url=="/server/getCurrentDownloads"){
											top=17;
										}

										if(url=="/common/apps.jsp"){
											left= 0;
											top= 25;
											divToShow.css('left', left);
										}
										if(divToShow.parents("#browsetable").length > 0){
											top = "2px";
										}

										//30 to be on the safe side and for the paging info
										if($("#centercol").length !== 0 && (($("#centercol").height()-30-$(e.target).offset().top) < divToShow.outerHeight() || divToShow.hasClass("rePosition")) && url!="/server/getCurrentDownloads" && $('#header').has(dropDownElement).length == 0){
											divToShow.addClass("rePosition"); // this is not redundant, for the first if case.
											top = "auto";
											bottom = "25px";
											divToShow.css('bottom', bottom);
										}

										divToShow.css('top', top);
										$(this).attr("aria-expanded","true");
										divToShow.show();
										dropDownShowing=true;
										currentShowing=url;
										currentShowingDataDiv='dropdown'+id;
										e.stopPropagation();
									});


									divToShow.attr("div-url", url);
								} else {
									if (typeof divToShow == 'undefined') {
										$(this).find(".vw-triangle-border").show().siblings(".vw-dropdown-menu").css("display", "inline-block");
										return;
									}
									divToShow = $(divToShow);
									divToShow.addClass("dropdown");
								}

								dropdownDivs[dropdownDivsCount] = divToShow;
								dropdownDivsCount++;
								e.preventDefault();
							}

							});

				$("body").on(
						"click keypress","ul.vw-dropdown-menu li",function(e){
							if($(this).attr("data-href")!=null){
								if($(this).attr("target")){
									window.open($(this).attr("data-href"), '_blank');
								}else{
									window.location=$(this).attr("data-href");
								}
							}

				});

				$('.vw-contains-drop-down').on('show.bs.dropdown', function () { // when bootstrap dropdowns are shown, hide other dropdowns
					$(".vw-dropdown-menu").parent(".vw-drop-down").hide();
					dropDownShowing = false;
				})

				var curStr = $("#currentLanguage").html();
				cvUtil.loadPage(cvUtil.getContextPath() + "/getLocaleName.do?localeStr=" + curStr, null, function(data) {
					$("#currentLanguage").html(data);
				});

				var lastFooterLink = $($(".footerLinks li")[$(".footerLinks li").length-1]);
				if( typeof(lastFooterLink) != "undefinded" && lastFooterLink!=null){
					lastFooterLink.addClass("nobar");
				}
			});

</script>

<c:if test="${paramValues.js != null}">
	<c:forEach items="${paramValues.js}" var="jsFile">
		<c:if test="${!fn:startsWith(jsFile, pageContext.request.contextPath)}">
			<c:set var="jsFile" value="${pageContext.request.contextPath}${pageContext.request.servletPath}/../${jsFile}" />
		</c:if>
		<c:if test="${cv:isSafeInclude(fn:escapeXml(jsFile))}" >
			<script nonce="${sessionScope.cspNonce}" src="${fn:escapeXml(jsFile)}?${applicationScope.BUILD_TS}"></script>
		</c:if>
	</c:forEach>
</c:if>

<c:if test="${paramValues.jsp != null}">
	<c:forEach items="${paramValues.jsp}" var="jspFile">
		<c:if test="${!(fn:contains(jspFile, 'WEB-INF/') || fn:contains(jspFile, 'WEB-INF\\\\'))}">
			<jsp:include page="${jspFile}" flush="true" />
		</c:if>
	</c:forEach>
</c:if>

<c:choose>
	<c:when test="${sessionScope.SESSION_TIMEOUT != null}">
		<script nonce="${sessionScope.cspNonce}" >cvUtil.SESSION_TIMEOUT = ("${sessionScope.SESSION_TIMEOUT}" * 1000);</script>
	</c:when>
	<c:otherwise>
		<script nonce="${sessionScope.cspNonce}" >cvUtil.SESSION_TIMEOUT = cvUtil.DEFAULT_SESSION_TIMEOUT;</script>
	</c:otherwise>
</c:choose>

<div class="modal fade hideOnExportFriendly hidden-print vw-hidden-export" id="shareNotificationDetails" style="overflow:none" role="dialog">
    <div class="modal-dialog">

      <!-- Modal content-->
      <div class="modal-content" style="max-width:400px;">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Notification Summary</h4>
        </div>
        <div id="shareNotificationBody" class="modal-body">
        	<span><a class="vw-share-summary-title" id="shareNameSummary"></a><span  style="padding-left: 4px;font-size:16px" id="shareActivityType"></span></span>
        </div>
        <div class="modal-footer">
          <button type="button" class="vw-btn vw-btn-default" data-dismiss="modal">Cancel</button>
        </div>
      </div>

    </div>
 </div>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="share.label.upload" var="uploadFilesNotification"/>
	<fmt:message key="share.label.createFolder" var="createFoldersNotification"/>
	<fmt:message key="share.label.deletedFiles" var="deletedFilesNotification"/>
	<fmt:message key="share.label.deletedFolders" var="deletedFoldersNotification"/>
	<fmt:message key="share.label.deletedShares" var="deletedSharesNotification"/>
	<fmt:message key="share.label.deletedShareFolders" var="deletedShareFoldersNotification"/>
	<fmt:message key="share.label.downloadedFiles" var="downloadedFilesNotification"/>
	<fmt:message key="share.label.downloadedFolders" var="downloadedFoldersNotification"/>
	<fmt:message key="share.label.movedFiles" var="movedFilesNotification"/>
	<fmt:message key="share.label.movedFolders" var="movedFoldersNotification"/>
	<fmt:message key="share.label.renamedFiles" var="renamedFilesNotification"/>
	<fmt:message key="share.label.renamedFolders" var="renamedFoldersNotification"/>
	<fmt:message key="share.label.sharedFiles" var="sharedFileNotification"/>
	<fmt:message key="share.label.sharedFolders" var="sharedFoldersNotification"/>
	<fmt:message key="share.label.updatedShareFiles" var="updatedShareFilesNotification"/>
	<fmt:message key="share.label.updatedShareFolders" var="updatedShareFoldersNotification"/>
</fmt:bundle>


<c:if test="${param.intro != null && param.intro == 'true'}">
	<link rel="stylesheet" href="${pageContext.request.contextPath}/common/introjs/introjs.min.css?${applicationScope.BUILD_TS}" />
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/introjs/intro.min.js?${applicationScope.BUILD_TS}"></script>
</c:if>
<cv:evaluate test="user is logged in" >
	<c:if test="${browser != 'Simpana PhantomJS' and sessionScope.isSoftwareStoreOpenAccess != true}">
		<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/thirdParty/atmosphere/atmosphere.min.js?${applicationScope.BUILD_TS}"></script>
		<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/push.js?"${applicationScope.BUILD_TS}></script>
	</c:if>
</cv:evaluate>
<div class="overlay"></div> <!-- used to disable clicks in mhtml -->
<script nonce="${sessionScope.cspNonce}" >
var localMsg = localMsg || {};
localMsg.uploadFilesNotification = "${uploadFilesNotification}";
localMsg.createFoldersNotification = "${createFoldersNotification}";
localMsg.deletedFilesNotification = "${deletedFilesNotification}";
localMsg.deletedFoldersNotification = "${deletedFoldersNotification}";
localMsg.deletedSharesNotification = "${deletedSharesNotification}";
localMsg.deletedShareFoldersNotification = "${deletedShareFoldersNotification}";
localMsg.downloadedFilesNotification = "${downloadedFilesNotification}";
localMsg.downloadedFoldersNotification = "${downloadedFoldersNotification}";
localMsg.movedFilesNotification = "${movedFilesNotification}";
localMsg.movedFoldersNotification = "${movedFoldersNotification}";
localMsg.renamedFilesNotification = "${renamedFilesNotification}";
localMsg.renamedFoldersNotification = "${renamedFoldersNotification}";
localMsg.sharedFilesNotification = "${sharedFoldersNotification}";
localMsg.sharedFoldersNotification = "${sharedFoldersNotification}";
localMsg.updatedShareFilesNotification = "${updatedShareFilesNotification}";
localMsg.updatedShareFoldersNotification = "${updatedShareFoldersNotification}";
var isPhantomJs = "${browser}" === "Simpana PhantomJS";
$(document).ready(function() {
	window.allOnReadiesExecuted=true; //while exporting we need to know when the page has completed its execution
});

function __shareNotificationToastCallback(data) {
	return function onShowDetailsClick() {
		switch (data.shareData.activityType) {
        case 'CreateFile':
            message = localMsg.uploadFilesNotification;
            break;
        case 'CreateFolder':
            message = localMsg.createFoldersNotification;
            break;
        case 'DeleteFile':
            message = localMsg.deletedFilesNotification;
            break;
        case 'DeleteFolder':
            message = localMsg.deletedFoldersNotification;
            break;
        case 'DeleteShareFile':
            message = localMsg.deletedSharesNotification;
            break;
        case 'DeleteShareFolder':
            message = localMsg.deletedShareFoldersNotification;
            break;
        case 'DownloadFile':
            message = localMsg.downloadedFilesNotification;
            break;
        case 'DownloadFolder':
            message = localMsg.downloadedFoldersNotification;
            break;
        case 'MoveFile':
            message = localMsg.movedFilesNotification;
            break;
        case 'MoveFolder':
            message = localMsg.movedFoldersNotification;
            break;
        case 'None':
            break;
        case 'RenameFile':
            message = localMsg.renamedFilesNotification;
            break;
        case 'RenameFolder':
            message = localMsg.renamedFoldersNotification;
            break;
        case 'ShareFile':
            message = localMsg.sharedFilesNotification;
            break;
        case 'ShareFolder':
            message = localMsg.sharedFoldersNotification;
            break;
        case 'UpdateShareFile':
            message = localMsg.updatedShareFilesNotification;
            break;
        case 'UpdateShareFolder':
            message = localMsg.updatedShareFoldersNotification;
            break;
        default:
            break;
        }
		var items = [];
		for(var i in data.shareData.activities) {
			var folderSvg = '<svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><polygon fill="#80a8c6" points="15.23 6.9 15.23 5.04 2.84 5.04 2.84 6.9 2.84 8.76 15.23 8.76 29.16 8.76 29.16 6.9 15.23 6.9"/><path fill="#4b708f" d="M15.23,5V6.9H29.16V8.76H2.84V5H15.23m1.32-1.32h-15v6.36H30.47V5.58H16.55V3.72Z"/><rect fill="#fff" x="2.84" y="10.08" width="26.31" height="16.88"/><path fill="#4b708f" d="M29.16,10.08V27H2.84V10.08H29.16m1.32-1.32H1.53V28.28H30.47V8.76Z"/></svg>';
			var fileSvg = '<svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" fill="#498bf4"><path d="M21,1.16H6.28A1.73,1.73,0,0,0,4.55,2.89V29.11a1.73,1.73,0,0,0,1.73,1.73h21.4a1.73,1.73,0,0,0,1.73-1.73V9Zm3,22.95H10.38a1.5,1.5,0,0,1,0-3H24a1.5,1.5,0,0,1,0,3Zm0-8H10.38a1.5,1.5,0,0,1,0-3H24a1.5,1.5,0,0,1,0,3Z"/></svg>';
			var temp = data.shareData.activityType ? (data.shareData.activityType.indexOf("Folder") !== -1 ? folderSvg : fileSvg) : fileSvg;
			var userName = data.shareData.activities[i].userDisplayName ?  data.shareData.activities[i].userDisplayName: data.shareData.activities[i].userName
			var shareBody = '<a href="#" class="list-group-item vw-share-summary">' + temp  +
			 '<span class="list-group-item-heading vw-share-summary-text" title="'+data.shareData.activities[i].fileName+'">'+data.shareData.activities[i].fileName
			+ '</span><p class="list-group-item-text vw-share-summary-username"> by '+userName +' </p>'+
			'<p class="list-group-item-text">'+ cvUtil.convertUnixTimeStampToDate(new Date(parseInt(data.shareData.activities[i].created) * 1000)) +'</p></a>';
			items.push(shareBody);
		}
		 $('.vw-share-summary').remove();
	     $('#shareNotificationBody').append(items.join(""));
	     $('#shareNameSummary').html(data.shareData.shareName ? data.shareData.shareName: '');
	     $('#shareNameSummary').attr('href', data.shareData.browseUrl? data.shareData.browseUrl: '#');
	     $('#shareActivityType').text('('+ message +')');
		 $("#shareNotificationDetails").modal();
	}
}

function notificationMessageTransform(data, browseUrl) {
	switch(data.shareData.activityType) {
	case 'ShareFile':
    case 'ShareFolder':
    case 'UpdateShareFile':
    case 'UpdateShareFolder':
    case 'DeleteShareFile':
    case 'DeleteShareFolder':
    	message = data.messageStr.replace(data.shareData.shareName, '<a style="color: white" href="'+ browseUrl+ '">' + data.shareData.shareName +'</a>');
         return message;
    default:
    	message = data.messageStr.replace(new RegExp(data.shareData.shareName + '.$'), '<a style="color: white" href="'+ browseUrl+ '">' + data.shareData.shareName +'</a>');;
        	}
	return message;
}

$("document").ready(function(){
	if(!isPhantomJs &&  typeof pushService !== "undefined"){
		pushService.subscribe({
			'msg' : 'subscribe',
			'type' : 'EDGE_DRIVE'
		}, function(data) {
			if(typeof data.shareData!== "undefined"){
			if(cvUtil.CONTEXT_PATH === '/vaultcxWeb'){
				if(data.shareData){
					var browseUrl = data.shareData.browseUrl ? data.shareData.browseUrl.replace("webconsole", "vaultcxWeb") : "";
					var fileNameReplaced = notificationMessageTransform(data, browseUrl);
					var isSummary = data.notificationOption === "SendSummary" ? '<a style="color:white" href="#" id="showDetailsNotification"> Show details</a>' : '';
					cvUtil.toast(fileNameReplaced + isSummary, null, null, null, data);
				}
			}else{
				var browseUrl = data.shareData.browseUrl;
				var fileNameReplaced = notificationMessageTransform(data, browseUrl);
				var isSummary = data.notificationOption === "SendSummary" ? '<a style="color:white" href="#" id="showDetailsNotification"> Show details</a>' : '';
				cvUtil.toast(fileNameReplaced + isSummary, null, null, null, data);
			}
			var message = "";
			if(data.shareData){
				var shareNotificationCallback = __shareNotificationToastCallback(data);
				$('#showDetailsNotification').on('click',shareNotificationCallback);
				}
			}

		}, function(data) {
			console.log("Something went wrong")
		});
	}
});



window.onbeforeunload = function(){
	if(!isPhantomJs && typeof pushService !== "undefined"){
		pushService.unsubscribe({
			'msg' : 'unsubscribe',
			'type' : 'EDGE_DRIVE'
		}, function(data) {
		}, function(data) {
			console.log("Something went wrong")
		});
	}
	localforage.setItem(nh.NOTIFICATIONS_COOKIE_NAME, JSON.stringify(nh.notificationItems[nh.NOTIFICATIONS_COOKIE_NAME]));
}
</script>
<script nonce="${sessionScope.cspNonce}">
	${cvConfig.getWebAnalyticsJsSnippet()}
</script>

</body>

</html>
