<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>

<fmt:bundle basename="localization.BackupBrowseMessages">
	<fmt:message key="backupBrowse.label.noPreviewAvailable"  var="noPreviewAvailable" />
	<fmt:message key="backupBrowse.action.download" var="downloadLabel" />
	<fmt:message key="backupBrowse.label.filename" var="filenameLabel" />
</fmt:bundle>

<html>
<head>
<jsp:include page="/common/search-engine.jsp" />
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta name="description" content="" />
<meta name="author" content="CommVault">

<c:set var="escapedFileName" value="${param.n}" />
<c:set var="escapedType" value="${param.t}" />
<enhance:out escapeXml="false">
	<c:set var="escapedUrl" value="${requestScope.url}" />
	<c:set var="escapedDownloadUrl" value="${requestScope.dUrl}" />
</enhance:out>

<title>${escapedFileName}</title>
<link rel="shortcut icon" href="${pageContext.request.contextPath}/${applicationScope.OEM_PATH}/favicon.png" />

<style>
body {
	margin: 0;
	background: #3B3B3B;
}

iframe {
	display: block;
	background: #fff;
	border: none;
	height: 100%;
	width: 100%;
}

#previewButtonHolder a.downloadBtn {
	line-height: 18px;
	padding: 5px 10px;
	text-decoration: none;
	font-weight: normal;
	background: #498bf4;
	color: #FFFFFF;
	border: 0px;
	font-family: Helvetica, Arial, sans-serif;;
	font-size: 16px;
}

.previewFileDetails {
	position: fixed;
	bottom: 0;
	width: 100%;
	z-index: 11111;
	/*     min-height: 48px; */
	background: rgba(39, 39, 39, .9);
}

.previewDetailsContent {
	display: inline-block;
	margin: 10px 130px 10px 0;
	min-height: 29px;
}

.previewFileDetails .fileName {
	color: #fff;
}

.previewFileDetails p .fileLabel {
	color: #aaa;
	font-size: 0.9em;
	padding: 0 5px 0 0;
}

.previewDetailsContent p {
	line-height: 18px;
	font-family: Helvetica, Arial, sans-serif;
	margin: 0;
	padding: 5px;
	font-size: 0.875em;
	color: #eee;
	padding: 5px;
	display: inline-block;
}

#previewButtonHolder {
	position: absolute;
	right: 10px;
	bottom: 14px;
}

#imgTag, #audioTag, #videoTag {
	margin: 0 auto;
	max-width: 100%;
	max-height: 100%;
	display: block;
}

#imgTag {
	background: url("img/transparent_bg.png") repeat 0 0;
}

.tagContainer {
	display: table-cell;
	vertical-align: middle;
	height: 100vh;
	width: 100vw;
}

.hideButton {
	position: absolute;
    top: -15px;
    background: rgba(39, 39, 39, .9);
    cursor: pointer;
    right: 50%;
    padding: 3px 30px 0;
    color: #aaa;
    border-radius: 15px 15px 0 0;
    font-size: .7em;
    box-sizing: border-box;
    height: 15px;
    margin-right: -32px;
}

.noImagePreview #downloadButtonSpan .dwnImg {
	padding: 20px 10px;
	display: block;
	cursor: pointer;
	color: #498bf4;
	background: url("img/downloadFromPreview.png") no-repeat center center;
	width: 98px;
	height: 98px;
	text-align: center;
	margin: 0 auto;
}

.noPreview {
	font-size: 2em;
	color: #aaa;
	font-weight: lighter;
	font-family: Helvetica;
	position: absolute;
	top: 50%;
	margin-top: -111px;
	margin-left: -156px;
	left: 50%;
}

.noImagePreview {
	height: 100%;
	width: 100%;
}

.noImagePreview #downloadButtonSpan .dwnBtn {
	padding: 10px 20px;
	margin-top: 5px;
	color: #498bf4;
	display: inline-block;
	border: 1px solid;
	font-size: 0.5em;
	cursor: pointer;
}

.noImagePreview .previewWrap {
	overflow: hidden;
	text-align: center;
	height: 100%;
	width: 100%;
	margin: auto;
	background-color: #fff;
}

</style>
</head>
<body>
	<c:choose>
		<c:when test='${(escapedType == "1")}'>
			<div class="tagContainer">
				<audio id='audioTag' src='${escapedDownloadUrl}' onError='showOnError()' controls autoplay></audio>
			</div>
		</c:when>
		<c:when test='${(escapedType == "2")}'>
			<div class="tagContainer">
				<video src="${escapedDownloadUrl}" id='videoTag' onError='showOnError()' controls autoplay></video>
			</div>
		</c:when>
		<c:when test='${(escapedType == "3")}'>
			<div class="tagContainer">
				<img src="${escapedUrl}" id='imgTag' onError='showOnError()'>
			</div>
		</c:when>
		<c:otherwise>
			<div class="iFrameContainer">
				<iframe src="${escapedUrl}" ></iframe>
			</div>
		</c:otherwise>
	</c:choose>

	<div class="previewFileDetails">
		<div>
			<span class="hideButton" onClick="showHide();">&#9660</span>
		</div>
		<div class="previewDetailsContent">
			<c:if test='${(not empty n)}'>
				<p>
					<span class="fileLabel">${filenameLabel}</span><span class="fileName">${escapedFileName}</span>
				</p>
			</c:if>
		</div>
		<div id="previewButtonHolder">
			<a class="downloadBtn" href="${escapedDownloadUrl}">${downloadLabel}</a>
		</div>
	</div>
</body>

<script nonce="${sessionScope.cspNonce}" >
	var localMsg = localMsg || {};
	localMsg.noPreviewAvailable = "${noPreviewAvailable}";
	localMsg.downloadLabel = "${downloadLabel}";

	function isHidden(el) {
		var style = window.getComputedStyle(el);
		return (style.display === 'none')
	}

	function showHide() {
		if (isHidden(document.getElementById("previewButtonHolder"))) {
			document.getElementById('previewButtonHolder').style.display = 'inline-block';
			document.getElementsByClassName('previewDetailsContent')[0].style.display = 'inline-block';
			document.getElementsByClassName('hideButton')[0].innerHTML = '&#9660';

		} else {
			document.getElementById('previewButtonHolder').style.display = 'none';
			document.getElementsByClassName('previewDetailsContent')[0].style.display = 'none';
			document.getElementsByClassName('hideButton')[0].innerHTML = '&#9650';
		}
	}

	function showOnError() {
		var html = '<div class="noImagePreview"><div class="previewWrap"><div class="noPreview">' + localMsg.noPreviewAvailable + '<br>'
				+ '<div id="downloadButtonSpan" title="Download" class="">'
				+ '<a href="' + "${escapedDownloadUrl}" + '"><span class="dwnImg"></span></a>'
				+ '<a href="' + "${escapedDownloadUrl}" + '"><span class="dwnBtn">' + localMsg.downloadLabel + '</span></a>'
				+ '</div></div></div></div>';

		var container = null;
		if ( document.getElementsByClassName("tagContainer").length > 0){
			container = document.getElementsByClassName("tagContainer")[0];
		} else {
			container = document.getElementsByClassName("iFrameContainer")[0];
		}
		container.innerHTML = html;
	}
</script>

</html>