<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	
<jsp:include page="../common/header.jsp">
	<jsp:param value="../common/css/templatestyles.css" name="css"/>
	<jsp:param value="../login/css/login.css" name="css"/>
	<jsp:param value="common.action.download" name="title" />
	<jsp:param value="true" name="showOnlyHelp" />
</jsp:include>
 
<fmt:bundle basename="localization.BackupBrowseMessages">
	

<style>
#downloadText{
	padding-bottom:10px;
	padding-left:2px;
}
#content #submitBtn{
	padding: 6px 20px;
	float: left;
	margin-top: 20px;
}
</style>

 
<div id="loginform">
	<p class="logintitle"><fmt:message key="share.download.downloadSharedFilesFolders" />
		 
	</p>
	<div class="loginMsg">${requestScope.error}&nbsp;</div>
   	<div id="contactFrm">
		<div id="downloadText"><fmt:message key="share.label.downloadSubmitted" /></div>
		
		<fmt:bundle basename="localization.messages">
		<input type="submit" id="submitBtn" class="mainBtn" name="submit" value='<fmt:message key="common.action.download" />' />
		</fmt:bundle>	
	</div>			
</div>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="../common/js/encoder.js" name="js"/>
</jsp:include>
<script nonce="${sessionScope.cspNonce}" >
var SHARE_FILES_DOWNLOAD_API = "/server/doDownloadSharedFile";
var PARAM_AUTH_TOKEN = "authToken";
var PARAM_USER_TOKEN = "userToken";

$("#submitBtn").on("click", function(){
	$(this).addClass("disabledActions").addClass("loading");
	var shareUrl =  SHARE_FILES_DOWNLOAD_API;

	// Prepare data parameter object:
	 var params = [];
     params.push(cvUtil.createParamString(PARAM_AUTH_TOKEN, cvUtil.getParameterByName("id")));
     params.push(cvUtil.createParamString(PARAM_USER_TOKEN, cvUtil.getParameterByName("authCode")));
     
	
	// Send request:
	//Using a cookie here to track when the download completes. When the cookie is recieved, download completes.
	// Is a smart hack to detect download complete. Needs to be thoroughly tested.
	console.debug("Posting ajax request to download shared files");
	downloadCompleteHandler(cvUtil.createUrlWithParams(shareUrl, params), 0);
	fileDownloadCheckTimer = window.setInterval(function () {
	    var cookieValue = $.cookie(cvUtil.getParameterByName("id"));
	    if (cookieValue == cvUtil.getParameterByName("id"))
	     finishDownload();
	  }, 1000);
});

/*
 * COOKIE is used here to detect download complete. Cookie is set in the download header response, and is removed here if it is detected. 
 * If detected, it means download complete!
 */
function finishDownload() {
	 window.clearInterval(fileDownloadCheckTimer);
	 $.removeCookie(cvUtil.getParameterByName("id"), {path:'/'}); //clears this cookie value
		$("#submitBtn").removeClass("disabledActions").removeClass("loading");
}


$("#submitBtn").click();
</script>
</fmt:bundle>