<%-- This jsp can be used where a dropdown of user suggestions is needed
 	Restriction:The selectized field needs to have a enclosing div with id 'divForSelectize'--%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<fmt:bundle basename="localization.BackupBrowseMessages">
<fmt:message key="sharing.error.text7" var="errorText7" />
<fmt:message key="share.label.add" var="add" />
<script nonce="${sessionScope.cspNonce}" >
	var fieldIdToSelectize = "${fn:escapeXml(param.fieldIdToSelectize)}";
	if (fieldIdToSelectize.trim()=="")
	{
		//if field id is not given.. assume the field to be selectedUsers
		fieldIdToSelectize = "selectedUsers";
	}
	fieldIdToSelectize = "#"+fieldIdToSelectize;
	var isUserEmailAllowed = ("${fn:escapeXml(param.isUserEmailAllowed)}" == "true");
	var msg = {};
	msg.emailFormatError = '${fn:escapeXml(errorText7)}';
	var addString = '${add}';
	var callbackAfterAdd= "${fn:escapeXml(param.callbackAfterAdd)}";//this function(if configured) will be called each time an item is added or removed from the selected users
	var callbackConfigured = false;
	if (!callbackAfterAdd.trim()=="") callbackConfigured = true;
</script>
<style>
	.selectize-input{
		height:${fn:escapeXml(param.selectizeHeight)};
		max-height:${fn:escapeXml(param.selectizeMaxHeight)};
		width:${fn:escapeXml(param.selectizeWidth)};
	}
</style>
<link rel="stylesheet" href="../common/css/cvUserSuggest.css"/>
<script nonce="${sessionScope.cspNonce}" src="../common/thirdParty/selectize/js/standalone/selectize.js" type="text/javascript"></script>
<script nonce="${sessionScope.cspNonce}" src="../common/js/cvUserSuggest.js?${applicationScope.BUILD_TS}" type="text/javascript"></script>
</fmt:bundle>
