<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib prefix="f" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>

<link rel="stylesheet" href="${pageContext.request.contextPath}/browse/css/dataPane.css?${applicationScope.BUILD_TS}" />
<c:set var="eSourcePage" value="${fn:escapeXml(param.sourcePage)}" />
<c:set var="ebreadCrumbValues" value="${fn:escapeXml(param.breadCrumbValues)}" />
	<enhance:out escapeXml="false">
    <c:set var="eheaderTitle" value="${param.headerTitle}" />
    </enhance:out>
<c:set var="esearchContext" value="${fn:escapeXml(param.searchContext)}" />
<c:set var="ehideSearchBox" value="${fn:escapeXml(param.hideSearchBox)}" />
<c:set var="esecHeadertopRightButtonHolder" value="${fn:escapeXml(param.secHeadertopRightButtonHolder)}" />

<div class="sechead dynamicDropDown vw-row">
	<c:if test="${ebreadCrumbValues != null && ebreadCrumbValues != ''}">
		<ul id='breadcrumbMain' class='breadcrumbMain col-sm-12 small vw-breadcrumbs' >
			<!-- <li class='smartlinkMain withSeparatorMain vw-breadcrumb-with-separator'><a class='smartLinkMain'  href='${pageContext.request.contextPath}/applications'><f:message key="My_Apps_Header" /></a></li> -->
				<c:set var="str" value='${ebreadCrumbValues}'/>
					<c:forEach var="item" items="${fn:split(str, ',')}" varStatus = "loop">
						<c:set var="itemSubs" value="${fn:split(item, ':')}" />
						<li class='smartlinkMain withSeparatorMain vw-breadcrumb-with-separator'><a class='smartLinkMain'  href='../${itemSubs[1]}'>${itemSubs[0]}</a><svg xmlns="http://www.w3.org/2000/svg" width="5" height="8" viewBox="0 0 5 8" class="vw-breadcrumb-arrow hidden" focusable="false"><path d="M0,8V6L3,4,0,2V0L5,4Z"/></svg></li>
					</c:forEach>

		</ul>
		<br/>
	</c:if>

	<div class="clrfloat"></div>

		<c:choose>
			<c:when test="${eSourcePage == 'clientDetails'}">
			<div id="secTitleDiv" class="col-md-10">
				<span id="sectionTitle" class="sectiontitle vw-page-title">
					<span id="changeNameTitle" class="changeNameTitleClass vw-change-name">
						<span id="changeName" tabindex="0">${eheaderTitle}</span>
						<input type="text" id="changeFolderNameTextBox" class="hidden" value="${eheaderTitle}" >
					</span>
				</span>
			</div>
			</c:when>
			<c:when test="${eSourcePage == 'sync'}">
			<div id="secTitleDiv" class="col-sm-12">
				<f:bundle basename="localization.SyncMessages">
				 	<f:message key="sync.label.filterText" var="filterText"/>
				</f:bundle>

				<span id="sectionTitle" class="sectiontitle vw-page-title">
					<c:choose>
			              <c:when test="${requestScope.NEW_FOLDER!=0}">
			                     <span id="changeNameTitle" class="changeNameTitleClass vw-change-name"><span id="changeName" data-id="0"></span><input type="text" id="changeFolderNameTextBox" class="noName" value="" ></span>
			             		 <a id="showFilters" class="okSaveButton vw-btn vw-btn-default vw-btn-filters"><span class="vw-sprite-filter"></span>${filterText}</a>
			              </c:when>
			              <c:otherwise>
			                      <span id="changeNameTitle" class="changeNameTitleClass vw-change-name"><span id="changeName" data-id="${requestScope.FOLDER_ID}">${requestScope.FOLDER_NAME}</span><input type="text" id="changeFolderNameTextBox" class="noName hidden" value="" ></span>
						 </c:otherwise>
			       </c:choose>
		       </span>
	       </div>
			</c:when>
			<c:when test="${eSourcePage == 'browse'}">
				<!-- Moved to inside Buttons holder div -->
			</c:when>
			<c:otherwise>
				<div id="secTitleDiv" class="col-sm-12">
					<span id="sectionTitle" class="sectiontitle vw-page-title">${eheaderTitle}</span>
				</div>
			</c:otherwise>
		</c:choose>

	<c:if test="${eSourcePage == 'clientDetails'}">
		<div class="col-md-2">
			<c:if test="${esearchContext != null && esearchContext != ''}">
				<c:if test="${ehideSearchBox == 'true'}">
					<c:set var="hideSearch" value="hidden" />
				</c:if>
				<div class="searchli ${hideSearch}" id="searchbox">
					<div class="arrowWrap"><div class="arrowDown"></div>
				</div><input id="pgsearch" type="text" name="search" rel="${esearchContext}"/><!--
				Do NOT remove this comment -suraj	 --><img class="deleteText" src="../common/img/cancel.png" alt="x">
				<c:if test="${requestScope.ADV_SEARCH_JSP != null && requestScope.ADV_SEARCH_JSP != ''}">
					<jsp:include page="../search/${requestScope.ADV_SEARCH_JSP}" />
				</c:if>
				</div>
				<script nonce="${sessionScope.cspNonce}" >
					$('#pgsearch').keyup(function(e) {
						$('#pgsearch').removeClass("showSearch");
						$('#pgsearch').addClass("hideSearch");
						$('.deleteText').css('display', 'inline-block');
					});
					$('.deleteText').on("click", function(e) {
						$('#pgsearch').removeClass("hideSearch");
						$('#pgsearch').addClass("showSearch");
						$('.deleteText').css('display', 'none');
						$('#pgsearch').val("");
						$('.advSearchHolder .fileextension option[value=]').prop('selected', 'selected');
					$('.advSearchHolder .searchlanguage option[value=]').prop('selected', 'selected');
						// clear/reset all fields in search dropdown as well:
						 $('.field input').filter(':not(#advSearchBtn)').val("");
						$('.advSearchHolder .timeOptions option[value=]').prop('selected', 'selected');
						$(".advSearchHolder .timeRangeOptions").hide();
						$("#hasAtt").prop("checked", false);
						$("#size").val("");
					});
				</script>
			</c:if>
			<c:if test="${param.showSearch == 'true'}">
				<f:bundle basename="localization.ClientDetailsMessages">
					<f:message key="clientDetails.label.search" var="searchKey"/>
				</f:bundle>
				<div id="searchDiv" class = "cd_search">
					<input type="search" id="cdSearch" class="form-control input-sm" placeholder="${searchKey}" role="search" />
				</div>
			</c:if>
			<c:if test="${esecHeadertopRightButtonHolder != null && esecHeadertopRightButtonHolder == true}">
				<ul id="secHeadertopRightButtonHolder" class="secHeadertopRightButtonHolder rghtFloat hideOnExportFriendly">
				</ul>
			</c:if>

			<c:if test="${requestScope.headerLinks != null}">
				<div class="headerLinks">
					<c:forEach var="item" items="${requestScope.headerLinks}"	varStatus="loop">
						<a href="${item[1] }">${item[0] }</a>
					</c:forEach>
				</div>
			</c:if>
		</div>
	</c:if>

	<c:if test="${eSourcePage == 'browse'}">

	<c:set var="escapedClientName" value="${fn:escapeXml(param.clientName)}" />
	<c:set var="escapedClientId" value="${fn:escapeXml(param.clientId)}" />
		<f:bundle basename="localization.BackupBrowseMessages">
			<div id="buttonsDivHolder">
				<div id="secTitleDiv">
					<span id="sectionTitle" class="sectiontitle vw-page-title vw-page-title_browse">${eheaderTitle}</span>
				</div>
				<div id="aButtons" class="browsetools aButtons">
					<div class="vw-action-menu-wrapper pull-left">
						<div class="action-menu"><a href="javascript:void(0)" class="js-smartMenuToggle vw-btn vw-btn-secondary"><f:message key="backupBrowse.action.actions" /><span class="sprite icon-arrow-dropdown hideOnSmallScreens" alt="^"></span></a></div>
						<ul id="firstControl">
						</ul>
					</div>

					<ul class="fltright browseOptList vw-browse-right-menu pull-right">
						<c:if test='${requestScope.APPTYPE != "SHAREFOLDER"}'>
							<c:if test="${!requestScope.IS_SYNC_FOLDER}">
							<li class="timeRangeMenu">
								<a href="#" class="vw-btn vw-btn-secondary">
									<span class="dropdownOpener vw-drop-down-toggle"
										data-url="/browse/timeRangeMenu.jsp?isLiveBrowseAvailable=${requestScope.browse.features.isLiveBrowseAvailable()}
										&isMachineBrowseAvailable=${requestScope.browse.features.isMachineBrowseAvailable()}&isAclBrowseSupported=${requestScope.browse.features.isAclBrowseSupported()}">
											<!-- <img class="date-icon" src="../common/img/date.png" alt="date"> -->
											<span id="timeRangeText" class="noTextInSmallScreens"></span>
											<span class="sprite icon-show_latest_backup showOnSmallScreens"></span>
											<span class="sprite icon-arrow-dropdown hideOnSmallScreens" alt="^"></span>
											<span class="dropdown vw-drop-down"></span>
									</span>
								</a>
							</li>
							<c:if test="${!requestScope.IS_ARCHIVER}">
								<li id="hideDeletedItemsLi"  >
									<a id="hideDeletedItems" href="#" class="active vw-btn vw-btn-secondary show-hide-items" title="<f:message key="backupBrowse.action.hideDeleted" />">
										<span class='sprite icon-show_deleted_items '></span>
									</a>
								</li>
								<li id="showDeletedItemsLi" style="display:none">
									<a id="showDeletedItems" href="#"  class=" vw-btn vw-btn-secondary show-hide-items" title="<f:message key="backupBrowse.action.showDeleted" />">
										<span class='sprite icon-show_deleted_items '></span>
									</a>
								</li>
								<li id="hideHiddenItemsLi" style="display:none" >
									<a id="hideHiddenItems" href="#" class="active vw-btn vw-btn-secondary show-hide-items" title="<f:message key="backupBrowse.action.hideHidden" />">
										<span class='sprite icon-show_hidden_items '></span>
									</a>
								</li>
								<li id="showHiddenItemsLi" >
									<a id="showHiddenItems" href="#"  class=" vw-btn vw-btn-secondary show-hide-items" title="<f:message key="backupBrowse.action.showHidden" />">
										<span class='sprite icon-show_hidden_items '></span>
									</a>
								</li>
							</c:if>
							</c:if>
						</c:if>
						<c:if test="${requestScope.browse.features.isPreviewAvailable()}">
								<li class="maybeNobar"><a href="#" id="previewToggle"><f:message key="backupBrowse.action.previewToggle" /></a></li>
						</c:if>
						<c:if test='${requestScope.browse.features.isIconViewAvailable() || requestScope.browse.features.isPieChartAvailable()}'>
							<li>
								<c:if test='${requestScope.browse.features.isIconViewAvailable()}'>
									<div class = "switchViewsFull fltright">
										<div class = "listSwitchButton">
						                             <span class="sprite icon-view-list"></span>
										</div>
										<div class = "iconSwitchButton">
						                             <span class="sprite icon-view-grid"></span>
										</div>
									</div>
								</c:if>

								<c:if test='${requestScope.browse.features.isPieChartAvailable()}'>
									<script nonce="${sessionScope.cspNonce}" >
									var showPieChart = true;
									</script>
									<div class = "pieChartButton fltright vw-btn vw-btn-secondary active">
										<div class = "showPieButton currentView">
											<span class="sprite icon-piechart"></span>
										</div>
									</div>
								</c:if>
							</li>
						</c:if>
							<li>
								<f:bundle basename="localization.BackupBrowseMessages">
									<a href="#" class="noText hideOnMediumScreens vw-btn vw-btn-secondary" id="toggleInfoPaneLink" title="<f:message key='dataPane.iconTitle.show'/>"><span class="sprite icon-info-pane-show showOnMediumScreens"></span></a>
								</f:bundle>
							</li>
					</ul>
				</div>
			</div>
		</f:bundle>
	</c:if>

	<c:if test="${requestScope.browse.features.isMachineBrowseAvailable() == true}">
		<script nonce="${sessionScope.cspNonce}" >
			var machineSupportsBrowse = true;
		</script>
	</c:if>
	<c:if test="${requestScope.browse.features.isAclBrowseSupported() == true}">
		<script nonce="${sessionScope.cspNonce}" >
			var aclBrowseSupported = true;
		</script>
	</c:if>
		<c:if test="${requestScope.browse.features.isMappedUserSet() == true}">
		<script nonce="${sessionScope.cspNonce}" >
			var passwordFreeBrowse = true;
		</script>
	</c:if>
	<div class="clrfloat"></div>
</div>

