/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.builtins.ArrayIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.AtomicsBuiltins;
import com.oracle.truffle.js.builtins.ConsoleBuiltins;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.DebugBuiltins;
import com.oracle.truffle.js.builtins.GlobalBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.JavaBuiltins;
import com.oracle.truffle.js.builtins.MapIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins;
import com.oracle.truffle.js.builtins.PerformanceBuiltins;
import com.oracle.truffle.js.builtins.PolyglotBuiltins;
import com.oracle.truffle.js.builtins.RealmFunctionBuiltins;
import com.oracle.truffle.js.builtins.ReflectBuiltins;
import com.oracle.truffle.js.builtins.RegExpStringIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.SetIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.StringIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.commonjs.GlobalCommonJSRequireBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConsoleUtil;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.Builtin;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSCollator;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSDateTimeFormat;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSGlobalObject;
import com.oracle.truffle.js.runtime.builtins.JSIntl;
import com.oracle.truffle.js.runtime.builtins.JSListFormat;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSMath;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.JSON;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSObjectPrototype;
import com.oracle.truffle.js.runtime.builtins.JSPluralRules;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSRelativeTimeFormat;
import com.oracle.truffle.js.runtime.builtins.JSSIMD;
import com.oracle.truffle.js.runtime.builtins.JSSegmenter;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.builtins.JSTest262;
import com.oracle.truffle.js.runtime.builtins.JSTestV8;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.builtins.JSWeakRef;
import com.oracle.truffle.js.runtime.builtins.JSWeakSet;
import com.oracle.truffle.js.runtime.builtins.SIMDType;
import com.oracle.truffle.js.runtime.java.JavaImporter;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.LocalTimeZoneHolder;
import com.oracle.truffle.js.runtime.util.PrintWriterWrapper;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.LinkOption;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SplittableRandom;
import java.util.TimeZone;
import java.util.WeakHashMap;
import org.graalvm.home.HomeFinder;
import org.graalvm.options.OptionValues;

public class JSRealm {
    public static final String POLYGLOT_CLASS_NAME = "Polyglot";
    public static final String REFLECT_CLASS_NAME = "Reflect";
    public static final String SHARED_ARRAY_BUFFER_CLASS_NAME = "SharedArrayBuffer";
    public static final String ATOMICS_CLASS_NAME = "Atomics";
    public static final String REALM_BUILTIN_CLASS_NAME = "Realm";
    public static final String ARGUMENTS_NAME = "arguments";
    public static final String JAVA_CLASS_NAME = "Java";
    public static final String JAVA_CLASS_NAME_NASHORN_COMPAT = "JavaNashornCompat";
    public static final String PERFORMANCE_CLASS_NAME = "performance";
    public static final String DEBUG_CLASS_NAME = "Debug";
    public static final String CONSOLE_CLASS_NAME = "Console";
    private static final String GRAALVM_VERSION = HomeFinder.getInstance().getVersion();
    private final JSContext context;
    @CompilerDirectives.CompilationFinal
    private DynamicObject globalObject;
    private final DynamicObject objectConstructor;
    private final DynamicObject objectPrototype;
    private final DynamicObject functionConstructor;
    private final DynamicObject functionPrototype;
    private final DynamicObject arrayConstructor;
    private final DynamicObject arrayPrototype;
    private final DynamicObject booleanConstructor;
    private final DynamicObject booleanPrototype;
    private final DynamicObject numberConstructor;
    private final DynamicObject numberPrototype;
    private final DynamicObject bigIntConstructor;
    private final DynamicObject bigIntPrototype;
    private final DynamicObject stringConstructor;
    private final DynamicObject stringPrototype;
    private final DynamicObject regExpConstructor;
    private final DynamicObject regExpPrototype;
    private final DynamicObject collatorConstructor;
    private final DynamicObject collatorPrototype;
    private final DynamicObject numberFormatConstructor;
    private final DynamicObject numberFormatPrototype;
    private final DynamicObject pluralRulesConstructor;
    private final DynamicObject pluralRulesPrototype;
    private final DynamicObject listFormatConstructor;
    private final DynamicObject listFormatPrototype;
    private final DynamicObject dateTimeFormatConstructor;
    private final DynamicObject dateTimeFormatPrototype;
    private final DynamicObject relativeTimeFormatConstructor;
    private final DynamicObject relativeTimeFormatPrototype;
    private final DynamicObject segmenterConstructor;
    private final DynamicObject segmenterPrototype;
    private final DynamicObject dateConstructor;
    private final DynamicObject datePrototype;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DynamicObject[] errorConstructors;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DynamicObject[] errorPrototypes;
    private final DynamicObject callSiteConstructor;
    private final DynamicObject callSitePrototype;
    private final Shape initialRegExpPrototypeShape;
    private final JSObjectFactory.RealmData objectFactories;
    private final DynamicObject symbolConstructor;
    private final DynamicObject symbolPrototype;
    private final DynamicObject mapConstructor;
    private final DynamicObject mapPrototype;
    private final DynamicObject setConstructor;
    private final DynamicObject setPrototype;
    private final DynamicObject weakRefConstructor;
    private final DynamicObject weakRefPrototype;
    private final DynamicObject weakMapConstructor;
    private final DynamicObject weakMapPrototype;
    private final DynamicObject weakSetConstructor;
    private final DynamicObject weakSetPrototype;
    private final DynamicObject mathObject;
    private DynamicObject realmBuiltinObject;
    private Object evalFunctionObject;
    private Object applyFunctionObject;
    private Object callFunctionObject;
    private Object reflectApplyFunctionObject;
    private Object reflectConstructFunctionObject;
    private Object commonJSRequireFunctionObject;
    private Map<String, DynamicObject> commonJSPreLoadedBuiltins;
    private Object jsonParseFunctionObject;
    private final DynamicObject arrayBufferConstructor;
    private final DynamicObject arrayBufferPrototype;
    private final DynamicObject sharedArrayBufferConstructor;
    private final DynamicObject sharedArrayBufferPrototype;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DynamicObject[] typedArrayConstructors;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DynamicObject[] typedArrayPrototypes;
    private final DynamicObject dataViewConstructor;
    private final DynamicObject dataViewPrototype;
    private final DynamicObject jsAdapterConstructor;
    private final DynamicObject jsAdapterPrototype;
    private final DynamicObject javaImporterConstructor;
    private final DynamicObject javaImporterPrototype;
    private final DynamicObject proxyConstructor;
    private final DynamicObject proxyPrototype;
    private final DynamicObject iteratorPrototype;
    private final DynamicObject arrayIteratorPrototype;
    private final DynamicObject setIteratorPrototype;
    private final DynamicObject mapIteratorPrototype;
    private final DynamicObject segmentIteratorPrototype;
    private final DynamicObject stringIteratorPrototype;
    private final DynamicObject regExpStringIteratorPrototype;
    private final DynamicObject enumerateIteratorPrototype;
    private final DynamicObject forInIteratorPrototype;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final JSConstructor[] simdTypeConstructors;
    private final DynamicObject generatorFunctionConstructor;
    private final DynamicObject generatorFunctionPrototype;
    private final DynamicObject generatorObjectPrototype;
    private final DynamicObject asyncFunctionConstructor;
    private final DynamicObject asyncFunctionPrototype;
    private final DynamicObject asyncIteratorPrototype;
    private final DynamicObject asyncFromSyncIteratorPrototype;
    private final DynamicObject asyncGeneratorObjectPrototype;
    private final DynamicObject asyncGeneratorFunctionConstructor;
    private final DynamicObject asyncGeneratorFunctionPrototype;
    private final DynamicObject throwerFunction;
    private final Accessor throwerAccessor;
    private final DynamicObject promiseConstructor;
    private final DynamicObject promisePrototype;
    @CompilerDirectives.CompilationFinal
    private DynamicObject javaPackageToPrimitiveFunction;
    private final DynamicObject arrayProtoValuesIterator;
    @CompilerDirectives.CompilationFinal
    private DynamicObject typedArrayConstructor;
    @CompilerDirectives.CompilationFinal
    private DynamicObject typedArrayPrototype;
    @CompilerDirectives.CompilationFinal
    private DynamicObject simdTypeConstructor;
    @CompilerDirectives.CompilationFinal
    private DynamicObject simdTypePrototype;
    private DynamicObject preinitIntlObject;
    private DynamicObject preinitConsoleBuiltinObject;
    private DynamicObject preinitPerformanceObject;
    private volatile Map<Object, DynamicObject> templateRegistry;
    private final DynamicObject globalScope;
    private DynamicObject scriptEngineImportScope;
    private TruffleLanguage.Env truffleLanguageEnv;
    private boolean preparingStackTrace;
    private Object embedderData;
    private Object regexResult;
    private Object lazyStaticRegexResultCompiledRegex;
    private String lazyStaticRegexResultInputString = "";
    private long lazyStaticRegexResultFromIndex;
    @CompilerDirectives.CompilationFinal
    private LocalTimeZoneHolder localTimeZoneHolder;
    public static final long NANOSECONDS_PER_MILLISECOND = 1000000L;
    private SplittableRandom random;
    private long nanoToZeroTimeOffset;
    private long nanoToCurrentTimeOffset;
    private long lastFuzzyTime = Long.MIN_VALUE;
    private OutputStream outputStream;
    private OutputStream errorStream;
    private PrintWriterWrapper outputWriter;
    private PrintWriterWrapper errorWriter;
    private final JSConsoleUtil consoleUtil;
    private JSModuleLoader moduleLoader;
    @CompilerDirectives.CompilationFinal
    private JSAgent agent;
    private List<JSRealm> realmList;
    private JSRealm parentRealm;
    private JSRealm v8RealmCurrent = this;
    Object v8RealmShared = Undefined.instance;
    static final ThreadLocal<Boolean> CREATING_CHILD_REALM = new ThreadLocal();
    private JavaScriptNode callNode;
    private final Map<TruffleFile, DynamicObject> commonJSRequireCache;
    private static final PropertyProxy REALM_SHARED_PROXY = new RealmSharedPropertyProxy();
    private static final Property REALM_SHARED_PROPERTY = JSObjectUtil.makeProxyProperty("shared", REALM_SHARED_PROXY, JSAttributes.getDefault());

    public JSRealm(JSContext context, TruffleLanguage.Env env) {
        boolean es9;
        boolean es8;
        boolean es6;
        this.context = context;
        this.truffleLanguageEnv = env;
        this.objectPrototype = JSObjectPrototype.create(context);
        this.functionPrototype = JSFunction.createFunctionPrototype(this, this.objectPrototype);
        this.objectFactories = context.newObjectFactoryRealmData();
        this.throwerFunction = this.createThrowerFunction();
        this.throwerAccessor = new Accessor(this.throwerFunction, this.throwerFunction);
        if (context.isOptionAnnexB()) {
            JSRealm.putProtoAccessorProperty(this);
        }
        this.globalObject = JSGlobalObject.create(this, this.objectPrototype);
        this.globalScope = JSObject.createInit(context.getGlobalScopeShape());
        if (context.getContextOptions().isScriptEngineGlobalScopeImport()) {
            this.scriptEngineImportScope = JSObject.createInit(context.createEmptyShape());
        }
        this.objectConstructor = JSRealm.createObjectConstructor(this, this.objectPrototype);
        JSObjectUtil.putDataProperty(context, this.objectPrototype, "constructor", this.objectConstructor, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putFunctionsFromContainer(this, this.objectPrototype, JSObjectPrototype.BUILTINS);
        this.functionConstructor = JSFunction.createFunctionConstructor(this);
        JSFunction.fillFunctionPrototype(this);
        JSConstructor ctor = JSArray.createConstructor(this);
        this.arrayConstructor = ctor.getFunctionObject();
        this.arrayPrototype = ctor.getPrototype();
        ctor = JSBoolean.createConstructor(this);
        this.booleanConstructor = ctor.getFunctionObject();
        this.booleanPrototype = ctor.getPrototype();
        ctor = JSNumber.createConstructor(this);
        this.numberConstructor = ctor.getFunctionObject();
        this.numberPrototype = ctor.getPrototype();
        ctor = JSString.createConstructor(this);
        this.stringConstructor = ctor.getFunctionObject();
        this.stringPrototype = ctor.getPrototype();
        ctor = JSRegExp.createConstructor(this);
        this.regExpConstructor = ctor.getFunctionObject();
        this.regExpPrototype = ctor.getPrototype();
        ctor = JSDate.createConstructor(this);
        this.dateConstructor = ctor.getFunctionObject();
        this.datePrototype = ctor.getPrototype();
        this.initialRegExpPrototypeShape = this.regExpPrototype.getShape();
        boolean bl = es6 = JSTruffleOptions.MaxECMAScriptVersion >= 6;
        if (es6) {
            ctor = JSSymbol.createConstructor(this);
            this.symbolConstructor = ctor.getFunctionObject();
            this.symbolPrototype = ctor.getPrototype();
            ctor = JSMap.createConstructor(this);
            this.mapConstructor = ctor.getFunctionObject();
            this.mapPrototype = ctor.getPrototype();
            ctor = JSSet.createConstructor(this);
            this.setConstructor = ctor.getFunctionObject();
            this.setPrototype = ctor.getPrototype();
            ctor = JSWeakRef.createConstructor(this);
            this.weakRefConstructor = ctor.getFunctionObject();
            this.weakRefPrototype = ctor.getPrototype();
            ctor = JSWeakMap.createConstructor(this);
            this.weakMapConstructor = ctor.getFunctionObject();
            this.weakMapPrototype = ctor.getPrototype();
            ctor = JSWeakSet.createConstructor(this);
            this.weakSetConstructor = ctor.getFunctionObject();
            this.weakSetPrototype = ctor.getPrototype();
            ctor = JSProxy.createConstructor(this);
            this.proxyConstructor = ctor.getFunctionObject();
            this.proxyPrototype = ctor.getPrototype();
            ctor = JSPromise.createConstructor(this);
            this.promiseConstructor = ctor.getFunctionObject();
            this.promisePrototype = ctor.getPrototype();
        } else {
            this.symbolConstructor = null;
            this.symbolPrototype = null;
            this.mapConstructor = null;
            this.mapPrototype = null;
            this.setConstructor = null;
            this.setPrototype = null;
            this.weakRefConstructor = null;
            this.weakRefPrototype = null;
            this.weakMapConstructor = null;
            this.weakMapPrototype = null;
            this.weakSetConstructor = null;
            this.weakSetPrototype = null;
            this.proxyConstructor = null;
            this.proxyPrototype = null;
            this.promiseConstructor = null;
            this.promisePrototype = null;
        }
        this.errorConstructors = new DynamicObject[JSErrorType.errorTypes().length];
        this.errorPrototypes = new DynamicObject[JSErrorType.errorTypes().length];
        this.initializeErrorConstructors();
        ctor = JSError.createCallSiteConstructor(this);
        this.callSiteConstructor = ctor.getFunctionObject();
        this.callSitePrototype = ctor.getPrototype();
        ctor = JSArrayBuffer.createConstructor(this);
        this.arrayBufferConstructor = ctor.getFunctionObject();
        this.arrayBufferPrototype = ctor.getPrototype();
        this.typedArrayConstructors = new DynamicObject[TypedArray.factories(context).length];
        this.typedArrayPrototypes = new DynamicObject[TypedArray.factories(context).length];
        this.initializeTypedArrayConstructors();
        ctor = JSDataView.createConstructor(this);
        this.dataViewConstructor = ctor.getFunctionObject();
        this.dataViewPrototype = ctor.getPrototype();
        if (context.getContextOptions().isSIMDjs()) {
            this.simdTypeConstructors = new JSConstructor[SIMDType.FACTORIES.length];
            this.initializeSIMDTypeConstructors();
        } else {
            this.simdTypeConstructors = null;
        }
        if (context.getContextOptions().isBigInt()) {
            ctor = JSBigInt.createConstructor(this);
            this.bigIntConstructor = ctor.getFunctionObject();
            this.bigIntPrototype = ctor.getPrototype();
        } else {
            this.bigIntConstructor = null;
            this.bigIntPrototype = null;
        }
        this.iteratorPrototype = this.createIteratorPrototype();
        this.arrayIteratorPrototype = es6 ? this.createArrayIteratorPrototype() : null;
        this.setIteratorPrototype = es6 ? this.createSetIteratorPrototype() : null;
        this.mapIteratorPrototype = es6 ? this.createMapIteratorPrototype() : null;
        this.stringIteratorPrototype = es6 ? this.createStringIteratorPrototype() : null;
        this.regExpStringIteratorPrototype = JSTruffleOptions.MaxECMAScriptVersion >= 10 ? this.createRegExpStringIteratorPrototype() : null;
        ctor = JSCollator.createConstructor(this);
        this.collatorConstructor = ctor.getFunctionObject();
        this.collatorPrototype = ctor.getPrototype();
        ctor = JSNumberFormat.createConstructor(this);
        this.numberFormatConstructor = ctor.getFunctionObject();
        this.numberFormatPrototype = ctor.getPrototype();
        ctor = JSDateTimeFormat.createConstructor(this);
        this.dateTimeFormatConstructor = ctor.getFunctionObject();
        this.dateTimeFormatPrototype = ctor.getPrototype();
        ctor = JSPluralRules.createConstructor(this);
        this.pluralRulesConstructor = ctor.getFunctionObject();
        this.pluralRulesPrototype = ctor.getPrototype();
        ctor = JSListFormat.createConstructor(this);
        this.listFormatConstructor = ctor.getFunctionObject();
        this.listFormatPrototype = ctor.getPrototype();
        ctor = JSRelativeTimeFormat.createConstructor(this);
        this.relativeTimeFormatConstructor = ctor.getFunctionObject();
        this.relativeTimeFormatPrototype = ctor.getPrototype();
        ctor = JSSegmenter.createConstructor(this);
        this.segmenterConstructor = ctor.getFunctionObject();
        this.segmenterPrototype = ctor.getPrototype();
        this.segmentIteratorPrototype = JSSegmenter.createSegmentIteratorPrototype(context, this);
        if (es6) {
            ctor = JSFunction.createGeneratorFunctionConstructor(this);
            this.generatorFunctionConstructor = ctor.getFunctionObject();
            this.generatorFunctionPrototype = ctor.getPrototype();
            this.generatorObjectPrototype = (DynamicObject)this.generatorFunctionPrototype.get((Object)"prototype", null);
        } else {
            this.generatorFunctionConstructor = null;
            this.generatorFunctionPrototype = null;
            this.generatorObjectPrototype = null;
        }
        this.enumerateIteratorPrototype = JSFunction.createEnumerateIteratorPrototype(this);
        this.forInIteratorPrototype = JSFunction.createForInIteratorPrototype(this);
        this.arrayProtoValuesIterator = (DynamicObject)this.getArrayPrototype().get((Object)Symbol.SYMBOL_ITERATOR, (Object)Undefined.instance);
        if (context.isOptionSharedArrayBuffer()) {
            ctor = JSSharedArrayBuffer.createConstructor(this);
            this.sharedArrayBufferConstructor = ctor.getFunctionObject();
            this.sharedArrayBufferPrototype = ctor.getPrototype();
        } else {
            this.sharedArrayBufferConstructor = null;
            this.sharedArrayBufferPrototype = null;
        }
        this.mathObject = JSMath.create(this);
        boolean bl2 = es8 = JSTruffleOptions.MaxECMAScriptVersion >= 8;
        if (es8) {
            ctor = JSFunction.createAsyncFunctionConstructor(this);
            this.asyncFunctionConstructor = ctor.getFunctionObject();
            this.asyncFunctionPrototype = ctor.getPrototype();
        } else {
            this.asyncFunctionConstructor = null;
            this.asyncFunctionPrototype = null;
        }
        boolean bl3 = es9 = JSTruffleOptions.MaxECMAScriptVersion >= 9;
        if (es9) {
            this.asyncIteratorPrototype = JSFunction.createAsyncIteratorPrototype(this);
            this.asyncFromSyncIteratorPrototype = JSFunction.createAsyncFromSyncIteratorPrototype(this);
            ctor = JSFunction.createAsyncGeneratorFunctionConstructor(this);
            this.asyncGeneratorFunctionConstructor = ctor.getFunctionObject();
            this.asyncGeneratorFunctionPrototype = ctor.getPrototype();
            this.asyncGeneratorObjectPrototype = (DynamicObject)this.asyncGeneratorFunctionPrototype.get((Object)"prototype", null);
        } else {
            this.asyncIteratorPrototype = null;
            this.asyncFromSyncIteratorPrototype = null;
            this.asyncGeneratorFunctionConstructor = null;
            this.asyncGeneratorFunctionPrototype = null;
            this.asyncGeneratorObjectPrototype = null;
        }
        boolean nashornCompat = context.isOptionNashornCompatibilityMode();
        if (nashornCompat) {
            ctor = JSAdapter.createConstructor(this);
            this.jsAdapterConstructor = ctor.getFunctionObject();
            this.jsAdapterPrototype = ctor.getPrototype();
            ctor = JavaImporter.createConstructor(this);
            this.javaImporterConstructor = ctor.getFunctionObject();
            this.javaImporterPrototype = ctor.getPrototype();
        } else {
            this.jsAdapterConstructor = null;
            this.jsAdapterPrototype = null;
            this.javaImporterConstructor = null;
            this.javaImporterPrototype = null;
        }
        this.outputStream = System.out;
        this.errorStream = System.err;
        this.outputWriter = new PrintWriterWrapper(this.outputStream, true);
        this.errorWriter = new PrintWriterWrapper(this.errorStream, true);
        this.consoleUtil = new JSConsoleUtil();
        this.commonJSRequireCache = context.getContextOptions().isCommonJSRequire() ? new HashMap<TruffleFile, DynamicObject>() : null;
    }

    private void initializeTypedArrayConstructors() {
        JSConstructor taConst = JSArrayBufferView.createTypedArrayConstructor(this);
        this.typedArrayConstructor = taConst.getFunctionObject();
        this.typedArrayPrototype = taConst.getPrototype();
        for (TypedArrayFactory factory : TypedArray.factories(this.context)) {
            JSConstructor constructor = JSArrayBufferView.createConstructor(this, factory, taConst);
            this.typedArrayConstructors[factory.getFactoryIndex()] = constructor.getFunctionObject();
            this.typedArrayPrototypes[factory.getFactoryIndex()] = constructor.getPrototype();
        }
    }

    private void initializeSIMDTypeConstructors() {
        assert (this.context.getContextOptions().isSIMDjs());
        JSConstructor taConst = JSSIMD.createSIMDTypeConstructor(this);
        this.simdTypeConstructor = taConst.getFunctionObject();
        this.simdTypePrototype = taConst.getPrototype();
        for (SIMDType.SIMDTypeFactory<? extends SIMDType> factory : SIMDType.FACTORIES) {
            JSConstructor constructor;
            this.simdTypeConstructors[factory.getFactoryIndex()] = constructor = JSSIMD.createConstructor(this, factory, taConst);
        }
    }

    private void initializeErrorConstructors() {
        for (JSErrorType type : JSErrorType.errorTypes()) {
            JSConstructor errorConstructor = JSError.createErrorConstructor(this, type);
            this.errorConstructors[type.ordinal()] = errorConstructor.getFunctionObject();
            this.errorPrototypes[type.ordinal()] = errorConstructor.getPrototype();
        }
    }

    public final JSContext getContext() {
        return this.context;
    }

    public final DynamicObject lookupFunction(JSBuiltinsContainer container, String methodName) {
        Builtin builtin = Objects.requireNonNull(container.lookupByName(methodName));
        JSFunctionData functionData = builtin.createFunctionData(this.context);
        return JSFunction.create(this, functionData);
    }

    public static DynamicObject createObjectConstructor(JSRealm realm, DynamicObject objectPrototype) {
        JSContext context = realm.getContext();
        DynamicObject objectConstructor = realm.lookupFunction(ConstructorBuiltins.BUILTINS, "Object");
        JSObjectUtil.putConstructorPrototypeProperty(context, objectConstructor, objectPrototype);
        JSObjectUtil.putFunctionsFromContainer(realm, objectConstructor, ObjectFunctionBuiltins.BUILTINS);
        return objectConstructor;
    }

    public final DynamicObject getErrorConstructor(JSErrorType type) {
        return this.errorConstructors[type.ordinal()];
    }

    public final DynamicObject getErrorPrototype(JSErrorType type) {
        return this.errorPrototypes[type.ordinal()];
    }

    public final DynamicObject getGlobalObject() {
        return this.globalObject;
    }

    public final void setGlobalObject(DynamicObject global) {
        this.globalObject = global;
    }

    public final DynamicObject getObjectConstructor() {
        return this.objectConstructor;
    }

    public final DynamicObject getObjectPrototype() {
        return this.objectPrototype;
    }

    public final DynamicObject getFunctionConstructor() {
        return this.functionConstructor;
    }

    public final DynamicObject getFunctionPrototype() {
        return this.functionPrototype;
    }

    public final DynamicObject getArrayConstructor() {
        return this.arrayConstructor;
    }

    public final DynamicObject getArrayPrototype() {
        return this.arrayPrototype;
    }

    public final DynamicObject getBooleanConstructor() {
        return this.booleanConstructor;
    }

    public final DynamicObject getBooleanPrototype() {
        return this.booleanPrototype;
    }

    public final DynamicObject getNumberConstructor() {
        return this.numberConstructor;
    }

    public final DynamicObject getNumberPrototype() {
        return this.numberPrototype;
    }

    public final DynamicObject getBigIntConstructor() {
        return this.bigIntConstructor;
    }

    public final DynamicObject getBigIntPrototype() {
        return this.bigIntPrototype;
    }

    public final DynamicObject getStringConstructor() {
        return this.stringConstructor;
    }

    public final DynamicObject getStringPrototype() {
        return this.stringPrototype;
    }

    public final DynamicObject getRegExpConstructor() {
        return this.regExpConstructor;
    }

    public final DynamicObject getRegExpPrototype() {
        return this.regExpPrototype;
    }

    public final DynamicObject getCollatorConstructor() {
        return this.collatorConstructor;
    }

    public final DynamicObject getCollatorPrototype() {
        return this.collatorPrototype;
    }

    public final DynamicObject getNumberFormatConstructor() {
        return this.numberFormatConstructor;
    }

    public final DynamicObject getNumberFormatPrototype() {
        return this.numberFormatPrototype;
    }

    public final DynamicObject getPluralRulesConstructor() {
        return this.pluralRulesConstructor;
    }

    public final DynamicObject getPluralRulesPrototype() {
        return this.pluralRulesPrototype;
    }

    public final DynamicObject getListFormatConstructor() {
        return this.listFormatConstructor;
    }

    public final DynamicObject getListFormatPrototype() {
        return this.listFormatPrototype;
    }

    public final DynamicObject getRelativeTimeFormatConstructor() {
        return this.relativeTimeFormatConstructor;
    }

    public final DynamicObject getRelativeTimeFormatPrototype() {
        return this.relativeTimeFormatPrototype;
    }

    public final DynamicObject getDateTimeFormatConstructor() {
        return this.dateTimeFormatConstructor;
    }

    public final DynamicObject getDateTimeFormatPrototype() {
        return this.dateTimeFormatPrototype;
    }

    public final DynamicObject getDateConstructor() {
        return this.dateConstructor;
    }

    public final DynamicObject getDatePrototype() {
        return this.datePrototype;
    }

    public final DynamicObject getSegmenterConstructor() {
        return this.segmenterConstructor;
    }

    public final DynamicObject getSegmenterPrototype() {
        return this.segmenterPrototype;
    }

    public final DynamicObject getSymbolConstructor() {
        return this.symbolConstructor;
    }

    public final DynamicObject getSymbolPrototype() {
        return this.symbolPrototype;
    }

    public final DynamicObject getMapConstructor() {
        return this.mapConstructor;
    }

    public final DynamicObject getMapPrototype() {
        return this.mapPrototype;
    }

    public final DynamicObject getSetConstructor() {
        return this.setConstructor;
    }

    public final DynamicObject getSetPrototype() {
        return this.setPrototype;
    }

    public final DynamicObject getWeakRefConstructor() {
        return this.weakRefConstructor;
    }

    public final DynamicObject getWeakRefPrototype() {
        return this.weakRefPrototype;
    }

    public final DynamicObject getWeakMapConstructor() {
        return this.weakMapConstructor;
    }

    public final DynamicObject getWeakMapPrototype() {
        return this.weakMapPrototype;
    }

    public final DynamicObject getWeakSetConstructor() {
        return this.weakSetConstructor;
    }

    public final DynamicObject getWeakSetPrototype() {
        return this.weakSetPrototype;
    }

    public final Shape getInitialRegExpPrototypeShape() {
        return this.initialRegExpPrototypeShape;
    }

    public final DynamicObject getArrayBufferConstructor() {
        return this.arrayBufferConstructor;
    }

    public final DynamicObject getArrayBufferPrototype() {
        return this.arrayBufferPrototype;
    }

    public final DynamicObject getSharedArrayBufferConstructor() {
        assert (this.context.isOptionSharedArrayBuffer());
        return this.sharedArrayBufferConstructor;
    }

    public final DynamicObject getSharedArrayBufferPrototype() {
        assert (this.context.isOptionSharedArrayBuffer());
        return this.sharedArrayBufferPrototype;
    }

    public final DynamicObject getArrayBufferViewConstructor(TypedArrayFactory factory) {
        return this.typedArrayConstructors[factory.getFactoryIndex()];
    }

    public final DynamicObject getArrayBufferViewPrototype(TypedArrayFactory factory) {
        return this.typedArrayPrototypes[factory.getFactoryIndex()];
    }

    public final DynamicObject getDataViewConstructor() {
        return this.dataViewConstructor;
    }

    public final DynamicObject getDataViewPrototype() {
        return this.dataViewPrototype;
    }

    public final DynamicObject getTypedArrayConstructor() {
        return this.typedArrayConstructor;
    }

    public final DynamicObject getTypedArrayPrototype() {
        return this.typedArrayPrototype;
    }

    public final DynamicObject getRealmBuiltinObject() {
        return this.realmBuiltinObject;
    }

    public final DynamicObject getProxyConstructor() {
        return this.proxyConstructor;
    }

    public final DynamicObject getProxyPrototype() {
        return this.proxyPrototype;
    }

    public final DynamicObject getGeneratorFunctionConstructor() {
        return this.generatorFunctionConstructor;
    }

    public final DynamicObject getGeneratorFunctionPrototype() {
        return this.generatorFunctionPrototype;
    }

    public final DynamicObject getAsyncFunctionConstructor() {
        return this.asyncFunctionConstructor;
    }

    public final DynamicObject getAsyncFunctionPrototype() {
        return this.asyncFunctionPrototype;
    }

    public final DynamicObject getAsyncGeneratorFunctionConstructor() {
        return this.asyncGeneratorFunctionConstructor;
    }

    public final DynamicObject getAsyncGeneratorFunctionPrototype() {
        return this.asyncGeneratorFunctionPrototype;
    }

    public final DynamicObject getEnumerateIteratorPrototype() {
        return this.enumerateIteratorPrototype;
    }

    public final DynamicObject getForInIteratorPrototype() {
        return this.forInIteratorPrototype;
    }

    public final DynamicObject getGeneratorObjectPrototype() {
        return this.generatorObjectPrototype;
    }

    public final DynamicObject getAsyncGeneratorObjectPrototype() {
        return this.asyncGeneratorObjectPrototype;
    }

    public final DynamicObject getJavaImporterConstructor() {
        return this.javaImporterConstructor;
    }

    public final DynamicObject getJavaImporterPrototype() {
        return this.javaImporterPrototype;
    }

    public final DynamicObject getJavaPackageToPrimitiveFunction() {
        assert (this.javaPackageToPrimitiveFunction != null);
        return this.javaPackageToPrimitiveFunction;
    }

    public final Map<Object, DynamicObject> getTemplateRegistry() {
        if (this.templateRegistry == null) {
            this.createTemplateRegistry();
        }
        return this.templateRegistry;
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void createTemplateRegistry() {
        if (this.templateRegistry == null) {
            this.templateRegistry = new WeakHashMap<Object, DynamicObject>();
        }
    }

    public final Object getEvalFunctionObject() {
        return this.evalFunctionObject;
    }

    public final Object getApplyFunctionObject() {
        return this.applyFunctionObject;
    }

    public final Object getCallFunctionObject() {
        return this.callFunctionObject;
    }

    public final Object getReflectApplyFunctionObject() {
        return this.reflectApplyFunctionObject;
    }

    public final Object getReflectConstructFunctionObject() {
        return this.reflectConstructFunctionObject;
    }

    public final Object getCommonJSRequireFunctionObject() {
        return this.commonJSRequireFunctionObject;
    }

    public final Object getJsonParseFunctionObject() {
        return this.jsonParseFunctionObject;
    }

    private static void putProtoAccessorProperty(JSRealm realm) {
        JSContext context = realm.getContext();
        DynamicObject getProto = JSFunction.create(realm, context.protoGetterFunctionData);
        DynamicObject setProto = JSFunction.create(realm, context.protoSetterFunctionData);
        JSObjectUtil.putConstantAccessorProperty(context, realm.getObjectPrototype(), "__proto__", getProto, setProto);
    }

    public final DynamicObject getThrowerFunction() {
        assert (this.throwerFunction != null);
        return this.throwerFunction;
    }

    public final Accessor getThrowerAccessor() {
        assert (this.throwerAccessor != null);
        return this.throwerAccessor;
    }

    public DynamicObject getIteratorPrototype() {
        return this.iteratorPrototype;
    }

    public DynamicObject getAsyncIteratorPrototype() {
        return this.asyncIteratorPrototype;
    }

    public DynamicObject getAsyncFromSyncIteratorPrototype() {
        return this.asyncFromSyncIteratorPrototype;
    }

    public DynamicObject getArrayIteratorPrototype() {
        return this.arrayIteratorPrototype;
    }

    public DynamicObject getSetIteratorPrototype() {
        return this.setIteratorPrototype;
    }

    public DynamicObject getMapIteratorPrototype() {
        return this.mapIteratorPrototype;
    }

    public DynamicObject getStringIteratorPrototype() {
        return this.stringIteratorPrototype;
    }

    public DynamicObject getRegExpStringIteratorPrototype() {
        return this.regExpStringIteratorPrototype;
    }

    public DynamicObject getSegmentIteratorPrototype() {
        return this.segmentIteratorPrototype;
    }

    private DynamicObject createThrowerFunction() {
        CompilerAsserts.neverPartOfCompilation();
        DynamicObject thrower = JSFunction.create(this, this.context.throwerFunctionData);
        JSObject.preventExtensions(thrower);
        JSObject.setIntegrityLevel(thrower, true);
        return thrower;
    }

    public DynamicObject getPromiseConstructor() {
        return this.promiseConstructor;
    }

    public DynamicObject getPromisePrototype() {
        return this.promisePrototype;
    }

    public final JSObjectFactory.RealmData getObjectFactories() {
        return this.objectFactories;
    }

    public void setupGlobals() {
        int n;
        CompilerAsserts.neverPartOfCompilation((String)"do not setup globals from compiled code");
        long time = JSTruffleOptions.ProfileTime ? System.nanoTime() : 0L;
        DynamicObject global = this.getGlobalObject();
        this.putGlobalProperty("Object", this.getObjectConstructor());
        this.putGlobalProperty("Function", this.getFunctionConstructor());
        this.putGlobalProperty("Array", this.getArrayConstructor());
        this.putGlobalProperty("String", this.getStringConstructor());
        this.putGlobalProperty("Date", this.getDateConstructor());
        this.putGlobalProperty("Number", this.getNumberConstructor());
        this.putGlobalProperty("Boolean", this.getBooleanConstructor());
        this.putGlobalProperty("RegExp", this.getRegExpConstructor());
        this.putGlobalProperty("Math", this.mathObject);
        this.putGlobalProperty("JSON", JSON.create(this));
        JSObjectUtil.putDataProperty(this.context, global, "NaN", (Object)Double.NaN);
        JSObjectUtil.putDataProperty(this.context, global, "Infinity", (Object)Double.POSITIVE_INFINITY);
        JSObjectUtil.putDataProperty(this.context, global, "undefined", (Object)Undefined.instance);
        JSObjectUtil.putFunctionsFromContainer(this, global, GlobalBuiltins.GLOBAL_FUNCTIONS);
        this.evalFunctionObject = JSObject.get(global, (Object)"eval");
        this.applyFunctionObject = JSObject.get(this.getFunctionPrototype(), (Object)"apply");
        this.callFunctionObject = JSObject.get(this.getFunctionPrototype(), (Object)"call");
        DynamicObject jsonBuiltin = (DynamicObject)JSObject.get(global, (Object)"JSON");
        this.jsonParseFunctionObject = JSObject.get(jsonBuiltin, (Object)"parse");
        for (JSErrorType type : JSErrorType.errorTypes()) {
            this.putGlobalProperty(type.name(), this.getErrorConstructor(type));
        }
        this.putGlobalProperty("ArrayBuffer", this.getArrayBufferConstructor());
        Enum[] enumArray = TypedArray.factories(this.context);
        int n2 = enumArray.length;
        for (n = 0; n < n2; ++n) {
            Enum factory = enumArray[n];
            this.putGlobalProperty(((TypedArrayFactory)factory).getName(), this.getArrayBufferViewConstructor((TypedArrayFactory)factory));
        }
        this.putGlobalProperty("DataView", this.getDataViewConstructor());
        if (this.context.getContextOptions().isSIMDjs()) {
            String[] simdObject = JSObject.createInit(this, this.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
            SIMDType.SIMDTypeFactory<? extends SIMDType>[] sIMDTypeFactoryArray = SIMDType.FACTORIES;
            n = sIMDTypeFactoryArray.length;
            for (int factory = 0; factory < n; ++factory) {
                SIMDType.SIMDTypeFactory<? extends SIMDType> factory2 = sIMDTypeFactoryArray[factory];
                JSObjectUtil.putDataProperty(this.context, (DynamicObject)simdObject, factory2.getName(), this.getSIMDTypeConstructor(factory2).getFunctionObject(), JSAttributes.getDefaultNotEnumerable());
            }
            this.putGlobalProperty("SIMD", simdObject);
        }
        if (this.context.getContextOptions().isBigInt()) {
            this.putGlobalProperty("BigInt", this.getBigIntConstructor());
        }
        if (this.context.isOptionNashornCompatibilityMode()) {
            this.initGlobalNashornExtensions();
            this.removeNashornIncompatibleBuiltins();
        }
        if (this.context.getContextOptions().isScriptEngineGlobalScopeImport()) {
            for (String builtin : new String[]{"importScriptEngineGlobalBindings", "checkSyntaxForScriptEngine"}) {
                JSObjectUtil.putDataProperty(this.context, this.getScriptEngineImportScope(), builtin, this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, builtin), JSAttributes.notConfigurableNotEnumerableNotWritable());
            }
        }
        if (this.context.getContextOptions().isPolyglotBuiltin() && (this.getEnv().isPolyglotEvalAllowed() || this.getEnv().isPolyglotBindingsAccessAllowed())) {
            this.setupPolyglot();
        }
        if (this.context.isOptionDebugBuiltin()) {
            this.putGlobalProperty(JSTruffleOptions.DebugPropertyName, this.createDebugObject());
        }
        if (this.context.getContextOptions().isTest262Mode()) {
            this.putGlobalProperty("$262", JSTest262.create(this));
        }
        if (this.context.getContextOptions().isTestV8Mode()) {
            this.putGlobalProperty("TestV8", JSTestV8.create(this));
        }
        if (this.context.getContextOptions().isV8RealmBuiltin()) {
            this.initRealmBuiltinObject();
        }
        if (this.context.getEcmaScriptVersion() >= 6) {
            Object parseInt = JSObject.get(global, (Object)"parseInt");
            Object parseFloat = JSObject.get(global, (Object)"parseFloat");
            this.putProperty(this.getNumberConstructor(), "parseInt", parseInt);
            this.putProperty(this.getNumberConstructor(), "parseFloat", parseFloat);
            this.putGlobalProperty("Map", this.getMapConstructor());
            this.putGlobalProperty("Set", this.getSetConstructor());
            this.putGlobalProperty("WeakMap", this.getWeakMapConstructor());
            this.putGlobalProperty("WeakSet", this.getWeakSetConstructor());
            this.putGlobalProperty("Symbol", this.getSymbolConstructor());
            JSRealm.setupPredefinedSymbols(this.getSymbolConstructor());
            DynamicObject reflectObject = this.createReflect();
            this.putGlobalProperty(REFLECT_CLASS_NAME, reflectObject);
            this.reflectApplyFunctionObject = JSObject.get(reflectObject, (Object)"apply");
            this.reflectConstructFunctionObject = JSObject.get(reflectObject, (Object)"construct");
            this.putGlobalProperty("Proxy", this.getProxyConstructor());
            this.putGlobalProperty("Promise", this.getPromiseConstructor());
        }
        if (this.context.isOptionSharedArrayBuffer()) {
            this.putGlobalProperty(SHARED_ARRAY_BUFFER_CLASS_NAME, this.getSharedArrayBufferConstructor());
        }
        if (this.context.isOptionAtomics()) {
            this.putGlobalProperty(ATOMICS_CLASS_NAME, this.createAtomics());
        }
        if (this.context.getEcmaScriptVersion() >= 10) {
            this.putGlobalProperty("globalThis", global);
        }
        if (this.context.getEcmaScriptVersion() >= 12) {
            this.putGlobalProperty("WeakRef", this.getWeakRefConstructor());
        }
        if (this.context.getContextOptions().isGraalBuiltin()) {
            this.putGraalObject();
        }
        if (JSTruffleOptions.ProfileTime) {
            System.out.println("SetupGlobals: " + (System.nanoTime() - time) / 1000000L);
        }
    }

    private void initGlobalNashornExtensions() {
        assert (this.getContext().isOptionNashornCompatibilityMode());
        this.putGlobalProperty("JSAdapter", this.jsAdapterConstructor);
        this.putGlobalProperty("exit", this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "exit"));
        this.putGlobalProperty("quit", this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "quit"));
        DynamicObject parseToJSON = this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "parseToJSON");
        this.putGlobalProperty("parseToJSON", parseToJSON);
    }

    private void removeNashornIncompatibleBuiltins() {
        assert (this.getContext().isOptionNashornCompatibilityMode());
        JSObject.delete(this.typedArrayPrototype, "join");
    }

    private void addPrintGlobals() {
        if (this.context.getContextOptions().isPrint()) {
            this.putGlobalProperty("print", this.lookupFunction(GlobalBuiltins.GLOBAL_PRINT, "print"));
            this.putGlobalProperty("printErr", this.lookupFunction(GlobalBuiltins.GLOBAL_PRINT, "printErr"));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void addCommonJSGlobals() {
        if (this.getContext().getContextOptions().isCommonJSRequire()) {
            String cwdOption = this.getContext().getContextOptions().getRequireCwd();
            TruffleFile cwdFile = this.getEnv().getPublicTruffleFile(cwdOption);
            try {
                if (cwdOption != null && !cwdFile.exists(new LinkOption[0])) {
                    throw Errors.createError("Invalid CommonJS root folder: " + cwdOption);
                }
            }
            catch (SecurityException se) {
                throw Errors.createError("Access denied to CommonJS root folder: " + cwdOption);
            }
            DynamicObject requireFunction = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, "require");
            DynamicObject resolveFunction = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, "resolve");
            JSObject.set(requireFunction, "resolve", (Object)resolveFunction);
            this.putGlobalProperty("require", requireFunction);
            DynamicObject dirnameGetter = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, GlobalCommonJSRequireBuiltins.GlobalRequire.dirnameGetter.getName());
            JSObject.defineOwnProperty(this.getGlobalObject(), "__dirname", PropertyDescriptor.createAccessor(dirnameGetter, Undefined.instance, false, false));
            DynamicObject filenameGetter = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, GlobalCommonJSRequireBuiltins.GlobalRequire.filenameGetter.getName());
            JSObject.defineOwnProperty(this.getGlobalObject(), "__filename", PropertyDescriptor.createAccessor(filenameGetter, Undefined.instance, false, false));
            DynamicObject moduleGetter = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, GlobalCommonJSRequireBuiltins.GlobalRequire.globalModuleGetter.getName());
            JSObject.defineOwnProperty(this.getGlobalObject(), "module", PropertyDescriptor.createAccessor(moduleGetter, Undefined.instance, false, false));
            DynamicObject exportsGetter = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, GlobalCommonJSRequireBuiltins.GlobalRequire.globalExportsGetter.getName());
            JSObject.defineOwnProperty(this.getGlobalObject(), "exports", PropertyDescriptor.createAccessor(exportsGetter, Undefined.instance, false, false));
            this.commonJSRequireFunctionObject = requireFunction;
            String commonJSRequireGlobals = this.getContext().getContextOptions().getCommonJSRequireGlobals();
            if (commonJSRequireGlobals != null && !commonJSRequireGlobals.isEmpty()) {
                JSFunction.call(JSArguments.create(this.commonJSRequireFunctionObject, this.commonJSRequireFunctionObject, commonJSRequireGlobals));
            }
            Map<String, String> commonJSRequireBuiltins = this.getContext().getContextOptions().getCommonJSRequireBuiltins();
            this.commonJSPreLoadedBuiltins = new HashMap<String, DynamicObject>();
            for (Map.Entry<String, String> entry : commonJSRequireBuiltins.entrySet()) {
                String builtinModule = entry.getValue();
                DynamicObject obj = (DynamicObject)JSFunction.call(JSArguments.create(this.commonJSRequireFunctionObject, this.commonJSRequireFunctionObject, builtinModule));
                this.commonJSPreLoadedBuiltins.put(entry.getKey(), obj);
            }
        }
    }

    private void addLoadGlobals() {
        if (this.getContext().getContextOptions().isLoad()) {
            this.putGlobalProperty("load", this.lookupFunction(GlobalBuiltins.GLOBAL_LOAD, "load"));
            this.putGlobalProperty("loadWithNewGlobal", this.lookupFunction(GlobalBuiltins.GLOBAL_LOAD, "loadWithNewGlobal"));
        }
    }

    private void addPerformanceGlobal() {
        if (this.context.getContextOptions().isPerformance()) {
            this.putGlobalProperty(PERFORMANCE_CLASS_NAME, this.preinitPerformanceObject != null ? this.preinitPerformanceObject : this.createPerformanceObject());
        }
    }

    public void addOptionalGlobals() {
        assert (!this.getEnv().isPreInitialization());
        this.addGlobalGlobal();
        this.addShellGlobals();
        this.addScriptingGlobals();
        this.addIntlGlobal();
        this.addLoadGlobals();
        this.addConsoleGlobals();
        this.addPrintGlobals();
        this.addPerformanceGlobal();
        this.addCommonJSGlobals();
        if (this.isJavaInteropEnabled()) {
            this.setupJavaInterop();
        }
    }

    private void addGlobalGlobal() {
        if (this.getContext().getContextOptions().isGlobalProperty()) {
            this.putGlobalProperty("global", this.getGlobalObject());
        }
    }

    private void addShellGlobals() {
        if (this.getContext().getContextOptions().isShell()) {
            GlobalBuiltins.GLOBAL_SHELL.forEachBuiltin(builtin -> {
                JSFunctionData functionData = builtin.createFunctionData(this.getContext());
                this.putGlobalProperty(builtin.getKey(), JSFunction.create(this, functionData), builtin.getAttributeFlags());
            });
        }
    }

    private void addIntlGlobal() {
        if (this.context.isOptionIntl402()) {
            this.putGlobalProperty("Intl", this.preinitIntlObject != null ? this.preinitIntlObject : this.createIntlObject());
        }
    }

    private DynamicObject createIntlObject() {
        DynamicObject intlObject = JSIntl.create(this);
        DynamicObject collatorFn = this.getCollatorConstructor();
        DynamicObject numberFormatFn = this.getNumberFormatConstructor();
        DynamicObject dateTimeFormatFn = this.getDateTimeFormatConstructor();
        DynamicObject pluralRulesFn = this.getPluralRulesConstructor();
        DynamicObject listFormatFn = this.getListFormatConstructor();
        DynamicObject relativeTimeFormatFn = this.getRelativeTimeFormatConstructor();
        DynamicObject segmenterFn = this.getSegmenterConstructor();
        JSObjectUtil.putDataProperty(this.context, intlObject, JSFunction.getName(collatorFn), collatorFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(this.context, intlObject, JSFunction.getName(numberFormatFn), numberFormatFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(this.context, intlObject, JSFunction.getName(dateTimeFormatFn), dateTimeFormatFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(this.context, intlObject, JSFunction.getName(pluralRulesFn), pluralRulesFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(this.context, intlObject, JSFunction.getName(listFormatFn), listFormatFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(this.context, intlObject, JSFunction.getName(relativeTimeFormatFn), relativeTimeFormatFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(this.context, intlObject, JSFunction.getName(segmenterFn), segmenterFn, JSAttributes.getDefaultNotEnumerable());
        return intlObject;
    }

    private void putGraalObject() {
        DynamicObject graalObject = JSUserObject.createInit(this);
        int flags = JSAttributes.notConfigurableEnumerableNotWritable();
        JSObjectUtil.putDataProperty(this.context, graalObject, "language", "JavaScript", flags);
        assert (GRAALVM_VERSION != null);
        JSObjectUtil.putDataProperty(this.context, graalObject, "versionGraalVM", GRAALVM_VERSION, flags);
        JSObjectUtil.putDataProperty(this.context, graalObject, "versionJS", GRAALVM_VERSION, flags);
        JSObjectUtil.putDataProperty(this.context, graalObject, "isGraalRuntime", JSFunction.create(this, JSRealm.isGraalRuntimeFunction(this.context)), flags);
        this.putGlobalProperty("Graal", graalObject);
    }

    private static JSFunctionData isGraalRuntimeFunction(JSContext context) {
        return context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.IsGraalRuntime, c -> JSFunctionData.createCallOnly(context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                return this.isGraalRuntime();
            }

            @CompilerDirectives.TruffleBoundary
            private boolean isGraalRuntime() {
                return Truffle.getRuntime().getName().contains("Graal");
            }
        }), 0, "isGraalRuntime"));
    }

    public JSConstructor getSIMDTypeConstructor(SIMDType.SIMDTypeFactory<? extends SIMDType> factory) {
        return this.simdTypeConstructors[factory.getFactoryIndex()];
    }

    private void putGlobalProperty(Object key, Object value) {
        this.putGlobalProperty(key, value, JSAttributes.getDefaultNotEnumerable());
    }

    private void putGlobalProperty(Object key, Object value, int attributes) {
        JSObjectUtil.putDataProperty(this.getContext(), this.getGlobalObject(), key, value, attributes);
    }

    private void putProperty(DynamicObject receiver, Object key, Object value) {
        JSObjectUtil.putDataProperty(this.getContext(), receiver, key, value, JSAttributes.getDefaultNotEnumerable());
    }

    private static void setupPredefinedSymbols(DynamicObject symbolFunction) {
        JSRealm.putSymbolProperty(symbolFunction, "hasInstance", Symbol.SYMBOL_HAS_INSTANCE);
        JSRealm.putSymbolProperty(symbolFunction, "isConcatSpreadable", Symbol.SYMBOL_IS_CONCAT_SPREADABLE);
        JSRealm.putSymbolProperty(symbolFunction, "iterator", Symbol.SYMBOL_ITERATOR);
        JSRealm.putSymbolProperty(symbolFunction, "asyncIterator", Symbol.SYMBOL_ASYNC_ITERATOR);
        JSRealm.putSymbolProperty(symbolFunction, "match", Symbol.SYMBOL_MATCH);
        JSRealm.putSymbolProperty(symbolFunction, "matchAll", Symbol.SYMBOL_MATCH_ALL);
        JSRealm.putSymbolProperty(symbolFunction, "replace", Symbol.SYMBOL_REPLACE);
        JSRealm.putSymbolProperty(symbolFunction, "search", Symbol.SYMBOL_SEARCH);
        JSRealm.putSymbolProperty(symbolFunction, "species", Symbol.SYMBOL_SPECIES);
        JSRealm.putSymbolProperty(symbolFunction, "split", Symbol.SYMBOL_SPLIT);
        JSRealm.putSymbolProperty(symbolFunction, "toStringTag", Symbol.SYMBOL_TO_STRING_TAG);
        JSRealm.putSymbolProperty(symbolFunction, "toPrimitive", Symbol.SYMBOL_TO_PRIMITIVE);
        JSRealm.putSymbolProperty(symbolFunction, "unscopables", Symbol.SYMBOL_UNSCOPABLES);
    }

    private static void putSymbolProperty(DynamicObject symbolFunction, String name, Symbol symbol) {
        symbolFunction.define((Object)name, (Object)symbol, JSAttributes.notConfigurableNotEnumerableNotWritable(), (s, v) -> s.allocator().constantLocation(v));
    }

    public boolean isJavaInteropEnabled() {
        return this.getEnv() != null && this.getEnv().isHostLookupAllowed();
    }

    private void setupJavaInterop() {
        assert (this.isJavaInteropEnabled());
        DynamicObject java = JSObject.createInit(this, this.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putDataProperty(this.context, java, Symbol.SYMBOL_TO_STRING_TAG, JAVA_CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putFunctionsFromContainer(this, java, JavaBuiltins.BUILTINS);
        if (this.context.isOptionNashornCompatibilityMode()) {
            JSObjectUtil.putFunctionsFromContainer(this, java, JavaBuiltins.BUILTINS_NASHORN_COMPAT);
        }
        this.putGlobalProperty(JAVA_CLASS_NAME, java);
        if (this.getEnv() != null && this.getEnv().isHostLookupAllowed() && ((Boolean)JSContextOptions.JAVA_PACKAGE_GLOBALS.getValue(this.getEnv().getOptions())).booleanValue()) {
            this.javaPackageToPrimitiveFunction = JavaPackage.createToPrimitiveFunction(this.context, this);
            this.putGlobalProperty("Packages", JavaPackage.createInit(this, ""));
            this.putGlobalProperty("java", JavaPackage.createInit(this, "java"));
            this.putGlobalProperty("javafx", JavaPackage.createInit(this, "javafx"));
            this.putGlobalProperty("javax", JavaPackage.createInit(this, "javax"));
            this.putGlobalProperty("com", JavaPackage.createInit(this, "com"));
            this.putGlobalProperty("org", JavaPackage.createInit(this, "org"));
            this.putGlobalProperty("edu", JavaPackage.createInit(this, "edu"));
            if (this.context.isOptionNashornCompatibilityMode()) {
                this.putGlobalProperty("JavaImporter", this.getJavaImporterConstructor());
            }
        }
    }

    private void setupPolyglot() {
        DynamicObject polyglotObject = JSObject.createInit(this, this.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(this, polyglotObject, PolyglotBuiltins.BUILTINS);
        if (this.getContext().isOptionDebugBuiltin()) {
            JSObjectUtil.putFunctionsFromContainer(this, polyglotObject, PolyglotBuiltins.INTERNAL_BUILTINS);
        } else if (this.getContext().getContextOptions().isPolyglotEvalFile()) {
            JSObjectUtil.putDataProperty(this.context, polyglotObject, "evalFile", this.lookupFunction(PolyglotBuiltins.INTERNAL_BUILTINS, "evalFile"), JSAttributes.getDefaultNotEnumerable());
        }
        this.putGlobalProperty(POLYGLOT_CLASS_NAME, polyglotObject);
    }

    private void addConsoleGlobals() {
        if (this.context.getContextOptions().isConsole()) {
            this.putGlobalProperty("console", this.preinitConsoleBuiltinObject != null ? this.preinitConsoleBuiltinObject : this.createConsoleObject());
        }
    }

    private DynamicObject createConsoleObject() {
        DynamicObject console = JSUserObject.createInit(this);
        JSObjectUtil.putFunctionsFromContainer(this, console, ConsoleBuiltins.BUILTINS);
        return console;
    }

    private DynamicObject createPerformanceObject() {
        DynamicObject obj = JSUserObject.createInit(this);
        JSObjectUtil.putFunctionsFromContainer(this, obj, PerformanceBuiltins.BUILTINS);
        return obj;
    }

    private DynamicObject createIteratorPrototype() {
        DynamicObject prototype = JSObject.createInit(this, this.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putDataProperty(this.context, prototype, Symbol.SYMBOL_ITERATOR, JSRealm.createIteratorPrototypeSymbolIteratorFunction(this), JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    private static DynamicObject createIteratorPrototypeSymbolIteratorFunction(JSRealm realm) {
        return JSFunction.create(realm, JSFunctionData.createCallOnly(realm.getContext(), realm.getContext().getSpeciesGetterFunctionCallTarget(), 0, "[Symbol.iterator]"));
    }

    private DynamicObject createArrayIteratorPrototype() {
        DynamicObject prototype = JSObject.createInit(this, this.iteratorPrototype, (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(this, prototype, ArrayIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(this.context, prototype, Symbol.SYMBOL_TO_STRING_TAG, "Array Iterator", JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    private DynamicObject createSetIteratorPrototype() {
        DynamicObject prototype = JSObject.createInit(this, this.iteratorPrototype, (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(this, prototype, SetIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(this.context, prototype, Symbol.SYMBOL_TO_STRING_TAG, "Set Iterator", JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    private DynamicObject createMapIteratorPrototype() {
        DynamicObject prototype = JSObject.createInit(this, this.iteratorPrototype, (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(this, prototype, MapIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(this.context, prototype, Symbol.SYMBOL_TO_STRING_TAG, "Map Iterator", JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    private DynamicObject createStringIteratorPrototype() {
        DynamicObject prototype = JSObject.createInit(this, this.iteratorPrototype, (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(this, prototype, StringIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(this.context, prototype, Symbol.SYMBOL_TO_STRING_TAG, "String Iterator", JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    private DynamicObject createRegExpStringIteratorPrototype() {
        DynamicObject prototype = JSObject.createInit(this, this.iteratorPrototype, (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(this, prototype, RegExpStringIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(this.context, prototype, Symbol.SYMBOL_TO_STRING_TAG, "RegExp String Iterator", JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    public DynamicObject getArrayProtoValuesIterator() {
        return this.arrayProtoValuesIterator;
    }

    private DynamicObject createReflect() {
        DynamicObject obj = JSObject.createInit(this, this.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putDataProperty(this.context, obj, Symbol.SYMBOL_TO_STRING_TAG, REFLECT_CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putFunctionsFromContainer(this, obj, ReflectBuiltins.BUILTINS);
        return obj;
    }

    private DynamicObject createAtomics() {
        DynamicObject obj = JSObject.createInit(this, this.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putDataProperty(this.context, obj, Symbol.SYMBOL_TO_STRING_TAG, ATOMICS_CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putFunctionsFromContainer(this, obj, AtomicsBuiltins.BUILTINS);
        return obj;
    }

    public final DynamicObject getCallSiteConstructor() {
        return this.callSiteConstructor;
    }

    public final DynamicObject getCallSitePrototype() {
        return this.callSitePrototype;
    }

    public final DynamicObject getGlobalScope() {
        return this.globalScope;
    }

    public DynamicObject getScriptEngineImportScope() {
        return this.scriptEngineImportScope;
    }

    private void addScriptingGlobals() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getContext().getParserOptions().isScripting()) {
            String timezone = this.getLocalTimeZoneId().getId();
            DynamicObject timezoneObj = JSUserObject.create(this.context, this);
            JSObjectUtil.putDataProperty(this.context, timezoneObj, "ID", timezone, JSAttributes.configurableEnumerableWritable());
            DynamicObject optionsObj = JSUserObject.create(this.context, this);
            JSObjectUtil.putDataProperty(this.context, optionsObj, "_timezone", timezoneObj, JSAttributes.configurableEnumerableWritable());
            JSObjectUtil.putDataProperty(this.context, optionsObj, "_scripting", true, JSAttributes.configurableEnumerableWritable());
            JSObjectUtil.putDataProperty(this.context, optionsObj, "_compile_only", false, JSAttributes.configurableEnumerableWritable());
            this.putGlobalProperty("$OPTIONS", optionsObj, JSAttributes.configurableNotEnumerableWritable());
            DynamicObject arguments = JSArray.createConstant(this.context, this.getEnv().getApplicationArguments());
            this.putGlobalProperty("$ARG", arguments, JSAttributes.configurableNotEnumerableWritable());
            DynamicObject envObj = JSUserObject.create(this.context, this);
            Map sysenv = this.getEnv().getEnvironment();
            for (Map.Entry entry : sysenv.entrySet()) {
                JSObjectUtil.putDataProperty(this.context, envObj, entry.getKey(), entry.getValue(), JSAttributes.configurableEnumerableWritable());
            }
            this.putGlobalProperty("$ENV", envObj, JSAttributes.configurableNotEnumerableWritable());
            this.putGlobalProperty("$EXEC", this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "exec"));
            this.putGlobalProperty("readFully", this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "readFully"));
            this.putGlobalProperty("readLine", this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "readLine"));
            this.putGlobalProperty("$EXIT", Undefined.instance);
            this.putGlobalProperty("$OUT", Undefined.instance);
            this.putGlobalProperty("$ERR", Undefined.instance);
        }
    }

    public void setRealmBuiltinObject(DynamicObject realmBuiltinObject) {
        if (this.realmBuiltinObject == null && realmBuiltinObject != null) {
            this.realmBuiltinObject = realmBuiltinObject;
            this.putGlobalProperty(REALM_BUILTIN_CLASS_NAME, realmBuiltinObject);
        }
    }

    public void initRealmBuiltinObject() {
        assert (this.context.getContextOptions().isV8RealmBuiltin());
        this.setRealmBuiltinObject(this.createRealmBuiltinObject());
    }

    private DynamicObject createRealmBuiltinObject() {
        DynamicObject obj = JSUserObject.createInit(this);
        JSObjectUtil.putDataProperty(this.getContext(), obj, Symbol.SYMBOL_TO_STRING_TAG, REALM_BUILTIN_CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putProxyProperty(obj, REALM_SHARED_PROPERTY);
        JSObjectUtil.putFunctionsFromContainer(this, obj, RealmFunctionBuiltins.BUILTINS);
        return obj;
    }

    private DynamicObject createDebugObject() {
        DynamicObject obj = JSUserObject.createInit(this);
        JSObjectUtil.putDataProperty(this.context, obj, Symbol.SYMBOL_TO_STRING_TAG, DEBUG_CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putFunctionsFromContainer(this, obj, DebugBuiltins.BUILTINS);
        return obj;
    }

    public void setArguments(Object[] arguments) {
        JSObjectUtil.defineDataProperty(this.context, this.getGlobalObject(), ARGUMENTS_NAME, JSArray.createConstant(this.context, arguments), this.context.isOptionV8CompatibilityModeInContextInit() ? JSAttributes.getDefault() : JSAttributes.getDefaultNotEnumerable());
    }

    public final DynamicObject getJSAdapterConstructor() {
        return this.jsAdapterConstructor;
    }

    public final DynamicObject getJSAdapterPrototype() {
        return this.jsAdapterPrototype;
    }

    public final TruffleLanguage.Env getEnv() {
        return this.truffleLanguageEnv;
    }

    public boolean patchContext(TruffleLanguage.Env newEnv) {
        CompilerAsserts.neverPartOfCompilation();
        Objects.requireNonNull(newEnv, "New env cannot be null.");
        this.truffleLanguageEnv = newEnv;
        this.getContext().setAllocationReporter(newEnv);
        this.getContext().getContextOptions().setOptionValues(newEnv.getOptions());
        if (newEnv.out() != this.getOutputStream()) {
            this.setOutputWriter(null, newEnv.out());
        }
        if (newEnv.err() != this.getErrorStream()) {
            this.setErrorWriter(null, newEnv.err());
        }
        this.addOptionalGlobals();
        this.addArgumentsFromEnv(newEnv);
        if (this.localTimeZoneHolder != null) {
            this.localTimeZoneHolder = this.getTimeZoneFromEnv();
        }
        this.initTimeOffsetAndRandom();
        return true;
    }

    public void initialize() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getEnv().isPreInitialization()) {
            this.preinitializeObjects();
            return;
        }
        this.addOptionalGlobals();
        this.addArgumentsFromEnv(this.getEnv());
        this.initTimeOffsetAndRandom();
    }

    private void preinitializeObjects() {
        this.preinitIntlObject = this.createIntlObject();
        this.preinitConsoleBuiltinObject = this.createConsoleObject();
        this.preinitPerformanceObject = this.createPerformanceObject();
    }

    private void addArgumentsFromEnv(TruffleLanguage.Env newEnv) {
        Object[] applicationArguments = newEnv.getApplicationArguments();
        if (this.context.getContextOptions().isGlobalArguments()) {
            this.setArguments(applicationArguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public JSRealm createChildRealm() {
        assert (CREATING_CHILD_REALM.get() != Boolean.TRUE);
        CREATING_CHILD_REALM.set(Boolean.TRUE);
        try {
            JSRealm jSRealm;
            TruffleContext nestedContext = this.getEnv().newContextBuilder().build();
            Object prev = nestedContext.enter();
            try {
                JSRealm childRealm = JavaScriptLanguage.getCurrentJSRealm();
                childRealm.agent = this.agent;
                childRealm.parentRealm = this;
                if (this.getContext().getContextOptions().isV8RealmBuiltin()) {
                    JSRealm topLevelRealm = this;
                    while (topLevelRealm.parentRealm != null) {
                        topLevelRealm = topLevelRealm.parentRealm;
                    }
                    topLevelRealm.addToRealmList(childRealm);
                }
                jSRealm = childRealm;
            }
            catch (Throwable throwable) {
                nestedContext.leave(prev);
                throw throwable;
            }
            nestedContext.leave(prev);
            return jSRealm;
        }
        finally {
            CREATING_CHILD_REALM.set(Boolean.FALSE);
        }
    }

    public boolean isPreparingStackTrace() {
        return this.preparingStackTrace;
    }

    public void setPreparingStackTrace(boolean preparingStackTrace) {
        this.preparingStackTrace = preparingStackTrace;
    }

    public final TruffleContext getTruffleContext() {
        return this.getEnv().getContext();
    }

    public final Object getEmbedderData() {
        return this.embedderData;
    }

    public final void setEmbedderData(Object embedderData) {
        this.embedderData = embedderData;
    }

    public Object getRegexResult() {
        assert (this.context.isOptionRegexpStaticResult());
        if (this.regexResult == null) {
            this.regexResult = TRegexUtil.getTRegexEmptyResult();
        }
        return this.regexResult;
    }

    public Object getLazyStaticRegexResultCompiledRegex() {
        return this.lazyStaticRegexResultCompiledRegex;
    }

    public String getLazyStaticRegexResultInputString() {
        return this.lazyStaticRegexResultInputString;
    }

    public long getLazyStaticRegexResultFromIndex() {
        return this.lazyStaticRegexResultFromIndex;
    }

    public void setRegexResult(Object tRegexCompiledRegex, String input, Object regexResult) {
        assert (this.context.isOptionRegexpStaticResult());
        assert (!this.context.getRegExpStaticResultUnusedAssumption().isValid());
        assert (TRegexUtil.InteropReadBooleanMemberNode.getUncached().execute(regexResult, "isMatch"));
        this.lazyStaticRegexResultCompiledRegex = tRegexCompiledRegex;
        this.lazyStaticRegexResultInputString = input;
        this.regexResult = regexResult;
    }

    private void setRegexResultLazy(Object tRegexCompiledRegex, String inputString, long fromIndex) {
        assert (this.context.isOptionRegexpStaticResult());
        assert (this.context.getRegExpStaticResultUnusedAssumption().isValid());
        this.lazyStaticRegexResultCompiledRegex = tRegexCompiledRegex;
        this.lazyStaticRegexResultInputString = inputString;
        this.lazyStaticRegexResultFromIndex = fromIndex;
    }

    public void setStaticRegexResult(JSContext context, Object compiledRegex, String input, long fromIndex, Object result) {
        CompilerAsserts.partialEvaluationConstant((Object)context);
        if (context.getRegExpStaticResultUnusedAssumption().isValid()) {
            this.setRegexResultLazy(compiledRegex, input, fromIndex);
        } else {
            this.setRegexResult(compiledRegex, input, result);
        }
    }

    public OptionValues getOptions() {
        return this.getEnv().getOptions();
    }

    public final PrintWriter getOutputWriter() {
        return this.outputWriter;
    }

    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    public final PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public final OutputStream getErrorStream() {
        return this.errorStream;
    }

    public final void setOutputWriter(Writer writer, OutputStream stream) {
        if (writer instanceof PrintWriterWrapper) {
            this.outputWriter.setFrom((PrintWriterWrapper)writer);
        } else if (stream != null) {
            this.outputWriter.setDelegate(stream);
        } else {
            this.outputWriter.setDelegate(writer);
        }
        this.outputStream = stream;
    }

    public final void setErrorWriter(Writer writer, OutputStream stream) {
        if (writer instanceof PrintWriterWrapper) {
            this.errorWriter.setFrom((PrintWriterWrapper)writer);
        } else if (stream != null) {
            this.errorWriter.setDelegate(stream);
        } else {
            this.errorWriter.setDelegate(writer);
        }
        this.errorStream = stream;
    }

    public long nanoTime() {
        return this.nanoTime(this.nanoToZeroTimeOffset);
    }

    public long nanoTime(long offset) {
        long last;
        long ns = System.nanoTime() + offset;
        long resolution = this.getContext().getTimerResolution();
        if (resolution > 0L) {
            return ns / resolution * resolution;
        }
        long fuzz = this.random.nextLong(1000000L) + 1L;
        if ((ns -= ns % fuzz) > (last = this.lastFuzzyTime)) {
            this.lastFuzzyTime = ns;
            return ns;
        }
        return last;
    }

    public long currentTimeMillis() {
        return this.nanoTime(this.nanoToCurrentTimeOffset) / 1000000L;
    }

    public JSConsoleUtil getConsoleUtil() {
        return this.consoleUtil;
    }

    public JSModuleLoader getModuleLoader() {
        if (this.moduleLoader == null) {
            this.createModuleLoader();
        }
        return this.moduleLoader;
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void createModuleLoader() {
        if (this.moduleLoader == null) {
            this.moduleLoader = new JSModuleLoader(){
                private final Map<String, JSModuleRecord> moduleMap = new HashMap<String, JSModuleRecord>();

                @Override
                public JSModuleRecord resolveImportedModule(ScriptOrModule referrer, String specifier) {
                    String refPath = referrer == null ? null : referrer.getSource().getPath();
                    try {
                        TruffleFile moduleFile;
                        if (refPath == null) {
                            moduleFile = JSRealm.this.getEnv().getPublicTruffleFile(specifier).getCanonicalFile(new LinkOption[0]);
                        } else {
                            TruffleFile refFile = JSRealm.this.getEnv().getPublicTruffleFile(refPath);
                            moduleFile = refFile.resolveSibling(specifier).getCanonicalFile(new LinkOption[0]);
                        }
                        String canonicalPath = moduleFile.getPath();
                        JSModuleRecord existingModule = this.moduleMap.get(canonicalPath);
                        if (existingModule != null) {
                            return existingModule;
                        }
                        Source source = Source.newBuilder((String)"js", (TruffleFile)moduleFile).name(specifier).build();
                        JSModuleRecord newModule = JSRealm.this.getContext().getEvaluator().parseModule(JSRealm.this.getContext(), source, this);
                        this.moduleMap.put(canonicalPath, newModule);
                        return newModule;
                    }
                    catch (IOException | SecurityException e) {
                        throw Errors.createErrorFromException(e);
                    }
                }

                @Override
                public JSModuleRecord loadModule(Source source) {
                    String canonicalPath;
                    String path = source.getPath();
                    if (path == null) {
                        canonicalPath = source.getName();
                    } else {
                        try {
                            TruffleFile moduleFile = JSRealm.this.getEnv().getPublicTruffleFile(path);
                            canonicalPath = moduleFile.getCanonicalFile(new LinkOption[0]).getPath();
                        }
                        catch (IOException | SecurityException e) {
                            throw Errors.createErrorFromException(e);
                        }
                    }
                    return this.moduleMap.computeIfAbsent(canonicalPath, key -> JSRealm.this.getContext().getEvaluator().parseModule(JSRealm.this.getContext(), source, this));
                }
            };
        }
    }

    public final JSAgent getAgent() {
        assert (this.agent != null);
        return this.agent;
    }

    public void setAgent(JSAgent newAgent) {
        assert (newAgent != null) : "Cannot set a null agent!";
        CompilerAsserts.neverPartOfCompilation((String)"Assigning agent to context in compiled code");
        this.agent = newAgent;
    }

    private LocalTimeZoneHolder getLocalTimeZoneHolder() {
        LocalTimeZoneHolder holder = this.localTimeZoneHolder;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (holder == null ? 1 : 0) != 0)) {
            if (CompilerDirectives.isPartialEvaluationConstant((Object)holder)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            this.localTimeZoneHolder = holder = this.getTimeZoneFromEnv();
        }
        return holder;
    }

    @CompilerDirectives.TruffleBoundary
    private LocalTimeZoneHolder getTimeZoneFromEnv() {
        OptionValues options = this.getEnv().getOptions();
        if (JSContextOptions.TIME_ZONE.hasBeenSet(options)) {
            return new LocalTimeZoneHolder(TimeZone.getTimeZone((String)JSContextOptions.TIME_ZONE.getValue(options)).toZoneId());
        }
        return new LocalTimeZoneHolder(this.getEnv().getTimeZone());
    }

    public final ZoneId getLocalTimeZoneId() {
        return this.getLocalTimeZoneHolder().localTimeZoneId;
    }

    public final long getLocalTZA() {
        return this.getLocalTimeZoneHolder().localTZA;
    }

    private void initTimeOffsetAndRandom() {
        assert (!this.getEnv().isPreInitialization());
        this.random = new SplittableRandom();
        this.nanoToZeroTimeOffset = -System.nanoTime();
        this.nanoToCurrentTimeOffset = System.currentTimeMillis() * 1000000L + this.nanoToZeroTimeOffset;
        this.lastFuzzyTime = Long.MIN_VALUE;
    }

    public final SplittableRandom getRandom() {
        return this.random;
    }

    public JSRealm getParent() {
        return this.parentRealm;
    }

    public JavaScriptNode getCallNode() {
        return this.callNode;
    }

    public void setCallNode(JavaScriptNode callNode) {
        this.callNode = callNode;
    }

    void initRealmList() {
        CompilerAsserts.neverPartOfCompilation();
        this.realmList = new ArrayList<JSRealm>();
    }

    synchronized void addToRealmList(JSRealm newRealm) {
        CompilerAsserts.neverPartOfCompilation();
        assert (!this.realmList.contains(newRealm));
        this.realmList.add(newRealm);
    }

    public synchronized JSRealm getFromRealmList(int idx) {
        CompilerAsserts.neverPartOfCompilation();
        return 0 <= idx && idx < this.realmList.size() ? this.realmList.get(idx) : null;
    }

    public synchronized int getIndexFromRealmList(JSRealm rlm) {
        CompilerAsserts.neverPartOfCompilation();
        return this.realmList.indexOf(rlm);
    }

    public synchronized void removeFromRealmList(int idx) {
        CompilerAsserts.neverPartOfCompilation();
        this.realmList.set(idx, null);
    }

    public JSRealm getCurrentV8Realm() {
        return this.v8RealmCurrent;
    }

    public void setCurrentV8Realm(JSRealm realm) {
        this.v8RealmCurrent = realm;
    }

    public final Map<TruffleFile, DynamicObject> getCommonJSRequireCache() {
        assert (this.context.getContextOptions().isCommonJSRequire());
        return this.commonJSRequireCache;
    }

    private static class RealmSharedPropertyProxy
    implements PropertyProxy {
        private RealmSharedPropertyProxy() {
        }

        @Override
        public Object get(DynamicObject store) {
            JSContext context = JSObject.getJSContext(store);
            return RealmSharedPropertyProxy.topLevelRealm((JSContext)context).v8RealmShared;
        }

        @Override
        public boolean set(DynamicObject store, Object value) {
            JSContext context = JSObject.getJSContext(store);
            RealmSharedPropertyProxy.topLevelRealm((JSContext)context).v8RealmShared = value;
            return true;
        }

        private static JSRealm topLevelRealm(JSContext context) {
            JSRealm realm = context.getRealm();
            while (realm.getParent() != null) {
                realm = realm.getParent();
            }
            return realm;
        }
    }
}

