/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PromiseReactionJobNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.PromiseReactionRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;

public class ImportCallNode
extends JavaScriptNode {
    @Node.Child
    private JavaScriptNode argRefNode;
    @Node.Child
    private JavaScriptNode activeScriptOrModuleNode;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapabilityNode;
    @Node.Child
    private JSToStringNode toStringNode;
    @Node.Child
    private PromiseReactionJobNode promiseReactionJobNode;
    @Node.Child
    private JSFunctionCallNode callRejectNode;
    @Node.Child
    private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
    private final JSContext context;
    private final ValueProfile typeProfile = ValueProfile.createClassProfile();

    protected ImportCallNode(JSContext context, JavaScriptNode argRefNode, JavaScriptNode activeScriptOrModuleNode) {
        this.context = context;
        this.argRefNode = argRefNode;
        this.activeScriptOrModuleNode = activeScriptOrModuleNode;
        this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
        this.toStringNode = JSToStringNode.create();
        this.promiseReactionJobNode = PromiseReactionJobNode.create(context);
    }

    public static ImportCallNode create(JSContext context, JavaScriptNode argRefNode, JavaScriptNode activeScriptOrModuleNode) {
        return new ImportCallNode(context, argRefNode, activeScriptOrModuleNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        String specifierString;
        Object referencingScriptOrModule = this.getActiveScriptOrModule(frame);
        Object specifier = this.argRefNode.execute(frame);
        try {
            specifierString = this.toStringNode.executeString(specifier);
        }
        catch (Throwable ex) {
            if (TryCatchNode.shouldCatch(ex, this.typeProfile)) {
                return this.newRejectedPromiseFromException(ex);
            }
            throw ex;
        }
        return this.hostImportModuleDynamically(referencingScriptOrModule, specifierString);
    }

    private Object getActiveScriptOrModule(VirtualFrame frame) {
        if (this.activeScriptOrModuleNode != null) {
            return this.activeScriptOrModuleNode.execute(frame);
        }
        return new ScriptOrModule(this.context, this.getEncapsulatingSourceSection().getSource());
    }

    private DynamicObject hostImportModuleDynamically(Object referencingScriptOrModule, String specifier) {
        JSRealm realm = this.context.getRealm();
        if (this.context.hasImportModuleDynamicallyCallbackBeenSet()) {
            DynamicObject promise = this.context.hostImportModuleDynamically(realm, (ScriptOrModule)referencingScriptOrModule, specifier);
            if (promise == null) {
                return this.newRejectedPromiseFromException(ImportCallNode.createTypeErrorCannotImport(specifier));
            }
            assert (JSPromise.isJSPromise(promise));
            return promise;
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        this.context.promiseEnqueueJob(realm, this.createImportModuleDynamicallyJob((ScriptOrModule)referencingScriptOrModule, specifier, promiseCapability));
        return promiseCapability.getPromise();
    }

    private PromiseCapabilityRecord newPromiseCapability() {
        if (this.newPromiseCapabilityNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.newPromiseCapabilityNode = (NewPromiseCapabilityNode)this.insert(NewPromiseCapabilityNode.create(this.context));
        }
        return this.newPromiseCapabilityNode.executeDefault();
    }

    private DynamicObject newRejectedPromiseFromException(Throwable ex) {
        if (this.callRejectNode == null || this.getErrorObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        this.callRejectNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), this.getErrorObjectNode.execute(ex)));
        return promiseCapability.getPromise();
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException createTypeErrorCannotImport(String specifier) {
        return Errors.createError("Cannot dynamically import module: " + specifier);
    }

    public DynamicObject createImportModuleDynamicallyJob(ScriptOrModule referencingScriptOrModule, String specifier, PromiseCapabilityRecord promiseCapability) {
        Pair<ScriptOrModule, String> request = new Pair<ScriptOrModule, String>(referencingScriptOrModule, specifier);
        return this.promiseReactionJobNode.execute(PromiseReactionRecord.create(promiseCapability, this.createImportModuleDynamicallyHandler(), true), request);
    }

    private DynamicObject createImportModuleDynamicallyHandler() {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ImportModuleDynamically, c -> ImportCallNode.createImportModuleDynamicallyHandlerImpl(c));
        return JSFunction.create(this.context.getRealm(), functionData);
    }

    private static JSFunctionData createImportModuleDynamicallyHandlerImpl(JSContext context) {
        class ImportModuleDynamicallyRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode argumentNode = AccessIndexedArgumentNode.create(0);
            final /* synthetic */ JSContext val$context;

            ImportModuleDynamicallyRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            public Object execute(VirtualFrame frame) {
                Pair request = (Pair)this.argumentNode.execute(frame);
                ScriptOrModule referencingScriptOrModule = (ScriptOrModule)request.getFirst();
                String specifier = (String)request.getSecond();
                JSModuleRecord moduleRecord = this.val$context.getEvaluator().hostResolveImportedModule(this.val$context, referencingScriptOrModule, specifier);
                JSRealm realm = this.val$context.getRealm();
                this.val$context.getEvaluator().moduleInstantiation(realm, moduleRecord);
                this.val$context.getEvaluator().moduleEvaluation(realm, moduleRecord);
                return this.finishDynamicImport(moduleRecord, referencingScriptOrModule, specifier);
            }

            private Object finishDynamicImport(JSModuleRecord moduleRecord, ScriptOrModule referencingScriptOrModule, String specifier) {
                assert (moduleRecord == this.val$context.getEvaluator().hostResolveImportedModule(this.val$context, referencingScriptOrModule, specifier));
                assert (moduleRecord.isEvaluated());
                return this.val$context.getEvaluator().getModuleNamespace(moduleRecord);
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new ImportModuleDynamicallyRootNode(context));
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 0, "");
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return ImportCallNode.create(this.context, ImportCallNode.cloneUninitialized(this.argRefNode), ImportCallNode.cloneUninitialized(this.activeScriptOrModuleNode));
    }
}

