/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.builtins.JSClass;

public abstract class RequireObjectCoercibleNode
extends JavaScriptBaseNode {
    protected RequireObjectCoercibleNode() {
    }

    public static RequireObjectCoercibleNode create() {
        return RequireObjectCoercibleNodeGen.create();
    }

    public final Object execute(Object operand) {
        this.executeVoid(operand);
        return operand;
    }

    public abstract void executeVoid(Object var1);

    @Specialization
    protected static void doInt(int value) {
    }

    @Specialization
    protected static void doLargeInteger(LargeInteger value) {
    }

    @Specialization
    protected static void doLong(long value) {
    }

    @Specialization
    protected static void doDouble(double value) {
    }

    @Specialization
    protected static void doCharSequence(CharSequence value) {
    }

    @Specialization
    protected static void doBoolean(boolean value) {
    }

    @Specialization(guards={"cachedShape != null", "cachedShape.check(object)"}, limit="1")
    protected static void doCachedShape(DynamicObject object, @Cached(value="getShapeIfObject(object)") Shape cachedShape) {
    }

    @Specialization(guards={"cachedClass != null", "cachedClass.isInstance(object)"}, limit="1", replaces={"doCachedShape"})
    protected static void doCachedJSClass(DynamicObject object, @Cached(value="getJSClassIfObject(object)") JSClass cachedClass) {
    }

    @Specialization(guards={"!isNullOrUndefined(object)"}, replaces={"doCachedJSClass"})
    protected static void doObjectCoercible(Object object) {
        assert (object != null);
    }

    @Specialization(guards={"isNullOrUndefined(object)"})
    protected void doNullOrUndefined(DynamicObject object) {
        throw Errors.createTypeErrorNotObjectCoercible(object, this);
    }

    protected static Shape getShapeIfObject(DynamicObject object) {
        if (JSGuards.isJSObject(object)) {
            return object.getShape();
        }
        return null;
    }

    public static abstract class RequireObjectCoercibleWrapperNode
    extends JSUnaryNode {
        @Node.Child
        private RequireObjectCoercibleNode requireObjectCoercibleNode = RequireObjectCoercibleNode.create();

        protected RequireObjectCoercibleWrapperNode(JavaScriptNode operand) {
            super(operand);
        }

        public static RequireObjectCoercibleWrapperNode create(JavaScriptNode child) {
            return RequireObjectCoercibleNodeGen.RequireObjectCoercibleWrapperNodeGen.create(child);
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return this.getOperand().isResultAlwaysOfType(clazz);
        }

        @Specialization
        protected Object doDefault(Object value) {
            return this.requireObjectCoercibleNode.execute(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized() {
            return RequireObjectCoercibleWrapperNode.create(RequireObjectCoercibleWrapperNode.cloneUninitialized(this.getOperand()));
        }
    }
}

