/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.LocalVarIncNode;
import com.oracle.truffle.js.nodes.access.LocalVarPostfixIncMaterializedNode;
import com.oracle.truffle.js.nodes.access.LocalVarPostfixIncNodeGen;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.LargeInteger;
import java.util.Set;

abstract class LocalVarPostfixIncNode
extends LocalVarIncNode {
    protected LocalVarPostfixIncNode(LocalVarIncNode.LocalVarOp op, FrameSlot frameSlot, boolean hasTemporalDeadZone, ScopeFrameNode scopeFrameNode) {
        super(op, frameSlot, hasTemporalDeadZone, scopeFrameNode);
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.ReadVariableTag.class) || materializedTags.contains(JSTags.WriteVariableTag.class) || materializedTags.contains(StandardTags.ReadVariableTag.class) || materializedTags.contains(StandardTags.WriteVariableTag.class)) {
            return new LocalVarPostfixIncMaterializedNode(this);
        }
        return this;
    }

    @Specialization(guards={"isBoolean(frame)", "isIntegerKind(frame)"})
    public int doBoolean(Frame frame) {
        int value = JSRuntime.booleanToNumber(this.getBoolean(frame));
        int newValue = this.op.doInt(value);
        frame.setInt(this.frameSlot, newValue);
        return value;
    }

    @Specialization(guards={"isBoolean(frame)", "isDoubleKind(frame)"}, replaces={"doBoolean"})
    public int doBooleanDouble(Frame frame) {
        int value = JSRuntime.booleanToNumber(this.getBoolean(frame));
        int newValue = this.op.doInt(value);
        frame.setDouble(this.frameSlot, (double)newValue);
        return value;
    }

    @Specialization(guards={"isBoolean(frame)", "ensureObjectKind(frame)"}, replaces={"doBooleanDouble"})
    public int doBooleanObject(Frame frame) {
        int value = JSRuntime.booleanToNumber(this.getBoolean(frame));
        int newValue = this.op.doInt(value);
        frame.setObject(this.frameSlot, (Object)newValue);
        return value;
    }

    @Specialization(guards={"isInt(frame)", "isIntegerKind(frame)"}, rewriteOn={ArithmeticException.class})
    public int doInt(Frame frame) {
        int value = this.getInt(frame);
        int newValue = this.op.doInt(value);
        frame.setInt(this.frameSlot, newValue);
        return value;
    }

    @Specialization(guards={"isInt(frame)", "isDoubleKind(frame)"}, replaces={"doInt"})
    public int doIntDouble(Frame frame) {
        int value = this.getInt(frame);
        double newValue = this.op.doDouble(value);
        frame.setDouble(this.frameSlot, newValue);
        return value;
    }

    @Specialization(guards={"isInt(frame)", "ensureObjectKind(frame)"}, replaces={"doIntDouble"})
    public int doIntObject(Frame frame) {
        int value = this.getInt(frame);
        double newValue = this.op.doDouble(value);
        frame.setObject(this.frameSlot, (Object)newValue);
        return value;
    }

    @Specialization(guards={"isDouble(frame)", "isDoubleKind(frame)"})
    public double doDouble(Frame frame) {
        double doubleValue = this.getDouble(frame);
        frame.setDouble(this.frameSlot, this.op.doDouble(doubleValue));
        return doubleValue;
    }

    @Specialization(guards={"isDouble(frame)", "ensureObjectKind(frame)"}, replaces={"doDouble"})
    public double doDoubleObject(Frame frame) {
        double doubleValue = this.getDouble(frame);
        frame.setObject(this.frameSlot, (Object)this.op.doDouble(doubleValue));
        return doubleValue;
    }

    @Specialization(guards={"isObject(frame)", "ensureObjectKind(frame)"})
    public Object doObject(Frame frame, @Cached(value="createBinaryProfile()") ConditionProfile isIntegerProfile, @Cached(value="createBinaryProfile()") ConditionProfile isBigIntProfile, @Cached(value="createBinaryProfile()") ConditionProfile isBoundaryProfile, @Cached(value="create()") JSToNumericNode toNumeric, @Cached(value="create()") BranchProfile deadBranch) {
        Object number;
        Object value = this.getObject(frame);
        if (this.hasTemporalDeadZone()) {
            this.checkNotDead(value, deadBranch);
        }
        if (isBigIntProfile.profile((number = toNumeric.execute(value)) instanceof BigInt)) {
            frame.setObject(this.frameSlot, (Object)this.op.doBigInt((BigInt)number));
        } else {
            frame.setObject(this.frameSlot, (Object)this.op.doNumber((Number)number, isIntegerProfile, isBoundaryProfile));
        }
        return number;
    }

    @Specialization(guards={"isLong(frame)", "isLongKind(frame)"}, rewriteOn={ArithmeticException.class})
    public LargeInteger doLargeInteger(Frame frame) {
        LargeInteger oldValue = LargeInteger.valueOf(this.getLong(frame));
        LargeInteger newValue = this.op.doLargeInteger(oldValue);
        frame.setLong(this.frameSlot, newValue.longValue());
        return oldValue;
    }

    @Specialization(guards={"isLong(frame)", "isDoubleKind(frame)"}, replaces={"doLargeInteger"})
    public double doLargeIntegerToDouble(Frame frame) {
        double oldValue = this.getLong(frame);
        double newValue = this.op.doDouble(oldValue);
        frame.setDouble(this.frameSlot, newValue);
        return oldValue;
    }

    @Specialization(guards={"isLong(frame)", "ensureObjectKind(frame)"}, replaces={"doLargeIntegerToDouble"})
    public double doLargeIntegerObject(Frame frame) {
        double oldValue = this.getLong(frame);
        double newValue = this.op.doDouble(oldValue);
        frame.setObject(this.frameSlot, (Object)newValue);
        return oldValue;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return LocalVarPostfixIncNodeGen.create(this.op, this.getFrameSlot(), this.hasTemporalDeadZone(), (ScopeFrameNode)NodeUtil.cloneNode((Node)this.getLevelFrameNode()));
    }
}

