/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.SetPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNodeGen;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;

public final class SetPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<SetPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new SetPrototypeBuiltins();

    protected SetPrototypeBuiltins() {
        super("Set.prototype", SetPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SetPrototype builtinEnum) {
        switch (builtinEnum) {
            case clear: {
                return SetPrototypeBuiltinsFactory.JSSetClearNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case delete: {
                return SetPrototypeBuiltinsFactory.JSSetDeleteNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case add: {
                return SetPrototypeBuiltinsFactory.JSSetAddNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case has: {
                return SetPrototypeBuiltinsFactory.JSSetHasNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case forEach: {
                return SetPrototypeBuiltinsFactory.JSSetForEachNodeGen.create(context, builtin, SetPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case values: {
                return SetPrototypeBuiltinsFactory.CreateSetIteratorNodeGen.create(context, builtin, 2, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case entries: {
                return SetPrototypeBuiltinsFactory.CreateSetIteratorNodeGen.create(context, builtin, 3, SetPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class CreateSetIteratorNode
    extends JSBuiltinNode {
        private final int iterationKind;
        @Node.Child
        private CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode;
        @Node.Child
        private PropertySetNode setNextIndexNode;
        @Node.Child
        private PropertySetNode setIteratedObjectNode;
        @Node.Child
        private PropertySetNode setIterationKindNode;

        public CreateSetIteratorNode(JSContext context, JSBuiltin builtin, int iterationKind) {
            super(context, builtin);
            this.iterationKind = iterationKind;
            this.createObjectNode = CreateObjectNode.createWithPrototype(context, null);
            this.setIteratedObjectNode = PropertySetNode.createSetHidden(JSRuntime.ITERATED_OBJECT_ID, context);
            this.setNextIndexNode = PropertySetNode.createSetHidden(JSRuntime.ITERATOR_NEXT_INDEX, context);
            this.setIterationKindNode = PropertySetNode.createSetHidden(JSSet.SET_ITERATION_KIND_ID, context);
        }

        @Specialization(guards={"isJSSet(set)"})
        protected DynamicObject doSet(VirtualFrame frame, DynamicObject set) {
            DynamicObject iterator = this.createObjectNode.executeDynamicObject(frame, this.getContext().getRealm().getSetIteratorPrototype());
            this.setIteratedObjectNode.setValue(iterator, set);
            this.setNextIndexNode.setValue(iterator, JSSet.getInternalSet(set).getEntries());
            this.setIterationKindNode.setValueInt(iterator, this.iterationKind);
            return iterator;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected DynamicObject doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeError("not a Set");
        }
    }

    public static abstract class JSSetForEachNode
    extends JSSetOperation {
        public JSSetForEachNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSSet(thisObj)", "isCallable.executeBoolean(callback)"}, limit="1")
        protected Object forEachFunction(DynamicObject thisObj, DynamicObject callback, Object thisArg, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable, @Cached(value="createCall()") JSFunctionCallNode callNode) {
            JSHashMap map = JSSet.getInternalSet(thisObj);
            JSHashMap.Cursor cursor = map.getEntries();
            while (cursor.advance()) {
                Object key = cursor.getKey();
                callNode.executeCall(JSArguments.create(thisArg, callback, key, key, thisObj));
            }
            return Undefined.instance;
        }

        @Specialization(guards={"isJSSet(thisObj)", "!isCallable.executeBoolean(callback)"}, limit="1")
        protected static Object forEachFunctionNoFunction(Object thisObj, Object callback, Object thisArg, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable) {
            throw Errors.createTypeErrorCallableExpected();
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static Object forEachFunctionNoSet(Object thisObj, Object callback, Object thisArg) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetHasNode
    extends JSSetOperation {
        public JSSetHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSSet(thisObj)"})
        protected boolean has(DynamicObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSSet.getInternalSet(thisObj).has(normalizedKey);
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected boolean hasNoObject(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetAddNode
    extends JSSetOperation {
        public JSSetAddNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSSet(thisObj)"})
        protected DynamicObject add(DynamicObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            JSSet.getInternalSet(thisObj).put(normalizedKey, PRESENT);
            return thisObj;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static DynamicObject notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetDeleteNode
    extends JSSetOperation {
        public JSSetDeleteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSSet(thisObj)"})
        protected boolean delete(DynamicObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSSet.getInternalSet(thisObj).remove(normalizedKey);
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static boolean notSet(Object thisObj, Object key) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetClearNode
    extends JSSetOperation {
        public JSSetClearNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSSet(thisObj)"})
        protected static DynamicObject clear(DynamicObject thisObj) {
            JSSet.getInternalSet(thisObj).clear();
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSSet(thisObj)"})
        protected static DynamicObject notSet(Object thisObj) {
            throw Errors.createTypeErrorSetExpected();
        }
    }

    public static abstract class JSSetOperation
    extends JSBuiltinNode {
        protected static final Object PRESENT = new Object();
        @Node.Child
        private JSCollectionsNormalizeNode normalizeNode;

        public JSSetOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected Object normalize(Object value) {
            if (this.normalizeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.normalizeNode = (JSCollectionsNormalizeNode)this.insert(JSCollectionsNormalizeNodeGen.create());
            }
            return this.normalizeNode.execute(value);
        }
    }

    public static enum SetPrototype implements BuiltinEnum<SetPrototype>
    {
        clear(0),
        delete(1),
        add(1),
        has(1),
        forEach(1),
        values(0),
        entries(0);

        private final int length;

        private SetPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

