/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.builtins.AsyncFromSyncIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IteratorCompleteNode;
import com.oracle.truffle.js.nodes.access.IteratorNextNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.nodes.promise.PromiseResolveNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class AsyncFromSyncIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<GeneratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new AsyncFromSyncIteratorPrototypeBuiltins();

    protected AsyncFromSyncIteratorPrototypeBuiltins() {
        super("%AsyncFromSyncIteratorPrototype%", GeneratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, GeneratorPrototype builtinEnum) {
        assert (context.getEcmaScriptVersion() >= 8);
        switch (builtinEnum) {
            case next: {
                return AsyncFromSyncIteratorPrototypeBuiltinsFactory.AsyncFromSyncNextNodeGen.create(context, builtin, AsyncFromSyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case return_: {
                return AsyncFromSyncIteratorPrototypeBuiltinsFactory.AsyncFromSyncReturnNodeGen.create(context, builtin, AsyncFromSyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case throw_: {
                return AsyncFromSyncIteratorPrototypeBuiltinsFactory.AsyncFromSyncThrowNodeGen.create(context, builtin, AsyncFromSyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class AsyncFromSyncThrow
    extends AsyncFromSyncMethod {
        @Node.Child
        private GetMethodNode getThrow;

        public AsyncFromSyncThrow(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getThrow = GetMethodNode.create(context, null, "throw");
        }

        @Override
        protected GetMethodNode getMethod() {
            return this.getThrow;
        }

        @Override
        protected Object processUndefinedMethod(VirtualFrame frame, PromiseCapabilityRecord promiseCapability, Object value) {
            this.promiseCapabilityRejectImpl(promiseCapability, value);
            return promiseCapability.getPromise();
        }

        @Specialization(guards={"isObject(thisObj)"})
        protected Object doThrow(VirtualFrame frame, DynamicObject thisObj, Object value) {
            return this.doMethod(frame, thisObj, value);
        }
    }

    public static abstract class AsyncFromSyncReturn
    extends AsyncFromSyncMethod {
        @Node.Child
        private GetMethodNode getReturn;
        @Node.Child
        private CreateIterResultObjectNode createIterResult;

        public AsyncFromSyncReturn(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getReturn = GetMethodNode.create(context, null, "return");
            this.createIterResult = CreateIterResultObjectNode.create(this.getContext());
        }

        @Override
        protected GetMethodNode getMethod() {
            return this.getReturn;
        }

        @Override
        protected Object processUndefinedMethod(VirtualFrame frame, PromiseCapabilityRecord promiseCapability, Object value) {
            DynamicObject iterResult = this.createIterResult.execute(frame, value, true);
            this.promiseCapabilityResolve(promiseCapability, iterResult);
            return promiseCapability.getPromise();
        }

        @Specialization(guards={"isObject(thisObj)"})
        protected Object resume(VirtualFrame frame, DynamicObject thisObj, Object value) {
            return this.doMethod(frame, thisObj, value);
        }
    }

    public static abstract class AsyncFromSyncMethod
    extends AsyncFromSyncBaseNode {
        @Node.Child
        private JSFunctionCallNode executeReturnMethod = JSFunctionCallNode.createCall();

        public AsyncFromSyncMethod(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected abstract GetMethodNode getMethod();

        protected abstract Object processUndefinedMethod(VirtualFrame var1, PromiseCapabilityRecord var2, Object var3);

        protected Object doMethod(VirtualFrame frame, DynamicObject thisObj, Object value) {
            Object returnResult;
            PromiseCapabilityRecord promiseCapability = this.createPromiseCapability();
            if (!this.isAsyncFromSyncIterator(thisObj)) {
                JSException typeError = Errors.createTypeErrorIncompatibleReceiver(thisObj);
                this.promiseCapabilityReject(promiseCapability, typeError);
                return promiseCapability.getPromise();
            }
            IteratorRecord syncIteratorRecord = (IteratorRecord)this.getSyncIteratorRecordNode.getValue(thisObj);
            DynamicObject syncIterator = syncIteratorRecord.getIterator();
            Object method = this.getMethod().executeWithTarget(syncIterator);
            if (method == Undefined.instance) {
                return this.processUndefinedMethod(frame, promiseCapability, value);
            }
            try {
                returnResult = this.executeReturnMethod.executeCall(JSArguments.create(syncIterator, method, value));
            }
            catch (GraalJSException e) {
                this.promiseCapabilityReject(promiseCapability, e);
                return promiseCapability.getPromise();
            }
            if (!JSObject.isJSObject(returnResult)) {
                this.promiseCapabilityReject(promiseCapability, Errors.createTypeErrorNotAnObject(returnResult));
                return promiseCapability.getPromise();
            }
            return this.asyncFromSyncIteratorContinuation((DynamicObject)returnResult, promiseCapability);
        }
    }

    public static abstract class AsyncFromSyncNext
    extends AsyncFromSyncBaseNode {
        public AsyncFromSyncNext(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isObject(thisObj)"})
        protected Object next(DynamicObject thisObj, Object value) {
            DynamicObject nextResult;
            PromiseCapabilityRecord promiseCapability = this.createPromiseCapability();
            if (!this.isAsyncFromSyncIterator(thisObj)) {
                JSException typeError = Errors.createTypeErrorIncompatibleReceiver(thisObj);
                this.promiseCapabilityReject(promiseCapability, typeError);
                return promiseCapability.getPromise();
            }
            IteratorRecord syncIteratorRecord = (IteratorRecord)this.getSyncIteratorRecordNode.getValue(thisObj);
            try {
                nextResult = this.iteratorNextNode.execute(syncIteratorRecord, value);
            }
            catch (GraalJSException e) {
                this.promiseCapabilityReject(promiseCapability, e);
                return promiseCapability.getPromise();
            }
            return this.asyncFromSyncIteratorContinuation(nextResult, promiseCapability);
        }
    }

    @ImportStatic(value={JSRuntime.class})
    private static abstract class AsyncFromSyncBaseNode
    extends JSBuiltinNode {
        static final HiddenKey DONE = new HiddenKey("Done");
        @Node.Child
        private PropertyGetNode getPromiseNode;
        @Node.Child
        private PropertyGetNode getPromiseResolveNode;
        @Node.Child
        private JSFunctionCallNode executePromiseMethodNode;
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        protected PerformPromiseThenNode performPromiseThenNode;
        @Node.Child
        private PromiseResolveNode promiseResolveNode;
        @Node.Child
        protected IteratorNextNode iteratorNextNode;
        @Node.Child
        protected IteratorValueNode iteratorValueNode;
        @Node.Child
        protected IteratorCompleteNode iteratorCompleteNode;
        @Node.Child
        protected PropertyGetNode getSyncIteratorRecordNode;
        @Node.Child
        private PropertySetNode setDoneNode;

        AsyncFromSyncBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
            this.executePromiseMethodNode = JSFunctionCallNode.createCall();
            this.iteratorNextNode = IteratorNextNode.create();
            this.iteratorCompleteNode = IteratorCompleteNode.create(context);
            this.iteratorValueNode = IteratorValueNodeGen.create(context);
            this.getSyncIteratorRecordNode = PropertyGetNode.createGetHidden(JSFunction.ASYNC_FROM_SYNC_ITERATOR_KEY, context);
            this.setDoneNode = PropertySetNode.createSetHidden(DONE, context);
            this.performPromiseThenNode = PerformPromiseThenNode.create(context);
            this.promiseResolveNode = PromiseResolveNode.create(context);
        }

        protected PromiseCapabilityRecord createPromiseCapability() {
            return this.newPromiseCapabilityNode.executeDefault();
        }

        protected boolean isAsyncFromSyncIterator(DynamicObject thiz) {
            return thiz != Undefined.instance && this.getSyncIteratorRecordNode.getValue(thiz) != Undefined.instance;
        }

        protected void promiseCapabilityReject(PromiseCapabilityRecord promiseCapability, GraalJSException exception) {
            Object result = exception.getErrorObjectEager(this.getContext());
            this.promiseCapabilityRejectImpl(promiseCapability, result);
        }

        protected void promiseCapabilityRejectImpl(PromiseCapabilityRecord promiseCapability, Object result) {
            this.executePromiseMethodNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), result));
        }

        protected void promiseCapabilityResolve(PromiseCapabilityRecord valueWrapperCapability, Object result) {
            this.executePromiseMethodNode.executeCall(JSArguments.createOneArg(Undefined.instance, valueWrapperCapability.getResolve(), result));
        }

        protected Object getPromise(DynamicObject promiseCapability) {
            return this.getPromiseNode.getValue(promiseCapability);
        }

        protected final Object asyncFromSyncIteratorContinuation(DynamicObject result, PromiseCapabilityRecord promiseCapability) {
            DynamicObject valueWrapper;
            Object returnValue;
            boolean done;
            try {
                done = this.iteratorCompleteNode.execute(result);
            }
            catch (GraalJSException e) {
                this.promiseCapabilityReject(promiseCapability, e);
                return promiseCapability.getPromise();
            }
            try {
                returnValue = this.iteratorValueNode.execute(result);
            }
            catch (GraalJSException e) {
                this.promiseCapabilityReject(promiseCapability, e);
                return promiseCapability.getPromise();
            }
            JSRealm realm = this.getContext().getRealm();
            if (this.getContext().usePromiseResolve()) {
                valueWrapper = this.promiseResolveNode.execute(realm.getPromiseConstructor(), returnValue);
            } else {
                PromiseCapabilityRecord valueWrapperCapability = this.createPromiseCapability();
                this.promiseCapabilityResolve(valueWrapperCapability, returnValue);
                valueWrapper = valueWrapperCapability.getPromise();
            }
            DynamicObject onFulfilled = this.createIteratorValueUnwrapFunction(realm, done);
            this.performPromiseThenNode.execute(valueWrapper, onFulfilled, Undefined.instance, promiseCapability);
            return promiseCapability.getPromise();
        }

        protected final DynamicObject createIteratorValueUnwrapFunction(JSRealm realm, boolean done) {
            JSContext context = realm.getContext();
            JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncFromSyncIteratorValueUnwrap, c -> AsyncFromSyncBaseNode.createIteratorValueUnwrapImpl(c));
            DynamicObject function = JSFunction.create(realm, functionData);
            this.setDoneNode.setValueBoolean(function, done);
            return function;
        }

        private static JSFunctionData createIteratorValueUnwrapImpl(JSContext context) {
            class AsyncFromSyncIteratorValueUnwrapRootNode
            extends JavaScriptRootNode {
                @Node.Child
                private JavaScriptNode valueNode = AccessIndexedArgumentNode.create(0);
                @Node.Child
                private PropertyGetNode isDoneNode = PropertyGetNode.createGetHidden(DONE, this.val$context);
                @Node.Child
                private CreateIterResultObjectNode createIterResult = CreateIterResultObjectNode.create(this.val$context);
                final /* synthetic */ JSContext val$context;

                AsyncFromSyncIteratorValueUnwrapRootNode(JSContext jSContext) {
                    this.val$context = jSContext;
                }

                public Object execute(VirtualFrame frame) {
                    boolean done;
                    DynamicObject functionObject = JSFrameUtil.getFunctionObject((Frame)frame);
                    Object value = this.valueNode.execute(frame);
                    try {
                        done = this.isDoneNode.getValueBoolean(functionObject);
                    }
                    catch (UnexpectedResultException e) {
                        throw Errors.shouldNotReachHere();
                    }
                    return this.createIterResult.execute(frame, value, done);
                }
            }
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new AsyncFromSyncIteratorValueUnwrapRootNode(context));
            return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "");
        }
    }

    public static enum GeneratorPrototype implements BuiltinEnum<GeneratorPrototype>
    {
        next(1),
        return_(1),
        throw_(1);

        private final int length;

        private GeneratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

