/*
 * Decompiled with CFR 0.152.
 */
package docusignWrapper;

import activities.RetrieveDocument;
import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.SessionUtil;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.logger.LoggerLevel;
import docusign.client.credential.BasicDocusignCredential;
import docusign.client.credential.DocuSignCredentials;
import docusign.client.dto.Document;
import docusign.client.dto.DocumentFile;
import docusign.client.dto.DocumentSignatureRequest;
import docusign.client.dto.DocumentTabCollection;
import docusign.client.dto.EnvelopeDocument;
import docusign.client.dto.EnvelopeDocumentInfo;
import docusign.client.dto.SignatureResponse;
import docusign.client.dto.recipients.Recipient;
import docusign.client.dto.recipients.RecipientCollection;
import docusign.client.dto.tabs.DateSignedTab;
import docusign.client.dto.tabs.SignHereTab;
import docusign.client.dto.tabs.Tab;
import docusign.client.dto.tabs.TextTab;
import docusign.client.envelope.attributes.Status;
import docusign.client.exception.EnvelopeException;
import docusign.client.exception.LoginException;
import docusign.client.exception.ServiceInitException;
import docusign.client.exception.SignatureRequestException;
import docusign.client.services.EnvelopeService;
import docusign.client.services.LoginService;
import docusign.client.services.RequestSignatureService;
import docusignWrapper.RetrieveDocumentOutput;
import docusignWrapper.Signer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class DocusignWrapper {
    private static final String SERVER_URI = "https://demo.docusign.net/restapi/v2";
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DocusignWrapper.class);
    private static final String tempDir = System.getenv("WINDIR") + "\\temp\\";

    public static void main(String[] stringArray) {
        try {
            String string = SERVER_URI;
            String string2 = "xzhang@commvault.com";
            String string3 = "commvault!12";
            String string4 = "COMM-b621f7ab-a6c6-4eae-b8f7-1eb846d363e7";
            boolean bl = true;
            ArrayList<Signer> arrayList = new ArrayList<Signer>();
            Signer signer = new Signer();
            signer.setName("xzhang");
            signer.setEmail(string2);
            signer.setAnchorString("xiaoxiaocasala");
            signer.setTimestampAnchorString("xiaoxiaotime");
            signer.setTextAnchorString("xiaoxiaotext");
            arrayList.add(signer);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("C:\\temp\\test.txt");
            String string5 = null;
            String string6 = "commvault!12";
            String string7 = "C:\\temp\\lala";
            new RetrieveDocument();
            String string8 = RetrieveDocument.validateDestPath(string7);
            if (!new File(string8).isDirectory()) {
                try {
                    throw new FileNotFoundException("Please provide a valid detination path.");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
            String string9 = null;
            try {
                DocusignWrapper.Login(string, string2, string3, string4);
            }
            catch (LoginException loginException) {
                System.out.println(loginException.getMessage());
            }
            try {
                string9 = DocusignWrapper.CreateAndSendEnvelope(string, string2, string3, string4, true, arrayList, arrayList2, string5, string6);
            }
            catch (SignatureRequestException signatureRequestException) {
                signatureRequestException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (ServiceInitException serviceInitException) {
            System.out.println(serviceInitException.getMessage());
        }
    }

    public static void Login(String string, String string2) throws LoginException, ServiceInitException {
        DocuSignCredentials docuSignCredentials = DocusignWrapper.getDocuSignCredentials(string, string2);
        LoginService loginService = new LoginService(SERVER_URI, docuSignCredentials);
        loginService.getLoginInformation();
        logger.info("Login successful!");
    }

    public static void Login(String string, String string2, String string3) throws LoginException, ServiceInitException {
        DocuSignCredentials docuSignCredentials = DocusignWrapper.getDocuSignCredentials(string, string2, string3);
        LoginService loginService = new LoginService(SERVER_URI, docuSignCredentials);
        loginService.getLoginInformation();
        logger.info("Login successful!");
    }

    public static void Login(String string, String string2, String string3, String string4) throws LoginException, ServiceInitException {
        DocuSignCredentials docuSignCredentials = DocusignWrapper.getDocuSignCredentials(string2, string3, string4);
        LoginService loginService = new LoginService(string, docuSignCredentials);
        loginService.getLoginInformation();
        logger.info("Login successful!");
    }

    /*
     * WARNING - void declaration
     */
    public static String CreateAndSendEnvelope(String string, String string2, String string3, String string4, Boolean bl, List<Signer> list, List<String> list2, String string5, String string6) throws ServiceInitException, SignatureRequestException, IOException {
        SignatureResponse signatureResponse;
        String string7;
        Object object;
        DocuSignCredentials docuSignCredentials = DocusignWrapper.getDocuSignCredentials(string2, string3, string4);
        ArrayList<docusign.client.dto.recipients.Signer> arrayList = new ArrayList<docusign.client.dto.recipients.Signer>();
        ArrayList<Document> arrayList2 = new ArrayList<Document>();
        int n = 1;
        for (String string8 : list2) {
            void object22;
            logger.debug(LoggerLevel.DEBUG, "Document selected for signature: " + string8, new Object[0]);
            if (string5 != null && !string5.isEmpty()) {
                logger.debug(LoggerLevel.DEBUG, "impersonation is used: " + string5, new Object[0]);
                String string9 = tempDir + FilenameUtils.getName((String)string8);
                object = DocusignWrapper.translateImpersonateUser(string5);
                string7 = SessionUtil.getInstance().copyFile((String)object, string6, string8, string9);
                if (!string7.isEmpty()) {
                    throw new FileNotFoundException("file: " + string8 + " is not found or not accessible");
                }
                String string10 = string9;
            }
            File file = new File((String)object22);
            object = DocusignWrapper.getMockDocument(file.getName(), String.valueOf(n), (String)object22);
            arrayList2.add((Document)object);
            ++n;
        }
        int n2 = 1;
        for (Signer signer : list) {
            object = null;
            string7 = signer.getAnchorString();
            if (string7 != null && !string7.isEmpty()) {
                logger.info("signature anchorString:" + string7);
            } else {
                logger.info("Empty signature anchorString found. Use default");
            }
            String string11 = signer.getTimestampAnchorString();
            if (string11 != null && !string11.isEmpty()) {
                logger.info("timeStamp anchorString:" + string11);
            } else {
                logger.info("Empty timeStamp anchorString found. Use default");
            }
            String string12 = signer.getTextAnchorString();
            if (string12 != null && !string12.isEmpty()) {
                logger.info("text anchorString:" + string12);
            } else {
                logger.info("Empty text anchorString found. Use default");
            }
            object = DocusignWrapper.getSigner(String.valueOf(n2), n, signer);
            logger.debug(LoggerLevel.DEBUG, "Recipient: " + signer.getName() + "signature anchorString: " + string7 + " timeStamp anchorString: " + string11 + " text anchorString: " + string12, new Object[0]);
            if (bl.booleanValue()) {
                ((Recipient)object).setRoutingOrder(String.valueOf(n2));
            }
            arrayList.add((docusign.client.dto.recipients.Signer)object);
            ++n2;
        }
        Object var14_19 = null;
        if (string == null || string.isEmpty()) {
            string = SERVER_URI;
        }
        try {
            signatureResponse = DocusignWrapper.SendDocumentSignRequest(string, docuSignCredentials, arrayList, arrayList2);
        }
        catch (Exception exception) {
            throw new IOException(exception.getCause().getMessage());
        }
        if (signatureResponse != null) {
            return signatureResponse.getEnvelopeId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RetrieveDocumentOutput GetEnvelope(ActivityContext activityContext, String string, String string2, String string3, String string4, String string5, int n, String string6, String string7, String string8) throws EnvelopeException, ServiceInitException, InterruptedException, IOException {
        Object object;
        DocuSignCredentials docuSignCredentials = DocusignWrapper.getDocuSignCredentials(string2, string3, string4);
        RetrieveDocumentOutput retrieveDocumentOutput = new RetrieveDocumentOutput();
        if (string == null || string.isEmpty()) {
            string = SERVER_URI;
        }
        EnvelopeService envelopeService = new EnvelopeService(string, docuSignCredentials);
        Status status = Status.sent;
        while (status != Status.completed && status != Status.declined && status != Status.deleted && status != Status.timedOut && status != Status.voided) {
            object = activityContext.getLock();
            synchronized (object) {
                if (n == 0 || n < 15) {
                    if (string.equalsIgnoreCase(SERVER_URI)) {
                        activityContext.getLock().wait(60000L);
                    } else {
                        activityContext.getLock().wait(900000L);
                    }
                } else {
                    activityContext.getLock().wait(n * 60000);
                }
                if (activityContext.getStatus() != ProcessStatus.RUNNING) {
                    logger.debugJob(LoggerLevel.INFO, Long.valueOf(activityContext.getJobId()), "exiting activity since it has a status of [%s]", new Object[]{activityContext.getStatus()});
                    activityContext.repeat(Integer.valueOf(0));
                }
                if (!activityContext.isRunning()) {
                    logger.debugJob(LoggerLevel.INFO, Long.valueOf(activityContext.getJobId()), "exiting activity since the workflow is shutting down", new Object[0]);
                    activityContext.repeat(Integer.valueOf(0));
                }
            }
            try {
                status = envelopeService.getEnvelope(string5).getStatus();
                logger.debug(LoggerLevel.INFO, "Envelope Status: " + status.toString(), new Object[0]);
            }
            catch (Exception exception) {
                logger.error("Exception trying to use REST Envelope Service, retrying");
            }
        }
        if (status == Status.completed) {
            object = envelopeService.getDocumentsInfo(string5);
            for (EnvelopeDocument envelopeDocument : ((EnvelopeDocumentInfo)object).getEnvelopeDocuments()) {
                if (envelopeDocument.getDocumentId().equalsIgnoreCase("certificate")) continue;
                logger.debug(LoggerLevel.DEBUG, envelopeDocument.getDocumentId() + "  " + envelopeDocument.getName(), new Object[0]);
                DocumentFile documentFile = null;
                try {
                    documentFile = envelopeService.getDocument(string5, envelopeDocument.getDocumentId());
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
                logger.debug(LoggerLevel.DEBUG, "signed file is saved to: " + documentFile.getDocFile().getPath(), new Object[0]);
                String string9 = string6 != null && !string6.isEmpty() ? tempDir + FilenameUtils.getBaseName((String)envelopeDocument.getName()) + "_signed.pdf" : string8 + FilenameUtils.getBaseName((String)envelopeDocument.getName()) + "_signed.pdf";
                retrieveDocumentOutput.setSignedFileName(FilenameUtils.getBaseName((String)envelopeDocument.getName()) + "_signed.pdf");
                File file = new File(string9);
                if (file.exists()) {
                    file.delete();
                }
                logger.debug(LoggerLevel.DEBUG, "move file from:" + documentFile.getDocFile().getPath() + "to:" + string9, new Object[0]);
                DocusignWrapper.copyFileUsingFileStreams(documentFile.getDocFile(), file);
                if (documentFile.getDocFile().exists()) {
                    documentFile.getDocFile().delete();
                }
                if (string6 == null || string6.isEmpty()) continue;
                String string10 = string8 + FilenameUtils.getName((String)string9);
                String string11 = DocusignWrapper.translateImpersonateUser(string6);
                String string12 = SessionUtil.getInstance().copyFile(string11, string7, string9, string10);
                if (!string12.isEmpty()) {
                    throw new FileNotFoundException("file: " + string9 + " is not found or not accessible");
                }
                logger.debug(LoggerLevel.DEBUG, "delete system\temp signed file: " + file.getPath(), new Object[0]);
                file.delete();
                String string13 = tempDir + FilenameUtils.getName((String)envelopeDocument.getName());
                File file2 = new File(string13);
                logger.debug(LoggerLevel.DEBUG, "delete system\temp orginal unsigned file: " + string13, new Object[0]);
                if (!file2.exists()) continue;
                file2.delete();
            }
        }
        logger.info("Env status:" + status.toString());
        retrieveDocumentOutput.setEnvelopeStatus(status.toString());
        return retrieveDocumentOutput;
    }

    private static SignatureResponse SendDocumentSignRequest(String string, DocuSignCredentials docuSignCredentials, List<docusign.client.dto.recipients.Signer> list, List<Document> list2) throws ServiceInitException, SignatureRequestException {
        RequestSignatureService requestSignatureService = new RequestSignatureService(string, docuSignCredentials);
        DocumentSignatureRequest documentSignatureRequest = DocusignWrapper.getDocumentSignatureRequest(list, list2);
        return requestSignatureService.sendDocument(documentSignatureRequest);
    }

    private static Document getMockDocument(String string, String string2, String string3) {
        Document document = new Document();
        document.setName(string);
        document.setDocumentId(string2);
        document.setPath(string3);
        return document;
    }

    private static DocumentSignatureRequest getDocumentSignatureRequest(List<docusign.client.dto.recipients.Signer> list, List<Document> list2) {
        DocumentSignatureRequest documentSignatureRequest = new DocumentSignatureRequest();
        documentSignatureRequest.setEmailBlurb("Please sign the document(s).");
        documentSignatureRequest.setEmailSubject("Please sign the document(s)");
        documentSignatureRequest.setStatus(Status.sent);
        documentSignatureRequest.setEnforceSignerVisibility(true);
        RecipientCollection recipientCollection = new RecipientCollection();
        recipientCollection.setSigners(list);
        documentSignatureRequest.setRecipients(recipientCollection);
        documentSignatureRequest.setDocuments(list2);
        return documentSignatureRequest;
    }

    private static docusign.client.dto.recipients.Signer getSigner(String string, String string2, String string3, int n, String string4) {
        docusign.client.dto.recipients.Signer signer = new docusign.client.dto.recipients.Signer();
        signer.setRecipientId(string);
        signer.setEmail(string2);
        signer.setName(string3);
        DocumentTabCollection documentTabCollection = new DocumentTabCollection();
        ArrayList<SignHereTab> arrayList = new ArrayList<SignHereTab>();
        for (int i = 1; i < n; ++i) {
            SignHereTab signHereTab = new SignHereTab();
            signHereTab.setDocumentId(String.valueOf(i));
            logger.info("getSigner using anchor string " + string4);
            signHereTab.setAnchorString(string4);
            signHereTab.setAnchorIgnoreIfNotPresent(true);
            arrayList.add(signHereTab);
        }
        documentTabCollection.setSignHereTabs(arrayList);
        signer.setTabs(documentTabCollection);
        return signer;
    }

    private static docusign.client.dto.recipients.Signer getSigner(String string, int n, Signer signer) {
        boolean bl;
        Object object;
        boolean bl2;
        String string2;
        Serializable serializable;
        boolean bl3;
        String string3;
        docusign.client.dto.recipients.Signer signer2 = new docusign.client.dto.recipients.Signer();
        signer2.setRecipientId(string);
        signer2.setEmail(signer.getEmail());
        signer2.setName(signer.getName());
        DocumentTabCollection documentTabCollection = new DocumentTabCollection();
        ArrayList<SignHereTab> arrayList = new ArrayList<SignHereTab>();
        Integer n2 = null;
        Integer n3 = null;
        if (signer.getAnchorString() != null && !signer.getAnchorString().isEmpty()) {
            string3 = signer.getAnchorString();
            bl3 = false;
            if (signer.getXOffset() != 0) {
                n2 = signer.getXOffset();
            }
            if (signer.getYOffset() != 0) {
                n3 = signer.getYOffset();
            }
        } else {
            string3 = "chankarrak";
            bl3 = true;
        }
        for (int i = 1; i < n; ++i) {
            serializable = new SignHereTab();
            serializable.setDocumentId(String.valueOf(i));
            serializable.setAnchorString(string3);
            serializable.setAnchorIgnoreIfNotPresent(bl3);
            if (n2 != null) {
                serializable.setAnchorXOffset(n2);
            }
            if (n3 != null) {
                serializable.setAnchorYOffset(n3);
            }
            arrayList.add((SignHereTab)serializable);
        }
        documentTabCollection.setSignHereTabs(arrayList);
        serializable = null;
        Integer n4 = null;
        if (signer.getTimestampAnchorString() != null && !signer.getTimestampAnchorString().isEmpty()) {
            string2 = signer.getTimestampAnchorString();
            bl2 = false;
            if (signer.getTimestampXOffset() != 0) {
                serializable = Integer.valueOf(signer.getTimestampXOffset());
            }
            if (signer.getTimestampYOffset() != 0) {
                n4 = signer.getTimestampYOffset();
            }
        } else {
            string2 = "chankarraktimestamp";
            bl2 = true;
        }
        ArrayList<DateSignedTab> arrayList2 = new ArrayList<DateSignedTab>();
        for (int i = 1; i < n; ++i) {
            object = new DateSignedTab();
            ((Tab)object).setDocumentId(String.valueOf(i));
            ((Tab)object).setAnchorString(string2);
            ((Tab)object).setAnchorIgnoreIfNotPresent(bl2);
            if (serializable != null) {
                ((Tab)object).setAnchorXOffset((Integer)serializable);
            }
            if (n4 != null) {
                ((Tab)object).setAnchorYOffset(n4);
            }
            arrayList2.add((DateSignedTab)object);
        }
        documentTabCollection.setDateSignedTabs(arrayList2);
        ArrayList<TextTab> arrayList3 = new ArrayList<TextTab>();
        Integer n5 = null;
        Integer n6 = null;
        if (signer.getTextAnchorString() != null && !signer.getTextAnchorString().isEmpty()) {
            object = signer.getTextAnchorString();
            bl = false;
            if (signer.getTextXOffset() != 0) {
                n5 = signer.getTextXOffset();
            }
            if (signer.getTextYOffset() != 0) {
                n6 = signer.getTextYOffset();
            }
        } else {
            object = "chankarraktext";
            bl = true;
        }
        for (int i = 1; i < n; ++i) {
            TextTab textTab = new TextTab();
            textTab.setDocumentId(String.valueOf(i));
            textTab.setAnchorString((String)object);
            textTab.setAnchorIgnoreIfNotPresent(bl);
            if (n5 != null) {
                textTab.setAnchorXOffset(n5);
            }
            if (n6 != null) {
                textTab.setAnchorYOffset(n6);
            }
            arrayList3.add(textTab);
        }
        documentTabCollection.setTextTabs(arrayList3);
        logger.info("anchorStringForText= " + (String)object);
        signer2.setTabs(documentTabCollection);
        return signer2;
    }

    private static DocuSignCredentials getDocuSignCredentials(String string, String string2) {
        BasicDocusignCredential basicDocusignCredential = new BasicDocusignCredential(string, string2, "MYTE-b938b3c7-eeb3-40a8-960c-86903f5d9c34");
        return basicDocusignCredential;
    }

    private static DocuSignCredentials getDocuSignCredentials(String string, String string2, String string3) {
        BasicDocusignCredential basicDocusignCredential = new BasicDocusignCredential(string, string2, string3);
        return basicDocusignCredential;
    }

    private static String translateImpersonateUser(String string) throws IllegalArgumentException {
        int n = string.lastIndexOf(92);
        if (n > 0) {
            String string2 = string.substring(n + 1);
            String string3 = string.substring(0, n);
            String string4 = string2 + "@" + string3;
            return string4;
        }
        throw new IllegalArgumentException("please provide correct impersonate username");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileUsingFileStreams(File file, File file2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }
}

