/*
 * Decompiled with CFR 0.152.
 */
package docusign.jackson;

import docusign.client.dto.utils.DtoHelper;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

public class ISO8601DateSerializer
extends JsonSerializer<Date> {
    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        try {
            String string = DtoHelper.formatISO8601Date(date);
            jsonGenerator.writeString(string);
        }
        catch (ParseException parseException) {
            throw new IOException("Error occurred while formatting date to ISO8601 format", parseException);
        }
    }
}

