/*
 * Decompiled with CFR 0.152.
 */
package docusign.client.services;

import docusign.client.base.BaseService;
import docusign.client.credential.DocuSignCredentials;
import docusign.client.dto.DocumentSignatureRequest;
import docusign.client.dto.SignatureResponse;
import docusign.client.dto.TemplateSignatureRequest;
import docusign.client.dto.user.LoginAccount;
import docusign.client.exception.ServiceInitException;
import docusign.client.exception.SignatureRequestException;
import docusign.client.resources.RequestSignatureResource;
import docusign.client.utils.DocuSignUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;

public class RequestSignatureService
extends BaseService<RequestSignatureResource> {
    public RequestSignatureService(String string, DocuSignCredentials docuSignCredentials) throws ServiceInitException {
        super(string, docuSignCredentials);
    }

    public RequestSignatureService(String string, DocuSignCredentials docuSignCredentials, LoginAccount loginAccount) throws ServiceInitException {
        super(loginAccount, docuSignCredentials);
    }

    public SignatureResponse sendFromTemplate(TemplateSignatureRequest templateSignatureRequest) throws SignatureRequestException {
        ClientResponse<SignatureResponse> clientResponse = ((RequestSignatureResource)this.resourceProxy).sendFromTemplate(templateSignatureRequest);
        return this.parseEntityFromResponse(clientResponse, SignatureRequestException.class);
    }

    public SignatureResponse sendDocument(DocumentSignatureRequest documentSignatureRequest) throws SignatureRequestException {
        MultipartFormDataOutput multipartFormDataOutput = DocuSignUtils.generateMultipartFormDataOutput(documentSignatureRequest);
        ClientResponse<SignatureResponse> clientResponse = ((RequestSignatureResource)this.resourceProxy).sendDocument(multipartFormDataOutput);
        return this.parseEntityFromResponse(clientResponse, SignatureRequestException.class);
    }

    @Override
    protected Class<RequestSignatureResource> getResourceClass() {
        return RequestSignatureResource.class;
    }
}

