/*
 * Decompiled with CFR 0.152.
 */
package docusign.client.services;

import docusign.client.base.BaseService;
import docusign.client.credential.DocuSignCredentials;
import docusign.client.dto.CorrectionViewRequest;
import docusign.client.dto.EnvelopeSenderViewRequest;
import docusign.client.dto.UrlResponse;
import docusign.client.dto.recipients.RecipientViewRequest;
import docusign.client.dto.user.LoginAccount;
import docusign.client.exception.ConsoleViewException;
import docusign.client.exception.ServiceInitException;
import docusign.client.resources.ConsoleViewResource;
import org.jboss.resteasy.client.ClientResponse;

public class ConsoleViewService
extends BaseService<ConsoleViewResource> {
    public ConsoleViewService(String string, DocuSignCredentials docuSignCredentials) throws ServiceInitException {
        super(string, docuSignCredentials);
    }

    public ConsoleViewService(DocuSignCredentials docuSignCredentials, LoginAccount loginAccount) throws ServiceInitException {
        super(loginAccount, docuSignCredentials);
    }

    public UrlResponse getAuthenticationView() throws ConsoleViewException {
        ClientResponse<UrlResponse> clientResponse = ((ConsoleViewResource)this.resourceProxy).getAuthenticationView();
        return this.parseEntityFromResponse(clientResponse, ConsoleViewException.class);
    }

    public UrlResponse getEnvelopeSenderView(String string, EnvelopeSenderViewRequest envelopeSenderViewRequest) throws ConsoleViewException {
        ClientResponse<UrlResponse> clientResponse = ((ConsoleViewResource)this.resourceProxy).getEnvelopeSenderView(string, envelopeSenderViewRequest);
        return this.parseEntityFromResponse(clientResponse, ConsoleViewException.class);
    }

    public UrlResponse getEnvelopeRecipientView(String string, RecipientViewRequest recipientViewRequest) throws ConsoleViewException {
        ClientResponse<UrlResponse> clientResponse = ((ConsoleViewResource)this.resourceProxy).getEnvelopeRecipientView(string, recipientViewRequest);
        return this.parseEntityFromResponse(clientResponse, ConsoleViewException.class);
    }

    public UrlResponse getEnvelopeCorrectionView(String string, CorrectionViewRequest correctionViewRequest) throws ConsoleViewException {
        ClientResponse<UrlResponse> clientResponse = ((ConsoleViewResource)this.resourceProxy).getEnvelopeCorrectionView(string, correctionViewRequest);
        return this.parseEntityFromResponse(clientResponse, ConsoleViewException.class);
    }

    @Override
    protected Class<ConsoleViewResource> getResourceClass() {
        return ConsoleViewResource.class;
    }
}

