/*
 * Decompiled with CFR 0.152.
 */
package docusign.client.dto.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class DtoHelper {
    private static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSz";

    public static Date parseISO8601Date(String string) throws ParseException {
        if (!string.endsWith("Z")) {
            string = string + "Z";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO8601_PATTERN);
        if ((string = string.replaceAll("(\\.[0-9]{3})[0-9]*(Z)", "$1$2")).endsWith("Z")) {
            string = string.substring(0, string.length() - 1) + "GMT-00:00";
        } else {
            int n = 6;
            String string2 = string.substring(0, string.length() - n);
            String string3 = string.substring(string.length() - n, string.length());
            string = string2 + "GMT" + string3;
        }
        return simpleDateFormat.parse(string);
    }

    public static String formatISO8601Date(Date date) throws ParseException {
        return DtoHelper.formatDate(date, "yyyy-MM-dd'T'HH:mm:ss.SSS'0000Z'", true);
    }

    public static String formatDate(Date date, String string, boolean bl) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        if (bl) {
            TimeZone timeZone = TimeZone.getTimeZone("UTC");
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat.format(date);
    }

    public static String getCommaSeparatedValue(List<? extends Enum<?>> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Enum<?> enum_ : list) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(enum_.name());
        }
        return stringBuffer.toString();
    }
}

