/*
 * Decompiled with CFR 0.152.
 */
package docusign.client.base;

import docusign.client.base.Resource;
import docusign.client.base.Service;
import docusign.client.credential.DocuSignCredentials;
import docusign.client.dto.user.ClientInfo;
import docusign.client.dto.user.LoginAccount;
import docusign.client.exception.LoginException;
import docusign.client.exception.ServiceInitException;
import docusign.client.services.LoginService;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseService<RT extends Resource>
extends Service<RT> {
    protected final DocuSignCredentials credentials;

    public BaseService(String string, DocuSignCredentials docuSignCredentials) throws ServiceInitException {
        super(BaseService.getRestBaseUri(string, docuSignCredentials), docuSignCredentials);
        this.credentials = docuSignCredentials;
    }

    public BaseService(LoginAccount loginAccount, DocuSignCredentials docuSignCredentials) throws ServiceInitException {
        super(loginAccount.getBaseUrl(), docuSignCredentials);
        this.credentials = docuSignCredentials;
    }

    private static String getRestBaseUri(String string, DocuSignCredentials docuSignCredentials) throws ServiceInitException {
        LoginAccount loginAccount = BaseService.getDefaultAccount(string, docuSignCredentials);
        if (loginAccount == null) {
            throw new ServiceInitException("Default account not found for docusign user");
        }
        String string2 = loginAccount.getBaseUrl();
        if (StringUtils.isBlank((CharSequence)string2)) {
            throw new ServiceInitException("Base REST URL not found for the default account: \n" + loginAccount + "'");
        }
        return string2;
    }

    private static LoginAccount getDefaultAccount(String string, DocuSignCredentials docuSignCredentials) throws ServiceInitException {
        LoginService loginService = new LoginService(string, docuSignCredentials);
        ClientInfo clientInfo = null;
        try {
            clientInfo = loginService.getLoginInformation();
        }
        catch (LoginException loginException) {
            throw new ServiceInitException("Error occurred while getting login information during initialization of DocuSign Service.", loginException);
        }
        if (clientInfo == null) {
            throw new ServiceInitException("Failed to retrieve client info against credentials.\n");
        }
        if (clientInfo.getLoginAccounts() == null || clientInfo.getLoginAccounts().size() == 0) {
            throw new ServiceInitException("Login accounts not found in client info retrirved against specified credentials.\n " + clientInfo);
        }
        for (LoginAccount loginAccount : clientInfo.getLoginAccounts()) {
            if (!loginAccount.isDefault()) continue;
            return loginAccount;
        }
        throw new ServiceInitException("Default account not found against specified credentials.\n " + clientInfo);
    }
}

