/*
 * Decompiled with CFR 0.152.
 */
package activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.logger.LoggerLevel;
import docusign.client.exception.EnvelopeException;
import docusign.client.exception.ServiceInitException;
import docusignWrapper.DocusignWrapper;
import docusignWrapper.RetrieveDocumentOutput;
import java.io.File;
import java.io.FileNotFoundException;
import workflow.types.EncryptedString;

public class RetrieveDocument
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(RetrieveDocument.class);
    @Input
    public String serviceUrl;
    @Input
    public String userEmail;
    @Input
    public EncryptedString password;
    @Input
    public String integratorKey;
    @Input
    public String envelopeId;
    @Input
    public int eventPollingMins;
    @Input
    public String impersonateUserName;
    @Input
    public String impersonateUserPassword;
    @Input
    public String destPath;
    @Output
    public String envelopeStatus;
    @Output
    public String signedFileName;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        try {
            if (this.serviceUrl.isEmpty()) {
                String string = "Empty serviceUrl provided, Please provide a valid serviceUrl";
                throw new EnvelopeException(string);
            }
            String string = RetrieveDocument.validateDestPath(this.destPath);
            if (!new File(string).isDirectory()) {
                throw new FileNotFoundException("Please provide a valid detination path.");
            }
            RetrieveDocumentOutput retrieveDocumentOutput = DocusignWrapper.GetEnvelope(activityContext, this.serviceUrl, this.userEmail, this.password.getPlainText(), this.integratorKey, this.envelopeId, this.eventPollingMins, this.impersonateUserName, this.impersonateUserPassword, string);
            this.envelopeStatus = retrieveDocumentOutput.getEnvelopeStatus();
            this.signedFileName = retrieveDocumentOutput.getSignedFileName();
        }
        catch (ServiceInitException serviceInitException) {
            logger.debugJob(LoggerLevel.ERROR, Long.valueOf(activityContext.getJobId()), "Service init exception", new Object[0]);
            logger.error((Throwable)serviceInitException);
            activityContext.setFailureReason(new EvMessageContainer(serviceInitException.getMessage()));
            return AttemptStatus.FAILED;
        }
        catch (EnvelopeException envelopeException) {
            logger.debugJob(LoggerLevel.ERROR, Long.valueOf(activityContext.getJobId()), "Envelope exception", new Object[0]);
            logger.error((Throwable)envelopeException);
            activityContext.setFailureReason(new EvMessageContainer(envelopeException.getMessage()));
            return AttemptStatus.FAILED;
        }
        catch (Exception exception) {
            logger.debugJob(LoggerLevel.ERROR, Long.valueOf(activityContext.getJobId()), "Exception in RetrieveDocument", new Object[0]);
            logger.error((Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    public static String validateDestPath(String string) {
        String string2 = string != null && string.charAt(string.length() - 1) != '\\' ? string + "\\" : string;
        return string2;
    }
}

