/*
 * Decompiled with CFR 0.152.
 */
package activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.logger.LoggerLevel;
import docusign.client.exception.ServiceInitException;
import docusign.client.exception.SignatureRequestException;
import docusignWrapper.DocusignWrapper;
import docusignWrapper.Signer;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workflow.types.EncryptedString;

public class CreateAndSendEnvelope
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateAndSendEnvelope.class);
    @InputOutput
    public String serviceUrl;
    @InputOutput
    public String userEmail;
    @InputOutput
    public EncryptedString password;
    @InputOutput
    public String integratorKey;
    @InputOutput
    public String impersonateUserName;
    @InputOutput
    public String impersonateUserPassword;
    @Input(defaultValue="true")
    public Boolean sequentialOrder;
    @Input
    public List<Signer> signers;
    @Input
    public List<String> documents;
    @Output
    public String envelopeId;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        String string = this.sequentialOrder != false ? "sequential" : "parallel";
        logger.info("Send Envelope with " + this.documents.size() + " document(s) to " + this.signers.size() + " recipient(s) in " + string + " order");
        try {
            Object object;
            if (this.serviceUrl.isEmpty()) {
                String string2 = "Empty serviceUrl provided, Please provide a valid serviceUrl";
                throw new SignatureRequestException(string2);
            }
            for (String object2 : this.documents) {
                object = new File(object2);
                String string2 = ((File)object).getName();
                int n = string2.lastIndexOf(".");
                if (n == -1 || n == string2.length() - 1) {
                    throw new IllegalArgumentException("missing document extension");
                }
                if (n > 2) continue;
                throw new IllegalArgumentException("document prefix has to be at least three characters");
            }
            for (Signer signer : this.signers) {
                object = signer.getEmail();
                if (CreateAndSendEnvelope.isValidEmailAddress((String)object)) continue;
                throw new IllegalArgumentException("please provide a valid email address : " + (String)object);
            }
            this.envelopeId = DocusignWrapper.CreateAndSendEnvelope(this.serviceUrl, this.userEmail, this.password.getPlainText(), this.integratorKey, this.sequentialOrder, this.signers, this.documents, this.impersonateUserName, this.impersonateUserPassword);
        }
        catch (SignatureRequestException signatureRequestException) {
            logger.debugJob(LoggerLevel.ERROR, Long.valueOf(activityContext.getJobId()), "failed in signature request from user [%s]", new Object[]{this.userEmail});
            logger.error((Throwable)signatureRequestException);
            activityContext.setFailureReason(new EvMessageContainer(signatureRequestException.getMessage()));
            return AttemptStatus.FAILED;
        }
        catch (ServiceInitException serviceInitException) {
            logger.debugJob(LoggerLevel.ERROR, Long.valueOf(activityContext.getJobId()), "Service init exception", new Object[0]);
            logger.error((Throwable)serviceInitException);
            activityContext.setFailureReason(new EvMessageContainer(serviceInitException.getMessage()));
            return AttemptStatus.FAILED;
        }
        catch (Exception exception) {
            logger.debugJob(LoggerLevel.ERROR, Long.valueOf(activityContext.getJobId()), "Exception in CreateEnvelope", new Object[0]);
            logger.error((Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    public static boolean isValidEmailAddress(String string) {
        if (string != null) {
            string = string.trim();
        }
        String string2 = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }
}

