/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsNullCipher
implements TlsCipher {
    protected final TlsCryptoParameters cryptoParameters;
    protected final TlsSuiteHMac readMac;
    protected final TlsSuiteHMac writeMac;

    public TlsNullCipher(TlsCryptoParameters tlsCryptoParameters, TlsHMAC tlsHMAC, TlsHMAC tlsHMAC2) throws IOException {
        this.cryptoParameters = tlsCryptoParameters;
        int n = tlsHMAC.getMacLength() + tlsHMAC2.getMacLength();
        byte[] byArray = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n);
        int n2 = 0;
        tlsHMAC.setKey(byArray, n2, tlsHMAC.getMacLength());
        tlsHMAC2.setKey(byArray, n2 += tlsHMAC.getMacLength(), tlsHMAC2.getMacLength());
        if ((n2 += tlsHMAC2.getMacLength()) != n) {
            throw new TlsFatalAlert(80);
        }
        if (tlsCryptoParameters.isServer()) {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
        } else {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
        }
    }

    public int getCiphertextLimit(int n) {
        return n + this.writeMac.getSize();
    }

    public int getPlaintextLimit(int n) {
        return n - this.writeMac.getSize();
    }

    public byte[] encodePlaintext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.writeMac.calculateMac(l, s, byArray, n, n2);
        byte[] byArray3 = new byte[n2 + byArray2.length];
        System.arraycopy(byArray, n, byArray3, 0, n2);
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        return byArray3;
    }

    public byte[] decodeCiphertext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        int n3 = this.readMac.getSize();
        if (n2 < n3) {
            throw new TlsFatalAlert(50);
        }
        int n4 = n2 - n3;
        byte[] byArray3 = TlsUtils.copyOfRangeExact(byArray, n + n4, n + n2);
        if (!Arrays.constantTimeAreEqual((byte[])byArray3, (byte[])(byArray2 = this.readMac.calculateMac(l, s, byArray, n, n4)))) {
            throw new TlsFatalAlert(20);
        }
        return TlsUtils.copyOfRangeExact(byArray, n, n + n4);
    }
}

