/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.DataAgent;

public class OperationRestore
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationRestore.class);
    @Input(documentation="Source client computer name from which data has to be restored", required=true)
    public ClientEntity sourceClient;
    @Input(documentation="Agent type installed on source client computer", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Backup set name to which subclient belongs, required for a few agents. If an iDataAgent supports backup sets, this option is mandatory.")
    public String backupSet;
    @Input(documentation="Instance name to which subclient belongs, required for a few agents. If an iDataAgent supports instances, this option is mandatory.")
    public String instance;
    @Input(documentation="File/Directory to be restored. For NAS restores on Unix, the path values must be surrounded by single quotes (for example, -spath '/abc/def'). For NAS restores on Windows, the path values must be \\UNC-NT_<filer>\\<volume_name>\\<folder>.", required=true)
    public String sourcePath;
    @Input(documentation="Destination client computer name, for cross-client restores (Optional) By default, data is restored to the source client computer")
    public ClientEntity destinationClient;
    @Input(documentation="Destination path to which backed up data will be restored (Optional) By default, data is restored to the source paths")
    public String destinationPath;
    @Output(documentation="Job Id")
    public Integer jobId;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.sourceClient == null || this.sourceClient.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no source client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required source client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation restore -sc '%s' -a '%s' -spath '%s'", this.sourceClient.getClientName(), this.dataAgent, this.sourcePath));
        if (this.backupSet != null && this.backupSet.length() > 0) {
            stringBuffer.append(String.format(" -b '%s'", this.backupSet));
        }
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        if (this.destinationClient != null || this.destinationClient.getClientName().length() > 0) {
            stringBuffer.append(String.format(" -dc '%s'", this.destinationClient.getClientName()));
        }
        if (this.destinationPath != null && this.destinationPath.length() > 0) {
            stringBuffer.append(String.format(" -dpath '%s'", this.destinationPath));
        }
        try {
            String string = this.execute(stringBuffer, activityContext);
            String string2 = CommandUtil.parseFirstValue(string);
            if (string2 != null) {
                this.jobId = Integer.parseInt(string2);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

