/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import workflow.types.BackupType;
import workflow.types.cmd.JobStatus;
import workflow.types.cmd.JobType;
import workflow.types.cmd.ReportFormat;
import workflow.types.cmd.ReportType;

public class OperationReport
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationReport.class);
    @Input(documentation="Type of Report to be generated", required=true, defaultValue="jobsummary")
    public ReportType reportType;
    @Input(documentation="Type of job (backup|restore|admin)")
    public JobType jobType;
    @Input(documentation="")
    public BackupType backupType;
    @Input(documentation="Client computer name(s)")
    public List<ClientEntity> client;
    @Input(documentation="Client computer group name(s)")
    public List<String> clientGroup;
    @Input(documentation="Agent type installed on client computer")
    public List<String> dataAgent;
    @Input(documentation="Job status")
    public JobStatus jobStatus;
    @Input(documentation="Start time")
    public Date startTime;
    @Input(documentation="End time")
    public Date endTime;
    @Input(documentation="Last hours")
    public Integer lastHours;
    @Input(documentation="Destination path where the report needs to be saved (supports both local paths, and UNC paths)")
    public String destinationPath;
    @Input(documentation="Format of report to be saved (html|text)")
    public ReportFormat reportFormat;
    @Input(documentation="Job ID")
    public Integer jobId;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.reportType == null) {
            this.reportType = ReportType.jobsummary;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation report -rt %s", this.reportType));
        if (this.jobType != null) {
            stringBuffer.append(" -jt " + this.jobType.toString());
        }
        if (this.backupType != null) {
            stringBuffer.append(" -t " + this.backupType.toString());
        }
        if (this.client != null && this.client.size() > 0) {
            for (ClientEntity object : this.client) {
                if (object.getClientName().length() <= 0) continue;
                stringBuffer.append(String.format(" -c '%s'", object.getClientName()));
            }
        }
        if (this.clientGroup != null && this.clientGroup.size() > 0) {
            for (String string : this.clientGroup) {
                if (string.length() <= 0) continue;
                stringBuffer.append(String.format(" -cg '%s'", string));
            }
        }
        if (this.dataAgent != null && this.dataAgent.size() > 0) {
            for (String string : this.dataAgent) {
                if (string.length() <= 0) continue;
                stringBuffer.append(String.format(" -a '%s'", string));
            }
        }
        if (this.jobStatus != null) {
            stringBuffer.append(" -js " + this.jobStatus.toString());
        }
        if (this.startTime != null) {
            stringBuffer.append(String.format(" -st '%s'", this.convertDate(this.startTime)));
        }
        if (this.endTime != null) {
            stringBuffer.append(String.format(" -et '%s'", this.convertDate(this.endTime)));
        }
        if (this.lastHours != null) {
            stringBuffer.append(" -lh " + this.lastHours);
        }
        if (this.destinationPath != null && this.destinationPath.length() > 0) {
            stringBuffer.append(String.format(" -dpath '%s'", this.destinationPath));
        }
        if (this.reportFormat != null) {
            stringBuffer.append(" -opfrmt " + this.reportFormat.toString());
        }
        if (this.jobId != null) {
            stringBuffer.append(" -j " + this.jobId);
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    private String convertDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return simpleDateFormat.format(date);
    }
}

