/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;

public class OperationMedia
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationMedia.class);
    @Input(documentation="Barcode list", required=true)
    public List<String> barCode;
    @Input(documentation="Library name", required=true)
    public String library;
    @Input(documentation="Export location name")
    public String exportLocation;
    @Input(documentation="MediaAgent name")
    public String mediaAgent;
    @Input(documentation="Verify OML before export")
    public Boolean verifyOML;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.barCode == null || this.barCode.size() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no barcodes were supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required barcode input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.barCode.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.barCode.get(i));
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(String.format("qoperation media -o export -b '%s' -l '%s' -el '%s' -m '%s'", stringBuffer.toString(), this.library, this.exportLocation, this.mediaAgent));
        if (this.verifyOML != null) {
            if (this.verifyOML.booleanValue()) {
                stringBuffer2.append(" -v 1");
            } else {
                stringBuffer2.append(" -v 0");
            }
        }
        try {
            this.execute(stringBuffer2, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

