/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.DataAgent;
import workflow.types.cmd.JobOperation;

public class OperationJobControlClient
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationJobControlClient.class);
    @Input(documentation="Operation to be performed on the job (kill, suspend, resume)", required=true)
    public JobOperation operation;
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer")
    public DataAgent dataAgent;
    @Input(documentation="Backup set name")
    public String backupSet;
    @Input(documentation="Subclient name")
    public String subClient;
    @Input(documentation="Instance name")
    public String instance;
    @Input(documentation="Job priority")
    public Integer priority;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.operation == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no operation was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required operation input");
            return AttemptStatus.FAILED;
        }
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation jobcontrol -o %s -c '%s'", this.operation.toString(), this.client.getClientName()));
        if (this.dataAgent != null) {
            stringBuffer.append(String.format(" -a '%s'", this.dataAgent));
        }
        if (this.backupSet != null && this.backupSet.length() > 0) {
            stringBuffer.append(String.format(" -b '%s'", this.backupSet));
        }
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        if (this.subClient != null && this.subClient.length() > 0) {
            stringBuffer.append(String.format(" -s '%s'", this.subClient));
        }
        if (this.priority != null) {
            stringBuffer.append(" -p " + this.priority);
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

