/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.activities.cmd.operation.OperationDRBackup;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;

public class OperationExecScript
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationDRBackup.class);
    @Input(documentation="the script to execute", required=true)
    public String scriptName;
    @Input(documentation="the arguments to pass into the script", required=false)
    public String arguments;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.scriptName == null || this.scriptName.length() == 0) {
            logger.info(Long.valueOf(activityContext.getJobId()), "no script to execute, skipping activity");
            return AttemptStatus.SUCCESS;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation execscript -sn '%s'", this.scriptName));
        if (this.arguments != null && this.arguments.length() > 0) {
            stringBuffer.append(String.format(" %s", this.arguments));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

