/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;

public class OperationAuxCopy
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationAuxCopy.class);
    @Input(documentation="Storage policy name ", required=true)
    public String storagePolicy;
    @Input(documentation="Secondary copy name")
    public String copy;
    @Output
    public Integer jobId;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation auxcopy -sp '%s'", this.storagePolicy));
        if (this.copy != null && this.copy.length() > 0) {
            stringBuffer.append(String.format(" -spc '%s'", this.copy));
        }
        try {
            String string = this.execute(stringBuffer, activityContext);
            String string2 = CommandUtil.parseFirstValue(string);
            if (string2 != null) {
                this.jobId = Integer.parseInt(string2);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

