/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;

public class OperationAutomaticUpdate
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationAutomaticUpdate.class);
    @Input(documentation="Client name", required=true)
    public ClientEntity client;
    @Input(documentation="Reboot specified client (if required) after update or upgrade has completed.")
    public boolean reboot;
    @Input(documentation="Automatically upgrade specified client.", required=true)
    public boolean upgrade;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation automaticupdate -c '%s'", this.client.getClientName()));
        if (this.reboot) {
            stringBuffer.append(" -reboot");
        }
        if (this.upgrade) {
            stringBuffer.append(" -upgrade");
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

