/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.modify;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.Answer;
import workflow.types.cmd.DataAgent;

public class ModifySubclient
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ModifySubclient.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Instance name, required for certain agents")
    public String instance;
    @Input(documentation="Backup set name, required for certain agents")
    public String backupSet;
    @Input(documentation="Name of the subclient to be modified", required=true)
    public String subClient;
    @Input(documentation="Name of the storage policy to be associated with the subclient", required=true)
    public String storagePolicy;
    @Input(documentation="File/Directory Path to be added to the existing content", required=true)
    public String content;
    @Input(documentation="If the contents needs to be overwritten")
    public Answer overwrite;
    @Input(documentation="Number of data readers")
    public Integer dataReaders;
    @Input(documentation="Do file/directory paths have wildcards")
    public Answer wildcards;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qmodify subclient -c '%s' -a '%s' -s '%s' -sp '%s' -f '%s'", this.client.getClientName(), this.dataAgent, this.subClient, this.storagePolicy, this.content));
        if (this.backupSet != null && this.backupSet.length() > 0) {
            stringBuffer.append(String.format(" -b '%s'", this.backupSet));
        }
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        if (this.overwrite != null) {
            if (this.overwrite == Answer.yes) {
                stringBuffer.append(" -ow 1");
            } else {
                stringBuffer.append(" -ow 0");
            }
        }
        if (this.wildcards != null) {
            if (this.wildcards == Answer.yes) {
                stringBuffer.append(" -wc y");
            } else {
                stringBuffer.append(" -wc n");
            }
        }
        if (this.dataReaders != null) {
            stringBuffer.append(" -drs " + this.dataReaders);
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

