/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.modify;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.AddRemove;
import workflow.types.cmd.DataAgent;

public class ModifySchedulePolicy
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ModifySchedulePolicy.class);
    @Input(documentation="Operation to be performed on the schedule policy", required=true)
    public AddRemove operation;
    @Input(documentation="SchedulePolicy name", required=true)
    public String schedulePolicy;
    @Input(documentation="Client group name")
    public String clientGroup;
    @Input(documentation="Client computer name")
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer")
    public DataAgent dataAgent;
    @Input(documentation="Instance name, required for certain agents")
    public String instance;
    @Input(documentation="Backup set name, required for certain agents")
    public String backupSet;
    @Input(documentation="Name of the subclient")
    public String subClient;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.operation == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no operation was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required operation input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qmodify schedulepolicy -o '%s' -scp '%s'", this.operation.toString(), this.schedulePolicy));
        if (this.clientGroup != null && this.clientGroup.length() > 0) {
            stringBuffer.append(String.format(" -cg '%s'", this.clientGroup));
        }
        if (this.client != null && this.client.getClientName().length() > 0) {
            stringBuffer.append(String.format(" -c '%s'", this.client.getClientName()));
        }
        if (this.dataAgent != null) {
            stringBuffer.append(String.format(" -a '%s'", this.dataAgent));
        }
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        if (this.backupSet != null && this.backupSet.length() > 0) {
            stringBuffer.append(String.format(" -b '%s'", this.backupSet));
        }
        if (this.subClient != null && this.subClient.length() > 0) {
            stringBuffer.append(String.format(" -s '%s'", this.subClient));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

