/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.modify;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.DataAgent;

public class ModifyPassword
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ModifyPassword.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Instance name, required for certain agents")
    public String instance;
    @Input(documentation="Backup set name, required for certain agents")
    public String backupSet;
    @Input(documentation="Name of the subclient", required=true)
    public String subClient;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        if (this.dataAgent == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no data agent provided in activity inputs");
            activityContext.setFailureReason("missing required data agent type");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qmodify password -c '%s' -a '%s' -s '%s'", this.client.getClientName(), this.dataAgent, this.subClient));
        if (this.backupSet != null && this.backupSet.length() > 0) {
            stringBuffer.append(String.format(" -b '%s'", this.backupSet));
        }
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

