/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.modify;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import org.apache.commons.lang.StringUtils;
import workflow.types.EncryptedString;

public class ModifyGalaxyPassword
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ModifyGalaxyPassword.class);
    @Input(documentation="User name", required=true)
    public String username;
    @Input(documentation="Password")
    public EncryptedString password;
    private String plainTextPassword;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        this.plainTextPassword = this.password != null ? this.password.getPlainText() : "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qmodify galaxypassword -u '%s'", this.username));
        if (this.password != null && this.plainTextPassword.length() > 0) {
            stringBuffer.append(String.format(" -p '%s'", this.plainTextPassword));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    @Override
    protected String getCommandToLog(String string) {
        if (this.plainTextPassword.length() > 0) {
            return StringUtils.replace((String)string, (String)this.plainTextPassword, (String)StringUtils.repeat((String)"*", (int)this.plainTextPassword.length()));
        }
        return super.getCommandToLog(string);
    }
}

