/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.modify;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.AddDelete;

public class ModifyClientGroup
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ModifyClientGroup.class);
    @Input(documentation="Operation to be performed on the client group (add|delete)", required=true)
    public AddDelete operation;
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Client group name", required=true)
    public String clientGroup;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        if (this.operation == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no operation was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required operation input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qmodify clientgroup -o %s -c '%s' -cg '%s'", this.operation.toString(), this.client.getClientName(), this.clientGroup));
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

