/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.media;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MediaPreventExport
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(MediaPreventExport.class);
    @Input(documentation="Media barcode", required=true)
    public String barCode;
    @Input(documentation="Expiration date and time (default: Infinite)")
    public Date expirationDate;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qmedia preventexport -b '%s'", this.barCode));
        if (this.expirationDate != null) {
            stringBuffer.append(String.format(" -et '%s'", this.convertDate(this.expirationDate)));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    private String convertDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return simpleDateFormat.format(date);
    }
}

