/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.media;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;

public class MediaExport
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(MediaExport.class);
    @Input(documentation="List of barcodes", required=true)
    public List<String> barCode;
    @Input(documentation="Export Location name", required=true)
    public String exportLocation;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.barCode == null || this.barCode.size() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no barcodes were supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required barcode input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.barCode.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.barCode.get(i));
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(String.format("qmedia export -b '%s' -el '%s'", stringBuffer.toString(), this.exportLocation));
        try {
            this.execute(stringBuffer2, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

