/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.List;
import workflow.types.WeekDay;
import workflow.types.cmd.ScheduleDetails;

public class ListSchedule
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListSchedule.class);
    @Input(documentation="Week day")
    public WeekDay weekDay;
    @Input(documentation="Hour (0-23")
    public WeekDay hour;
    @Output(documentation="")
    public List<ScheduleDetails> schedule;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("qlist schedule");
        if (this.weekDay != null) {
            stringBuffer.append(" -day " + this.weekDay.getEnumValue());
        }
        if (this.hour != null) {
            stringBuffer.append(" -hour " + this.hour);
        }
        this.schedule = new ArrayList<ScheduleDetails>();
        try {
            String string = this.execute(stringBuffer, activityContext);
            List<CommandUtil.RowData> list = CommandUtil.parseColumnValues(string);
            for (CommandUtil.RowData rowData : list) {
                ScheduleDetails scheduleDetails = new ScheduleDetails();
                scheduleDetails.time = rowData.getColumn("TIME");
                scheduleDetails.backupJobs = Integer.parseInt(rowData.getColumn("BACKUPJOBS"));
                scheduleDetails.restoreJobs = Integer.parseInt(rowData.getColumn("RESTOREJOBS"));
                scheduleDetails.adminJobs = Integer.parseInt(rowData.getColumn("ADMINJOBS"));
                this.schedule.add(scheduleDetails);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

