/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import workflow.types.cmd.DataAgent;
import workflow.types.cmd.QuickMediaDetails;

public class ListQuickMedia
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListQuickMedia.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Instance name")
    public String instance;
    @Input(documentation="Backup set name")
    public String backupSet;
    @Input(documentation="Subclient name")
    public String subClient;
    @Input(documentation="Browse From")
    public Date browseFrom;
    @Input(documentation="Browse To")
    public Date browseTo;
    @Input(documentation="Synchronous copy precedence")
    public String syncPrecedence;
    @Input(documentation="Selective copy precedence")
    public String selPrecedence;
    @Output(documentation="")
    public List<QuickMediaDetails> media;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qlist quickmedia -c '%s'", this.client.getClientName()));
        if (this.dataAgent != null) {
            stringBuffer.append(String.format(" -a '%s'", this.dataAgent));
        }
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        if (this.backupSet != null && this.backupSet.length() > 0) {
            stringBuffer.append(String.format(" -b '%s'", this.backupSet));
        }
        if (this.subClient != null && this.subClient.length() > 0) {
            stringBuffer.append(String.format(" -s '%s'", this.subClient));
        }
        if (this.browseFrom != null) {
            stringBuffer.append(String.format(" -bf '%s'", this.convertDate(this.browseFrom)));
        }
        if (this.browseTo != null) {
            stringBuffer.append(String.format(" -bt '%s'", this.convertDate(this.browseTo)));
        }
        if (this.syncPrecedence != null && this.syncPrecedence.length() > 0) {
            stringBuffer.append(String.format(" -syp '%s'", this.syncPrecedence));
        }
        if (this.selPrecedence != null && this.selPrecedence.length() > 0) {
            stringBuffer.append(String.format(" -sep '%s'", this.selPrecedence));
        }
        this.media = new ArrayList<QuickMediaDetails>();
        try {
            String string = this.execute(stringBuffer, activityContext);
            List<CommandUtil.RowData> list = CommandUtil.parseColumnValues(string);
            for (CommandUtil.RowData rowData : list) {
                QuickMediaDetails quickMediaDetails = new QuickMediaDetails();
                quickMediaDetails.barCode = rowData.getColumn("BARCODE");
                quickMediaDetails.container = rowData.getColumn("CONTAINER");
                quickMediaDetails.library = rowData.getColumn("LIBRARY");
                quickMediaDetails.storagePolicy = rowData.getColumn("STORAGEPOLICY");
                quickMediaDetails.copyName = rowData.getColumn("COPYNAME");
                quickMediaDetails.subClient = rowData.getColumn("SUBCLIENT");
                this.media.add(quickMediaDetails);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    private String convertDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return simpleDateFormat.format(date);
    }
}

