/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.activities.cmd.list.ListDrive;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.util.ArrayList;
import java.util.List;
import workflow.types.cmd.DataAgentDetails;

public class ListDataAgent
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListDrive.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Output(documentation="")
    public List<DataAgentDetails> dataAgent;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qlist dataagent -c '%s'", this.client.getClientName()));
        this.dataAgent = new ArrayList<DataAgentDetails>();
        try {
            String string = this.execute(stringBuffer, activityContext);
            List<CommandUtil.RowData> list = CommandUtil.parseColumnValues(string);
            for (CommandUtil.RowData rowData : list) {
                DataAgentDetails dataAgentDetails = new DataAgentDetails();
                dataAgentDetails.dataAgent = rowData.getColumn("NAME");
                dataAgentDetails.description = rowData.getColumn("DESCRIPTION");
                dataAgentDetails.active = CommandUtil.parseAnswer(rowData.getColumn("ACTIVE"));
                this.dataAgent.add(dataAgentDetails);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

